/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGGElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGTests;

public class SVGSwitchElementBridge
extends SVGGElementBridge {
    protected Element selectedChild;

    @Override
    public String getLocalName() {
        return "switch";
    }

    @Override
    public Bridge getInstance() {
        return new SVGSwitchElementBridge();
    }

    @Override
    public GraphicsNode createGraphicsNode(BridgeContext ctx, Element e2) {
        GraphicsNode refNode = null;
        GVTBuilder builder = ctx.getGVTBuilder();
        this.selectedChild = null;
        for (Node n2 = e2.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            if (n2.getNodeType() != 1) continue;
            Element ref = (Element)n2;
            if (!(n2 instanceof SVGTests) || !SVGUtilities.matchUserAgent(ref, ctx.getUserAgent())) continue;
            this.selectedChild = ref;
            refNode = builder.build(ctx, ref);
            break;
        }
        if (refNode == null) {
            return null;
        }
        CompositeGraphicsNode group = (CompositeGraphicsNode)super.createGraphicsNode(ctx, e2);
        if (group == null) {
            return null;
        }
        group.add(refNode);
        return group;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public void dispose() {
        this.selectedChild = null;
        super.dispose();
    }

    @Override
    protected void handleElementAdded(CompositeGraphicsNode gn, Node parent, Element childElt) {
        for (Node n2 = childElt.getPreviousSibling(); n2 != null; n2 = n2.getPreviousSibling()) {
            if (n2 != childElt) continue;
            return;
        }
        if (childElt instanceof SVGTests && SVGUtilities.matchUserAgent(childElt, this.ctx.getUserAgent())) {
            if (this.selectedChild != null) {
                gn.remove(0);
                SVGSwitchElementBridge.disposeTree(this.selectedChild);
            }
            this.selectedChild = childElt;
            GVTBuilder builder = this.ctx.getGVTBuilder();
            GraphicsNode refNode = builder.build(this.ctx, childElt);
            if (refNode != null) {
                gn.add(refNode);
            }
        }
    }

    protected void handleChildElementRemoved(Element e2) {
        CompositeGraphicsNode gn = (CompositeGraphicsNode)this.node;
        if (this.selectedChild == e2) {
            gn.remove(0);
            SVGSwitchElementBridge.disposeTree(this.selectedChild);
            this.selectedChild = null;
            GraphicsNode refNode = null;
            GVTBuilder builder = this.ctx.getGVTBuilder();
            for (Node n2 = e2.getNextSibling(); n2 != null; n2 = n2.getNextSibling()) {
                if (n2.getNodeType() != 1) continue;
                Element ref = (Element)n2;
                if (!(n2 instanceof SVGTests) || !SVGUtilities.matchUserAgent(ref, this.ctx.getUserAgent())) continue;
                refNode = builder.build(this.ctx, ref);
                this.selectedChild = ref;
                break;
            }
            if (refNode != null) {
                gn.add(refNode);
            }
        }
    }
}

