/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.bridge.CSSFontFace;
import org.apache.batik.bridge.FontFace;
import org.apache.batik.bridge.FontFamilyResolver;
import org.apache.batik.gvt.font.AWTFontFamily;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;

public final class DefaultFontFamilyResolver
implements FontFamilyResolver {
    public static final DefaultFontFamilyResolver SINGLETON;
    private static final AWTFontFamily DEFAULT_FONT_FAMILY;
    protected static final Map fonts;
    protected static final List awtFontFamilies;
    protected static final List awtFonts;
    protected static final Map resolvedFontFamilies;

    private DefaultFontFamilyResolver() {
    }

    @Override
    public AWTFontFamily resolve(String familyName, FontFace fontFace) {
        String fontName = (String)fonts.get(fontFace.getFamilyName().toLowerCase());
        if (fontName == null) {
            return null;
        }
        CSSFontFace face = FontFace.createFontFace(fontName, fontFace);
        return new AWTFontFamily(fontFace);
    }

    @Override
    public GVTFontFamily loadFont(InputStream in, FontFace ff) throws Exception {
        Font font = Font.createFont(0, in);
        return new AWTFontFamily(ff, font);
    }

    @Override
    public GVTFontFamily resolve(String familyName) {
        GVTFontFamily resolvedFF = (GVTFontFamily)resolvedFontFamilies.get(familyName = familyName.toLowerCase());
        if (resolvedFF == null) {
            String awtFamilyName = (String)fonts.get(familyName);
            if (awtFamilyName != null) {
                resolvedFF = new AWTFontFamily(awtFamilyName);
            }
            resolvedFontFamilies.put(familyName, resolvedFF);
        }
        return resolvedFF;
    }

    @Override
    public GVTFontFamily getFamilyThatCanDisplay(char c2) {
        for (int i2 = 0; i2 < awtFontFamilies.size(); ++i2) {
            AWTFontFamily fontFamily = (AWTFontFamily)awtFontFamilies.get(i2);
            AWTGVTFont font = (AWTGVTFont)awtFonts.get(i2);
            if (!font.canDisplay(c2) || fontFamily.getFamilyName().indexOf("Song") != -1) continue;
            return fontFamily;
        }
        return null;
    }

    @Override
    public GVTFontFamily getDefault() {
        return DEFAULT_FONT_FAMILY;
    }

    static {
        Font[] allFonts;
        SINGLETON = new DefaultFontFamilyResolver();
        DEFAULT_FONT_FAMILY = new AWTFontFamily("SansSerif");
        fonts = new HashMap();
        awtFontFamilies = new ArrayList();
        awtFonts = new ArrayList();
        fonts.put("sans-serif", "SansSerif");
        fonts.put("serif", "Serif");
        fonts.put("times", "Serif");
        fonts.put("times new roman", "Serif");
        fonts.put("cursive", "Dialog");
        fonts.put("fantasy", "Symbol");
        fonts.put("monospace", "Monospaced");
        fonts.put("monospaced", "Monospaced");
        fonts.put("courier", "Monospaced");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = env.getAvailableFontFamilyNames();
        int nFonts = fontNames != null ? fontNames.length : 0;
        for (int i2 = 0; i2 < nFonts; ++i2) {
            fonts.put(fontNames[i2].toLowerCase(), fontNames[i2]);
            StringTokenizer st = new StringTokenizer(fontNames[i2]);
            String fontNameWithoutSpaces = "";
            while (st.hasMoreTokens()) {
                fontNameWithoutSpaces = fontNameWithoutSpaces + st.nextToken();
            }
            fonts.put(fontNameWithoutSpaces.toLowerCase(), fontNames[i2]);
            String fontNameWithDashes = fontNames[i2].replace(' ', '-');
            if (fontNameWithDashes.equals(fontNames[i2])) continue;
            fonts.put(fontNameWithDashes.toLowerCase(), fontNames[i2]);
        }
        for (Font f2 : allFonts = env.getAllFonts()) {
            fonts.put(f2.getFontName().toLowerCase(), f2.getFontName());
        }
        awtFontFamilies.add(DEFAULT_FONT_FAMILY);
        awtFonts.add(new AWTGVTFont(DEFAULT_FONT_FAMILY.getFamilyName(), 0, 12));
        Collection fontValues = fonts.values();
        for (Object fontValue : fontValues) {
            String fontFamily = (String)fontValue;
            AWTFontFamily awtFontFamily = new AWTFontFamily(fontFamily);
            awtFontFamilies.add(awtFontFamily);
            AWTGVTFont font = new AWTGVTFont(fontFamily, 0, 12);
            awtFonts.add(font);
        }
        resolvedFontFamilies = new HashMap();
    }
}

