/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.batik.apps.svgbrowser.HistoryBrowser;
import org.apache.batik.apps.svgbrowser.HistoryBrowserInterface;
import org.apache.batik.util.gui.DropDownComponent;
import org.apache.batik.util.resources.ResourceManager;

public class DropDownHistoryModel
implements DropDownComponent.ScrollablePopupMenuModel {
    private static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.DropDownHistoryModelMessages";
    private static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.DropDownHistoryModelMessages", Locale.getDefault());
    private static ResourceManager resources = new ResourceManager(bundle);
    protected ArrayList items = new ArrayList();
    protected HistoryBrowserInterface historyBrowserInterface;
    protected DropDownComponent.ScrollablePopupMenu parent;

    public DropDownHistoryModel(DropDownComponent.ScrollablePopupMenu parent, HistoryBrowserInterface historyBrowserInterface) {
        this.parent = parent;
        this.historyBrowserInterface = historyBrowserInterface;
        historyBrowserInterface.getHistoryBrowser().addListener(new HistoryBrowser.HistoryBrowserAdapter(){

            @Override
            public void historyReset(HistoryBrowser.HistoryBrowserEvent event) {
                DropDownHistoryModel.this.clearAllScrollablePopupMenuItems("");
            }
        });
    }

    @Override
    public String getFooterText() {
        return "";
    }

    public DropDownComponent.ScrollablePopupMenuItem createItem(String itemName) {
        return new DropDownComponent.DefaultScrollablePopupMenuItem(this.parent, itemName);
    }

    protected void addItem(DropDownComponent.ScrollablePopupMenuItem item, String details) {
        int oldSize = this.items.size();
        this.items.add(0, item);
        this.parent.add(item, 0, oldSize, this.items.size());
        this.parent.fireItemsWereAdded(new DropDownComponent.ScrollablePopupMenuEvent(this.parent, 1, 1, details));
    }

    protected void removeItem(DropDownComponent.ScrollablePopupMenuItem item, String details) {
        int oldSize = this.items.size();
        this.items.remove(item);
        this.parent.remove(item, oldSize, this.items.size());
        this.parent.fireItemsWereRemoved(new DropDownComponent.ScrollablePopupMenuEvent(this.parent, 2, 1, details));
    }

    protected boolean removeLastScrollablePopupMenuItem(String details) {
        int i2 = this.items.size() - 1;
        if (i2 >= 0) {
            DropDownComponent.ScrollablePopupMenuItem item = (DropDownComponent.ScrollablePopupMenuItem)this.items.get(i2);
            this.removeItem(item, details);
            return true;
        }
        return false;
    }

    protected boolean removeFirstScrollablePopupMenuItem(String details) {
        Iterator i$ = this.items.iterator();
        if (i$.hasNext()) {
            Object item1 = i$.next();
            DropDownComponent.ScrollablePopupMenuItem item = (DropDownComponent.ScrollablePopupMenuItem)item1;
            this.removeItem(item, details);
            return true;
        }
        return false;
    }

    protected void clearAllScrollablePopupMenuItems(String details) {
        while (this.removeLastScrollablePopupMenuItem(details)) {
        }
    }

    @Override
    public void processItemClicked() {
    }

    @Override
    public void processBeforeShowed() {
        this.historyBrowserInterface.performCurrentCompoundCommand();
    }

    @Override
    public void processAfterShowed() {
    }

    static /* synthetic */ ResourceManager access$000() {
        return resources;
    }

    public static class RedoPopUpMenuModel
    extends DropDownHistoryModel {
        protected static String REDO_FOOTER_TEXT = DropDownHistoryModel.access$000().getString("RedoModel.footerText");
        protected static String REDO_TOOLTIP_PREFIX = DropDownHistoryModel.access$000().getString("RedoModel.tooltipPrefix");

        public RedoPopUpMenuModel(DropDownComponent.ScrollablePopupMenu parent, HistoryBrowserInterface historyBrowserInterface) {
            super(parent, historyBrowserInterface);
            this.init();
        }

        private void init() {
            this.historyBrowserInterface.getHistoryBrowser().addListener(new HistoryBrowser.HistoryBrowserAdapter(){

                @Override
                public void executePerformed(HistoryBrowser.HistoryBrowserEvent event) {
                    HistoryBrowser.CommandNamesInfo info = (HistoryBrowser.CommandNamesInfo)event.getSource();
                    String details = REDO_TOOLTIP_PREFIX + info.getLastRedoableCommandName();
                    RedoPopUpMenuModel.this.clearAllScrollablePopupMenuItems(details);
                }

                @Override
                public void undoPerformed(HistoryBrowser.HistoryBrowserEvent event) {
                    HistoryBrowser.CommandNamesInfo info = (HistoryBrowser.CommandNamesInfo)event.getSource();
                    String details = REDO_TOOLTIP_PREFIX + info.getLastRedoableCommandName();
                    RedoPopUpMenuModel.this.addItem(RedoPopUpMenuModel.this.createItem(info.getCommandName()), details);
                }

                @Override
                public void redoPerformed(HistoryBrowser.HistoryBrowserEvent event) {
                    HistoryBrowser.CommandNamesInfo info = (HistoryBrowser.CommandNamesInfo)event.getSource();
                    String details = REDO_TOOLTIP_PREFIX + info.getLastRedoableCommandName();
                    RedoPopUpMenuModel.this.removeFirstScrollablePopupMenuItem(details);
                }

                @Override
                public void doCompoundEdit(HistoryBrowser.HistoryBrowserEvent event) {
                    if (RedoPopUpMenuModel.this.parent.isEnabled()) {
                        RedoPopUpMenuModel.this.parent.setEnabled(false);
                    }
                }

                @Override
                public void compoundEditPerformed(HistoryBrowser.HistoryBrowserEvent event) {
                }
            });
        }

        @Override
        public String getFooterText() {
            return REDO_FOOTER_TEXT;
        }

        @Override
        public void processItemClicked() {
            this.historyBrowserInterface.getHistoryBrowser().compoundRedo(this.parent.getSelectedItemsCount());
        }
    }

    public static class UndoPopUpMenuModel
    extends DropDownHistoryModel {
        protected static String UNDO_FOOTER_TEXT = DropDownHistoryModel.access$000().getString("UndoModel.footerText");
        protected static String UNDO_TOOLTIP_PREFIX = DropDownHistoryModel.access$000().getString("UndoModel.tooltipPrefix");

        public UndoPopUpMenuModel(DropDownComponent.ScrollablePopupMenu parent, HistoryBrowserInterface historyBrowserInterface) {
            super(parent, historyBrowserInterface);
            this.init();
        }

        private void init() {
            this.historyBrowserInterface.getHistoryBrowser().addListener(new HistoryBrowser.HistoryBrowserAdapter(){

                @Override
                public void executePerformed(HistoryBrowser.HistoryBrowserEvent event) {
                    HistoryBrowser.CommandNamesInfo info = (HistoryBrowser.CommandNamesInfo)event.getSource();
                    String details = UNDO_TOOLTIP_PREFIX + info.getLastUndoableCommandName();
                    UndoPopUpMenuModel.this.addItem(UndoPopUpMenuModel.this.createItem(info.getCommandName()), details);
                }

                @Override
                public void undoPerformed(HistoryBrowser.HistoryBrowserEvent event) {
                    HistoryBrowser.CommandNamesInfo info = (HistoryBrowser.CommandNamesInfo)event.getSource();
                    String details = UNDO_TOOLTIP_PREFIX + info.getLastUndoableCommandName();
                    UndoPopUpMenuModel.this.removeFirstScrollablePopupMenuItem(details);
                }

                @Override
                public void redoPerformed(HistoryBrowser.HistoryBrowserEvent event) {
                    HistoryBrowser.CommandNamesInfo info = (HistoryBrowser.CommandNamesInfo)event.getSource();
                    String details = UNDO_TOOLTIP_PREFIX + info.getLastUndoableCommandName();
                    UndoPopUpMenuModel.this.addItem(UndoPopUpMenuModel.this.createItem(info.getCommandName()), details);
                }

                @Override
                public void doCompoundEdit(HistoryBrowser.HistoryBrowserEvent event) {
                    if (!UndoPopUpMenuModel.this.parent.isEnabled()) {
                        UndoPopUpMenuModel.this.parent.setEnabled(true);
                    }
                }

                @Override
                public void compoundEditPerformed(HistoryBrowser.HistoryBrowserEvent event) {
                }
            });
        }

        @Override
        public String getFooterText() {
            return UNDO_FOOTER_TEXT;
        }

        @Override
        public void processItemClicked() {
            this.historyBrowserInterface.getHistoryBrowser().compoundUndo(this.parent.getSelectedItemsCount());
        }
    }
}

