/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.antlr.misc.IntSet;
import org.antlr.misc.Interval;
import org.antlr.misc.Utils;
import org.antlr.runtime.BitSet;
import org.antlr.tool.Grammar;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntervalSet
implements IntSet {
    public static final IntervalSet COMPLETE_SET = IntervalSet.of(0, 65535);
    protected List<Interval> intervals;

    public IntervalSet() {
        this.intervals = new ArrayList<Interval>(2);
    }

    public IntervalSet(List<Interval> intervals) {
        this.intervals = intervals;
    }

    public static IntervalSet of(int a2) {
        IntervalSet s2 = new IntervalSet();
        s2.add(a2);
        return s2;
    }

    public static IntervalSet of(int a2, int b2) {
        IntervalSet s2 = new IntervalSet();
        s2.add(a2, b2);
        return s2;
    }

    @Override
    public void add(int el) {
        this.add(el, el);
    }

    public void add(int a2, int b2) {
        this.add(Interval.create(a2, b2));
    }

    protected void add(Interval addition) {
        if (addition.b < addition.a) {
            return;
        }
        ListIterator<Interval> iter = this.intervals.listIterator();
        while (iter.hasNext()) {
            Interval r2 = iter.next();
            if (addition.equals(r2)) {
                return;
            }
            if (addition.adjacent(r2) || !addition.disjoint(r2)) {
                Interval next;
                Interval bigger = addition.union(r2);
                iter.set(bigger);
                if (iter.hasNext() && (bigger.adjacent(next = iter.next()) || !bigger.disjoint(next))) {
                    iter.remove();
                    iter.previous();
                    iter.set(bigger.union(next));
                }
                return;
            }
            if (!addition.startsBeforeDisjoint(r2)) continue;
            iter.previous();
            iter.add(addition);
            return;
        }
        this.intervals.add(addition);
    }

    @Override
    public void addAll(IntSet set) {
        if (set == null) {
            return;
        }
        if (!(set instanceof IntervalSet)) {
            throw new IllegalArgumentException(new StringBuffer().append("can't add non IntSet (").append(set.getClass().getName()).append(") to IntervalSet").toString());
        }
        IntervalSet other = (IntervalSet)set;
        int n2 = other.intervals.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Interval I2 = other.intervals.get(i2);
            this.add(I2.a, I2.b);
        }
    }

    public IntSet complement(int minElement, int maxElement) {
        return this.complement(IntervalSet.of(minElement, maxElement));
    }

    @Override
    public IntSet complement(IntSet vocabulary) {
        if (vocabulary == null) {
            return null;
        }
        if (!(vocabulary instanceof IntervalSet)) {
            throw new IllegalArgumentException(new StringBuffer().append("can't complement with non IntervalSet (").append(vocabulary.getClass().getName()).append(")").toString());
        }
        IntervalSet vocabularyIS = (IntervalSet)vocabulary;
        int maxElement = vocabularyIS.getMaxElement();
        IntervalSet compl = new IntervalSet();
        int n2 = this.intervals.size();
        if (n2 == 0) {
            return compl;
        }
        Interval first = this.intervals.get(0);
        if (first.a > 0) {
            IntervalSet s2 = IntervalSet.of(0, first.a - 1);
            IntervalSet a2 = (IntervalSet)s2.and(vocabularyIS);
            compl.addAll(a2);
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            Interval previous = this.intervals.get(i2 - 1);
            Interval current = this.intervals.get(i2);
            IntervalSet s3 = IntervalSet.of(previous.b + 1, current.a - 1);
            IntervalSet a3 = (IntervalSet)s3.and(vocabularyIS);
            compl.addAll(a3);
        }
        Interval last = this.intervals.get(n2 - 1);
        if (last.b < maxElement) {
            IntervalSet s4 = IntervalSet.of(last.b + 1, maxElement);
            IntervalSet a4 = (IntervalSet)s4.and(vocabularyIS);
            compl.addAll(a4);
        }
        return compl;
    }

    @Override
    public IntSet subtract(IntSet other) {
        return this.and(((IntervalSet)other).complement(COMPLETE_SET));
    }

    @Override
    public IntSet or(IntSet a2) {
        IntervalSet o2 = new IntervalSet();
        o2.addAll(this);
        o2.addAll(a2);
        return o2;
    }

    @Override
    public IntSet and(IntSet other) {
        if (other == null) {
            return null;
        }
        ArrayList myIntervals = (ArrayList)this.intervals;
        ArrayList theirIntervals = (ArrayList)((IntervalSet)other).intervals;
        IntervalSet intersection = null;
        int mySize = myIntervals.size();
        int theirSize = theirIntervals.size();
        int i2 = 0;
        int j2 = 0;
        while (i2 < mySize && j2 < theirSize) {
            Interval theirs;
            Interval mine = (Interval)myIntervals.get(i2);
            if (mine.startsBeforeDisjoint(theirs = (Interval)theirIntervals.get(j2))) {
                ++i2;
                continue;
            }
            if (theirs.startsBeforeDisjoint(mine)) {
                ++j2;
                continue;
            }
            if (mine.properlyContains(theirs)) {
                if (intersection == null) {
                    intersection = new IntervalSet();
                }
                intersection.add(mine.intersection(theirs));
                ++j2;
                continue;
            }
            if (theirs.properlyContains(mine)) {
                if (intersection == null) {
                    intersection = new IntervalSet();
                }
                intersection.add(mine.intersection(theirs));
                ++i2;
                continue;
            }
            if (mine.disjoint(theirs)) continue;
            if (intersection == null) {
                intersection = new IntervalSet();
            }
            intersection.add(mine.intersection(theirs));
            if (mine.startsAfterNonDisjoint(theirs)) {
                ++j2;
                continue;
            }
            if (!theirs.startsAfterNonDisjoint(mine)) continue;
            ++i2;
        }
        if (intersection == null) {
            return new IntervalSet();
        }
        return intersection;
    }

    @Override
    public boolean member(int el) {
        int n2 = this.intervals.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Interval I2 = this.intervals.get(i2);
            int a2 = I2.a;
            int b2 = I2.b;
            if (el < a2) break;
            if (el < a2 || el > b2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNil() {
        return this.intervals == null || this.intervals.size() == 0;
    }

    @Override
    public int getSingleElement() {
        if (this.intervals != null && this.intervals.size() == 1) {
            Interval I2 = this.intervals.get(0);
            if (I2.a == I2.b) {
                return I2.a;
            }
        }
        return -7;
    }

    public int getMaxElement() {
        if (this.isNil()) {
            return -7;
        }
        Interval last = this.intervals.get(this.intervals.size() - 1);
        return last.b;
    }

    public int getMinElement() {
        if (this.isNil()) {
            return -7;
        }
        int n2 = this.intervals.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Interval I2 = this.intervals.get(i2);
            int a2 = I2.a;
            int b2 = I2.b;
            for (int v2 = a2; v2 <= b2; ++v2) {
                if (v2 < 0) continue;
                return v2;
            }
        }
        return -7;
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IntervalSet)) {
            return false;
        }
        IntervalSet other = (IntervalSet)obj;
        return ((Object)this.intervals).equals(other.intervals);
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(Grammar g2) {
        StringBuffer buf = new StringBuffer();
        if (this.intervals == null || this.intervals.size() == 0) {
            return "{}";
        }
        if (this.intervals.size() > 1) {
            buf.append("{");
        }
        Iterator<Interval> iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval I2 = iter.next();
            int a2 = I2.a;
            int b2 = I2.b;
            if (a2 == b2) {
                if (g2 != null) {
                    buf.append(g2.getTokenDisplayName(a2));
                } else {
                    buf.append(a2);
                }
            } else if (g2 != null) {
                buf.append(new StringBuffer().append(g2.getTokenDisplayName(a2)).append("..").append(g2.getTokenDisplayName(b2)).toString());
            } else {
                buf.append(new StringBuffer().append(a2).append("..").append(b2).toString());
            }
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        if (this.intervals.size() > 1) {
            buf.append("}");
        }
        return buf.toString();
    }

    @Override
    public int size() {
        int n2 = 0;
        int numIntervals = this.intervals.size();
        if (numIntervals == 1) {
            Interval firstInterval = this.intervals.get(0);
            return firstInterval.b - firstInterval.a + 1;
        }
        for (int i2 = 0; i2 < numIntervals; ++i2) {
            Interval I2 = this.intervals.get(i2);
            n2 += I2.b - I2.a + 1;
        }
        return n2;
    }

    @Override
    public List toList() {
        ArrayList<Integer> values = new ArrayList<Integer>();
        int n2 = this.intervals.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Interval I2 = this.intervals.get(i2);
            int a2 = I2.a;
            int b2 = I2.b;
            for (int v2 = a2; v2 <= b2; ++v2) {
                values.add(Utils.integer(v2));
            }
        }
        return values;
    }

    public int get(int i2) {
        int n2 = this.intervals.size();
        int index = 0;
        for (int j2 = 0; j2 < n2; ++j2) {
            Interval I2 = this.intervals.get(j2);
            int a2 = I2.a;
            int b2 = I2.b;
            for (int v2 = a2; v2 <= b2; ++v2) {
                if (index == i2) {
                    return v2;
                }
                ++index;
            }
        }
        return -1;
    }

    public int[] toArray() {
        int[] values = new int[this.size()];
        int n2 = this.intervals.size();
        int j2 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Interval I2 = this.intervals.get(i2);
            int a2 = I2.a;
            int b2 = I2.b;
            int v2 = a2;
            while (v2 <= b2) {
                values[j2] = v2++;
                ++j2;
            }
        }
        return values;
    }

    public BitSet toRuntimeBitSet() {
        BitSet s2 = new BitSet(this.getMaxElement() + 1);
        int n2 = this.intervals.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Interval I2 = this.intervals.get(i2);
            int a2 = I2.a;
            int b2 = I2.b;
            for (int v2 = a2; v2 <= b2; ++v2) {
                s2.add(v2);
            }
        }
        return s2;
    }

    @Override
    public void remove(int el) {
        throw new NoSuchMethodError("IntervalSet.remove() unimplemented");
    }
}

