/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.misc.OrderedHashSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph {
    protected Map<Object, Node> nodes = new HashMap<Object, Node>();

    public void addEdge(Object a2, Object b2) {
        Node a_node = this.getNode(a2);
        Node b_node = this.getNode(b2);
        a_node.addEdge(b_node);
    }

    protected Node getNode(Object a2) {
        Node existing = this.nodes.get(a2);
        if (existing != null) {
            return existing;
        }
        Node n2 = new Node(a2);
        this.nodes.put(a2, n2);
        return n2;
    }

    public List<Object> sort() {
        OrderedHashSet visited = new OrderedHashSet();
        ArrayList<Object> sorted = new ArrayList<Object>();
        while (visited.size() < this.nodes.size()) {
            Node n22 = null;
            for (Node n22 : this.nodes.values()) {
                if (!visited.contains(n22)) break;
            }
            this.DFS(n22, visited, sorted);
        }
        return sorted;
    }

    public void DFS(Node n2, Set<Node> visited, ArrayList<Object> sorted) {
        if (visited.contains(n2)) {
            return;
        }
        visited.add(n2);
        if (n2.edges != null) {
            for (Node target : n2.edges) {
                this.DFS(target, visited, sorted);
            }
        }
        sorted.add(n2.payload);
    }

    public static class Node {
        Object payload;
        List<Node> edges;

        public Node(Object payload) {
            this.payload = payload;
        }

        public void addEdge(Node n2) {
            if (this.edges == null) {
                this.edges = new ArrayList<Node>();
            }
            if (!this.edges.contains(n2)) {
                this.edges.add(n2);
            }
        }

        public String toString() {
            return this.payload.toString();
        }
    }
}

