/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit.swingui.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.antlr.gunit.swingui.model.Rule;
import org.antlr.gunit.swingui.model.TestSuite;
import org.antlr.gunit.swingui.parsers.ANTLRv3Lexer;
import org.antlr.gunit.swingui.parsers.ANTLRv3Parser;
import org.antlr.gunit.swingui.parsers.StGUnitLexer;
import org.antlr.gunit.swingui.parsers.StGUnitParser;
import org.antlr.gunit.swingui.runner.TestSuiteAdapter;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuiteFactory {
    private static String TEMPLATE_FILE = "org/antlr/gunit/swingui/gunit.stg";
    private static StringTemplateGroup templates;
    public static final String TEST_SUITE_EXT = ".gunit";
    public static final String GRAMMAR_EXT = ".g";
    static /* synthetic */ Class class$org$antlr$gunit$swingui$model$TestSuiteFactory;

    public static TestSuite createTestSuite(File grammarFile) {
        if (grammarFile != null && grammarFile.exists() && grammarFile.isFile()) {
            String fileName = grammarFile.getName();
            String grammarName = fileName.substring(0, fileName.lastIndexOf(46));
            String grammarDir = grammarFile.getParent();
            File testFile = new File(new StringBuffer().append(grammarDir).append(File.separator).append(grammarName).append(TEST_SUITE_EXT).toString());
            TestSuite result = new TestSuite(grammarName, testFile);
            result.rules = TestSuiteFactory.loadRulesFromGrammar(grammarFile);
            if (TestSuiteFactory.saveTestSuite(result)) {
                return result;
            }
            throw new RuntimeException("Can't save test suite file.");
        }
        throw new RuntimeException("Invalid grammar file.");
    }

    private static List<Rule> loadRulesFromGrammar(File grammarFile) {
        ArrayList<String> ruleNames = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(grammarFile));
            ANTLRv3Lexer lexer = new ANTLRv3Lexer(new ANTLRReaderStream(reader));
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            ANTLRv3Parser parser = new ANTLRv3Parser(tokens);
            parser.rules = ruleNames;
            parser.grammarDef();
            ((Reader)reader).close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        for (String str : ruleNames) {
            ruleList.add(new Rule(str));
        }
        return ruleList;
    }

    public static boolean saveTestSuite(TestSuite testSuite) {
        String data = TestSuiteFactory.getScript(testSuite);
        try {
            FileWriter fw = new FileWriter(testSuite.getTestSuiteFile());
            fw.write(data);
            fw.flush();
            fw.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
        return true;
    }

    public static String getScript(TestSuite testSuite) {
        if (testSuite == null) {
            return null;
        }
        StringTemplate gUnitScript = templates.getInstanceOf("gUnitFile");
        gUnitScript.setAttribute("testSuite", (Object)testSuite);
        return gUnitScript.toString();
    }

    public static TestSuite loadTestSuite(File file) {
        if (file.getName().endsWith(GRAMMAR_EXT)) {
            throw new RuntimeException(new StringBuffer().append(file.getName()).append(" is a grammar file not a gunit file").toString());
        }
        File grammarFile = TestSuiteFactory.getGrammarFile(file);
        if (grammarFile == null) {
            throw new RuntimeException(new StringBuffer().append("Can't find grammar file associated with gunit file: ").append(file.getAbsoluteFile()).toString());
        }
        TestSuite result = new TestSuite("", file);
        try {
            TestSuiteAdapter adapter;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StGUnitLexer lexer = new StGUnitLexer(new ANTLRReaderStream(reader));
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            StGUnitParser parser = new StGUnitParser(tokens);
            parser.adapter = adapter = new TestSuiteAdapter(result);
            parser.gUnitDef();
            result.setTokens(tokens);
            ((Reader)reader).close();
        }
        catch (Exception ex) {
            throw new RuntimeException(new StringBuffer().append("Error reading test suite file.\n").append(ex.getMessage()).toString());
        }
        List<Rule> completeRuleList = TestSuiteFactory.loadRulesFromGrammar(grammarFile);
        for (Rule rule : completeRuleList) {
            if (result.hasRule(rule)) continue;
            result.addRule(rule);
        }
        return result;
    }

    private static File getGrammarFile(File testsuiteFile) {
        String sTestFile;
        try {
            sTestFile = testsuiteFile.getCanonicalPath();
        }
        catch (IOException e2) {
            return null;
        }
        String fname = new StringBuffer().append(sTestFile.substring(0, sTestFile.lastIndexOf(46))).append(GRAMMAR_EXT).toString();
        File fileGrammar = new File(fname);
        if (fileGrammar.exists() && fileGrammar.isFile()) {
            return fileGrammar;
        }
        fname = new StringBuffer().append(sTestFile.substring(0, sTestFile.lastIndexOf(46))).append("Parser").append(GRAMMAR_EXT).toString();
        if (fileGrammar.exists() && fileGrammar.isFile()) {
            return fileGrammar;
        }
        return fileGrammar;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        ClassLoader loader = (class$org$antlr$gunit$swingui$model$TestSuiteFactory == null ? (class$org$antlr$gunit$swingui$model$TestSuiteFactory = TestSuiteFactory.class$("org.antlr.gunit.swingui.model.TestSuiteFactory")) : class$org$antlr$gunit$swingui$model$TestSuiteFactory).getClassLoader();
        InputStream in = loader.getResourceAsStream(TEMPLATE_FILE);
        if (in == null) {
            throw new RuntimeException(new StringBuffer().append("internal error: Can't find templates ").append(TEMPLATE_FILE).toString());
        }
        InputStreamReader rd = new InputStreamReader(in);
        templates = new StringTemplateGroup((Reader)rd);
    }
}

