/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.codegen;

import java.io.IOException;
import java.util.List;
import org.antlr.Tool;
import org.antlr.codegen.CodeGenerator;
import org.antlr.runtime.Token;
import org.antlr.tool.Grammar;
import org.stringtemplate.v4.ST;

public class Target {
    protected String[] targetCharValueEscape = new String[255];

    public Target() {
        this.targetCharValueEscape[10] = "\\n";
        this.targetCharValueEscape[13] = "\\r";
        this.targetCharValueEscape[9] = "\\t";
        this.targetCharValueEscape[8] = "\\b";
        this.targetCharValueEscape[12] = "\\f";
        this.targetCharValueEscape[92] = "\\\\";
        this.targetCharValueEscape[39] = "\\'";
        this.targetCharValueEscape[34] = "\\\"";
    }

    protected void genRecognizerFile(Tool tool, CodeGenerator generator, Grammar grammar, ST outputFileST) throws IOException {
        String fileName = generator.getRecognizerFileName(grammar.name, grammar.type);
        generator.write(outputFileST, fileName);
    }

    protected void genRecognizerHeaderFile(Tool tool, CodeGenerator generator, Grammar grammar, ST headerFileST, String extName) throws IOException {
    }

    protected void performGrammarAnalysis(CodeGenerator generator, Grammar grammar) {
        grammar.buildNFA();
        grammar.createLookaheadDFAs();
    }

    public boolean isValidActionScope(int grammarType, String scope) {
        switch (grammarType) {
            case 1: {
                if (!scope.equals("lexer")) break;
                return true;
            }
            case 2: {
                if (!scope.equals("parser")) break;
                return true;
            }
            case 4: {
                if (scope.equals("parser")) {
                    return true;
                }
                if (!scope.equals("lexer")) break;
                return true;
            }
            case 3: {
                if (!scope.equals("treeparser")) break;
                return true;
            }
        }
        return false;
    }

    public String getTokenTypeAsTargetLabel(CodeGenerator generator, int ttype) {
        String name = generator.grammar.getTokenDisplayName(ttype);
        if (name.charAt(0) == '\'') {
            return String.valueOf(ttype);
        }
        return name;
    }

    public String getTargetCharLiteralFromANTLRCharLiteral(CodeGenerator generator, String literal) {
        StringBuffer buf = new StringBuffer();
        buf.append('\'');
        int c2 = Grammar.getCharValueFromGrammarCharLiteral(literal);
        if (c2 < 0) {
            return "'\u0000'";
        }
        if (c2 < this.targetCharValueEscape.length && this.targetCharValueEscape[c2] != null) {
            buf.append(this.targetCharValueEscape[c2]);
        } else if (Character.UnicodeBlock.of((char)c2) == Character.UnicodeBlock.BASIC_LATIN && !Character.isISOControl((char)c2)) {
            buf.append((char)c2);
        } else {
            String hex = Integer.toHexString(c2 | 0x10000).toUpperCase().substring(1, 5);
            buf.append("\\u");
            buf.append(hex);
        }
        buf.append('\'');
        return buf.toString();
    }

    public String getTargetStringLiteralFromANTLRStringLiteral(CodeGenerator generator, String literal) {
        StringBuilder sb = new StringBuilder();
        StringBuffer is = new StringBuffer(literal);
        sb.append('\"');
        for (int i2 = 1; i2 < is.length() - 1; ++i2) {
            if (is.charAt(i2) == '\\') {
                switch (is.charAt(i2 + 1)) {
                    case '\"': 
                    case '\\': 
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': 
                    case 'u': {
                        sb.append('\\');
                        break;
                    }
                }
                ++i2;
            } else if (is.charAt(i2) == '\"') {
                sb.append('\\');
            }
            sb.append(is.charAt(i2));
        }
        sb.append('\"');
        return sb.toString();
    }

    public String getTargetStringLiteralFromString(String s2, boolean quoted) {
        if (s2 == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        if (quoted) {
            buf.append('\"');
        }
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 != '\'' && c2 < this.targetCharValueEscape.length && this.targetCharValueEscape[c2] != null) {
                buf.append(this.targetCharValueEscape[c2]);
                continue;
            }
            buf.append(c2);
        }
        if (quoted) {
            buf.append('\"');
        }
        return buf.toString();
    }

    public String getTargetStringLiteralFromString(String s2) {
        return this.getTargetStringLiteralFromString(s2, false);
    }

    public String getTarget64BitStringFromValue(long word) {
        int numHexDigits = 16;
        StringBuffer buf = new StringBuffer(numHexDigits + 2);
        buf.append("0x");
        String digits = Long.toHexString(word);
        digits = digits.toUpperCase();
        int padding = numHexDigits - digits.length();
        for (int i2 = 1; i2 <= padding; ++i2) {
            buf.append('0');
        }
        buf.append(digits);
        return buf.toString();
    }

    public String encodeIntAsCharEscape(int v2) {
        if (v2 <= 127) {
            return "\\" + Integer.toOctalString(v2);
        }
        String hex = Integer.toHexString(v2 | 0x10000).substring(1, 5);
        return "\\u" + hex;
    }

    public int getMaxCharValue(CodeGenerator generator) {
        return 65535;
    }

    public List postProcessAction(List chunks, Token actionToken) {
        return chunks;
    }
}

