/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.codegen;

import java.io.IOException;
import org.antlr.Tool;
import org.antlr.codegen.CodeGenerator;
import org.antlr.codegen.Target;
import org.antlr.tool.Grammar;
import org.stringtemplate.v4.ST;

public class CPPTarget
extends Target {
    public String escapeChar(int c2) {
        switch (c2) {
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 13: {
                return "\\r";
            }
            case 92: {
                return "\\\\";
            }
            case 39: {
                return "\\'";
            }
            case 34: {
                return "\\\"";
            }
        }
        if (c2 < 32 || c2 > 126) {
            if (c2 > 255) {
                String s2 = Integer.toString(c2, 16);
                while (s2.length() < 4) {
                    s2 = '0' + s2;
                }
                return "\\u" + s2;
            }
            return "\\" + Integer.toString(c2, 8);
        }
        return String.valueOf((char)c2);
    }

    public String escapeString(String s2) {
        StringBuffer retval = new StringBuffer();
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            retval.append(this.escapeChar(s2.charAt(i2)));
        }
        return retval.toString();
    }

    protected void genRecognizerHeaderFile(Tool tool, CodeGenerator generator, Grammar grammar, ST headerFileST, String extName) throws IOException {
        generator.write(headerFileST, grammar.name + extName);
    }

    public String getTargetCharLiteralFromANTLRCharLiteral(CodeGenerator codegen, String literal) {
        int c2 = Grammar.getCharValueFromGrammarCharLiteral(literal);
        String prefix = "'";
        if (codegen.grammar.getMaxCharValue() > 255) {
            prefix = "L'";
        } else if ((c2 & 0x80) != 0) {
            return "" + c2;
        }
        return prefix + this.escapeChar(c2) + "'";
    }

    public String getTargetStringLiteralFromANTLRStringLiteral(CodeGenerator codegen, String literal) {
        StringBuffer buf = Grammar.getUnescapedStringFromGrammarStringLiteral(literal);
        String prefix = "\"";
        if (codegen.grammar.getMaxCharValue() > 255) {
            prefix = "L\"";
        }
        return prefix + this.escapeString(buf.toString()) + "\"";
    }

    public int getMaxCharValue(CodeGenerator codegen) {
        int maxval = 255;
        if (maxval <= 255) {
            return 255;
        }
        return maxval;
    }
}

