/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.codegen.CodeGenerator;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SemanticContext {
    public static final SemanticContext EMPTY_SEMANTIC_CONTEXT = new Predicate(-2);

    public abstract SemanticContext getGatedPredicateContext();

    public abstract ST genExpr(CodeGenerator var1, STGroup var2, DFA var3);

    public abstract boolean hasUserSemanticPredicate();

    public abstract boolean isSyntacticPredicate();

    public void trackUseOfSyntacticPredicates(Grammar g2) {
    }

    public static SemanticContext and(SemanticContext a2, SemanticContext b2) {
        boolean factored;
        SemanticContext[] terms = SemanticContext.factorOr(a2, b2);
        SemanticContext commonTerms = terms[0];
        a2 = terms[1];
        b2 = terms[2];
        boolean bl = factored = commonTerms != null && commonTerms != EMPTY_SEMANTIC_CONTEXT && !(commonTerms instanceof TruePredicate);
        if (factored) {
            return SemanticContext.or(commonTerms, SemanticContext.and(a2, b2));
        }
        if (a2 instanceof FalsePredicate || b2 instanceof FalsePredicate) {
            return new FalsePredicate();
        }
        if (a2 == EMPTY_SEMANTIC_CONTEXT || a2 == null) {
            return b2;
        }
        if (b2 == EMPTY_SEMANTIC_CONTEXT || b2 == null) {
            return a2;
        }
        if (a2 instanceof TruePredicate) {
            return b2;
        }
        if (b2 instanceof TruePredicate) {
            return a2;
        }
        return new AND(a2, b2);
    }

    public static SemanticContext or(SemanticContext a2, SemanticContext b2) {
        NOT n2;
        boolean factored;
        SemanticContext[] terms = SemanticContext.factorAnd(a2, b2);
        SemanticContext commonTerms = terms[0];
        a2 = terms[1];
        b2 = terms[2];
        boolean bl = factored = commonTerms != null && commonTerms != EMPTY_SEMANTIC_CONTEXT && !(commonTerms instanceof FalsePredicate);
        if (factored) {
            return SemanticContext.and(commonTerms, SemanticContext.or(a2, b2));
        }
        if (a2 == EMPTY_SEMANTIC_CONTEXT || a2 == null || a2 instanceof FalsePredicate) {
            return b2;
        }
        if (b2 == EMPTY_SEMANTIC_CONTEXT || b2 == null || b2 instanceof FalsePredicate) {
            return a2;
        }
        if (a2 instanceof TruePredicate || b2 instanceof TruePredicate || commonTerms instanceof TruePredicate) {
            return new TruePredicate();
        }
        if (a2 instanceof NOT) {
            n2 = (NOT)a2;
            if (n2.ctx.equals(b2)) {
                return new TruePredicate();
            }
        } else if (b2 instanceof NOT) {
            n2 = (NOT)b2;
            if (n2.ctx.equals(a2)) {
                return new TruePredicate();
            }
        }
        OR result = new OR(a2, b2);
        if (result.operands.size() == 1) {
            return (SemanticContext)result.operands.iterator().next();
        }
        return result;
    }

    public static SemanticContext not(SemanticContext a2) {
        if (a2 instanceof NOT) {
            return ((NOT)a2).ctx;
        }
        if (a2 instanceof TruePredicate) {
            return new FalsePredicate();
        }
        if (a2 instanceof FalsePredicate) {
            return new TruePredicate();
        }
        return new NOT(a2);
    }

    public static SemanticContext[] factorAnd(SemanticContext a2, SemanticContext b2) {
        if (a2 == EMPTY_SEMANTIC_CONTEXT || a2 == null || a2 instanceof FalsePredicate) {
            return new SemanticContext[]{EMPTY_SEMANTIC_CONTEXT, a2, b2};
        }
        if (b2 == EMPTY_SEMANTIC_CONTEXT || b2 == null || b2 instanceof FalsePredicate) {
            return new SemanticContext[]{EMPTY_SEMANTIC_CONTEXT, a2, b2};
        }
        if (a2 instanceof TruePredicate || b2 instanceof TruePredicate) {
            return new SemanticContext[]{new TruePredicate(), EMPTY_SEMANTIC_CONTEXT, EMPTY_SEMANTIC_CONTEXT};
        }
        HashSet<SemanticContext> opsA = new HashSet<SemanticContext>(SemanticContext.getAndOperands(a2));
        HashSet<SemanticContext> opsB = new HashSet<SemanticContext>(SemanticContext.getAndOperands(b2));
        HashSet<SemanticContext> result = new HashSet<SemanticContext>(opsA);
        result.retainAll(opsB);
        if (result.size() == 0) {
            return new SemanticContext[]{EMPTY_SEMANTIC_CONTEXT, a2, b2};
        }
        opsA.removeAll(result);
        a2 = opsA.size() == 0 ? new TruePredicate() : (opsA.size() == 1 ? opsA.iterator().next() : new AND(opsA));
        opsB.removeAll(result);
        b2 = opsB.size() == 0 ? new TruePredicate() : (opsB.size() == 1 ? opsB.iterator().next() : new AND(opsB));
        if (result.size() == 1) {
            return new SemanticContext[]{result.iterator().next(), a2, b2};
        }
        return new SemanticContext[]{new AND(result), a2, b2};
    }

    public static SemanticContext[] factorOr(SemanticContext a2, SemanticContext b2) {
        HashSet<SemanticContext> opsA = new HashSet<SemanticContext>(SemanticContext.getOrOperands(a2));
        HashSet<SemanticContext> opsB = new HashSet<SemanticContext>(SemanticContext.getOrOperands(b2));
        HashSet<SemanticContext> result = new HashSet<SemanticContext>(opsA);
        result.retainAll(opsB);
        if (result.size() == 0) {
            return new SemanticContext[]{EMPTY_SEMANTIC_CONTEXT, a2, b2};
        }
        opsA.removeAll(result);
        a2 = opsA.size() == 0 ? new FalsePredicate() : (opsA.size() == 1 ? opsA.iterator().next() : new OR(opsA));
        opsB.removeAll(result);
        b2 = opsB.size() == 0 ? new FalsePredicate() : (opsB.size() == 1 ? opsB.iterator().next() : new OR(opsB));
        if (result.size() == 1) {
            return new SemanticContext[]{result.iterator().next(), a2, b2};
        }
        return new SemanticContext[]{new OR(result), a2, b2};
    }

    public static Collection<SemanticContext> getAndOperands(SemanticContext context) {
        if (context instanceof AND) {
            return ((AND)context).operands;
        }
        if (context instanceof NOT) {
            Collection<SemanticContext> operands = SemanticContext.getOrOperands(((NOT)context).ctx);
            ArrayList<SemanticContext> result = new ArrayList<SemanticContext>(operands.size());
            for (SemanticContext operand : operands) {
                result.add(SemanticContext.not(operand));
            }
            return result;
        }
        ArrayList<SemanticContext> result = new ArrayList<SemanticContext>();
        result.add(context);
        return result;
    }

    public static Collection<SemanticContext> getOrOperands(SemanticContext context) {
        if (context instanceof OR) {
            return ((OR)context).operands;
        }
        if (context instanceof NOT) {
            Collection<SemanticContext> operands = SemanticContext.getAndOperands(((NOT)context).ctx);
            ArrayList<SemanticContext> result = new ArrayList<SemanticContext>(operands.size());
            for (SemanticContext operand : operands) {
                result.add(SemanticContext.not(operand));
            }
            return result;
        }
        ArrayList<SemanticContext> result = new ArrayList<SemanticContext>();
        result.add(context);
        return result;
    }

    public static class NOT
    extends SemanticContext {
        protected SemanticContext ctx;

        public NOT(SemanticContext ctx) {
            this.ctx = ctx;
        }

        public ST genExpr(CodeGenerator generator, STGroup templates, DFA dfa) {
            ST eST = null;
            eST = templates != null ? templates.getInstanceOf("notPredicate") : new ST("!(<pred>)");
            eST.add("pred", this.ctx.genExpr(generator, templates, dfa));
            return eST;
        }

        public SemanticContext getGatedPredicateContext() {
            SemanticContext p2 = this.ctx.getGatedPredicateContext();
            if (p2 == null) {
                return null;
            }
            return new NOT(p2);
        }

        public boolean hasUserSemanticPredicate() {
            return this.ctx.hasUserSemanticPredicate();
        }

        public boolean isSyntacticPredicate() {
            return this.ctx.isSyntacticPredicate();
        }

        public void trackUseOfSyntacticPredicates(Grammar g2) {
            this.ctx.trackUseOfSyntacticPredicates(g2);
        }

        public boolean equals(Object object) {
            if (!(object instanceof NOT)) {
                return false;
            }
            return this.ctx.equals(((NOT)object).ctx);
        }

        public int hashCode() {
            return ~this.ctx.hashCode();
        }

        public String toString() {
            return "!(" + this.ctx + ")";
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OR
    extends CommutativePredicate {
        public OR(SemanticContext a2, SemanticContext b2) {
            super(a2, b2);
        }

        public OR(HashSet<SemanticContext> contexts) {
            super(contexts);
        }

        @Override
        public ST genExpr(CodeGenerator generator, STGroup templates, DFA dfa) {
            ST eST = null;
            eST = templates != null ? templates.getInstanceOf("orPredicates") : new ST("(<first(operands)><rest(operands):{o | ||<o>}>)");
            for (SemanticContext semctx : this.operands) {
                eST.add("operands", semctx.genExpr(generator, templates, dfa));
            }
            return eST;
        }

        @Override
        public String getOperandString() {
            return "||";
        }

        @Override
        public SemanticContext combinePredicates(SemanticContext left, SemanticContext right) {
            return SemanticContext.or(left, right);
        }

        @Override
        public int calculateHashCode() {
            int hashcode = 0;
            for (SemanticContext context : this.operands) {
                hashcode = ~hashcode ^ context.hashCode();
            }
            return hashcode;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AND
    extends CommutativePredicate {
        public AND(SemanticContext a2, SemanticContext b2) {
            super(a2, b2);
        }

        public AND(HashSet<SemanticContext> contexts) {
            super(contexts);
        }

        @Override
        public ST genExpr(CodeGenerator generator, STGroup templates, DFA dfa) {
            ST result = null;
            for (SemanticContext operand : this.operands) {
                if (result == null) {
                    result = operand.genExpr(generator, templates, dfa);
                }
                ST eST = null;
                eST = templates != null ? templates.getInstanceOf("andPredicates") : new ST("(<left>&&<right>)");
                eST.add("left", result);
                eST.add("right", operand.genExpr(generator, templates, dfa));
                result = eST;
            }
            return result;
        }

        @Override
        public String getOperandString() {
            return "&&";
        }

        @Override
        public SemanticContext combinePredicates(SemanticContext left, SemanticContext right) {
            return SemanticContext.and(left, right);
        }

        @Override
        public int calculateHashCode() {
            int hashcode = 0;
            for (SemanticContext context : this.operands) {
                hashcode ^= context.hashCode();
            }
            return hashcode;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CommutativePredicate
    extends SemanticContext {
        protected final Set<SemanticContext> operands = new HashSet<SemanticContext>();
        protected int hashcode;

        public CommutativePredicate(SemanticContext a2, SemanticContext b2) {
            CommutativePredicate predicate;
            if (a2.getClass() == this.getClass()) {
                predicate = (CommutativePredicate)a2;
                this.operands.addAll(predicate.operands);
            } else {
                this.operands.add(a2);
            }
            if (b2.getClass() == this.getClass()) {
                predicate = (CommutativePredicate)b2;
                this.operands.addAll(predicate.operands);
            } else {
                this.operands.add(b2);
            }
            this.hashcode = this.calculateHashCode();
        }

        public CommutativePredicate(HashSet<SemanticContext> contexts) {
            for (SemanticContext context : contexts) {
                if (context.getClass() == this.getClass()) {
                    CommutativePredicate predicate = (CommutativePredicate)context;
                    this.operands.addAll(predicate.operands);
                    continue;
                }
                this.operands.add(context);
            }
            this.hashcode = this.calculateHashCode();
        }

        @Override
        public SemanticContext getGatedPredicateContext() {
            SemanticContext result = null;
            for (SemanticContext semctx : this.operands) {
                SemanticContext gatedPred = semctx.getGatedPredicateContext();
                if (gatedPred == null) continue;
                result = this.combinePredicates(result, gatedPred);
            }
            return result;
        }

        @Override
        public boolean hasUserSemanticPredicate() {
            for (SemanticContext semctx : this.operands) {
                if (!semctx.hasUserSemanticPredicate()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isSyntacticPredicate() {
            for (SemanticContext semctx : this.operands) {
                if (!semctx.isSyntacticPredicate()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void trackUseOfSyntacticPredicates(Grammar g2) {
            for (SemanticContext semctx : this.operands) {
                semctx.trackUseOfSyntacticPredicates(g2);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                CommutativePredicate commutative = (CommutativePredicate)obj;
                Set<SemanticContext> otherOperands = commutative.operands;
                if (this.operands.size() != otherOperands.size()) {
                    return false;
                }
                return this.operands.containsAll(otherOperands);
            }
            if (obj instanceof NOT) {
                NOT not = (NOT)obj;
                if (not.ctx instanceof CommutativePredicate && not.ctx.getClass() != this.getClass()) {
                    Set<SemanticContext> otherOperands = ((CommutativePredicate)not.ctx).operands;
                    if (this.operands.size() != otherOperands.size()) {
                        return false;
                    }
                    ArrayList<SemanticContext> temp = new ArrayList<SemanticContext>(this.operands.size());
                    for (SemanticContext context : otherOperands) {
                        temp.add(CommutativePredicate.not(context));
                    }
                    return this.operands.containsAll(temp);
                }
            }
            return false;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("(");
            int i2 = 0;
            for (SemanticContext semctx : this.operands) {
                if (i2 > 0) {
                    buf.append(this.getOperandString());
                }
                buf.append(semctx.toString());
                ++i2;
            }
            buf.append(")");
            return buf.toString();
        }

        public abstract String getOperandString();

        public abstract SemanticContext combinePredicates(SemanticContext var1, SemanticContext var2);

        public abstract int calculateHashCode();
    }

    public static class FalsePredicate
    extends Predicate {
        public FalsePredicate() {
            super(0);
        }

        public ST genExpr(CodeGenerator generator, STGroup templates, DFA dfa) {
            if (templates != null) {
                return templates.getInstanceOf("false");
            }
            return new ST("false");
        }

        public boolean hasUserSemanticPredicate() {
            return false;
        }

        public String toString() {
            return "false";
        }
    }

    public static class TruePredicate
    extends Predicate {
        public TruePredicate() {
            super(-1);
        }

        public ST genExpr(CodeGenerator generator, STGroup templates, DFA dfa) {
            if (templates != null) {
                return templates.getInstanceOf("true_value");
            }
            return new ST("true");
        }

        public boolean hasUserSemanticPredicate() {
            return false;
        }

        public String toString() {
            return "true";
        }
    }

    public static class Predicate
    extends SemanticContext {
        public GrammarAST predicateAST;
        protected boolean gated = false;
        protected boolean synpred = false;
        public static final int INVALID_PRED_VALUE = -2;
        public static final int FALSE_PRED = 0;
        public static final int TRUE_PRED = -1;
        protected int constantValue = -2;

        public Predicate(int constantValue) {
            this.predicateAST = new GrammarAST();
            this.constantValue = constantValue;
        }

        public Predicate(GrammarAST predicate) {
            this.predicateAST = predicate;
            this.gated = predicate.getType() == 44 || predicate.getType() == 45;
            this.synpred = predicate.getType() == 45 || predicate.getType() == 46;
        }

        public Predicate(Predicate p2) {
            this.predicateAST = p2.predicateAST;
            this.gated = p2.gated;
            this.synpred = p2.synpred;
            this.constantValue = p2.constantValue;
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof Predicate)) {
                return false;
            }
            Predicate other = (Predicate)o2;
            if (this.constantValue != other.constantValue) {
                return false;
            }
            if (this.constantValue != -2) {
                return true;
            }
            return this.predicateAST.getText().equals(other.predicateAST.getText());
        }

        public int hashCode() {
            if (this.constantValue != -2) {
                return this.constantValue;
            }
            if (this.predicateAST == null) {
                return 0;
            }
            return this.predicateAST.getText().hashCode();
        }

        public ST genExpr(CodeGenerator generator, STGroup templates, DFA dfa) {
            ST eST = null;
            if (templates != null) {
                if (this.synpred) {
                    eST = templates.getInstanceOf("evalSynPredicate");
                } else {
                    eST = templates.getInstanceOf("evalPredicate");
                    generator.grammar.decisionsWhoseDFAsUsesSemPreds.add(dfa);
                }
                String predEnclosingRuleName = this.predicateAST.enclosingRuleName;
                if (generator != null) {
                    eST.add("pred", generator.translateAction(predEnclosingRuleName, this.predicateAST));
                }
            } else {
                eST = new ST("<pred>");
                eST.add("pred", this.toString());
                return eST;
            }
            if (generator != null) {
                String description = generator.target.getTargetStringLiteralFromString(this.toString());
                eST.add("description", description);
            }
            return eST;
        }

        public SemanticContext getGatedPredicateContext() {
            if (this.gated) {
                return this;
            }
            return null;
        }

        public boolean hasUserSemanticPredicate() {
            return this.predicateAST != null && (this.predicateAST.getType() == 44 || this.predicateAST.getType() == 71);
        }

        public boolean isSyntacticPredicate() {
            return this.predicateAST != null && (this.predicateAST.getType() == 45 || this.predicateAST.getType() == 46);
        }

        public void trackUseOfSyntacticPredicates(Grammar g2) {
            if (this.synpred) {
                g2.synPredNamesUsedInDFA.add(this.predicateAST.getText());
            }
        }

        public String toString() {
            if (this.predicateAST == null) {
                return "<nopred>";
            }
            return this.predicateAST.getText();
        }
    }
}

