/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.HashSet;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.Transition;
import org.antlr.misc.Utils;
import org.antlr.tool.Grammar;

public class DFAOptimizer {
    public static boolean PRUNE_EBNF_EXIT_BRANCHES = true;
    public static boolean PRUNE_TOKENS_RULE_SUPERFLUOUS_EOT_EDGES = true;
    public static boolean COLLAPSE_ALL_PARALLEL_EDGES = true;
    public static boolean MERGE_STOP_STATES = true;
    protected Set visited = new HashSet();
    protected Grammar grammar;

    public DFAOptimizer(Grammar grammar) {
        this.grammar = grammar;
    }

    public void optimize() {
        for (int decisionNumber = 1; decisionNumber <= this.grammar.getNumberOfDecisions(); ++decisionNumber) {
            DFA dfa = this.grammar.getLookaheadDFA(decisionNumber);
            this.optimize(dfa);
        }
    }

    protected void optimize(DFA dfa) {
        if (dfa == null) {
            return;
        }
        if (PRUNE_EBNF_EXIT_BRANCHES && dfa.canInlineDecision()) {
            this.visited.clear();
            int decisionType = dfa.getNFADecisionStartState().decisionStateType;
            if (dfa.isGreedy() && (decisionType == 3 || decisionType == 1)) {
                this.optimizeExitBranches(dfa.startState);
            }
        }
        if (PRUNE_TOKENS_RULE_SUPERFLUOUS_EOT_EDGES && dfa.isTokensRuleDecision() && dfa.probe.stateToSyntacticallyAmbiguousTokensRuleAltsMap.size() > 0) {
            this.visited.clear();
            this.optimizeEOTBranches(dfa.startState);
        }
    }

    protected void optimizeExitBranches(DFAState d2) {
        Integer sI = Utils.integer(d2.stateNumber);
        if (this.visited.contains(sI)) {
            return;
        }
        this.visited.add(sI);
        int nAlts = d2.dfa.getNumberOfAlts();
        for (int i2 = 0; i2 < d2.getNumberOfTransitions(); ++i2) {
            Transition edge = d2.transition(i2);
            DFAState edgeTarget = (DFAState)edge.target;
            if (edgeTarget.isAcceptState() && edgeTarget.getUniquelyPredictedAlt() == nAlts) {
                d2.removeTransition(i2);
                --i2;
            }
            this.optimizeExitBranches(edgeTarget);
        }
    }

    protected void optimizeEOTBranches(DFAState d2) {
        Integer sI = Utils.integer(d2.stateNumber);
        if (this.visited.contains(sI)) {
            return;
        }
        this.visited.add(sI);
        for (int i2 = 0; i2 < d2.getNumberOfTransitions(); ++i2) {
            Transition edge = d2.transition(i2);
            DFAState edgeTarget = (DFAState)edge.target;
            if (PRUNE_TOKENS_RULE_SUPERFLUOUS_EOT_EDGES && edgeTarget.isAcceptState() && d2.getNumberOfTransitions() == 1 && edge.label.isAtom() && edge.label.getAtom() == -2) {
                d2.removeTransition(i2);
                d2.setAcceptState(true);
                d2.cachedUniquelyPredicatedAlt = edgeTarget.getUniquelyPredictedAlt();
                --i2;
            }
            this.optimizeEOTBranches(edgeTarget);
        }
    }
}

