/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.BtreeDictCompactor;
import com.sun.java.help.search.BtreeDictParameters;
import com.sun.java.help.search.ConceptLocation;
import com.sun.java.help.search.DocumentCompressor;
import com.sun.java.help.search.DocumentLists;
import com.sun.java.help.search.FullBtreeDict;
import com.sun.java.help.search.Schema;
import com.sun.java.help.search.Utilities;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.help.search.IndexBuilder;

public class DefaultIndexBuilder
extends IndexBuilder {
    private static int InitSize = 4096;
    private FullBtreeDict dict;
    protected Hashtable cache = new Hashtable(15000);
    private DocumentCompressor compr;
    private int free = 0;
    private int size = InitSize;
    private ConceptLocation[] locations = new ConceptLocation[this.size];
    private int freeID;
    private int currentDocID = 0;
    private Schema _schema;
    private BtreeDictParameters _tmapParams;
    private int _title = 0;
    private Hashtable tmpstopWords = new Hashtable();
    private boolean debug = false;

    public DefaultIndexBuilder(String string) throws Exception {
        super(string);
        this.removeExistingFiles(string);
        this._schema = new Schema(null, string, true);
        this._tmapParams = new BtreeDictParameters(this._schema, "TMAP");
        if (!this._tmapParams.readState()) {
            this._tmapParams.setBlockSize(2048);
            this._tmapParams.setRoot(0);
            this._tmapParams.setFreeID(1);
        }
        URL uRL = new URL("file", "", string);
        this.dict = new FullBtreeDict(this._tmapParams, true);
        this.freeID = this._tmapParams.getFreeID();
        this.compr = new DocumentCompressor(uRL);
    }

    public void storeStopWords(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.tmpstopWords.put(string, string);
        }
    }

    public Enumeration getStopWords() {
        return null;
    }

    private boolean isStopWord(String string) {
        return this.tmpstopWords.get(string) != null;
    }

    public void close() throws Exception {
        this.dict.close(this.freeID);
        this._tmapParams.setFreeID(this.freeID);
        this._tmapParams.updateSchema();
        this.debug("compacting...");
        BtreeDictCompactor btreeDictCompactor = new BtreeDictCompactor(this._tmapParams, false);
        URL uRL = new URL("file", "", this.indexDir + "compacted");
        BtreeDictParameters btreeDictParameters = new BtreeDictParameters(uRL, this._tmapParams.getBlockSize(), 0, this.freeID);
        btreeDictCompactor.compact(btreeDictParameters);
        URL uRL2 = new URL("file", "", this.indexDir + "TMAP");
        File file = new File(Utilities.URLDecoder(uRL2.getFile()));
        file.delete();
        File file2 = new File(Utilities.URLDecoder(uRL.getFile()));
        file2.renameTo(file);
        this._tmapParams.setRoot(btreeDictParameters.getRootPosition());
        this._tmapParams.updateSchema();
        this.debug("freeID is " + this.freeID);
        this.compr.close(this.indexDir + "OFFSETS");
        this.debug("inverting index");
        DocumentLists.invert(this.indexDir);
        this._schema.save();
    }

    public void openDocument(String string) throws Exception {
        if (this.currentDocID != 0) {
            throw new Exception("document already open");
        }
        this.currentDocID = this.intern(string);
    }

    public void closeDocument() throws Exception {
        if (this.currentDocID == 0) {
            throw new Exception("no document open");
        }
        this.compr.compress(this.currentDocID, this._title, this.locations, this.free, null, 0);
        this.free = 0;
        this.currentDocID = 0;
        this._title = 0;
    }

    public void storeLocation(String string, int n2) throws Exception {
        if (this.isStopWord(string)) {
            return;
        }
        if (this.free == this.size) {
            ConceptLocation[] conceptLocationArray = new ConceptLocation[this.size *= 2];
            System.arraycopy(this.locations, 0, conceptLocationArray, 0, this.free);
            this.locations = conceptLocationArray;
        }
        this.locations[this.free++] = new ConceptLocation(this.intern(string), n2, n2 + string.length());
    }

    public void storeTitle(String string) throws Exception {
        this._title = this.intern(string);
    }

    private int intern(String string) throws Exception {
        Integer n2 = (Integer)this.cache.get(string);
        if (n2 != null) {
            return n2;
        }
        int n3 = this.dict.fetch(string);
        if (n3 == 0) {
            n3 = this.freeID++;
            this.dict.store(string, n3);
        }
        this.cache.put(string, new Integer(n3));
        return n3;
    }

    private void removeExistingFiles(String string) {
        block14: {
            File file = new File(string);
            try {
                File file2;
                if (!file.exists()) break block14;
                try {
                    file2 = new File(file, "TMAP");
                    file2.delete();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    file2 = new File(file, "DOCS");
                    file2.delete();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    file2 = new File(file, "DOCS.TAB");
                    file2.delete();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    file2 = new File(file, "OFFSETS");
                    file2.delete();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    file2 = new File(file, "POSITIONS");
                    file2.delete();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    file2 = new File(file, "SCHEMA");
                    file2.delete();
                }
                catch (NullPointerException nullPointerException) {}
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    private void debug(String string) {
        if (this.debug) {
            System.err.println("DefaultIndexBuilder: " + string);
        }
    }
}

