/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.JideTabbedPaneUI;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.plaf.basic.Resource;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Sticky;
import com.jidesoft.swing.StringConverter;
import com.jidesoft.swing.TabEditingEvent;
import com.jidesoft.swing.TabEditingListener;
import com.jidesoft.swing.TabEditingValidator;
import com.jidesoft.utils.JideFocusTracker;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;

public class JideTabbedPane
extends JTabbedPane {
    private boolean _hideOneTab = false;
    private boolean _showTabButtons = false;
    private boolean _showCloseButton = false;
    private boolean _showCloseButtonOnTab = false;
    private boolean _showCloseButtonOnMouseOver = false;
    private boolean _useDefaultShowCloseButtonOnTab = false;
    private boolean _showTabArea = true;
    private boolean _showTabContent = true;
    private boolean _showIconsOnTab = true;
    private boolean _useDefaultShowIconsOnTab = true;
    private boolean _rightClickSelect;
    private boolean _dragOverDisabled;
    private boolean _scrollSelectedTabOnWheel = false;
    private int _tabAlignment = 10;
    public static final String SHRINK_TAB_PROPERTY = "shrinkTab";
    public static final String HIDE_IF_ONE_TAB_PROPERTY = "hideIfOneTab";
    public static final String SHOW_TAB_BUTTONS_PROPERTY = "showTabButtons";
    public static final String BOX_STYLE_PROPERTY = "boxStyle";
    public static final String SHOW_ICONS_PROPERTY = "showIconsOnTab";
    public static final String USE_DEFAULT_SHOW_ICONS_PROPERTY = "useDefaultShowIconsOnTab";
    public static final String SHOW_CLOSE_BUTTON_ON_TAB_PROPERTY = "showCloseButtonOnTab";
    public static final String SHOW_CLOSE_BUTTON_PROPERTY = "showCloseButton";
    public static final String SHOW_TAB_AREA_PROPERTY = "showTabArea";
    public static final String SHOW_TAB_CONTENT_PROPERTY = "showTabContent";
    public static final String TAB_CLOSABLE_PROPERTY = "tabClosable";
    public static final String USE_DEFAULT_SHOW_CLOSE_BUTTON_ON_TAB_PROPERTY = "useDefaultShowCloseButtonOnTab";
    public static final String BOLDACTIVETAB_PROPERTY = "boldActiveTab";
    public static final String GRIPPER_PROPERTY = "gripper";
    public static final String PROPERTY_TAB_SHAPE = "tabShape";
    public static final String PROPERTY_COLOR_THEME = "colorTheme";
    public static final String PROPERTY_TAB_RESIZE_MODE = "tabResizeMode";
    public static final String PROPERTY_TAB_LEADING_COMPONENT = "tabLeadingComponent";
    public static final String PROPERTY_TAB_TRAILING_COMPONENT = "tabTrailingComponent";
    public static final String PROPERTY_TAB_COLOR_PROVIDER = "tabColorProvider";
    public static final String PROPERTY_CONTENT_BORDER_INSETS = "contentBorderInsets";
    public static final String PROPERTY_TAB_AREA_INSETS = "tabAreaInsets";
    public static final String PROPERTY_TAB_INSETS = "tabInsets";
    public static final String PROPERTY_DRAG_OVER_DISABLED = "dragOverDisabled";
    public static final String SCROLL_TAB_ON_WHEEL_PROPERTY = "scrollTabOnWheel";
    public static final String PROPERTY_SELECTED_INDEX = "selectedIndex";
    public static final String PROPERTY_SHOW_CLOSE_BUTTON_ON_MOUSE_OVER = "showCloseButtonOnMouseOver";
    public static final int BUTTON_CLOSE = 0;
    public static final int BUTTON_EAST = 1;
    public static final int BUTTON_WEST = 2;
    public static final int BUTTON_NORTH = 3;
    public static final int BUTTON_SOUTH = 4;
    public static final int BUTTON_LIST = 5;
    private static final String uiClassID = "JideTabbedPaneUI";
    private boolean _showGripper = false;
    private StringConverter _stringConverter;
    private boolean _boldActiveTab = false;
    private Set<Object> _closableSet = new HashSet<Object>();
    private Hashtable<Component, Object> _pageLastFocusTrackers = new Hashtable();
    private Font _selectedTabFont;
    public static final int RESIZE_MODE_DEFAULT = 0;
    public static final int RESIZE_MODE_NONE = 1;
    public static final int RESIZE_MODE_FIT = 2;
    public static final int RESIZE_MODE_FIXED = 3;
    public static final int RESIZE_MODE_COMPRESSED = 4;
    private int _tabResizeMode = 0;
    public static final int COLOR_THEME_DEFAULT = 0;
    public static final int COLOR_THEME_WIN2K = 1;
    public static final int COLOR_THEME_OFFICE2003 = 2;
    public static final int COLOR_THEME_VSNET = 3;
    public static final int COLOR_THEME_WINXP = 4;
    private int _colorTheme = 0;
    public static final int SHAPE_DEFAULT = 0;
    public static final int SHAPE_WINDOWS = 1;
    public static final int SHAPE_VSNET = 2;
    public static final int SHAPE_BOX = 3;
    public static final int SHAPE_OFFICE2003 = 4;
    public static final int SHAPE_FLAT = 5;
    public static final int SHAPE_ECLIPSE = 6;
    public static final int SHAPE_ECLIPSE3X = 7;
    public static final int SHAPE_EXCEL = 8;
    public static final int SHAPE_ROUNDED_VSNET = 9;
    public static final int SHAPE_ROUNDED_FLAT = 10;
    public static final int SHAPE_WINDOWS_SELECTED = 11;
    private int _tabShape = 0;
    private Component _tabLeadingComponent = null;
    private Component _tabTrailingComponent = null;
    private boolean _hideTrailingWhileNoButtons = false;
    private boolean _showCloseButtonOnSelectedTab = false;
    private ListCellRenderer _tabListCellRenderer;
    private Insets _contentBorderInsets;
    private Insets _tabAreaInsets;
    private Insets _tabInsets;
    private static final Logger LOGGER_EVENT = Logger.getLogger(TabEditingEvent.class.getName());
    private boolean _closeTabOnMouseMiddleButton = false;
    private boolean _layoutTrailingComponentBeforeButtons = false;
    private JidePopup _tabListPopup;
    private Action _closeAction;
    boolean _autoFocusonTabHideClose = true;
    private boolean _suppressStateChangedEvents = false;
    private boolean _suppressSetSelectedIndex = false;
    private boolean _autoRequestFocus = true;
    protected transient boolean _tabEditingAllowed = false;
    protected transient TabEditingValidator _tabEditValidator;
    private ColorProvider _tabColorProvider;
    private static Color[] ONENOTE_COLORS = new Color[]{new Color(138, 168, 228), new Color(238, 149, 151), new Color(180, 158, 222), new Color(145, 186, 174), new Color(246, 176, 120), new Color(255, 216, 105), new Color(183, 201, 151)};
    public static ColorProvider ONENOTE_COLOR_PROVIDER = new OneNoteColorProvider();
    protected PropertyChangeListener _focusChangeListener;

    public JideTabbedPane() {
        this(1, 1);
    }

    public JideTabbedPane(int n2) {
        this(n2, 1);
    }

    public JideTabbedPane(int n2, int n3) {
        super(n2, n3);
        this.setModel(new IgnoreableSingleSelectionModel());
    }

    @Override
    public TabbedPaneUI getUI() {
        return (TabbedPaneUI)this.ui;
    }

    @Override
    public void setUI(TabbedPaneUI tabbedPaneUI) {
        super.setUI(tabbedPaneUI);
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI((TabbedPaneUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public boolean isHideOneTab() {
        return !this.isShowTabButtons() && this._hideOneTab;
    }

    public void setHideOneTab(boolean bl) {
        boolean bl2 = this._hideOneTab;
        if (bl2 != bl) {
            this._hideOneTab = bl;
            this.firePropertyChange(HIDE_IF_ONE_TAB_PROPERTY, bl2, this._hideOneTab);
        }
    }

    public boolean isTabShown() {
        return this.isShowTabArea() && (!this.isHideOneTab() || this.getTabCount() > 1);
    }

    public boolean isShowTabButtons() {
        return this._showTabButtons;
    }

    public void setShowTabButtons(boolean bl) {
        boolean bl2 = this._showTabButtons;
        if (bl2 != bl) {
            this._showTabButtons = bl;
            this.firePropertyChange(SHOW_TAB_BUTTONS_PROPERTY, bl2, this._showTabButtons);
        }
    }

    public void setCloseAction(Action action) {
        Action action2 = this._closeAction;
        if (action2 != action) {
            this._closeAction = action;
            this.firePropertyChange("closeTabAction", action2, this._closeAction);
        }
    }

    public Action getCloseAction() {
        return this._closeAction;
    }

    public void setAutoFocusOnTabHideClose(boolean bl) {
        this._autoFocusonTabHideClose = bl;
    }

    public boolean isAutoFocusOnTabHideClose() {
        return this._autoFocusonTabHideClose;
    }

    public void resetDefaultCloseAction() {
        this.setCloseAction(null);
    }

    public void setSuppressStateChangedEvents(boolean bl) {
        this._suppressStateChangedEvents = bl;
    }

    public boolean isSuppressStateChangedEvents() {
        return this._suppressStateChangedEvents;
    }

    @Override
    protected void fireStateChanged() {
        if (this._suppressStateChangedEvents) {
            return;
        }
        if (!this.isAutoFocusOnTabHideClose()) {
            this.clearVisComp();
        }
        super.fireStateChanged();
    }

    public boolean isSuppressSetSelectedIndex() {
        return this._suppressSetSelectedIndex;
    }

    public void setSuppressSetSelectedIndex(boolean bl) {
        this._suppressSetSelectedIndex = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedIndex(int n2) {
        if (this._suppressSetSelectedIndex) {
            return;
        }
        boolean bl = this.isFocusCycleRoot();
        this.setFocusCycleRoot(true);
        try {
            int n3 = this.getSelectedIndex();
            if (n3 != n2) {
                super.setSelectedIndex(n2);
                this.firePropertyChange(PROPERTY_SELECTED_INDEX, n3, n2);
            }
        }
        finally {
            this.setFocusCycleRoot(bl);
        }
    }

    public void popupSelectedIndex(int n2) {
        this.setSelectedIndex(n2);
    }

    @Override
    public void setComponentAt(int n2, Component component) {
        Component component2 = this.getComponentAt(n2);
        if (component2 != null) {
            PageLastFocusTracker pageLastFocusTracker = (PageLastFocusTracker)this._pageLastFocusTrackers.get(component2);
            this._pageLastFocusTrackers.remove(component2);
            if (pageLastFocusTracker != null) {
                pageLastFocusTracker.setHeighestComponent(null);
            }
        }
        boolean bl = false;
        if (this._closableSet.contains(component2)) {
            bl = true;
        }
        super.setComponentAt(n2, component);
        if (bl) {
            this._closableSet.add(component);
        }
        if (!this.isAutoFocusOnTabHideClose()) {
            this.clearVisComp();
        }
    }

    public boolean isAutoRequestFocus() {
        return this._autoRequestFocus;
    }

    public void setAutoRequestFocus(boolean bl) {
        this._autoRequestFocus = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void moveSelectedTabTo(int var1_1) {
        var2_2 = this.getSelectedIndex();
        if (var2_2 == var1_1) {
            return;
        }
        if (var1_1 == -1 || var2_2 == -1) {
            return;
        }
        if (this.isTabEditing()) {
            this.stopTabEditing();
        }
        var3_3 = this.getComponentAt(var2_2);
        var4_4 = this.isAutoRequestFocus();
        var5_5 = false;
        if (var3_3 != null && JideSwingUtilities.isAncestorOfFocusOwner(var3_3) && this.isAutoFocusOnTabHideClose()) {
            var5_5 = true;
        }
        try {
            this._suppressStateChangedEvents = true;
            this.setAutoRequestFocus(false);
            if (var2_2 - var1_1 == 1 || var1_1 - var2_2 == 1) {
                var6_6 = this.getComponentAt(var1_1);
                var7_8 = this.getTitleAt(var1_1);
                var8_10 = this.getToolTipTextAt(var1_1);
                var9_12 = this.getIconAt(var1_1);
                this._suppressSetSelectedIndex = true;
                var10_14 = true;
                if (this._closableSet != null) {
                    var10_14 = this.isTabClosableAt(var1_1);
                }
                try {
                    if (var1_1 > var2_2) {
                        this.insertTab(var7_8, var9_12, var6_6, var8_10, var2_2);
                    } else {
                        this.insertTab(var7_8, var9_12, var6_6, var8_10, var2_2 + 1);
                    }
                    if (var10_14) ** GOTO lbl57
                    this._closableSet.add(var6_6);
                }
                finally {
                    this._suppressSetSelectedIndex = false;
                }
            } else {
                var6_7 = this.getComponentAt(var2_2);
                var7_9 = this.getTitleAt(var2_2);
                var8_11 = this.getToolTipTextAt(var2_2);
                var9_13 = this.getIconAt(var2_2);
                this._suppressSetSelectedIndex = true;
                var10_15 = true;
                if (this._closableSet != null) {
                    var10_15 = this.isTabClosableAt(var1_1);
                }
                try {
                    if (var1_1 > var2_2) {
                        this.insertTab(var7_9, var9_13, var6_7, var8_11, var1_1 + 1);
                    } else {
                        this.insertTab(var7_9, var9_13, var6_7, var8_11, var1_1);
                    }
                    if (!var10_15) {
                        this._closableSet.add(var6_7);
                    }
                }
                finally {
                    this._suppressSetSelectedIndex = false;
                }
            }
            if (!SystemInfo.isJdk15Above() && var1_1 == this.getTabCount() - 2) {
                this.setSelectedIndex(this.getTabCount() - 1);
            }
            this.setAutoRequestFocus(var4_4);
            this.setSelectedIndex(var1_1);
        }
        finally {
            this._suppressStateChangedEvents = false;
            if (var5_5 && !this.requestFocusForVisibleComponent()) {
                this.requestFocusInWindow();
            }
        }
    }

    public boolean requestFocusForVisibleComponent() {
        return false;
    }

    public boolean isHideTrailingWhileNoButtons() {
        return this._hideTrailingWhileNoButtons;
    }

    public void setHideTrailingWhileNoButtons(boolean bl) {
        this._hideTrailingWhileNoButtons = bl;
    }

    public boolean isLayoutTrailingComponentBeforeButtons() {
        return this._layoutTrailingComponentBeforeButtons;
    }

    public void setLayoutTrailingComponentBeforeButtons(boolean bl) {
        this._layoutTrailingComponentBeforeButtons = bl;
    }

    public void processMouseSelection(int n2, MouseEvent mouseEvent) {
    }

    public int getTabHeight() {
        if (this.getTabPlacement() == 1 || this.getTabPlacement() == 3) {
            return ((JideTabbedPaneUI)this.getUI()).getTabPanel().getHeight();
        }
        return ((JideTabbedPaneUI)this.getUI()).getTabPanel().getWidth();
    }

    public boolean isRightClickSelect() {
        return this._rightClickSelect;
    }

    public void setRightClickSelect(boolean bl) {
        this._rightClickSelect = bl;
    }

    public int getTabAtLocation(int n2, int n3) {
        int n4 = this.getTabCount();
        int n5 = this.getUI().tabForCoordinate(this, n2, n3);
        return n5 < 0 || n5 >= n4 ? -1 : n5;
    }

    public boolean isShowGripper() {
        return this._showGripper;
    }

    public void setShowGripper(boolean bl) {
        boolean bl2 = this._showGripper;
        if (bl2 != bl) {
            this._showGripper = bl;
            this.firePropertyChange(GRIPPER_PROPERTY, bl2, this._showGripper);
        }
    }

    public boolean isShowIconsOnTab() {
        return this._showIconsOnTab;
    }

    public void setShowIconsOnTab(boolean bl) {
        boolean bl2 = this._showIconsOnTab;
        if (bl2 != bl) {
            this._showIconsOnTab = bl;
            this.firePropertyChange(SHOW_ICONS_PROPERTY, bl2, this._showIconsOnTab);
        }
    }

    public boolean isUseDefaultShowIconsOnTab() {
        return this._useDefaultShowIconsOnTab;
    }

    public void setUseDefaultShowIconsOnTab(boolean bl) {
        boolean bl2 = this._useDefaultShowIconsOnTab;
        if (bl2 != bl) {
            this._useDefaultShowIconsOnTab = bl;
            this.firePropertyChange(USE_DEFAULT_SHOW_ICONS_PROPERTY, bl2, this._useDefaultShowIconsOnTab);
        }
    }

    public boolean isShowCloseButtonOnTab() {
        return this._showCloseButtonOnTab;
    }

    public void setShowCloseButtonOnTab(boolean bl) {
        boolean bl2 = this._showCloseButtonOnTab;
        if (bl2 != bl) {
            this._showCloseButtonOnTab = bl;
            this.firePropertyChange(SHOW_CLOSE_BUTTON_ON_TAB_PROPERTY, bl2, this._showCloseButtonOnTab);
            if (this._showCloseButtonOnTab) {
                this.setShowCloseButton(true);
            }
        }
        this.setUseDefaultShowCloseButtonOnTab(false);
    }

    public boolean isUseDefaultShowCloseButtonOnTab() {
        return this._useDefaultShowCloseButtonOnTab;
    }

    public void setUseDefaultShowCloseButtonOnTab(boolean bl) {
        boolean bl2 = this._useDefaultShowCloseButtonOnTab;
        if (bl2 != bl) {
            this._useDefaultShowCloseButtonOnTab = bl;
            this.firePropertyChange(USE_DEFAULT_SHOW_CLOSE_BUTTON_ON_TAB_PROPERTY, bl2, this._useDefaultShowCloseButtonOnTab);
        }
    }

    public void setTabEditingAllowed(boolean bl) {
        this._tabEditingAllowed = bl;
    }

    public boolean isTabEditingAllowed() {
        return this._tabEditingAllowed && this.getTabLayoutPolicy() == 1;
    }

    public void setTabEditingValidator(TabEditingValidator tabEditingValidator) {
        this._tabEditValidator = tabEditingValidator;
    }

    public TabEditingValidator getTabEditingValidator() {
        return this._tabEditValidator;
    }

    public boolean isShowCloseButton() {
        return this._showCloseButton;
    }

    public void setShowCloseButton(boolean bl) {
        boolean bl2 = this._showCloseButton;
        if (bl2 != bl) {
            this._showCloseButton = bl;
            this.firePropertyChange(SHOW_CLOSE_BUTTON_PROPERTY, bl2, this._showCloseButton);
        }
    }

    public boolean isShowTabArea() {
        return this._showTabArea;
    }

    public void setShowTabArea(boolean bl) {
        boolean bl2 = this._showTabArea;
        if (bl2 != bl) {
            this._showTabArea = bl;
            this.firePropertyChange(SHOW_TAB_AREA_PROPERTY, bl2, this._showTabArea);
        }
    }

    public boolean isShowTabContent() {
        return this._showTabContent;
    }

    public void setShowTabContent(boolean bl) {
        boolean bl2 = this._showTabContent;
        if (bl2 != bl) {
            this._showTabContent = bl;
            this.firePropertyChange(SHOW_TAB_CONTENT_PROPERTY, bl2, this._showTabContent);
        }
    }

    public StringConverter getStringConverter() {
        return this._stringConverter;
    }

    public void setStringConverter(StringConverter stringConverter) {
        this._stringConverter = stringConverter;
    }

    public String getDisplayTitleAt(int n2) {
        if (this._stringConverter != null) {
            return this._stringConverter.convert(super.getTitleAt(n2));
        }
        return super.getTitleAt(n2);
    }

    public boolean isBoldActiveTab() {
        return this._boldActiveTab;
    }

    public void setBoldActiveTab(boolean bl) {
        boolean bl2 = this._boldActiveTab;
        if (bl2 != bl) {
            this._boldActiveTab = bl;
            this.firePropertyChange(BOLDACTIVETAB_PROPERTY, bl2, this._boldActiveTab);
        }
    }

    @Override
    public void removeTabAt(int n2) {
        int n3 = this.getTabCount();
        int n4 = this.getSelectedIndex();
        boolean bl = false;
        if (n4 == n2 && n4 < n3 - 1) {
            bl = !SystemInfo.isJdk15Above();
        }
        Component component = this.getComponentAt(n2);
        boolean bl2 = false;
        if (this._closableSet.contains(component)) {
            bl2 = true;
        }
        if (!this.isAutoFocusOnTabHideClose()) {
            this.clearVisComp();
        }
        super.removeTabAt(n2);
        if (bl2) {
            this._closableSet.remove(component);
        }
        if (component != null) {
            PageLastFocusTracker pageLastFocusTracker = (PageLastFocusTracker)this._pageLastFocusTrackers.get(component);
            this._pageLastFocusTrackers.remove(component);
            if (pageLastFocusTracker != null) {
                pageLastFocusTracker.setHeighestComponent(null);
            }
        }
        if (bl) {
            try {
                this.fireStateChanged();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.updateUI();
        if (this.getUI() instanceof BasicJideTabbedPaneUI) {
            ((BasicJideTabbedPaneUI)this.getUI()).ensureActiveTabIsVisible(true);
            if (this.isAutoFocusOnTabHideClose()) {
                ((BasicJideTabbedPaneUI)this.getUI()).requestFocusForVisibleComponent();
            }
        }
    }

    public boolean isTabClosableAt(int n2) {
        return !this._closableSet.contains(this.getComponentAt(n2));
    }

    public void setTabClosableAt(int n2, boolean bl) {
        if (bl) {
            this._closableSet.remove(this.getComponentAt(n2));
        } else {
            this._closableSet.add(this.getComponentAt(n2));
        }
        this.firePropertyChange(TAB_CLOSABLE_PROPERTY, !bl, bl);
    }

    protected Hashtable getPageLastFocusTrackers() {
        return this._pageLastFocusTrackers;
    }

    public Component getLastFocusedComponent(Component component) {
        if (component == null) {
            return null;
        }
        PageLastFocusTracker pageLastFocusTracker = (PageLastFocusTracker)this.getPageLastFocusTrackers().get(component);
        return pageLastFocusTracker != null ? pageLastFocusTracker.getLastFocusedComponent() : null;
    }

    protected void clearVisComp() {
        try {
            Field field = JTabbedPane.class.getDeclaredField("visComp");
            field.setAccessible(true);
            field.set(this, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, String string2, int n2) {
        if (component == this.getTabLeadingComponent() || component == this.getTabTrailingComponent()) {
            return;
        }
        if (component != null && !component.isVisible()) {
            component.setVisible(false);
        }
        super.insertTab(string, icon, component, string2, n2);
        if (component != null) {
            this._pageLastFocusTrackers.put(component, new PageLastFocusTracker(component));
        }
    }

    public Font getSelectedTabFont() {
        return this._selectedTabFont;
    }

    public void setSelectedTabFont(Font font) {
        this._selectedTabFont = font;
    }

    public int getColorTheme() {
        if (this._colorTheme == 0) {
            return this.getDefaultColorTheme();
        }
        return this._colorTheme;
    }

    public int getDefaultColorTheme() {
        return UIDefaultsLookup.getInt("JideTabbedPane.defaultTabColorTheme");
    }

    public void setColorTheme(int n2) {
        int n3 = this._colorTheme;
        if (n3 != n2) {
            this._colorTheme = n2;
            this.firePropertyChange(PROPERTY_COLOR_THEME, n3, n2);
        }
    }

    public int getTabResizeMode() {
        if (this._tabResizeMode == 0) {
            return this.getDefaultTabResizeMode();
        }
        return this._tabResizeMode;
    }

    public void setTabResizeMode(int n2) {
        int n3 = this._tabResizeMode;
        if (n3 != n2) {
            this._tabResizeMode = n2;
            this.firePropertyChange(PROPERTY_TAB_RESIZE_MODE, n3, n2);
        }
    }

    public int getDefaultTabResizeMode() {
        return UIDefaultsLookup.getInt("JideTabbedPane.defaultResizeMode");
    }

    public int getTabShape() {
        if (this._tabShape == 0) {
            return this.getDefaultTabStyle();
        }
        return this._tabShape;
    }

    public int getDefaultTabStyle() {
        return UIDefaultsLookup.getInt("JideTabbedPane.defaultTabShape");
    }

    public void setTabShape(int n2) {
        int n3 = this._tabShape;
        if (n3 != n2) {
            this._tabShape = n2;
            this.firePropertyChange(PROPERTY_TAB_SHAPE, n3, this._tabShape);
        }
    }

    public void setTabLeadingComponent(Component component) {
        Component component2 = this._tabLeadingComponent;
        this._tabLeadingComponent = component;
        this.firePropertyChange(PROPERTY_TAB_LEADING_COMPONENT, component2, component);
    }

    public Component getTabLeadingComponent() {
        return this._tabLeadingComponent;
    }

    public void setTabTrailingComponent(Component component) {
        Component component2 = this._tabTrailingComponent;
        this._tabTrailingComponent = component;
        this.firePropertyChange(PROPERTY_TAB_TRAILING_COMPONENT, component2, component);
    }

    @Override
    public Component add(Component component) {
        if (!(component instanceof UIResource) && component != this.getTabTrailingComponent() && component != this.getTabLeadingComponent()) {
            this.addTab(component.getName(), component);
        } else {
            this.addImpl(component, null, -1);
        }
        return component;
    }

    public Component getTabTrailingComponent() {
        return this._tabTrailingComponent;
    }

    public boolean isShowCloseButtonOnSelectedTab() {
        return this._showCloseButtonOnSelectedTab;
    }

    public void setShowCloseButtonOnSelectedTab(boolean bl) {
        this._showCloseButtonOnSelectedTab = bl;
    }

    public boolean isShowCloseButtonOnMouseOver() {
        return this._showCloseButtonOnMouseOver;
    }

    public void setShowCloseButtonOnMouseOver(boolean bl) {
        if (this._showCloseButtonOnMouseOver != bl) {
            boolean bl2 = this._showCloseButtonOnMouseOver;
            this._showCloseButtonOnMouseOver = bl;
            this.firePropertyChange(PROPERTY_SHOW_CLOSE_BUTTON_ON_MOUSE_OVER, bl2, this._showCloseButtonOnMouseOver);
        }
    }

    public ColorProvider getTabColorProvider() {
        return this._tabColorProvider;
    }

    public void setTabColorProvider(ColorProvider colorProvider) {
        ColorProvider colorProvider2 = this._tabColorProvider;
        if (colorProvider2 != colorProvider) {
            this._tabColorProvider = colorProvider;
            this.firePropertyChange(PROPERTY_TAB_COLOR_PROVIDER, colorProvider2, colorProvider);
        }
    }

    public void editTabAt(int n2) {
        boolean bl = ((JideTabbedPaneUI)this.getUI()).editTabAt(n2);
        if (bl) {
            this.fireTabEditing(3099, n2, this.getTitleAt(n2), null);
        }
    }

    public boolean isTabEditing() {
        return ((JideTabbedPaneUI)this.getUI()).isTabEditing();
    }

    public void stopTabEditing() {
        int n2 = this.getEditingTabIndex();
        if (n2 != -1 && n2 < this.getTabCount()) {
            String string = this.getTitleAt(n2);
            ((JideTabbedPaneUI)this.getUI()).stopTabEditing();
            String string2 = this.getTitleAt(n2);
            this.fireTabEditing(3100, n2, string, string2);
        }
    }

    public void cancelTabEditing() {
        int n2 = this.getEditingTabIndex();
        if (n2 != -1) {
            ((JideTabbedPaneUI)this.getUI()).cancelTabEditing();
            this.fireTabEditing(3101, n2, this.getTitleAt(n2), this.getTitleAt(n2));
        }
    }

    public int getEditingTabIndex() {
        return ((JideTabbedPaneUI)this.getUI()).getEditingTabIndex();
    }

    protected PropertyChangeListener createFocusChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl;
                boolean bl2 = JideTabbedPane.this.isAncestorOf((Component)propertyChangeEvent.getOldValue()) || JideTabbedPane.this == propertyChangeEvent.getOldValue();
                boolean bl3 = bl = JideTabbedPane.this == propertyChangeEvent.getNewValue() || JideTabbedPane.this.hasFocusComponent();
                if (bl != bl2) {
                    JideTabbedPane.this.repaintTabAreaAndContentBorder();
                }
            }
        };
    }

    public void repaintTabAreaAndContentBorder() {
        int n2 = 200;
        ((JideTabbedPaneUI)this.getUI()).getTabPanel().repaint(n2);
        Insets insets = this.getContentBorderInsets();
        if (insets == null) {
            LookAndFeelFactory.installJideExtension();
            insets = this.getContentBorderInsets();
        }
        if (insets != null && (insets.top != 0 || insets.bottom != 0 || insets.left != 0 || insets.right != 0)) {
            Insets insets2 = new Insets(0, 0, 0, 0);
            BasicJideTabbedPaneUI.rotateInsets(insets, insets2, this.tabPlacement);
            switch (this.getTabPlacement()) {
                case 1: {
                    insets2.top += this.getTabHeight();
                    break;
                }
                case 3: {
                    insets2.bottom += this.getTabHeight();
                    break;
                }
                case 2: {
                    insets2.left += this.getTabHeight();
                    break;
                }
                case 4: {
                    insets2.right += this.getTabHeight();
                }
            }
            if (insets2.top != 0) {
                this.repaintContentBorder(0, 0, this.getWidth(), insets2.top);
            }
            if (insets2.left != 0) {
                this.repaintContentBorder(0, 0, insets2.left, this.getHeight());
            }
            if (insets2.right != 0) {
                this.repaintContentBorder(this.getWidth() - insets2.right, 0, insets2.right, this.getHeight());
            }
            if (insets2.bottom != 0) {
                this.repaintContentBorder(0, this.getHeight() - insets2.bottom, this.getWidth(), insets2.bottom);
            }
        }
    }

    protected void repaintContentBorder(int n2, int n3, int n4, int n5) {
        this.repaint(n2, n3, n4, n5);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._focusChangeListener == null) {
            this._focusChangeListener = this.createFocusChangeListener();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this._focusChangeListener);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._focusChangeListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this._focusChangeListener);
            this._focusChangeListener = null;
        }
    }

    public ListCellRenderer getTabListCellRenderer() {
        if (this._tabListCellRenderer != null) {
            return this._tabListCellRenderer;
        }
        return new TabListCellRenderer();
    }

    public void setTabListCellRenderer(ListCellRenderer listCellRenderer) {
        this._tabListCellRenderer = listCellRenderer;
    }

    public boolean hasFocusComponent() {
        return JideSwingUtilities.isAncestorOfFocusOwner(this);
    }

    public Insets getContentBorderInsets() {
        return this._contentBorderInsets;
    }

    public void setContentBorderInsets(Insets insets) {
        Insets insets2 = this._contentBorderInsets;
        this._contentBorderInsets = insets;
        this.firePropertyChange(PROPERTY_CONTENT_BORDER_INSETS, insets2, this._contentBorderInsets);
    }

    public Insets getTabAreaInsets() {
        return this._tabAreaInsets;
    }

    public void setTabAreaInsets(Insets insets) {
        Insets insets2 = this._tabAreaInsets;
        this._tabAreaInsets = insets;
        this.firePropertyChange(PROPERTY_TAB_AREA_INSETS, insets2, this._tabAreaInsets);
    }

    public Insets getTabInsets() {
        return this._tabInsets;
    }

    public void setTabInsets(Insets insets) {
        Insets insets2 = this._tabInsets;
        this._tabInsets = insets;
        this.firePropertyChange(PROPERTY_TAB_INSETS, insets2, this._tabInsets);
    }

    public boolean isDragOverDisabled() {
        return this._dragOverDisabled;
    }

    public void setDragOverDisabled(boolean bl) {
        boolean bl2 = this._dragOverDisabled;
        if (bl2 != bl) {
            this._dragOverDisabled = bl;
            this.firePropertyChange(PROPERTY_DRAG_OVER_DISABLED, bl2, bl);
        }
    }

    public void scrollSelectedTabToVisible(boolean bl) {
        ((JideTabbedPaneUI)this.getUI()).ensureActiveTabIsVisible(bl);
    }

    public void addTabEditingListener(TabEditingListener tabEditingListener) {
        this.listenerList.add(TabEditingListener.class, tabEditingListener);
    }

    public void removeTabEditingListener(TabEditingListener tabEditingListener) {
        this.listenerList.remove(TabEditingListener.class, tabEditingListener);
    }

    public TabEditingListener[] getTabEditingListeners() {
        return (TabEditingListener[])this.listenerList.getListeners(TabEditingListener.class);
    }

    protected void fireTabEditing(int n2, int n3, String string, String string2) {
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (n2) {
                case 3099: {
                    LOGGER_EVENT.fine("TabEditing Started at tab \"" + n3 + "\"; the current title is " + string);
                    break;
                }
                case 3100: {
                    LOGGER_EVENT.fine("TabEditing Stopped at tab \"" + n3 + "\"; the old title is " + string + "; the new title is " + string2);
                    break;
                }
                case 3101: {
                    LOGGER_EVENT.fine("TabEditing Cancelled at tab \"" + n3 + "\"; the current title remains " + string);
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TabEditingListener.class) continue;
            TabEditingEvent tabEditingEvent = new TabEditingEvent(this, n2, n3, string, string2);
            if (n2 == 3099) {
                ((TabEditingListener)objectArray[i2 + 1]).editingStarted(tabEditingEvent);
                continue;
            }
            if (n2 == 3101) {
                ((TabEditingListener)objectArray[i2 + 1]).editingCanceled(tabEditingEvent);
                continue;
            }
            if (n2 != 3100) continue;
            ((TabEditingListener)objectArray[i2 + 1]).editingStopped(tabEditingEvent);
        }
    }

    public Icon getIconForTab(int n2) {
        boolean bl = UIDefaultsLookup.getBoolean("JideTabbedPane.showIconOnTab");
        if (this.isUseDefaultShowIconsOnTab()) {
            if (bl) {
                return !this.isEnabled() || !this.isEnabledAt(n2) ? this.getDisabledIconAt(n2) : this.getIconAt(n2);
            }
            return null;
        }
        if (this.isShowIconsOnTab()) {
            return !this.isEnabled() || !this.isEnabledAt(n2) ? this.getDisabledIconAt(n2) : this.getIconAt(n2);
        }
        return null;
    }

    public boolean isScrollSelectedTabOnWheel() {
        return this._scrollSelectedTabOnWheel;
    }

    public void setScrollSelectedTabOnWheel(boolean bl) {
        boolean bl2 = this.isScrollSelectedTabOnWheel();
        if (bl2 != bl) {
            this._scrollSelectedTabOnWheel = bl;
            this.firePropertyChange(SCROLL_TAB_ON_WHEEL_PROPERTY, bl2, this._scrollSelectedTabOnWheel);
        }
    }

    public boolean isCloseTabOnMouseMiddleButton() {
        return this._closeTabOnMouseMiddleButton;
    }

    public void setCloseTabOnMouseMiddleButton(boolean bl) {
        this._closeTabOnMouseMiddleButton = bl;
    }

    public int getTabAlignment() {
        return this._tabAlignment;
    }

    public void setTabAlignment(int n2) {
        if (n2 != 10 && n2 != 0) {
            throw new IllegalArgumentException("illegal tab alignment: must be LEADING or CENTER");
        }
        if (this._tabAlignment != n2) {
            int n3 = this._tabAlignment;
            this._tabAlignment = n2;
            this.firePropertyChange("tabAlignment", n3, n2);
            this.revalidate();
            this.repaint();
        }
    }

    public String getResourceString(String string) {
        return Resource.getResourceBundle(this.getLocale()).getString(string);
    }

    protected JidePopup createTabListPopup() {
        return new JidePopup();
    }

    public boolean isTabListPopupVisible() {
        return this._tabListPopup != null && this._tabListPopup.isPopupVisible();
    }

    public void hideTabListPopup() {
        if (this._tabListPopup != null) {
            if (this._tabListPopup.isPopupVisible()) {
                this._tabListPopup.hidePopupImmediately();
            }
            this._tabListPopup = null;
        }
    }

    public void showTabListPopup(JButton jButton) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(UIDefaultsLookup.getColor("JideTabbedPane.tabListBackground"));
        jPanel.setOpaque(true);
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JList jList = this.createTabList(jPanel.getInsets());
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setOpaque(false);
        jPanel.add(jScrollPane);
        this.hideTabListPopup();
        this._tabListPopup = this.createTabListPopup();
        this._tabListPopup.setComponentOrientation(this.getComponentOrientation());
        this._tabListPopup.setPopupBorder(BorderFactory.createLineBorder(UIDefaultsLookup.getColor("JideTabbedPane.darkShadow")));
        this._tabListPopup.add(jPanel);
        this._tabListPopup.addExcludedComponent(jButton);
        this._tabListPopup.setDefaultFocusComponent(jList);
        this._tabListPopup.setOwner(this);
        this._tabListPopup.removeExcludedComponent(this);
        Point point = this.calculateTabListPopupPosition(jButton);
        this._tabListPopup.showPopup(point.x, point.y);
    }

    protected Point calculateTabListPopupPosition(JButton jButton) {
        int n2;
        int n3;
        Dimension dimension = this._tabListPopup.getPreferredSize();
        Rectangle rectangle = jButton.getBounds();
        Point point = jButton.getLocationOnScreen();
        rectangle.x = point.x;
        rectangle.y = point.y;
        switch (this.getTabPlacement()) {
            default: {
                n3 = this.getComponentOrientation().isLeftToRight() ? rectangle.x + rectangle.width - dimension.width : rectangle.x;
                n2 = rectangle.y + rectangle.height + 2;
                break;
            }
            case 3: {
                n3 = this.getComponentOrientation().isLeftToRight() ? rectangle.x + rectangle.width - dimension.width : rectangle.x;
                n2 = rectangle.y - dimension.height - 2;
                break;
            }
            case 2: {
                n3 = rectangle.x + rectangle.width + 2;
                n2 = rectangle.y + rectangle.height - dimension.height;
                break;
            }
            case 4: {
                n3 = rectangle.x - dimension.width - 2;
                n2 = rectangle.y + rectangle.height - dimension.height;
            }
        }
        Rectangle rectangle2 = PortingUtils.getScreenBounds(this);
        int n4 = n3 + dimension.width + 3;
        int n5 = n2 + dimension.height + 3;
        if (n4 > rectangle2.x + rectangle2.width) {
            n3 -= n4 - rectangle2.x - rectangle2.width;
        }
        if (n3 < rectangle2.x) {
            n3 = rectangle2.x;
        }
        if (n5 > rectangle2.height) {
            n2 -= n5 - rectangle2.height;
        }
        if (n2 < rectangle2.y) {
            n2 = rectangle2.y;
        }
        return new Point(n3, n2);
    }

    protected JList createTabList(Insets insets) {
        int n2;
        final JList jList = new JList(){

            @Override
            public void removeSelectionInterval(int n2, int n3) {
                super.removeSelectionInterval(n2, n3);
                if (this.getSelectedIndex() == -1) {
                    this.setSelectedIndex(n2);
                }
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                int n2;
                Dimension dimension = super.getPreferredScrollableViewportSize();
                if (dimension.width < 150) {
                    dimension.width = 150;
                }
                if (dimension.width >= (n2 = PortingUtils.getScreenSize((Component)this).width)) {
                    dimension.width = n2;
                }
                return dimension;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                int n2 = PortingUtils.getScreenSize((Component)this).width;
                if (dimension.width >= n2) {
                    dimension.width = n2;
                }
                return dimension;
            }
        };
        DefaultListModel<JideTabbedPane> defaultListModel = new DefaultListModel<JideTabbedPane>();
        int n3 = this.getSelectedIndex();
        int n4 = this.getTabCount();
        for (n2 = 0; n2 < n4; ++n2) {
            defaultListModel.addElement(this);
        }
        jList.setCellRenderer(this.getTabListCellRenderer());
        jList.setModel(defaultListModel);
        jList.setSelectedIndex(n3);
        jList.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    JideTabbedPane.this.componentSelected(jList);
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                JideTabbedPane.this.componentSelected(jList);
            }
        });
        jList.setSelectionMode(0);
        n2 = (PortingUtils.getLocalScreenSize((Component)this).height - insets.top - insets.bottom) / jList.getCellBounds((int)0, (int)0).height;
        if (defaultListModel.getSize() > n2) {
            jList.setVisibleRowCount(n2);
        } else {
            jList.setVisibleRowCount(defaultListModel.getSize());
        }
        new Sticky(jList);
        jList.setBackground(UIDefaultsLookup.getColor("JideTabbedPane.tabListBackground"));
        return jList;
    }

    private void componentSelected(JList jList) {
        int n2 = jList.getSelectedIndex();
        if (n2 != -1 && this.isEnabledAt(n2)) {
            if (n2 == this.getSelectedIndex() && JideSwingUtilities.isAncestorOfFocusOwner(this)) {
                if (this.isAutoFocusOnTabHideClose() && this.isRequestFocusEnabled()) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            JideTabbedPane.this.requestFocus();
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            } else {
                this.setSelectedIndex(n2);
                final Component component = this.getComponentAt(n2);
                if (this.isAutoFocusOnTabHideClose() && !component.isVisible() && SystemInfo.isJdk15Above() && !SystemInfo.isJdk6Above()) {
                    component.addComponentListener(new ComponentAdapter(){

                        @Override
                        public void componentShown(ComponentEvent componentEvent) {
                            component.removeComponentListener(this);
                            final Component component2 = JideTabbedPane.this.getLastFocusedComponent(component);
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    if (component2 != null) {
                                        component2.requestFocus();
                                    } else if (JideTabbedPane.this.isRequestFocusEnabled()) {
                                        JideTabbedPane.this.requestFocus();
                                    }
                                }
                            };
                            SwingUtilities.invokeLater(runnable);
                        }
                    });
                } else {
                    final Component component2 = this.getLastFocusedComponent(component);
                    if (component2 != null) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                component2.requestFocus();
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    } else {
                        Component component3;
                        Container container = component instanceof Container ? (Container)component : component.getFocusCycleRootAncestor();
                        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
                        if (focusTraversalPolicy != null) {
                            component3 = focusTraversalPolicy.getDefaultComponent(container);
                            if (component3 == null) {
                                component3 = focusTraversalPolicy.getFirstComponent(container);
                            }
                        } else {
                            component3 = component instanceof Container ? this.findFocusableComponent((Container)component) : component;
                        }
                        if (component3 != null) {
                            final Component component4 = component3;
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    component4.requestFocus();
                                }
                            };
                            SwingUtilities.invokeLater(runnable);
                        }
                    }
                }
            }
            if (this.getUI() instanceof BasicJideTabbedPaneUI) {
                ((BasicJideTabbedPaneUI)this.getUI()).ensureActiveTabIsVisible(false);
            }
            this.hideTabListPopup();
        }
    }

    private Component findFocusableComponent(Container container) {
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        Component component = null;
        if (focusTraversalPolicy != null && (component = focusTraversalPolicy.getDefaultComponent(container)) == null) {
            component = focusTraversalPolicy.getFirstComponent(container);
        }
        if (component != null) {
            return component;
        }
        for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
            Component component2 = container.getComponent(i2);
            if (component2 instanceof Container) {
                component = this.findFocusableComponent((Container)component2);
                if (component == null) continue;
                return component;
            }
            if (!component2.isFocusable()) continue;
            return component2;
        }
        if (container.isFocusable()) {
            return container;
        }
        return null;
    }

    public NoFocusButton createNoFocusButton(int n2) {
        return new NoFocusButton(n2);
    }

    public class NoFocusButton
    extends JButton
    implements MouseMotionListener,
    MouseListener,
    UIResource {
        private int _type;
        private int _index = -1;
        private boolean _mouseOver = false;
        private boolean _mousePressed = false;

        @Override
        public void updateUI() {
            super.updateUI();
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.setRequestFocusEnabled(false);
            String string = this.getName();
            if (string != null) {
                this.setToolTipText(JideTabbedPane.this.getResourceString(string));
            }
        }

        public NoFocusButton() {
            this(0);
        }

        public NoFocusButton(int n2) {
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.setType(n2);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        public int getIndex() {
            return this._index;
        }

        public void setIndex(int n2) {
            this._index = n2;
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.getIcon() != null) {
                super.paintComponent(graphics);
                return;
            }
            if (!this.isEnabled()) {
                this.setMouseOver(false);
                this.setMousePressed(false);
            }
            if (this.isMouseOver() && this.isMousePressed()) {
                graphics.setColor(this.getPressedShadowColor());
                graphics.drawLine(0, 0, this.getWidth() - 1, 0);
                graphics.drawLine(0, this.getHeight() - 2, 0, 1);
                graphics.setColor(this.getShadowColor());
                graphics.drawLine(this.getWidth() - 1, 1, this.getWidth() - 1, this.getHeight() - 2);
                graphics.drawLine(this.getWidth() - 1, this.getHeight() - 1, 0, this.getHeight() - 1);
            } else if (this.isMouseOver()) {
                graphics.setColor(this.getShadowColor());
                graphics.drawLine(0, 0, this.getWidth() - 1, 0);
                graphics.drawLine(0, this.getHeight() - 2, 0, 1);
                graphics.setColor(this.getPressedShadowColor());
                graphics.drawLine(this.getWidth() - 1, 1, this.getWidth() - 1, this.getHeight() - 2);
                graphics.drawLine(this.getWidth() - 1, this.getHeight() - 1, 0, this.getHeight() - 1);
            }
            graphics.setColor(this.getForegroundColor());
            int n2 = this.getWidth() >> 1;
            int n3 = this.getHeight() >> 1;
            int n4 = this.getType();
            if (!(JideTabbedPane.this.getTabPlacement() != 1 && JideTabbedPane.this.getTabPlacement() != 3 || JideTabbedPane.this.getComponentOrientation().isLeftToRight())) {
                if (n4 == 1) {
                    n4 = 2;
                } else if (n4 == 2) {
                    n4 = 1;
                }
            }
            switch (n4) {
                case 0: {
                    Object object;
                    if (JideTabbedPane.this.isShowCloseButtonOnMouseOver() && !this.isMouseOver() && (object = JideTabbedPane.this.getClientProperty("JideTabbedPane.mouseOverTabIndex")) instanceof Integer && this.getIndex() >= 0 && ((Integer)object).intValue() != this.getIndex()) {
                        return;
                    }
                    if (this.isEnabled()) {
                        graphics.drawLine(n2 - 3, n3 - 3, n2 + 3, n3 + 3);
                        graphics.drawLine(n2 - 4, n3 - 3, n2 + 2, n3 + 3);
                        graphics.drawLine(n2 + 3, n3 - 3, n2 - 3, n3 + 3);
                        graphics.drawLine(n2 + 2, n3 - 3, n2 - 4, n3 + 3);
                        break;
                    }
                    graphics.drawLine(n2 - 3, n3 - 3, n2 + 3, n3 + 3);
                    graphics.drawLine(n2 + 3, n3 - 3, n2 - 3, n3 + 3);
                    break;
                }
                case 1: {
                    if (JideTabbedPane.this.getTabPlacement() == 1 || JideTabbedPane.this.getTabPlacement() == 3) {
                        int n5 = n2 + 2;
                        int n6 = n3;
                        if (this.isEnabled()) {
                            graphics.drawLine(n5 - 4, n6 - 4, n5 - 4, n6 + 4);
                            graphics.drawLine(n5 - 3, n6 - 3, n5 - 3, n6 + 3);
                            graphics.drawLine(n5 - 2, n6 - 2, n5 - 2, n6 + 2);
                            graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 + 1);
                            graphics.drawLine(n5, n6, n5, n6);
                            break;
                        }
                        graphics.drawLine(n5 - 4, n6 - 4, n5, n6);
                        graphics.drawLine(n5 - 4, n6 - 4, n5 - 4, n6 + 4);
                        graphics.drawLine(n5 - 4, n6 + 4, n5, n6);
                        break;
                    }
                    int n7 = n2 + 3;
                    int n8 = n3 - 2;
                    if (this.isEnabled()) {
                        graphics.drawLine(n7 - 8, n8, n7, n8);
                        graphics.drawLine(n7 - 7, n8 + 1, n7 - 1, n8 + 1);
                        graphics.drawLine(n7 - 6, n8 + 2, n7 - 2, n8 + 2);
                        graphics.drawLine(n7 - 5, n8 + 3, n7 - 3, n8 + 3);
                        graphics.drawLine(n7 - 4, n8 + 4, n7 - 4, n8 + 4);
                        break;
                    }
                    graphics.drawLine(n7 - 8, n8, n7, n8);
                    graphics.drawLine(n7 - 8, n8, n7 - 4, n8 + 4);
                    graphics.drawLine(n7 - 4, n8 + 4, n7, n8);
                    break;
                }
                case 2: {
                    if (JideTabbedPane.this.getTabPlacement() == 1 || JideTabbedPane.this.getTabPlacement() == 3) {
                        int n9 = n2 - 3;
                        int n10 = n3;
                        if (this.isEnabled()) {
                            graphics.drawLine(n9, n10, n9, n10);
                            graphics.drawLine(n9 + 1, n10 - 1, n9 + 1, n10 + 1);
                            graphics.drawLine(n9 + 2, n10 - 2, n9 + 2, n10 + 2);
                            graphics.drawLine(n9 + 3, n10 - 3, n9 + 3, n10 + 3);
                            graphics.drawLine(n9 + 4, n10 - 4, n9 + 4, n10 + 4);
                            break;
                        }
                        graphics.drawLine(n9, n10, n9 + 4, n10 - 4);
                        graphics.drawLine(n9, n10, n9 + 4, n10 + 4);
                        graphics.drawLine(n9 + 4, n10 - 4, n9 + 4, n10 + 4);
                        break;
                    }
                    int n11 = n2 - 5;
                    int n12 = n3 + 3;
                    if (this.isEnabled()) {
                        graphics.drawLine(n11, n12, n11 + 8, n12);
                        graphics.drawLine(n11 + 1, n12 - 1, n11 + 7, n12 - 1);
                        graphics.drawLine(n11 + 2, n12 - 2, n11 + 6, n12 - 2);
                        graphics.drawLine(n11 + 3, n12 - 3, n11 + 5, n12 - 3);
                        graphics.drawLine(n11 + 4, n12 - 4, n11 + 4, n12 - 4);
                        break;
                    }
                    graphics.drawLine(n11, n12, n11 + 8, n12);
                    graphics.drawLine(n11, n12, n11 + 4, n12 - 4);
                    graphics.drawLine(n11 + 8, n12, n11 + 4, n12 - 4);
                    break;
                }
                case 5: {
                    int n13 = n2 + 2;
                    int n14 = n3;
                    graphics.drawLine(n13 - 6, n14 - 4, n13 - 6, n14 + 4);
                    graphics.drawLine(n13 + 1, n14 - 4, n13 + 1, n14 + 4);
                    graphics.drawLine(n13 - 6, n14 - 4, n13 + 1, n14 - 4);
                    graphics.drawLine(n13 - 4, n14 - 2, n13 - 1, n14 - 2);
                    graphics.drawLine(n13 - 4, n14, n13 - 1, n14);
                    graphics.drawLine(n13 - 4, n14 + 2, n13 - 1, n14 + 2);
                    graphics.drawLine(n13 - 6, n14 + 4, n13 + 1, n14 + 4);
                    break;
                }
            }
        }

        protected Color getForegroundColor() {
            return UIDefaultsLookup.getColor("JideTabbedPane.foreground");
        }

        protected Color getShadowColor() {
            return UIDefaultsLookup.getColor("control");
        }

        protected Color getPressedShadowColor() {
            return UIDefaultsLookup.getColor("controlDkShadow");
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public boolean isOpaque() {
            return false;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(true);
            this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(true);
            this.setMousePressed(false);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMousePressed(true);
            this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMousePressed(false);
            this.setMouseOver(false);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(true);
            this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(false);
            this.setMousePressed(false);
            this.repaint();
            JideTabbedPane.this.repaint();
        }

        public int getType() {
            return this._type;
        }

        public void setType(int n2) {
            this._type = n2;
        }

        public boolean isMouseOver() {
            return this._mouseOver;
        }

        public void setMouseOver(boolean bl) {
            this._mouseOver = bl;
        }

        public boolean isMousePressed() {
            return this._mousePressed;
        }

        public void setMousePressed(boolean bl) {
            this._mousePressed = bl;
        }
    }

    public static class TabListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            if (object instanceof JideTabbedPane) {
                JideTabbedPane jideTabbedPane = (JideTabbedPane)object;
                String string = jideTabbedPane.getTitleAt(n2);
                String string2 = jideTabbedPane.getToolTipTextAt(n2);
                Icon icon = jideTabbedPane.getIconForTab(n2);
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, string, n2, bl, bl2);
                jLabel.setToolTipText(string2);
                Font font = jideTabbedPane.getSelectedIndex() == n2 && jideTabbedPane.getSelectedTabFont() != null ? jideTabbedPane.getSelectedTabFont() : jideTabbedPane.getFont();
                if (jideTabbedPane.getSelectedIndex() == n2 && jideTabbedPane.isBoldActiveTab() && font.getStyle() != 1) {
                    font = font.deriveFont(1);
                }
                jLabel.setFont(font);
                jLabel.setIcon(icon);
                jLabel.setEnabled(jideTabbedPane.isEnabledAt(n2));
                return jLabel;
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n2, bl, bl2);
        }
    }

    private static class OneNoteColorProvider
    implements ColorProvider {
        private OneNoteColorProvider() {
        }

        @Override
        public Color getBackgroundAt(int n2) {
            return ONENOTE_COLORS[n2 % ONENOTE_COLORS.length];
        }

        @Override
        public Color getForegroundAt(int n2) {
            return Color.BLACK;
        }

        @Override
        public float getGradientRatio(int n2) {
            return 0.86f;
        }
    }

    public static interface GradientColorProvider
    extends ColorProvider {
        public Color getTopBackgroundAt(int var1);
    }

    public static interface ColorProvider {
        public Color getBackgroundAt(int var1);

        public Color getForegroundAt(int var1);

        public float getGradientRatio(int var1);
    }

    protected class PageLastFocusTracker
    extends JideFocusTracker {
        private Component _lastFocusedComponent;
        private FocusListener _lastFocusedListener;

        protected PageLastFocusTracker(Component component) {
            this.setHeighestComponent(component);
        }

        protected Component getLastFocusedComponent() {
            return this._lastFocusedComponent;
        }

        @Override
        public void setHeighestComponent(Component component) {
            if (component == null) {
                if (this._lastFocusedListener != null) {
                    this.removeFocusListener(this._lastFocusedListener);
                    this._lastFocusedListener = null;
                }
            } else if (this._lastFocusedListener == null) {
                this._lastFocusedListener = new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        PageLastFocusTracker.this._lastFocusedComponent = focusEvent.getComponent();
                    }
                };
                this.addFocusListener(this._lastFocusedListener);
            }
            super.setHeighestComponent(component);
        }
    }

    protected class IgnoreableSingleSelectionModel
    extends DefaultSingleSelectionModel {
        private static final long serialVersionUID = -4321082126384337792L;

        protected IgnoreableSingleSelectionModel() {
        }

        @Override
        protected void fireStateChanged() {
            if (!JideTabbedPane.this._suppressStateChangedEvents) {
                super.fireStateChanged();
            }
        }
    }
}

