/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.windows;

import com.jidesoft.plaf.windows.AnimationController;
import com.jidesoft.plaf.windows.TMSchema;
import com.jidesoft.utils.ReflectionUtils;
import com.jidesoft.utils.SystemInfo;
import com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import sun.awt.image.SunWritableRaster;
import sun.awt.image.SurfaceManager;
import sun.awt.windows.ThemeReader;
import sun.security.action.GetPropertyAction;
import sun.swing.CachedPainter;

public class XPStyle {
    private static XPStyle xp;
    private static SkinPainter skinPainter;
    private static Boolean themeActive;
    private HashMap<String, Border> borderMap;
    private HashMap<String, Color> colorMap;
    private boolean flatMenus = XPStyle.getSysBoolean(TMSchema.Prop.FLATMENUS);

    public static synchronized void invalidateStyle() {
        xp = null;
        themeActive = null;
        skinPainter.flush();
    }

    public static synchronized XPStyle getXP() {
        if (themeActive == null) {
            GetPropertyAction getPropertyAction;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            themeActive = (Boolean)toolkit.getDesktopProperty("win.xpstyle.themeActive");
            if (themeActive == null) {
                themeActive = Boolean.FALSE;
            }
            if (themeActive.booleanValue() && AccessController.doPrivileged(getPropertyAction = new GetPropertyAction("swing.noxp")) == null && ThemeReader.isThemed() && !(UIManager.getLookAndFeel() instanceof WindowsClassicLookAndFeel)) {
                xp = new XPStyle();
            }
        }
        return xp;
    }

    public static boolean isVista() {
        XPStyle xPStyle = XPStyle.getXP();
        return xPStyle != null && xPStyle.isSkinDefined(null, TMSchema.Part.CP_DROPDOWNBUTTONRIGHT);
    }

    public String getString(Component component, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        return XPStyle.getTypeEnumName(component, part, state, prop);
    }

    public TMSchema.TypeEnum getTypeEnum(Component component, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        int n2 = ThemeReader.getEnum((String)part.getControlName(component), (int)part.getValue(), (int)TMSchema.State.getValue(part, state), (int)prop.getValue());
        return TMSchema.TypeEnum.getTypeEnum(prop, n2);
    }

    private static String getTypeEnumName(Component component, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        int n2 = ThemeReader.getEnum((String)part.getControlName(component), (int)part.getValue(), (int)TMSchema.State.getValue(part, state), (int)prop.getValue());
        if (n2 == -1) {
            return null;
        }
        return TMSchema.TypeEnum.getTypeEnum(prop, n2).getName();
    }

    public int getInt(Component component, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop, int n2) {
        return ThemeReader.getInt((String)part.getControlName(component), (int)part.getValue(), (int)TMSchema.State.getValue(part, state), (int)prop.getValue());
    }

    public Dimension getDimension(Component component, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        return ThemeReader.getPosition((String)part.getControlName(component), (int)part.getValue(), (int)TMSchema.State.getValue(part, state), (int)prop.getValue());
    }

    public Point getPoint(Component component, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        Dimension dimension = ThemeReader.getPosition((String)part.getControlName(component), (int)part.getValue(), (int)TMSchema.State.getValue(part, state), (int)prop.getValue());
        if (dimension != null) {
            return new Point(dimension.width, dimension.height);
        }
        return null;
    }

    public Insets getMargin(Component component, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        return ThemeReader.getThemeMargins((String)part.getControlName(component), (int)part.getValue(), (int)TMSchema.State.getValue(part, state), (int)prop.getValue());
    }

    public synchronized Color getColor(Skin skin, TMSchema.Prop prop, Color color) {
        String string = skin.toString() + "." + prop.name();
        TMSchema.Part part = skin.part;
        Color color2 = this.colorMap.get(string);
        if (color2 == null && (color2 = ThemeReader.getColor((String)part.getControlName(null), (int)part.getValue(), (int)TMSchema.State.getValue(part, skin.state), (int)prop.getValue())) != null) {
            color2 = new ColorUIResource(color2);
            this.colorMap.put(string, color2);
        }
        return color2 != null ? color2 : color;
    }

    Color getColor(Component component, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop, Color color) {
        return this.getColor(new Skin(component, part, state), prop, color);
    }

    public synchronized Border getBorder(Component component, TMSchema.Part part) {
        if (part == TMSchema.Part.MENU) {
            if (this.flatMenus) {
                return new XPFillBorder(UIManager.getColor("InternalFrame.borderShadow"), 1);
            }
            return null;
        }
        Skin skin = new Skin(component, part, null);
        Border border = this.borderMap.get(skin.string);
        if (border == null) {
            Insets insets;
            String string = XPStyle.getTypeEnumName(component, part, null, TMSchema.Prop.BGTYPE);
            if ("borderfill".equalsIgnoreCase(string)) {
                int n2 = this.getInt(component, part, null, TMSchema.Prop.BORDERSIZE, 1);
                Color color = this.getColor(skin, TMSchema.Prop.BORDERCOLOR, Color.black);
                border = new XPFillBorder(color, n2);
                if (part == TMSchema.Part.CP_COMBOBOX) {
                    border = new XPStatefulFillBorder(color, n2, part, TMSchema.Prop.BORDERCOLOR);
                }
            } else if ("imagefile".equalsIgnoreCase(string) && (insets = this.getMargin(component, part, null, TMSchema.Prop.SIZINGMARGINS)) != null) {
                border = this.getBoolean(component, part, null, TMSchema.Prop.BORDERONLY) ? new XPImageBorder(component, part) : (part == TMSchema.Part.CP_COMBOBOX ? new EmptyBorder(1, 1, 1, 1) : (part == TMSchema.Part.TP_BUTTON ? new XPEmptyBorder(new Insets(3, 3, 3, 3)) : new XPEmptyBorder(insets)));
            }
            if (border != null) {
                this.borderMap.put(skin.string, border);
            }
        }
        return border;
    }

    public boolean isSkinDefined(Component component, TMSchema.Part part) {
        return part.getValue() == 0 || ThemeReader.isThemePartDefined((String)part.getControlName(component), (int)part.getValue(), (int)0);
    }

    public synchronized Skin getSkin(Component component, TMSchema.Part part) {
        assert (this.isSkinDefined(component, part)) : "part " + (Object)((Object)part) + " is not defined";
        return new Skin(component, part, null);
    }

    long getThemeTransitionDuration(Component component, TMSchema.Part part, TMSchema.State state, TMSchema.State state2, TMSchema.Prop prop) {
        return ThemeReader.getThemeTransitionDuration((String)part.getControlName(component), (int)part.getValue(), (int)TMSchema.State.getValue(part, state), (int)TMSchema.State.getValue(part, state2), (int)(prop != null ? prop.getValue() : 0));
    }

    private XPStyle() {
        this.colorMap = new HashMap();
        this.borderMap = new HashMap();
    }

    private boolean getBoolean(Component component, TMSchema.Part part, TMSchema.State state, TMSchema.Prop prop) {
        return ThemeReader.getBoolean((String)part.getControlName(component), (int)part.getValue(), (int)TMSchema.State.getValue(part, state), (int)prop.getValue());
    }

    static Dimension getPartSize(TMSchema.Part part, TMSchema.State state) {
        return ThemeReader.getPartSize((String)part.getControlName(null), (int)part.getValue(), (int)TMSchema.State.getValue(part, state));
    }

    private static boolean getSysBoolean(TMSchema.Prop prop) {
        return ThemeReader.getSysBoolean((String)"window", (int)prop.getValue());
    }

    static {
        skinPainter = new SkinPainter();
        themeActive = null;
        XPStyle.invalidateStyle();
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
                    XPStyle.invalidateStyle();
                }
            }
        });
    }

    static class GlyphButton
    extends JButton {
        private Skin skin;

        public GlyphButton(Component component, TMSchema.Part part) {
            XPStyle xPStyle = XPStyle.getXP();
            this.skin = xPStyle.getSkin(component, part);
            this.setBorder(null);
            this.setContentAreaFilled(false);
            this.setMinimumSize(new Dimension(5, 5));
            this.setPreferredSize(new Dimension(16, 16));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        protected TMSchema.State getState() {
            TMSchema.State state = TMSchema.State.NORMAL;
            if (!this.isEnabled()) {
                state = TMSchema.State.DISABLED;
            } else if (this.getModel().isPressed()) {
                state = TMSchema.State.PRESSED;
            } else if (this.getModel().isRollover()) {
                state = TMSchema.State.HOT;
            }
            return state;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Dimension dimension = this.getSize();
            this.skin.paintSkin(graphics, 0, 0, dimension.width, dimension.height, this.getState());
        }

        public void setPart(Component component, TMSchema.Part part) {
            XPStyle xPStyle = XPStyle.getXP();
            this.skin = xPStyle.getSkin(component, part);
            this.revalidate();
            this.repaint();
        }

        @Override
        protected void paintBorder(Graphics graphics) {
        }
    }

    private static class SkinPainter
    extends CachedPainter {
        SkinPainter() {
            super(30);
            this.flush();
        }

        @Override
        public void flush() {
            super.flush();
        }

        @Override
        protected void paintToImage(Component component, Image image, Graphics graphics, int n2, int n3, Object[] objectArray) {
            if (!SystemInfo.isJdk7Above()) {
                BufferedImage bufferedImage;
                SurfaceManager surfaceManager;
                boolean bl = false;
                Skin skin = (Skin)objectArray[0];
                TMSchema.Part part = skin.part;
                TMSchema.State state = (TMSchema.State)((Object)objectArray[1]);
                if (state == null) {
                    state = skin.state;
                }
                if (component == null) {
                    component = skin.component;
                }
                if ((surfaceManager = SurfaceManager.getManager(bufferedImage = (BufferedImage)image)).getClass().getName().equals("sun.awt.image.CachingSurfaceManager")) {
                    try {
                        bl = (Boolean)ReflectionUtils.callGet(surfaceManager, "isLocalAccelerationEnabled");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                WritableRaster writableRaster = bufferedImage.getRaster();
                DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
                ThemeReader.paintBackground((int[])dataBufferInt.getData(), (String)part.getControlName(component), (int)part.getValue(), (int)TMSchema.State.getValue(part, state), (int)0, (int)0, (int)n2, (int)n3, (int)n2);
                if (surfaceManager.getClass().getName().equals("sun.awt.image.CachingSurfaceManager")) {
                    try {
                        boolean bl2 = (Boolean)ReflectionUtils.callGet(surfaceManager, "isLocalAccelerationEnabled");
                        if (bl != bl2) {
                            ReflectionUtils.callSet(surfaceManager, "setLocalAccelerationEnabled", bl);
                            ReflectionUtils.call(surfaceManager, "rasterChanged");
                        }
                    }
                    catch (Exception exception) {}
                }
            } else {
                boolean bl = false;
                Skin skin = (Skin)objectArray[0];
                TMSchema.Part part = skin.part;
                TMSchema.State state = (TMSchema.State)((Object)objectArray[1]);
                if (state == null) {
                    state = skin.state;
                }
                if (component == null) {
                    component = skin.component;
                }
                BufferedImage bufferedImage = (BufferedImage)image;
                WritableRaster writableRaster = bufferedImage.getRaster();
                DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
                try {
                    ThemeReader.paintBackground((int[])((int[])ReflectionUtils.callStatic(SunWritableRaster.class, "stealData", new Class[]{DataBufferInt.class, Integer.TYPE}, new Object[]{dataBufferInt, 0})), (String)part.getControlName(component), (int)part.getValue(), (int)TMSchema.State.getValue(part, state), (int)0, (int)0, (int)n2, (int)n3, (int)n2);
                    ReflectionUtils.callStatic(SunWritableRaster.class, "markDirty", new Class[]{DataBuffer.class}, new Object[]{dataBufferInt});
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        @Override
        protected Image createImage(Component component, int n2, int n3, GraphicsConfiguration graphicsConfiguration, Object[] objectArray) {
            return new BufferedImage(n2, n3, 2);
        }
    }

    public static class Skin {
        final Component component;
        final TMSchema.Part part;
        final TMSchema.State state;
        private final String string;
        private Dimension size = null;

        Skin(Component component, TMSchema.Part part) {
            this(component, part, null);
        }

        Skin(TMSchema.Part part, TMSchema.State state) {
            this(null, part, state);
        }

        Skin(Component component, TMSchema.Part part, TMSchema.State state) {
            this.component = component;
            this.part = part;
            this.state = state;
            String string = part.getControlName(component) + "." + part.name();
            if (state != null) {
                string = string + "(" + state.name() + ")";
            }
            this.string = string;
        }

        private int getWidth(TMSchema.State state) {
            if (this.size == null) {
                this.size = XPStyle.getPartSize(this.part, state);
            }
            return this.size.width;
        }

        int getWidth() {
            return this.getWidth(this.state != null ? this.state : TMSchema.State.NORMAL);
        }

        private int getHeight(TMSchema.State state) {
            if (this.size == null) {
                this.size = XPStyle.getPartSize(this.part, state);
            }
            return this.size.height;
        }

        int getHeight() {
            return this.getHeight(this.state != null ? this.state : TMSchema.State.NORMAL);
        }

        public String toString() {
            return this.string;
        }

        public boolean equals(Object object) {
            return object instanceof Skin && ((Skin)object).string.equals(this.string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public void paintSkin(Graphics graphics, int n2, int n3, TMSchema.State state) {
            if (state == null) {
                state = this.state;
            }
            this.paintSkin(graphics, n2, n3, this.getWidth(state), this.getHeight(state), state);
        }

        public void paintSkin(Graphics graphics, Rectangle rectangle, TMSchema.State state) {
            this.paintSkin(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, state);
        }

        public void paintSkin(Graphics graphics, int n2, int n3, int n4, int n5, TMSchema.State state) {
            if (SystemInfo.isJdk6Above() && ThemeReader.isGetThemeTransitionDurationDefined() && this.component instanceof JComponent && SwingUtilities.getAncestorOfClass(CellRendererPane.class, this.component) == null) {
                AnimationController.paintSkin((JComponent)this.component, this, graphics, n2, n3, n4, n5, state);
            } else {
                this.paintSkinRaw(graphics, n2, n3, n4, n5, state);
            }
        }

        public void paintSkinRaw(Graphics graphics, int n2, int n3, int n4, int n5, TMSchema.State state) {
            skinPainter.paint(null, graphics, n2, n3, n4, n5, new Object[]{this, state});
        }

        public void paintSkin(Graphics graphics, int n2, int n3, int n4, int n5, TMSchema.State state, boolean bl) {
            if (bl && "borderfill".equals(XPStyle.getTypeEnumName(this.component, this.part, state, TMSchema.Prop.BGTYPE))) {
                return;
            }
            skinPainter.paint(null, graphics, n2, n3, n4, n5, new Object[]{this, state});
        }
    }

    private class XPEmptyBorder
    extends EmptyBorder
    implements UIResource {
        XPEmptyBorder(Insets insets) {
            super(insets.top + 2, insets.left + 2, insets.bottom + 2, insets.right + 2);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets = super.getBorderInsets(component, insets);
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                Insets insets3 = ((AbstractButton)component).getMargin();
                if (component.getParent() instanceof JToolBar && !(component instanceof JRadioButton) && !(component instanceof JCheckBox) && insets3 instanceof InsetsUIResource) {
                    insets.top -= 2;
                    insets.left -= 2;
                    insets.bottom -= 2;
                    insets.right -= 2;
                } else {
                    insets2 = insets3;
                }
            } else if (component instanceof JToolBar) {
                insets2 = ((JToolBar)component).getMargin();
            } else if (component instanceof JTextComponent) {
                insets2 = ((JTextComponent)component).getMargin();
            }
            if (insets2 != null) {
                insets.top = insets2.top + 2;
                insets.left = insets2.left + 2;
                insets.bottom = insets2.bottom + 2;
                insets.right = insets2.right + 2;
            }
            return insets;
        }
    }

    private class XPImageBorder
    extends AbstractBorder
    implements UIResource {
        Skin skin;

        XPImageBorder(Component component, TMSchema.Part part) {
            this.skin = XPStyle.this.getSkin(component, part);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            this.skin.paintSkin(graphics, n2, n3, n4, n5, null);
        }
    }

    private class XPStatefulFillBorder
    extends XPFillBorder {
        private final TMSchema.Part part;
        private final TMSchema.Prop prop;

        XPStatefulFillBorder(Color color, int n2, TMSchema.Part part, TMSchema.Prop prop) {
            super(color, n2);
            this.part = part;
            this.prop = prop;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            JComboBox jComboBox;
            TMSchema.State state = TMSchema.State.NORMAL;
            if (component instanceof JComboBox && (jComboBox = (JComboBox)component).getUI() instanceof WindowsComboBoxUI) {
                WindowsComboBoxUI windowsComboBoxUI = (WindowsComboBoxUI)jComboBox.getUI();
            }
            this.lineColor = XPStyle.this.getColor(component, this.part, state, this.prop, Color.black);
            super.paintBorder(component, graphics, n2, n3, n4, n5);
        }
    }

    private class XPFillBorder
    extends LineBorder
    implements UIResource {
        XPFillBorder(Color color, int n2) {
            super(color, n2);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            } else if (component instanceof JToolBar) {
                insets2 = ((JToolBar)component).getMargin();
            } else if (component instanceof JTextComponent) {
                insets2 = ((JTextComponent)component).getMargin();
            }
            insets.top = (insets2 != null ? insets2.top : 0) + this.thickness;
            insets.left = (insets2 != null ? insets2.left : 0) + this.thickness;
            insets.bottom = (insets2 != null ? insets2.bottom : 0) + this.thickness;
            insets.right = (insets2 != null ? insets2.right : 0) + this.thickness;
            return insets;
        }
    }
}

