/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.windows;

import com.jidesoft.swing.RangeSlider;
import com.sun.java.swing.plaf.windows.WindowsSliderUI;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class WindowsRangeSliderUI
extends WindowsSliderUI {
    protected static final int MOUSE_HANDLE_NONE = 0;
    protected static final int MOUSE_HANDLE_MIN = 1;
    protected static final int MOUSE_HANDLE_MAX = 2;
    protected static final int MOUSE_HANDLE_MIDDLE = 4;
    protected static final int MOUSE_HANDLE_LOWER = 5;
    protected static final int MOUSE_HANDLE_UPPER = 6;
    protected static final int MOUSE_HANDLE_BOTH = 7;
    protected boolean hover;
    protected boolean second;
    protected boolean rollover1;
    protected boolean pressed1;
    protected boolean rollover2;
    protected boolean pressed2;

    public WindowsRangeSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsRangeSliderUI((JSlider)jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.second = false;
        super.paint(graphics, jComponent);
        Rectangle rectangle = graphics.getClipBounds();
        this.second = true;
        Point point = this.adjustThumbForHighValue();
        if (rectangle.intersects(this.thumbRect)) {
            this.paintThumb(graphics);
        }
        this.restoreThumbForLowValue(point);
        this.second = false;
    }

    protected void restoreThumbForLowValue(Point point) {
        this.thumbRect.x = point.x;
        this.thumbRect.y = point.y;
    }

    protected Point adjustThumbForHighValue() {
        Point point = this.thumbRect.getLocation();
        if (this.slider.getOrientation() == 0) {
            int n2 = this.xPositionForValue(((RangeSlider)this.slider).getHighValue());
            this.thumbRect.x = n2 - this.thumbRect.width / 2;
        } else {
            int n3 = this.yPositionForValue(((RangeSlider)this.slider).getHighValue());
            this.thumbRect.y = n3 - this.thumbRect.height / 2;
        }
        return point;
    }

    protected void adjustSnapHighValue() {
        int n2;
        int n3 = n2 = ((RangeSlider)this.slider).getHighValue();
        int n4 = this.slider.getMajorTickSpacing();
        int n5 = this.slider.getMinorTickSpacing();
        int n6 = 0;
        if (n5 > 0) {
            n6 = n5;
        } else if (n4 > 0) {
            n6 = n4;
        }
        if (n6 != 0) {
            if ((n2 - this.slider.getMinimum()) % n6 != 0) {
                float f2 = (float)(n2 - this.slider.getMinimum()) / (float)n6;
                int n7 = Math.round(f2);
                n3 = this.slider.getMinimum() + n7 * n6;
            }
            if (n3 != n2) {
                ((RangeSlider)this.slider).setHighValue(n3);
            }
        }
    }

    protected void calculateThumbLocation() {
        if (this.slider.getSnapToTicks()) {
            this.adjustSnapHighValue();
        }
        super.calculateThumbLocation();
    }

    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new RangeTrackListener(super.createTrackListener(jSlider));
    }

    protected int getMouseHandle(int n2, int n3) {
        int n4;
        Rectangle rectangle = this.trackRect;
        this.slider.putClientProperty("RangeSlider.mousePosition", null);
        boolean bl = false;
        boolean bl2 = false;
        if (this.thumbRect.contains(n2, n3)) {
            bl = true;
        }
        Point point = this.adjustThumbForHighValue();
        if (this.thumbRect.contains(n2, n3)) {
            bl2 = true;
        }
        this.restoreThumbForLowValue(point);
        if (bl && bl2) {
            return 7;
        }
        if (bl) {
            return 1;
        }
        if (bl2) {
            return 2;
        }
        if (this.slider.getOrientation() == 1) {
            int n5;
            int n6 = this.yPositionForValue(((RangeSlider)this.slider).getLowValue());
            Rectangle rectangle2 = new Rectangle(rectangle.x, Math.min(n6, n5 = this.yPositionForValue(((RangeSlider)this.slider).getHighValue())) + this.thumbRect.height / 2, rectangle.width, Math.abs(n5 - n6) - this.thumbRect.height);
            if (rectangle2.contains(n2, n3)) {
                return 4;
            }
            int n7 = rectangle.y + Math.max(n6, n5) + this.thumbRect.height / 2;
            Rectangle rectangle3 = new Rectangle(rectangle.x, n7, rectangle.width, rectangle.y + rectangle.height - n7);
            if (rectangle3.contains(n2, n3)) {
                this.slider.putClientProperty("RangeSlider.mousePosition", true);
                return 5;
            }
            Rectangle rectangle4 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, Math.min(n5, n6) - this.thumbRect.height / 2);
            if (rectangle4.contains(n2, n3)) {
                this.slider.putClientProperty("RangeSlider.mousePosition", false);
                return 6;
            }
            return 0;
        }
        int n8 = this.xPositionForValue(((RangeSlider)this.slider).getLowValue());
        Rectangle rectangle5 = new Rectangle(Math.min(n8, n4 = this.xPositionForValue(((RangeSlider)this.slider).getHighValue())) + this.thumbRect.width / 2, rectangle.y, Math.abs(n4 - n8) - this.thumbRect.width, rectangle.height);
        if (rectangle5.contains(n2, n3)) {
            return 4;
        }
        Rectangle rectangle6 = new Rectangle(rectangle.x, rectangle.y, Math.min(n8, n4) - this.thumbRect.width / 2 - rectangle.x, rectangle.height);
        if (rectangle6.contains(n2, n3)) {
            this.slider.putClientProperty("RangeSlider.mousePosition", true);
            return 5;
        }
        int n9 = rectangle.x + Math.abs(n4 - n8) + this.thumbRect.width / 2;
        Rectangle rectangle7 = new Rectangle(n9, rectangle.y, rectangle.width - n9, rectangle.height);
        if (rectangle7.contains(n2, n3)) {
            this.slider.putClientProperty("RangeSlider.mousePosition", false);
            return 6;
        }
        return 0;
    }

    public void paintThumb(Graphics graphics) {
        try {
            Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("rollover");
            field.setAccessible(true);
            field.set((Object)this, this.second ? this.rollover2 : this.rollover1);
            field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("pressed");
            field.setAccessible(true);
            field.set((Object)this, this.second ? this.pressed2 : this.pressed1);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        super.paintThumb(graphics);
    }

    protected void setMouseRollover(int n2) {
        switch (n2) {
            case 1: {
                this.rollover1 = true;
                this.rollover2 = false;
                break;
            }
            case 2: {
                this.rollover2 = true;
                this.rollover1 = false;
                break;
            }
            case 4: 
            case 7: {
                this.rollover1 = true;
                this.rollover2 = true;
                break;
            }
            case 0: {
                this.rollover1 = false;
                this.rollover2 = false;
            }
        }
        this.slider.repaint(this.thumbRect);
        Point point = this.adjustThumbForHighValue();
        this.slider.repaint(this.thumbRect);
        this.restoreThumbForLowValue(point);
    }

    protected void setMousePressed(int n2) {
        switch (n2) {
            case 1: {
                this.pressed1 = true;
                this.pressed2 = false;
                break;
            }
            case 2: {
                this.pressed2 = true;
                this.pressed1 = false;
                break;
            }
            case 4: 
            case 7: {
                this.pressed1 = true;
                this.pressed2 = true;
                break;
            }
            case 0: {
                this.pressed1 = false;
                this.pressed2 = false;
            }
        }
        this.slider.repaint(this.thumbRect);
        Point point = this.adjustThumbForHighValue();
        this.slider.repaint(this.thumbRect);
        this.restoreThumbForLowValue(point);
    }

    protected void setMouseReleased(int n2) {
        this.pressed1 = false;
        this.pressed2 = false;
        this.slider.repaint(this.thumbRect);
        Point point = this.adjustThumbForHighValue();
        this.slider.repaint(this.thumbRect);
        this.restoreThumbForLowValue(point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByBlock(int n2) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            Object object = this.slider.getClientProperty("RangeSlider.mousePosition");
            int n3 = object == null ? this.slider.getValue() : (Boolean.TRUE.equals(object) ? ((RangeSlider)this.slider).getLowValue() : ((RangeSlider)this.slider).getHighValue());
            int n4 = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (n4 <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                n4 = 1;
            }
            this.slider.putClientProperty("RangeSlider.adjustAction", "scrollByBlock");
            int n5 = n4 * (n2 > 0 ? 1 : -1);
            if (object == null) {
                this.slider.setValue(Math.max(Math.min(n3 + n5, this.slider.getMaximum()), this.slider.getMinimum()));
            } else if (Boolean.TRUE.equals(object)) {
                ((RangeSlider)this.slider).setLowValue(Math.max(Math.min(n3 + n5, this.slider.getMaximum()), this.slider.getMinimum()));
            } else {
                ((RangeSlider)this.slider).setHighValue(Math.max(Math.min(n3 + n5, this.slider.getMaximum()), this.slider.getMinimum()));
            }
            this.slider.putClientProperty("RangeSlider.adjustAction", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByUnit(int n2) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            Object object = this.slider.getClientProperty("RangeSlider.mousePosition");
            int n3 = object == null ? this.slider.getValue() : (Boolean.TRUE.equals(object) ? ((RangeSlider)this.slider).getLowValue() : ((RangeSlider)this.slider).getHighValue());
            int n4 = 1 * (n2 > 0 ? 1 : -1);
            this.slider.putClientProperty("RangeSlider.adjustAction", "scrollByUnit");
            if (object == null) {
                this.slider.setValue(Math.max(Math.min(n3 + n4, this.slider.getMaximum()), this.slider.getMinimum()));
            } else if (Boolean.TRUE.equals(object)) {
                ((RangeSlider)this.slider).setLowValue(Math.max(Math.min(n3 + n4, this.slider.getMaximum()), this.slider.getMinimum()));
            } else {
                ((RangeSlider)this.slider).setHighValue(Math.max(Math.min(n3 + n4, this.slider.getMaximum()), this.slider.getMinimum()));
            }
            this.slider.putClientProperty("RangeSlider.adjustAction", null);
        }
    }

    protected class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        int handle;
        int handleOffset;
        int mouseStartLocation;
        BasicSliderUI.TrackListener _listener;

        public RangeTrackListener(BasicSliderUI.TrackListener trackListener) {
            super((BasicSliderUI)((Object)WindowsRangeSliderUI.this));
            this._listener = trackListener;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!WindowsRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (WindowsRangeSliderUI.this.slider.isRequestFocusEnabled()) {
                WindowsRangeSliderUI.this.slider.requestFocus();
            }
            this.handle = WindowsRangeSliderUI.this.getMouseHandle(mouseEvent.getX(), mouseEvent.getY());
            WindowsRangeSliderUI.this.setMousePressed(this.handle);
            if (this.handle == 2 || this.handle == 1 || this.handle == 4 || this.handle == 7) {
                this.handleOffset = WindowsRangeSliderUI.this.slider.getOrientation() == 1 ? mouseEvent.getY() - WindowsRangeSliderUI.this.yPositionForValue(((RangeSlider)WindowsRangeSliderUI.this.slider).getLowValue()) : mouseEvent.getX() - WindowsRangeSliderUI.this.xPositionForValue(((RangeSlider)WindowsRangeSliderUI.this.slider).getLowValue());
                this.mouseStartLocation = WindowsRangeSliderUI.this.slider.getOrientation() == 1 ? mouseEvent.getY() : mouseEvent.getX();
                WindowsRangeSliderUI.this.slider.getModel().setValueIsAdjusting(true);
            } else if (this.handle == 5 || this.handle == 6) {
                this._listener.mousePressed(mouseEvent);
                WindowsRangeSliderUI.this.slider.putClientProperty("RangeSlider.mousePosition", null);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n2;
            if (!WindowsRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            int n3 = WindowsRangeSliderUI.this.slider.getOrientation() == 1 ? mouseEvent.getY() : mouseEvent.getX();
            int n4 = n2 = WindowsRangeSliderUI.this.slider.getOrientation() == 1 ? WindowsRangeSliderUI.this.valueForYPosition(n3) : WindowsRangeSliderUI.this.valueForXPosition(n3);
            if (n2 < WindowsRangeSliderUI.this.slider.getModel().getMinimum()) {
                n2 = WindowsRangeSliderUI.this.slider.getModel().getMinimum();
            }
            if (n2 > WindowsRangeSliderUI.this.slider.getModel().getMaximum()) {
                n2 = WindowsRangeSliderUI.this.slider.getModel().getMaximum();
            }
            if (this.handle == 7) {
                if (n3 - this.mouseStartLocation >= 1) {
                    this.handle = 2;
                } else if (n3 - this.mouseStartLocation <= -1) {
                    this.handle = 1;
                } else {
                    return;
                }
            }
            RangeSlider rangeSlider = (RangeSlider)WindowsRangeSliderUI.this.slider;
            switch (this.handle) {
                case 1: {
                    rangeSlider.setLowValue(Math.min(n2, rangeSlider.getHighValue()));
                    break;
                }
                case 2: {
                    rangeSlider.setHighValue(Math.max(rangeSlider.getLowValue(), n2));
                    break;
                }
                case 4: {
                    int n5;
                    if (!((RangeSlider)WindowsRangeSliderUI.this.slider).isRangeDraggable()) break;
                    int n6 = n5 = WindowsRangeSliderUI.this.slider.getOrientation() == 1 ? WindowsRangeSliderUI.this.valueForYPosition(n3 - this.handleOffset) - rangeSlider.getLowValue() : WindowsRangeSliderUI.this.valueForXPosition(n3 - this.handleOffset) - rangeSlider.getLowValue();
                    if (n5 < 0 && rangeSlider.getLowValue() + n5 < rangeSlider.getMinimum()) {
                        n5 = rangeSlider.getMinimum() - rangeSlider.getLowValue();
                    }
                    if (n5 > 0 && rangeSlider.getHighValue() + n5 > rangeSlider.getMaximum()) {
                        n5 = rangeSlider.getMaximum() - rangeSlider.getHighValue();
                    }
                    if (n5 == 0) break;
                    rangeSlider.setLowValue(rangeSlider.getLowValue() + n5);
                    rangeSlider.setHighValue(rangeSlider.getHighValue() + n5);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            WindowsRangeSliderUI.this.slider.getModel().setValueIsAdjusting(false);
            WindowsRangeSliderUI.this.setMouseReleased(this.handle);
            this._listener.mouseReleased(mouseEvent);
        }

        private void setCursor(int n2) {
            Cursor cursor = Cursor.getPredefinedCursor(n2);
            if (WindowsRangeSliderUI.this.slider.getCursor() != cursor) {
                WindowsRangeSliderUI.this.slider.setCursor(cursor);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!WindowsRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            int n2 = WindowsRangeSliderUI.this.getMouseHandle(mouseEvent.getX(), mouseEvent.getY());
            WindowsRangeSliderUI.this.setMouseRollover(n2);
            switch (n2) {
                case 1: 
                case 2: 
                case 7: {
                    this.setCursor(0);
                    break;
                }
                case 4: {
                    if (WindowsRangeSliderUI.this.slider instanceof RangeSlider && ((RangeSlider)WindowsRangeSliderUI.this.slider).isRangeDraggable()) {
                        this.setCursor(13);
                        break;
                    }
                    this.setCursor(0);
                    break;
                }
                default: {
                    this.setCursor(0);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                WindowsRangeSliderUI.this.slider.getModel().setValue(WindowsRangeSliderUI.this.slider.getModel().getMinimum());
                WindowsRangeSliderUI.this.slider.getModel().setExtent(WindowsRangeSliderUI.this.slider.getModel().getMaximum() - WindowsRangeSliderUI.this.slider.getModel().getMinimum());
                WindowsRangeSliderUI.this.slider.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            WindowsRangeSliderUI.this.hover = true;
            WindowsRangeSliderUI.this.slider.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            WindowsRangeSliderUI.this.hover = false;
            WindowsRangeSliderUI.this.slider.repaint();
            this.setCursor(0);
        }
    }
}

