/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

final class PlasticBumps
implements Icon {
    private static final List<BumpBuffer> BUFFERS = new ArrayList<BumpBuffer>();
    private int xBumps;
    private int yBumps;
    private Color topColor;
    private Color shadowColor;
    private Color backColor;
    private BumpBuffer buffer;

    PlasticBumps(int width, int height, Color newTopColor, Color newShadowColor, Color newBackColor) {
        this.setBumpArea(width, height);
        this.setBumpColors(newTopColor, newShadowColor, newBackColor);
    }

    void setBumpArea(int width, int height) {
        this.xBumps = width / 2;
        this.yBumps = height / 2;
    }

    void setBumpColors(Color newTopColor, Color newShadowColor, Color newBackColor) {
        this.topColor = newTopColor;
        this.shadowColor = newShadowColor;
        this.backColor = newBackColor;
    }

    @Override
    public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        GraphicsConfiguration gc = g2 instanceof Graphics2D ? ((Graphics2D)g2).getDeviceConfiguration() : null;
        this.buffer = this.getBuffer(gc, this.topColor, this.shadowColor, this.backColor);
        int bufferWidth = BumpBuffer.getImageSize().width;
        int bufferHeight = BumpBuffer.getImageSize().height;
        int iconWidth = this.getIconWidth();
        int iconHeight = this.getIconHeight();
        int x22 = x2 + iconWidth;
        int y22 = y2 + iconHeight;
        int savex = x2;
        while (y2 < y22) {
            int h2 = Math.min(y22 - y2, bufferHeight);
            for (x2 = savex; x2 < x22; x2 += bufferWidth) {
                int w2 = Math.min(x22 - x2, bufferWidth);
                g2.drawImage(this.buffer.getImage(), x2, y2, x2 + w2, y2 + h2, 0, 0, w2, h2, null);
            }
            y2 += bufferHeight;
        }
    }

    @Override
    public int getIconWidth() {
        return this.xBumps * 2;
    }

    @Override
    public int getIconHeight() {
        return this.yBumps * 2;
    }

    private BumpBuffer getBuffer(GraphicsConfiguration gc, Color aTopColor, Color aShadowColor, Color aBackColor) {
        if (this.buffer != null && this.buffer.hasSameConfiguration(gc, aTopColor, aShadowColor, aBackColor)) {
            return this.buffer;
        }
        BumpBuffer result = null;
        for (BumpBuffer element : BUFFERS) {
            BumpBuffer aBuffer = element;
            if (!aBuffer.hasSameConfiguration(gc, aTopColor, aShadowColor, aBackColor)) continue;
            result = aBuffer;
            break;
        }
        if (result == null) {
            result = new BumpBuffer(gc, this.topColor, this.shadowColor, this.backColor);
            BUFFERS.add(result);
        }
        return result;
    }

    private static final class BumpBuffer {
        private static final int IMAGE_SIZE = 64;
        private static Dimension imageSize = new Dimension(64, 64);
        transient Image image;
        private final Color topColor;
        private final Color shadowColor;
        private final Color backColor;
        private final GraphicsConfiguration gc;

        BumpBuffer(GraphicsConfiguration gc, Color aTopColor, Color aShadowColor, Color aBackColor) {
            this.gc = gc;
            this.topColor = aTopColor;
            this.shadowColor = aShadowColor;
            this.backColor = aBackColor;
            this.createImage();
            this.fillBumpBuffer();
        }

        boolean hasSameConfiguration(GraphicsConfiguration aGC, Color aTopColor, Color aShadowColor, Color aBackColor) {
            if (this.gc != null ? !this.gc.equals(aGC) : aGC != null) {
                return false;
            }
            return this.topColor.equals(aTopColor) && this.shadowColor.equals(aShadowColor) && this.backColor.equals(aBackColor);
        }

        Image getImage() {
            return this.image;
        }

        static Dimension getImageSize() {
            return imageSize;
        }

        private void fillBumpBuffer() {
            int y2;
            int x2;
            Graphics g2 = this.image.getGraphics();
            g2.setColor(this.backColor);
            g2.fillRect(0, 0, 64, 64);
            g2.setColor(this.topColor);
            for (x2 = 0; x2 < 64; x2 += 4) {
                for (y2 = 0; y2 < 64; y2 += 4) {
                    g2.drawLine(x2, y2, x2, y2);
                    g2.drawLine(x2 + 2, y2 + 2, x2 + 2, y2 + 2);
                }
            }
            g2.setColor(this.shadowColor);
            for (x2 = 0; x2 < 64; x2 += 4) {
                for (y2 = 0; y2 < 64; y2 += 4) {
                    g2.drawLine(x2 + 1, y2 + 1, x2 + 1, y2 + 1);
                    g2.drawLine(x2 + 3, y2 + 3, x2 + 3, y2 + 3);
                }
            }
            g2.dispose();
        }

        private void createImage() {
            if (this.gc != null) {
                this.image = this.gc.createCompatibleImage(64, 64);
            } else {
                int[] cmap = new int[]{this.backColor.getRGB(), this.topColor.getRGB(), this.shadowColor.getRGB()};
                IndexColorModel icm = new IndexColorModel(8, 3, cmap, 0, false, -1, 0);
                this.image = new BufferedImage(64, 64, 13, icm);
            }
        }
    }
}

