/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.predicates.JoinPredicate;
import unity.util.HashFunc;

public class HashBuffer {
    private int[] buckets;
    private byte[][] tuples;
    private int tableSize;
    private int numTuples;
    private JoinPredicate predicate;
    private Tuple buildTuple;

    public HashBuffer(int n, JoinPredicate joinPredicate, Relation relation) {
        this.tableSize = HashFunc.nextPrime(n);
        this.tuples = new byte[this.tableSize][];
        this.buckets = new int[this.tableSize];
        this.numTuples = 0;
        this.predicate = joinPredicate;
        this.buildTuple = new Tuple(relation);
    }

    public void clear() {
        if (this.numTuples == 0) {
            return;
        }
        this.numTuples = 0;
        Arrays.fill(this.buckets, 0);
        Arrays.fill((Object[])this.tuples, null);
    }

    public void insert(int n, byte[] byArray) {
        int n2;
        if (this.numTuples >= this.tableSize) {
            n2 = this.tuples.length * 2;
            byte[][] byArrayArray = new byte[n2][];
            System.arraycopy(this.tuples, 0, byArrayArray, 0, this.tableSize);
            this.tuples = byArrayArray;
        }
        n2 = HashFunc.getBucket(n, this.tableSize);
        int n3 = this.buckets[n2];
        Tuple.setId(byArray, n);
        this.tuples[this.numTuples++] = byArray;
        if (n3 == 0) {
            this.buckets[n2] = this.numTuples;
        } else {
            Tuple.setNext(byArray, n3);
            this.buckets[n2] = this.numTuples;
        }
    }

    public void getNonMatched(ArrayList<byte[]> arrayList) {
        for (int i = 0; i < this.buckets.length; ++i) {
            int n = this.buckets[i];
            while (n != 0) {
                byte[] byArray = this.tuples[n - 1];
                if (!Tuple.getFlag(byArray)) {
                    arrayList.add(byArray);
                }
                n = Tuple.getNext(byArray);
            }
        }
    }

    public void find(int n, Tuple tuple, ArrayList<byte[]> arrayList) throws SQLException {
        arrayList.clear();
        int n2 = HashFunc.getBucket(n, this.tableSize);
        int n3 = this.buckets[n2];
        while (n3 != 0) {
            byte[] byArray = this.tuples[n3 - 1];
            if (Tuple.getId(byArray) == n) {
                this.buildTuple.setBytes(byArray);
                if (this.predicate.isEqual(this.buildTuple, tuple)) {
                    arrayList.add(byArray);
                    Tuple.setFlag(byArray, true);
                }
            }
            n3 = Tuple.getNext(byArray);
        }
    }
}

