/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlval.cmd;

import com.mimer.ws.validateSQL.ValidatorResult;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServicePreferences;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServiceSession;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServiceSessionProperties;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServiceValidator;

public class ValidateSQLCommand
implements ICommand {
    private final WebServicePreferences _prefs;
    private final WebServiceSessionProperties _wsSessionProps;
    private final String _sql;
    private final String _stmtSep;
    private final String _solComment;
    private SessionProperties _sessionProperties;
    private String _results;
    private final ISession _session;
    private static final ILogger s_log = LoggerController.createLogger(ValidateSQLCommand.class);

    public ValidateSQLCommand(WebServicePreferences prefs, WebServiceSessionProperties wsSessionProps, String sql, String stmtSep, String solComment, SessionProperties sessionProperties, ISession session) {
        this._prefs = prefs;
        this._wsSessionProps = wsSessionProps;
        this._sql = sql;
        this._stmtSep = stmtSep;
        this._solComment = solComment;
        this._sessionProperties = sessionProperties;
        this._session = session;
    }

    public void openSession(WebServiceSession info) {
        if (info == null) {
            throw new IllegalArgumentException("ValidationInfo == null");
        }
    }

    public String getResults() {
        return this._results;
    }

    public void execute() throws BaseException {
        try {
            WebServiceSession wss = new WebServiceSession(this._prefs, this._wsSessionProps);
            wss.open();
            WebServiceValidator val = new WebServiceValidator(wss, this._wsSessionProps);
            IQueryTokenizer qt = this._session.getQueryTokenizer();
            qt.setScriptToTokenize(this._sql);
            StringBuffer results = new StringBuffer(1024);
            while (qt.hasQuery()) {
                ValidatorResult rc = val.validate(qt.nextQuery().getQuery());
                results.append(rc.getData());
            }
            this._results = results.toString().trim();
        }
        catch (Throwable th) {
            throw new BaseException(th);
        }
    }
}

