/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.session.CatalogsPanel;
import net.sourceforge.squirrel_sql.client.gui.session.MainPanel;
import net.sourceforge.squirrel_sql.client.gui.session.SchemaPanel;
import net.sourceforge.squirrel_sql.client.gui.session.SessionColoringUtil;
import net.sourceforge.squirrel_sql.client.gui.session.ToolbarItem;
import net.sourceforge.squirrel_sql.client.gui.session.rowcolumnlabel.RowColumnLabel;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandler;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ExecuteAllSqlsAction;
import net.sourceforge.squirrel_sql.client.session.action.ExecuteSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.GoToLastEditLocationAction;
import net.sourceforge.squirrel_sql.client.session.action.NextSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.PreviousSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.RefreshSchemaInfoAction;
import net.sourceforge.squirrel_sql.client.session.action.SQLFilterAction;
import net.sourceforge.squirrel_sql.client.session.action.SelectSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.SessionPropertiesAction;
import net.sourceforge.squirrel_sql.client.session.action.file.FileAppendAction;
import net.sourceforge.squirrel_sql.client.session.action.file.FileCloseAction;
import net.sourceforge.squirrel_sql.client.session.action.file.FileDetachAction;
import net.sourceforge.squirrel_sql.client.session.action.file.FileNewAction;
import net.sourceforge.squirrel_sql.client.session.action.file.FileOpenAction;
import net.sourceforge.squirrel_sql.client.session.action.file.FileOpenRecentAction;
import net.sourceforge.squirrel_sql.client.session.action.file.FilePrintAction;
import net.sourceforge.squirrel_sql.client.session.action.file.FileReloadAction;
import net.sourceforge.squirrel_sql.client.session.action.file.FileSaveAction;
import net.sourceforge.squirrel_sql.client.session.action.file.FileSaveAsAction;
import net.sourceforge.squirrel_sql.client.session.filemanager.IFileEditorAPI;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IMainPanelTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.IObjectTreeListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.SQLTab;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.client.session.schemainfo.FilterMatcher;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.StatusBar;
import net.sourceforge.squirrel_sql.fw.gui.ToolBar;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;

public class SessionPanel
extends JPanel {
    private final IApplication _app;
    private IIdentifier _sessionId;
    private PropertyChangeListener _propsListener;
    private MainPanel _mainPanel;
    private MyToolBar _toolBar;
    private Vector<ToolbarItem> _externallyAddedToolbarActionsAndSeparators = new Vector();
    private StatusBar _statusBar = new StatusBar();
    private boolean _hasBeenVisible;
    private transient ObjectTreeSelectionListener _objTreeSelectionLis = null;
    private TitleFilePathHandler _titleFileHandler = null;

    public SessionPanel(ISession session, TitleFilePathHandler titleFileHandler) {
        super(new BorderLayout());
        this._titleFileHandler = titleFileHandler;
        this._app = session.getApplication();
        this._sessionId = session.getIdentifier();
        SessionColoringUtil.colorStatusbar(session, this._statusBar);
    }

    protected void initialize(ISession session) {
        this.createGUI(session);
        this.propertiesHaveChanged(null);
        this._propsListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SessionPanel.this.propertiesHaveChanged(evt.getPropertyName());
            }
        };
        session.getProperties().addPropertyChangeListener(this._propsListener);
    }

    public void addToToolsPopUp(String selectionString, Action action) {
        this.getMainSQLPaneAPI().addToToolsPopUp(selectionString, action);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this._hasBeenVisible) {
            this._hasBeenVisible = true;
            this._mainPanel.getObjectTreePanel().refreshTree();
        }
    }

    public ISession getSession() {
        return this._app.getSessionManager().getSession(this._sessionId);
    }

    public void sessionHasClosed() {
        ISession session;
        if (this._objTreeSelectionLis != null) {
            this.getObjectTreePanel().removeTreeSelectionListener(this._objTreeSelectionLis);
            this._objTreeSelectionLis = null;
        }
        if ((session = this.getSession()) != null) {
            if (this._propsListener != null) {
                session.getProperties().removePropertyChangeListener(this._propsListener);
                this._propsListener = null;
            }
            this._mainPanel.sessionClosing(session);
            this._sessionId = null;
        }
    }

    public void setStatusBarMessage(String msg) {
        GUIUtils.processOnSwingEventThread(() -> this._statusBar.setText(msg));
    }

    public void setStatusBarProgress(String msg, int minimum, int maximum, int value) {
        GUIUtils.processOnSwingEventThread(() -> this._statusBar.setStatusBarProgress(msg, minimum, maximum, value));
    }

    public void setStatusBarProgressFinished() {
        GUIUtils.processOnSwingEventThread(() -> this._statusBar.setStatusBarProgressFinished());
    }

    public synchronized void addToToolbar(Action action) {
        this._externallyAddedToolbarActionsAndSeparators.add(new ToolbarItem(action));
        if (null != this._toolBar) {
            this._toolBar.add(action);
        }
    }

    public synchronized void addSeparatorToToolbar() {
        this._externallyAddedToolbarActionsAndSeparators.add(new ToolbarItem());
        if (null != this._toolBar) {
            this._toolBar.addSeparator();
        }
    }

    public void addToStatusBar(JComponent comp) {
        this._statusBar.addJComponent(comp);
    }

    public void removeFromStatusBar(JComponent comp) {
        this._statusBar.remove(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propertiesHaveChanged(String propertyName) {
        final ISession session = this.getSession();
        final SessionProperties props = session.getProperties();
        if (propertyName == null || propertyName.equals("commitOnClosingConnection")) {
            this._app.getThreadPool().addTask(new Runnable(){

                @Override
                public void run() {
                    session.getSQLConnection().setCommitOnClose(props.getCommitOnClosingConnection());
                }
            });
        }
        if (propertyName == null || propertyName.equals("showToolBar")) {
            SessionPanel sessionPanel = this;
            synchronized (sessionPanel) {
                boolean show = props.getShowToolBar();
                if (show != (this._toolBar != null)) {
                    if (show) {
                        if (this._toolBar == null) {
                            this._toolBar = new MyToolBar(session);
                            for (int i = 0; i < this._externallyAddedToolbarActionsAndSeparators.size(); ++i) {
                                ToolbarItem toolbarItem = this._externallyAddedToolbarActionsAndSeparators.get(i);
                                if (toolbarItem.isSeparator()) {
                                    this._toolBar.addSeparator();
                                    continue;
                                }
                                this._toolBar.add(toolbarItem.getAction());
                            }
                            this.add((Component)this._toolBar, "North");
                        }
                    } else if (this._toolBar != null) {
                        this.remove(this._toolBar);
                        this._toolBar = null;
                    }
                }
            }
        }
    }

    private void createGUI(ISession session) {
        IApplication app = session.getApplication();
        this._mainPanel = new MainPanel(session, this._titleFileHandler);
        this.add((Component)this._mainPanel, "Center");
        Font fn = app.getFontInfoStore().getStatusBarFontInfo().createFont();
        this._statusBar.setFont(fn);
        this.add((Component)this._statusBar, "South");
        this._objTreeSelectionLis = new ObjectTreeSelectionListener();
        this.getObjectTreePanel().addTreeSelectionListener(this._objTreeSelectionLis);
        this.addToStatusBar(new SchemaPanel(session));
        this.addToStatusBar(new RowColumnLabel(this._mainPanel));
        this.validate();
    }

    public boolean isObjectTreeTabSelected() {
        return 0 == this._mainPanel.getSelectedMainTabIndex();
    }

    public int getTabCount() {
        return this._mainPanel.getMainTabCount();
    }

    public int getMainPanelTabIndex(IMainPanelTab mainPanelTab) {
        return this._mainPanel.getTabIndex(mainPanelTab);
    }

    public String getSelectedCatalogFromCatalogsComboBox() {
        if (null == this._toolBar) {
            return null;
        }
        return this._toolBar._catalogsPanel.getSelectedCatalog();
    }

    public IMainPanelTab getMainPanelTabAt(int tabIndex) {
        return this._mainPanel.getMainPanelTabAt(tabIndex);
    }

    public ISQLPanelAPI getMainSQLPaneAPI() {
        return this._mainPanel.getMainSQLPanel().getSQLPanelAPI();
    }

    public ISQLPanelAPI getSelectedOrMainSQLPanelAPI() {
        return this._mainPanel.getSelectedOrMainSQLPanel().getSQLPanelAPI();
    }

    public ISQLEntryPanel getMainSQLEntryPanel() {
        return this.getMainSQLPanel().getSQLEntryPanel();
    }

    public SQLPanel getMainSQLPanel() {
        return this._mainPanel.getMainSQLPanel();
    }

    public List<SQLPanel> getAllSQLPanels() {
        return this._mainPanel.getAllSQLPanels();
    }

    public SQLPanel getSelectedSQLPanel() {
        return this._mainPanel.getSelectedSQLPanel();
    }

    public SQLPanel getSelectedOrMainSQLPanel() {
        return this._mainPanel.getSelectedOrMainSQLPanel();
    }

    public boolean isAnSQLTabSelected() {
        return this._mainPanel.getSelectedMainTab() instanceof SQLTab || this._mainPanel.getSelectedMainTab() instanceof AdditionalSQLTab;
    }

    public void sessionWindowClosing() {
        this._mainPanel.sessionWindowClosing();
    }

    public ObjectTreePanel getObjectTreePanel() {
        return this._mainPanel.getObjectTreePanel();
    }

    public void selectMainTab(int tabIndex) {
        if (tabIndex >= this._mainPanel.getMainTabCount()) {
            throw new IllegalArgumentException("" + tabIndex + " is not a valid index into the main tabbed pane.");
        }
        if (this._mainPanel.getSelectedMainTabIndex() != tabIndex) {
            this._mainPanel.selectMainTab(tabIndex);
        }
    }

    public void selectMainTab(IMainPanelTab mainPanelTab) {
        int mainTabIndex = this.getMainPanelTabIndex(mainPanelTab);
        if (-1 == mainTabIndex) {
            throw new IllegalStateException("Couldn't find index for IMainPanelTab: " + mainPanelTab);
        }
        this.selectMainTab(mainTabIndex);
    }

    public int getSelectedMainTabIndex() {
        return this._mainPanel.getSelectedMainTabIndex();
    }

    public IMainPanelTab getSelectedMainTab() {
        return this._mainPanel.getSelectedMainTab();
    }

    public int addMainTab(IMainPanelTab tab) {
        if (tab == null) {
            throw new IllegalArgumentException("IMainPanelTab == null");
        }
        return this._mainPanel.addMainPanelTab(tab);
    }

    public void insertMainTab(IMainPanelTab tab, int idx) {
        this.insertMainTab(tab, idx, true);
    }

    public void insertMainTab(IMainPanelTab tab, int idx, boolean selectInsertedTab) {
        if (tab == null) {
            throw new IllegalArgumentException("Null IMainPanelTab passed");
        }
        if (idx == 1 || idx == 0) {
            throw new IllegalArgumentException("Index " + idx + "conflicts with standard tabs");
        }
        this._mainPanel.insertMainPanelTab(tab, idx, selectInsertedTab);
    }

    public int removeMainTab(IMainPanelTab tab) {
        if (tab == null) {
            throw new IllegalArgumentException("Null IMainPanelTab passed");
        }
        return this._mainPanel.removeMainPanelTab(tab);
    }

    public IFileEditorAPI getActiveIFileEditorAPIOrNull() {
        return this.getSelectedMainTab().getActiveFileEditorAPIOrNull();
    }

    public void performStateChanged() {
        this._mainPanel.performStateChanged();
    }

    private final class ObjectTreeSelectionListener
    implements TreeSelectionListener {
        private ObjectTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            TreePath selPath = evt.getNewLeadSelectionPath();
            if (selPath != null) {
                StringBuffer buf = new StringBuffer();
                Object[] fullPath = selPath.getPath();
                for (int i = 0; i < fullPath.length; ++i) {
                    if (!(fullPath[i] instanceof ObjectTreeNode)) continue;
                    ObjectTreeNode node = (ObjectTreeNode)fullPath[i];
                    buf.append('/').append(node.toString());
                }
                SessionPanel.this.setStatusBarMessage(buf.toString());
            }
        }
    }

    private final class CatalogsComboListener
    implements ActionListener {
        private CatalogsComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String selectedCatalog = SessionPanel.this._toolBar._catalogsPanel.getSelectedCatalog();
            if (selectedCatalog != null) {
                try {
                    ISession session = SessionPanel.this.getSession();
                    session.getSQLConnection().setCatalog(selectedCatalog);
                    this.refreshSchemaInBackground();
                }
                catch (SQLException ex) {
                    SessionPanel.this.getSession().showErrorMessage(ex);
                    SessionPanel.this._toolBar._catalogsPanel.refreshCatalogs();
                }
            }
        }

        private void refreshSchemaInBackground() {
            final ISession session = SessionPanel.this.getSession();
            session.getApplication().getThreadPool().addTask(new Runnable(){

                @Override
                public void run() {
                    session.getSchemaInfo().reloadAll();
                    CatalogsComboListener.this.expandTreeInForeground();
                }
            });
        }

        private void expandTreeInForeground() {
            final ISession session = SessionPanel.this.getSession();
            final String selectedCatalog = SessionPanel.this._toolBar._catalogsPanel.getSelectedCatalog();
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    CatalogsComboListener.this.expandTablesForCatalog(session, selectedCatalog);
                }
            });
        }

        private void expandTablesForCatalog(ISession session, String selectedCatalog) {
            ObjectTreeNode[] nodes;
            IObjectTreeAPI api = session.getObjectTreeAPIOfActiveSessionWindow();
            api.refreshTree(true);
            if (api.selectInObjectTree(selectedCatalog, null, new FilterMatcher("TABLE", null)) && (nodes = api.getSelectedNodes()).length > 0) {
                ObjectTreeNode tableNode = nodes[0];
                api.expandNode(tableNode);
            }
        }
    }

    private class MyToolBar
    extends ToolBar {
        private IObjectTreeListener _lis;
        private CatalogsPanel _catalogsPanel;

        MyToolBar(ISession session) {
            this.createGUI(session);
            SessionColoringUtil.colorToolbar(session, this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!SessionPanel.this._hasBeenVisible) {
                SessionPanel.this._hasBeenVisible = true;
                SessionPanel.this._mainPanel.getObjectTreePanel().refreshTree();
            }
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            if (this._lis != null) {
                SessionPanel.this.getObjectTreePanel().removeObjectTreeListener(this._lis);
                this._lis = null;
            }
        }

        private void createGUI(ISession session) {
            this._catalogsPanel = new CatalogsPanel(session, this);
            this._catalogsPanel.addActionListener(new CatalogsComboListener());
            this.add(this._catalogsPanel);
            ActionCollection actions = session.getApplication().getActionCollection();
            this.setUseRolloverButtons(true);
            this.setFloatable(false);
            this.add(actions.get(SessionPropertiesAction.class));
            this.add(actions.get(RefreshSchemaInfoAction.class));
            this.addSeparator();
            this.add(actions.get(ExecuteSqlAction.class));
            this.addSeparator();
            this.add(actions.get(ExecuteAllSqlsAction.class));
            this.addSeparator();
            this.add(actions.get(SQLFilterAction.class));
            this.addSeparator();
            this.add(actions.get(FileNewAction.class));
            this.add(actions.get(FileDetachAction.class));
            this.add(actions.get(FileOpenAction.class));
            this.add(actions.get(FileOpenRecentAction.class));
            this.add(actions.get(FileAppendAction.class));
            this.add(actions.get(FileSaveAction.class));
            this.add(actions.get(FileSaveAsAction.class));
            this.add(actions.get(FileCloseAction.class));
            this.add(actions.get(FilePrintAction.class));
            this.add(actions.get(FileReloadAction.class));
            this.addSeparator();
            this.add(actions.get(PreviousSqlAction.class));
            this.add(actions.get(NextSqlAction.class));
            this.add(actions.get(SelectSqlAction.class));
            this.add(actions.get(GoToLastEditLocationAction.class));
        }
    }
}

