/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ps" locale.
 */
public class LocalizedNamesImpl_ps extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "PK",
        "AF",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AD",
        "AE",
        "AG",
        "AI",
        "AM",
        "AR",
        "AS",
        "AU",
        "AW",
        "AX",
        "AZ",
        "BA",
        "BB",
        "BE",
        "BF",
        "BH",
        "BI",
        "BJ",
        "BL",
        "BM",
        "BN",
        "BO",
        "BQ",
        "BR",
        "BS",
        "BT",
        "BV",
        "BW",
        "BY",
        "BZ",
        "CC",
        "CD",
        "CF",
        "CG",
        "CI",
        "CK",
        "CL",
        "CM",
        "CP",
        "CR",
        "CV",
        "CW",
        "CX",
        "CY",
        "CZ",
        "DG",
        "DJ",
        "DM",
        "DO",
        "EA",
        "EC",
        "EE",
        "EH",
        "ER",
        "EU",
        "FJ",
        "FK",
        "FM",
        "FO",
        "GA",
        "GD",
        "GE",
        "GF",
        "GG",
        "GI",
        "GL",
        "GM",
        "GP",
        "GQ",
        "GS",
        "GU",
        "GW",
        "GY",
        "HK",
        "HM",
        "HR",
        "HT",
        "IC",
        "IE",
        "IL",
        "IM",
        "IO",
        "IR",
        "JE",
        "JO",
        "KE",
        "KG",
        "KI",
        "KM",
        "KN",
        "KP",
        "KR",
        "KY",
        "KZ",
        "LC",
        "LI",
        "LK",
        "LS",
        "LT",
        "LU",
        "LV",
        "MC",
        "MD",
        "ME",
        "MF",
        "MG",
        "MH",
        "MK",
        "ML",
        "MM",
        "MO",
        "MP",
        "MQ",
        "MR",
        "MS",
        "MT",
        "MU",
        "MV",
        "MW",
        "MX",
        "MZ",
        "NA",
        "NC",
        "NE",
        "NF",
        "NR",
        "NU",
        "OM",
        "PA",
        "PE",
        "PF",
        "PG",
        "PH",
        "PM",
        "PN",
        "PR",
        "PW",
        "PY",
        "QA",
        "QO",
        "RE",
        "RO",
        "RS",
        "SB",
        "SC",
        "SD",
        "SG",
        "SH",
        "SI",
        "SJ",
        "SK",
        "SL",
        "SM",
        "SN",
        "SO",
        "SR",
        "SS",
        "ST",
        "SX",
        "SZ",
        "TA",
        "TC",
        "TD",
        "TF",
        "TG",
        "TH",
        "TK",
        "TL",
        "TM",
        "TN",
        "TO",
        "TR",
        "TT",
        "TV",
        "TW",
        "UA",
        "UG",
        "UM",
        "US",
        "UZ",
        "VA",
        "VC",
        "VE",
        "VG",
        "VI",
        "VN",
        "VU",
        "WF",
        "WS",
        "XK",
        "YT",
        "ZA",
        "ZM",
        "ZW",
        "IS",
        "AT",
        "AF",
        "AL",
        "DZ",
        "DE",
        "AQ",
        "ID",
        "AO",
        "IT",
        "GB",
        "BG",
        "BD",
        "TJ",
        "TZ",
        "JP",
        "JM",
        "ET",
        "RU",
        "RW",
        "SV",
        "SA",
        "SY",
        "CH",
        "SE",
        "IQ",
        "FR",
        "PS",
        "FI",
        "LA",
        "LR",
        "LB",
        "LY",
        "MY",
        "HU",
        "MA",
        "EG",
        "MN",
        "NO",
        "NG",
        "NI",
        "NZ",
        "NP",
        "NL",
        "HN",
        "ES",
        "IN",
        "PK",
        "PT",
        "PL",
        "CN",
        "DK",
        "CA",
        "KH",
        "CO",
        "KW",
        "CU",
        "GH",
        "GT",
        "GN",
        "YE",
        "UY",
        "GR",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AF", "افغانستان");
    namesMap.put("AL", "البانیه");
    namesMap.put("AO", "انګولا");
    namesMap.put("AQ", "انتارکتیکا");
    namesMap.put("AT", "اتریش");
    namesMap.put("BD", "بنګله‌دیش");
    namesMap.put("BG", "بلغاریه");
    namesMap.put("CA", "کاناډا");
    namesMap.put("CH", "سویس");
    namesMap.put("CN", "چین");
    namesMap.put("CO", "کولمبیا");
    namesMap.put("CU", "کیوبا");
    namesMap.put("DE", "المان");
    namesMap.put("DK", "ډنمارک");
    namesMap.put("DZ", "الجزایر");
    namesMap.put("EG", "مصر");
    namesMap.put("ES", "هسپانیه");
    namesMap.put("ET", "حبشه");
    namesMap.put("FI", "فنلینډ");
    namesMap.put("FR", "فرانسه");
    namesMap.put("GB", "برتانیه");
    namesMap.put("GH", "ګانا");
    namesMap.put("GN", "ګیانا");
    namesMap.put("GR", "یونان");
    namesMap.put("GT", "ګواتیمالا");
    namesMap.put("HN", "هانډوراس");
    namesMap.put("HU", "مجارستان");
    namesMap.put("ID", "اندونیزیا");
    namesMap.put("IN", "هند");
    namesMap.put("IQ", "عراق");
    namesMap.put("IS", "آیسلینډ");
    namesMap.put("IT", "ایټالیه");
    namesMap.put("JM", "جمیکا");
    namesMap.put("JP", "جاپان");
    namesMap.put("KH", "کمبودیا");
    namesMap.put("KW", "کویټ");
    namesMap.put("LA", "لاوس");
    namesMap.put("LB", "لبنان");
    namesMap.put("LR", "لایبریا");
    namesMap.put("LY", "لیبیا");
    namesMap.put("MA", "مراکش");
    namesMap.put("MN", "مغولستان");
    namesMap.put("MY", "مالیزیا");
    namesMap.put("NG", "نایجیریا");
    namesMap.put("NI", "نکاراګوا");
    namesMap.put("NL", "هالېنډ");
    namesMap.put("NO", "ناروې");
    namesMap.put("NP", "نیپال");
    namesMap.put("NZ", "نیوزیلنډ");
    namesMap.put("PK", "پاکستان");
    namesMap.put("PL", "پولنډ");
    namesMap.put("PS", "فلسطین");
    namesMap.put("PT", "پورتګال");
    namesMap.put("RU", "روسیه");
    namesMap.put("RW", "روندا");
    namesMap.put("SA", "سعودی عربستان");
    namesMap.put("SE", "سویډن");
    namesMap.put("SV", "سالوېډور");
    namesMap.put("SY", "سوریه");
    namesMap.put("TJ", "تاجکستان");
    namesMap.put("TZ", "تنزانیا");
    namesMap.put("UY", "یوروګوای");
    namesMap.put("YE", "یمن");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AF": "افغانستان",
        "AL": "البانیه",
        "AO": "انګولا",
        "AQ": "انتارکتیکا",
        "AT": "اتریش",
        "BD": "بنګله‌دیش",
        "BG": "بلغاریه",
        "CA": "کاناډا",
        "CH": "سویس",
        "CN": "چین",
        "CO": "کولمبیا",
        "CU": "کیوبا",
        "DE": "المان",
        "DK": "ډنمارک",
        "DZ": "الجزایر",
        "EG": "مصر",
        "ES": "هسپانیه",
        "ET": "حبشه",
        "FI": "فنلینډ",
        "FR": "فرانسه",
        "GB": "برتانیه",
        "GH": "ګانا",
        "GN": "ګیانا",
        "GR": "یونان",
        "GT": "ګواتیمالا",
        "HN": "هانډوراس",
        "HU": "مجارستان",
        "ID": "اندونیزیا",
        "IN": "هند",
        "IQ": "عراق",
        "IS": "آیسلینډ",
        "IT": "ایټالیه",
        "JM": "جمیکا",
        "JP": "جاپان",
        "KH": "کمبودیا",
        "KW": "کویټ",
        "LA": "لاوس",
        "LB": "لبنان",
        "LR": "لایبریا",
        "LY": "لیبیا",
        "MA": "مراکش",
        "MN": "مغولستان",
        "MY": "مالیزیا",
        "NG": "نایجیریا",
        "NI": "نکاراګوا",
        "NL": "هالېنډ",
        "NO": "ناروې",
        "NP": "نیپال",
        "NZ": "نیوزیلنډ",
        "PK": "پاکستان",
        "PL": "پولنډ",
        "PS": "فلسطین",
        "PT": "پورتګال",
        "RU": "روسیه",
        "RW": "روندا",
        "SA": "سعودی عربستان",
        "SE": "سویډن",
        "SV": "سالوېډور",
        "SY": "سوریه",
        "TJ": "تاجکستان",
        "TZ": "تنزانیا",
        "UY": "یوروګوای",
        "YE": "یمن"
    };
  }-*/;
}
