/*
 * Decompiled with CFR 0.152.
 */
package org.grails.compiler.injection.test;

import grails.test.runtime.FreshRuntime;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.grails.compiler.injection.GrailsASTUtils;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class DirtiesRuntimeTransformation
implements ASTTransformation {
    public void visit(ASTNode[] astNodes, SourceUnit source) {
        List annotations;
        if (!(astNodes[0] instanceof AnnotationNode) || !(astNodes[1] instanceof MethodNode)) {
            throw new RuntimeException("Internal error: wrong types: $node.class / $parent.class");
        }
        MethodNode methodNode = (MethodNode)astNodes[1];
        ClassNode declaringClassNode = methodNode.getDeclaringClass();
        if (declaringClassNode != null && (annotations = declaringClassNode.getAnnotations(ClassHelper.make(FreshRuntime.class))) != null && annotations.size() > 0) {
            String message = "The [" + methodNode.getName() + "] method in [" + declaringClassNode.getName() + "] is marked with @DirtiesRuntime.  " + "There is no need to mark a test method with @DirtiesRuntime " + "inside of a test class which is marked with @FreshRuntime.";
            GrailsASTUtils.warning((SourceUnit)source, (ASTNode)methodNode, (String)message);
        }
    }
}

