/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.Serializable;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Cookie
extends NameValuePair
implements Serializable,
Comparator {
    private String cookieComment;
    private String cookieDomain;
    private Date cookieExpiryDate;
    private String cookiePath;
    private boolean isSecure;
    private boolean hasPathAttribute = false;
    private boolean hasDomainAttribute = false;
    private int cookieVersion = 0;
    private static final RuleBasedCollator STRING_COLLATOR = (RuleBasedCollator)Collator.getInstance(new Locale("en", "US", ""));
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$Cookie != null ? class$org$apache$commons$httpclient$Cookie : (class$org$apache$commons$httpclient$Cookie = Cookie.class$("org.apache.commons.httpclient.Cookie")));
    static /* synthetic */ Class class$org$apache$commons$httpclient$Cookie;

    public Cookie() {
        this(null, "noname", null, null, null, false);
    }

    public Cookie(String domain, String name, String value) {
        this(domain, name, value, null, null, false);
    }

    public Cookie(String domain, String name, String value, String path, int maxAge, boolean secure) {
        this(domain, name, value, path, null, secure);
        if (maxAge < -1) {
            throw new IllegalArgumentException("Invalid max age:  " + Integer.toString(maxAge));
        }
        if (maxAge >= 0) {
            this.setExpiryDate(new Date(System.currentTimeMillis() + (long)maxAge * 1000L));
        }
    }

    public Cookie(String domain, String name, String value, String path, Date expires, boolean secure) {
        super(name, value);
        LOG.trace("enter Cookie(String, String, String, String, Date, boolean)");
        if (name == null) {
            throw new IllegalArgumentException("Cookie name may not be null");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("Cookie name may not be blank");
        }
        if (name.indexOf(32) != -1) {
            throw new IllegalArgumentException("Cookie name may not contain blanks");
        }
        if (name.startsWith("$")) {
            throw new IllegalArgumentException("Cookie name may not start with $");
        }
        this.setPath(path);
        this.setDomain(domain);
        this.setExpiryDate(expires);
        this.setSecure(secure);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public int compare(Object o1, Object o2) {
        LOG.trace("enter Cookie.compare(Object, Object)");
        if (!(o1 instanceof Cookie)) {
            throw new ClassCastException(o1.getClass().getName());
        }
        if (!(o2 instanceof Cookie)) {
            throw new ClassCastException(o2.getClass().getName());
        }
        Cookie c1 = (Cookie)o1;
        Cookie c2 = (Cookie)o2;
        if (c1.getPath() == null && c2.getPath() == null) {
            return 0;
        }
        if (c1.getPath() == null) {
            if (c2.getPath().equals("/")) {
                return 0;
            }
            return -1;
        }
        if (c2.getPath() == null) {
            if (c1.getPath().equals("/")) {
                return 0;
            }
            return 1;
        }
        return STRING_COLLATOR.compare(c1.getPath(), c2.getPath());
    }

    public static Header createCookieHeader(String domain, int port, String path, boolean secure, Date now, Cookie[] cookies) throws IllegalArgumentException {
        LOG.trace("enter Cookie.createCookieHeader(String, int, String, boolean, Date, Cookie[])");
        CookieSpec matcher = CookiePolicy.getDefaultSpec();
        cookies = matcher.match(domain, port, path, secure, cookies);
        if (cookies != null && cookies.length > 0) {
            return matcher.formatCookieHeader(cookies);
        }
        return null;
    }

    public static Header createCookieHeader(String domain, int port, String path, boolean secure, Cookie[] cookies) throws IllegalArgumentException {
        LOG.trace("enter Cookie.createCookieHeader(String, int, String, boolean, Cookie[])");
        return Cookie.createCookieHeader(domain, port, path, secure, new Date(), cookies);
    }

    public static Header createCookieHeader(String domain, String path, boolean secure, Cookie[] cookies) throws IllegalArgumentException {
        int port;
        block3: {
            LOG.trace("enter Cookie.createCookieHeader(String, String, boolean, Cookie[])");
            if (domain == null) {
                throw new IllegalArgumentException("null domain in createCookieHeader.");
            }
            port = secure ? 443 : 80;
            int ndx = domain.indexOf(":");
            if (ndx == -1) break block3;
            try {
                port = Integer.parseInt(domain.substring(ndx + 1, domain.length()));
            }
            catch (NumberFormatException numberFormatException) {
                LOG.warn("Cookie.createCookieHeader():  Invalid port number in domain " + domain);
            }
        }
        return Cookie.createCookieHeader(domain, port, path, secure, cookies);
    }

    public static Header createCookieHeader(String domain, String path, Cookie[] cookies) {
        LOG.trace("enter Cookie.createCookieHeader(String,String,Cookie[])");
        return Cookie.createCookieHeader(domain, path, false, cookies);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        LOG.trace("enter Cookie.equals(Object)");
        if (obj == null) return false;
        if (!(obj instanceof Cookie)) return false;
        Cookie that = (Cookie)obj;
        if (this.getName() == null) {
            if (that.getName() != null) {
                return false;
            }
        } else {
            boolean bl = this.getName().equals(that.getName());
            if (!bl) return false;
        }
        if (this.getPath() == null) {
            if (that.getPath() != null) {
                return false;
            }
        } else {
            boolean bl = this.getPath().equals(that.getPath());
            if (!bl) return false;
        }
        if (this.getDomain() == null) {
            if (that.getDomain() == null) return true;
            return false;
        }
        boolean bl = this.getDomain().equals(that.getDomain());
        if (bl) return true;
        return false;
    }

    public String getComment() {
        return this.cookieComment;
    }

    public String getDomain() {
        return this.cookieDomain;
    }

    public Date getExpiryDate() {
        return this.cookieExpiryDate;
    }

    public String getPath() {
        return this.cookiePath;
    }

    public boolean getSecure() {
        return this.isSecure;
    }

    public int getVersion() {
        return this.cookieVersion;
    }

    public int hashCode() {
        return super.hashCode() ^ (this.cookiePath == null ? 0 : this.cookiePath.hashCode()) ^ (this.cookieDomain == null ? 0 : this.cookieDomain.hashCode());
    }

    public boolean isDomainAttributeSpecified() {
        return this.hasDomainAttribute;
    }

    public boolean isExpired() {
        return this.cookieExpiryDate != null && this.cookieExpiryDate.getTime() <= System.currentTimeMillis();
    }

    public boolean isExpired(Date now) {
        return this.cookieExpiryDate != null && this.cookieExpiryDate.getTime() <= now.getTime();
    }

    public boolean isPathAttributeSpecified() {
        return this.hasPathAttribute;
    }

    public boolean isPersistent() {
        return this.cookieExpiryDate != null;
    }

    public boolean matches(String domain, int port, String path, boolean secure) {
        LOG.trace("enter Cookie.matches(String, int, String, boolean");
        return this.matches(domain, port, path, secure, new Date());
    }

    public boolean matches(String domain, int port, String path, boolean secure, Date date) {
        LOG.trace("enter Cookie.matches(Strinng, int, String, boolean, Date");
        CookieSpec matcher = CookiePolicy.getDefaultSpec();
        return matcher.match(domain, port, path, secure, this);
    }

    public static Cookie[] parse(String domain, int port, String path, Header setCookie) throws HttpException, IllegalArgumentException {
        LOG.trace("enter Cookie.parse(String, int, String, Header)");
        return Cookie.parse(domain, port, path, false, setCookie);
    }

    public static Cookie[] parse(String domain, int port, String path, boolean secure, Header setCookie) throws HttpException {
        LOG.trace("enter Cookie.parse(String, int, String, boolean, Header)");
        CookieSpec parser = CookiePolicy.getDefaultSpec();
        Cookie[] cookies = parser.parse(domain, port, path, secure, setCookie);
        int i = 0;
        while (i < cookies.length) {
            Cookie cookie = cookies[i];
            CookieSpec validator = CookiePolicy.getSpecByVersion(cookie.getVersion());
            validator.validate(domain, port, path, secure, cookie);
            ++i;
        }
        return cookies;
    }

    public static Cookie[] parse(String domain, String path, Header setCookie) throws HttpException, IllegalArgumentException {
        LOG.trace("enter Cookie.parse(String, String, Header)");
        return Cookie.parse(domain, 80, path, false, setCookie);
    }

    public static Cookie[] parse(String domain, String path, boolean secure, Header setCookie) throws HttpException, IllegalArgumentException {
        LOG.trace("enter Cookie.parse(String, String, boolean, Header)");
        return Cookie.parse(domain, secure ? 443 : 80, path, secure, setCookie);
    }

    public void setComment(String comment) {
        this.cookieComment = comment;
    }

    public void setDomain(String domain) {
        if (domain != null) {
            int ndx = domain.indexOf(":");
            if (ndx != -1) {
                domain = domain.substring(0, ndx);
            }
            this.cookieDomain = domain.toLowerCase();
        }
    }

    public void setDomainAttributeSpecified(boolean value) {
        this.hasDomainAttribute = value;
    }

    public void setExpiryDate(Date expiryDate) {
        this.cookieExpiryDate = expiryDate;
    }

    public void setPath(String path) {
        this.cookiePath = path;
    }

    public void setPathAttributeSpecified(boolean value) {
        this.hasPathAttribute = value;
    }

    public void setSecure(boolean secure) {
        this.isSecure = secure;
    }

    public void setVersion(int version) {
        this.cookieVersion = version;
    }

    public String toExternalForm() {
        return CookiePolicy.getSpecByVersion(this.getVersion()).formatCookie(this);
    }

    public String toString() {
        return this.toExternalForm();
    }
}

