/*
 * Decompiled with CFR 0.152.
 */
package neobio.alignment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import neobio.alignment.Factor;
import neobio.alignment.InvalidSequenceException;
import neobio.alignment.Trie;

public class FactorSequence {
    protected static final char COMMENT_CHAR = '>';
    protected Factor root_factor;
    protected int num_chars;
    protected int num_factors;

    public FactorSequence(Reader reader) throws IOException, InvalidSequenceException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(reader);
        Trie trie = null;
        this.root_factor = new Factor();
        Trie trie2 = new Trie(this.root_factor);
        this.num_factors = 1;
        this.num_chars = 0;
        Trie trie3 = trie2;
        Factor factor = this.root_factor;
        while ((n = bufferedReader.read()) != -1) {
            char c = (char)n;
            if (c == '>') {
                bufferedReader.readLine();
                continue;
            }
            if (Character.isLetter(c)) {
                ++this.num_chars;
                trie = trie3.spellDown(c);
                if (trie != null) {
                    trie3 = trie;
                    continue;
                }
                Factor factor2 = (Factor)trie3.getData();
                Factor factor3 = new Factor(factor2, this.num_factors, c);
                trie3.add(factor3, c);
                factor.setNext(factor3);
                factor = factor3;
                trie3 = trie2;
                ++this.num_factors;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            throw new InvalidSequenceException("Sequences can contain letters only.");
        }
        if (trie != null) {
            factor.setNext((Factor)trie.getData());
            ++this.num_factors;
        }
        if (this.num_factors <= 1) {
            throw new InvalidSequenceException("Empty sequence.");
        }
    }

    public Factor getRootFactor() {
        return this.root_factor;
    }

    public int numFactors() {
        return this.num_factors;
    }

    public int numChars() {
        return this.num_chars;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Factor factor = this.root_factor.getNext();
        int n = 1;
        while (n < this.numFactors()) {
            stringBuffer.append(factor);
            factor = factor.getNext();
            ++n;
        }
        return stringBuffer.toString();
    }

    public String printFactors() {
        StringBuffer stringBuffer = new StringBuffer();
        Factor factor = this.root_factor.getNext();
        int n = 1;
        while (n < this.numFactors()) {
            stringBuffer.append(factor.getSerialNumber() + "\t<");
            stringBuffer.append(factor.getAncestor().getSerialNumber() + " ,\t");
            stringBuffer.append(factor.getNewChar() + ">\t");
            stringBuffer.append(factor.length() + "\t" + factor + "\n");
            factor = factor.getNext();
            ++n;
        }
        stringBuffer.append(this.numFactors() + " factors\n");
        return stringBuffer.toString();
    }
}

