/*
 * Decompiled with CFR 0.152.
 */
package neobio.alignment;

import java.io.IOException;
import java.io.Reader;
import neobio.alignment.AlignmentBlock;
import neobio.alignment.Factor;
import neobio.alignment.FactorSequence;
import neobio.alignment.IncompatibleScoringSchemeException;
import neobio.alignment.InvalidSequenceException;
import neobio.alignment.OutMatrix;
import neobio.alignment.PairwiseAlignment;
import neobio.alignment.PairwiseAlignmentAlgorithm;
import neobio.alignment.Smawk;

public abstract class CrochemoreLandauZivUkelson
extends PairwiseAlignmentAlgorithm {
    protected static final byte STOP_DIRECTION = 0;
    protected static final byte LEFT_DIRECTION = 1;
    protected static final byte DIAGONAL_DIRECTION = 2;
    protected static final byte TOP_DIRECTION = 3;
    protected FactorSequence seq1;
    protected FactorSequence seq2;
    protected AlignmentBlock[][] block_table;
    protected int num_rows;
    protected int num_cols;
    protected Smawk smawk = new Smawk();
    protected OutMatrix out_matrix = new OutMatrix();

    protected void loadSequencesInternal(Reader reader, Reader reader2) throws IOException, InvalidSequenceException {
        this.seq1 = new FactorSequence(reader);
        this.seq2 = new FactorSequence(reader2);
        this.num_rows = this.seq1.numFactors();
        this.num_cols = this.seq2.numFactors();
    }

    protected void unloadSequencesInternal() {
        this.seq1 = null;
        this.seq2 = null;
        this.block_table = null;
    }

    protected PairwiseAlignment computePairwiseAlignment() throws IncompatibleScoringSchemeException {
        this.computeBlockTable();
        PairwiseAlignment pairwiseAlignment = this.buildOptimalAlignment();
        this.block_table = null;
        return pairwiseAlignment;
    }

    protected int computeScore() throws IncompatibleScoringSchemeException {
        this.computeBlockTable();
        int n = this.locateScore();
        this.block_table = null;
        return n;
    }

    protected void computeBlockTable() throws IncompatibleScoringSchemeException {
        this.block_table = new AlignmentBlock[this.num_rows][this.num_cols];
        int n = Math.max(this.seq1.numChars(), this.seq2.numChars());
        this.out_matrix.init(n, this.scoring.maxAbsoluteScore());
        Factor factor = this.seq1.getRootFactor();
        Factor factor2 = this.seq2.getRootFactor();
        if (factor.getSerialNumber() != 0 || factor2.getSerialNumber() != 0) {
            throw new IndexOutOfBoundsException("Unexpected factor index.");
        }
        this.block_table[0][0] = this.createRootBlock(factor, factor2);
        int n2 = 1;
        while (n2 < this.num_cols) {
            factor2 = factor2.getNext();
            if (n2 < this.num_cols - 1 && factor2.getSerialNumber() != n2) {
                throw new IndexOutOfBoundsException("Unexpected factor index.");
            }
            this.block_table[0][n2] = this.createFirstRowBlock(factor, factor2, n2);
            ++n2;
        }
        int n3 = 1;
        while (n3 < this.num_rows) {
            factor = factor.getNext();
            if (n3 < this.num_rows - 1 && factor.getSerialNumber() != n3) {
                throw new IndexOutOfBoundsException("Unexpected factor index.");
            }
            factor2 = this.seq2.getRootFactor();
            if (factor2.getSerialNumber() != 0) {
                throw new IndexOutOfBoundsException("Unexpected factor index.");
            }
            this.block_table[n3][0] = this.createFirstColumnBlock(factor, factor2, n3);
            n2 = 1;
            while (n2 < this.num_cols) {
                factor2 = factor2.getNext();
                if (n2 < this.num_cols - 1 && factor2.getSerialNumber() != n2) {
                    throw new IndexOutOfBoundsException("Unexpected factor index.");
                }
                this.block_table[n3][n2] = this.createBlock(factor, factor2, n3, n2);
                ++n2;
            }
            ++n3;
        }
    }

    protected int[][] assembleDistMatrix(AlignmentBlock alignmentBlock, int n, int n2, int n3, int n4) {
        AlignmentBlock alignmentBlock2;
        int[][] nArrayArray = new int[n][];
        Factor factor = alignmentBlock.factor2.getAncestor();
        int n5 = n4 - 1;
        while (n5 >= 0) {
            alignmentBlock.ancestor[n5] = alignmentBlock2 = this.block_table[n2][factor.getSerialNumber()];
            nArrayArray[n5] = alignmentBlock2.dist_column;
            factor = factor.getAncestor();
            --n5;
        }
        nArrayArray[n4] = alignmentBlock.dist_column;
        alignmentBlock.ancestor[n4] = alignmentBlock;
        factor = alignmentBlock.factor1.getAncestor();
        n5 = n4 + 1;
        while (n5 < n) {
            alignmentBlock.ancestor[n5] = alignmentBlock2 = this.block_table[factor.getSerialNumber()][n3];
            nArrayArray[n5] = alignmentBlock2.dist_column;
            factor = factor.getAncestor();
            ++n5;
        }
        return nArrayArray;
    }

    protected int[] assembleInputBorder(int n, int n2, int n3, int n4) {
        AlignmentBlock alignmentBlock = null;
        AlignmentBlock alignmentBlock2 = null;
        int[] nArray = new int[n];
        if (n3 > 0) {
            alignmentBlock = this.block_table[n2][n3 - 1];
        }
        if (n2 > 0) {
            alignmentBlock2 = this.block_table[n2 - 1][n3];
        }
        int n5 = 0;
        while (n5 < n) {
            nArray[n5] = n5 < n4 ? (alignmentBlock != null ? alignmentBlock.output_border[alignmentBlock.factor2.length() + n5] : -1073741824) : (n5 == n4 ? (alignmentBlock != null ? alignmentBlock.output_border[alignmentBlock.factor2.length() + n5] : alignmentBlock2.output_border[n5 - n4]) : (alignmentBlock2 != null ? alignmentBlock2.output_border[n5 - n4] : -1073741824));
            ++n5;
        }
        return nArray;
    }

    protected void traverseBlock(AlignmentBlock alignmentBlock, int n, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) throws IncompatibleScoringSchemeException {
        while (alignmentBlock.direction[n] != 0) {
            char c = alignmentBlock.factor1.getNewChar();
            char c2 = alignmentBlock.factor2.getNewChar();
            switch (alignmentBlock.direction[n]) {
                case 1: {
                    stringBuffer.insert(0, '-');
                    stringBuffer2.insert(0, ' ');
                    stringBuffer3.insert(0, c2);
                    alignmentBlock = this.getLeftPrefix(alignmentBlock);
                    break;
                }
                case 2: {
                    stringBuffer.insert(0, c);
                    if (c == c2) {
                        if (this.useMatchTag()) {
                            stringBuffer2.insert(0, '|');
                        } else {
                            stringBuffer2.insert(0, c);
                        }
                    } else if (this.scoreSubstitution(c, c2) > 0) {
                        stringBuffer2.insert(0, '+');
                    } else {
                        stringBuffer2.insert(0, ' ');
                    }
                    stringBuffer3.insert(0, c2);
                    alignmentBlock = this.getDiagonalPrefix(alignmentBlock);
                    --n;
                    break;
                }
                case 3: {
                    stringBuffer.insert(0, c);
                    stringBuffer2.insert(0, ' ');
                    stringBuffer3.insert(0, '-');
                    alignmentBlock = this.getTopPrefix(alignmentBlock);
                    --n;
                }
            }
        }
    }

    protected AlignmentBlock getLeftPrefix(AlignmentBlock alignmentBlock) {
        int n = alignmentBlock.factor1.getSerialNumber();
        int n2 = alignmentBlock.factor2.getAncestorSerialNumber();
        return this.block_table[n][n2];
    }

    protected AlignmentBlock getDiagonalPrefix(AlignmentBlock alignmentBlock) {
        int n = alignmentBlock.factor1.getAncestorSerialNumber();
        int n2 = alignmentBlock.factor2.getAncestorSerialNumber();
        return this.block_table[n][n2];
    }

    protected AlignmentBlock getTopPrefix(AlignmentBlock alignmentBlock) {
        int n = alignmentBlock.factor1.getAncestorSerialNumber();
        int n2 = alignmentBlock.factor2.getSerialNumber();
        return this.block_table[n][n2];
    }

    protected abstract AlignmentBlock createRootBlock(Factor var1, Factor var2) throws IncompatibleScoringSchemeException;

    protected abstract AlignmentBlock createFirstRowBlock(Factor var1, Factor var2, int var3) throws IncompatibleScoringSchemeException;

    protected abstract AlignmentBlock createFirstColumnBlock(Factor var1, Factor var2, int var3) throws IncompatibleScoringSchemeException;

    protected abstract AlignmentBlock createBlock(Factor var1, Factor var2, int var3, int var4) throws IncompatibleScoringSchemeException;

    protected abstract PairwiseAlignment buildOptimalAlignment() throws IncompatibleScoringSchemeException;

    protected abstract int locateScore();
}

