/*
 * Decompiled with CFR 0.152.
 */
package neobio.alignment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import neobio.alignment.InvalidSequenceException;

public class CharSequence {
    protected static final char COMMENT_CHAR = '>';
    protected char[] sequence;

    public CharSequence(Reader reader) throws IOException, InvalidSequenceException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = bufferedReader.read()) != -1) {
            char c = (char)n;
            if (c == '>') {
                bufferedReader.readLine();
                continue;
            }
            if (Character.isLetter(c)) {
                stringBuffer.append(c);
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            throw new InvalidSequenceException("Sequences can contain letters only.");
        }
        if (stringBuffer.length() <= 0) {
            throw new InvalidSequenceException("Empty sequence.");
        }
        this.sequence = new char[stringBuffer.length()];
        stringBuffer.getChars(0, stringBuffer.length(), this.sequence, 0);
    }

    public int length() {
        return this.sequence.length;
    }

    public char charAt(int n) {
        return this.sequence[n - 1];
    }

    public String toString() {
        return new String(this.sequence);
    }
}

