/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.structure;

import com.informagen.sa.structure.GraphPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;

public class GraphCanvas
extends JComponent
implements PropertyChangeListener {
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    GraphPanel mGraphPanel = null;
    double[] mGraphData;
    int mNumOfPoints = 0;
    int mSelectFrom = 0;
    int mSelectTo = 0;
    int mHitPosition;
    double mVmax;
    double mVmin;
    double mMax;
    double mMin;
    double mGraphMax;
    double mGraphMin;
    double mHscale;
    double mVscale;
    double mCutoff;
    Color mColor;
    Dimension offDimension;
    Image offImage;
    Graphics offGraphics;
    final int[] selectionRange = new int[2];

    public GraphCanvas() {
        this.setCutoff(0.0);
        this.setPenColor(Color.blue);
        this.mGraphMax = Double.POSITIVE_INFINITY;
        this.mGraphMin = Double.NEGATIVE_INFINITY;
        this.wireUI();
    }

    private void wireUI() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                if (GraphCanvas.this.mGraphData == null) {
                    return;
                }
                if (GraphCanvas.this.mGraphPanel == null) {
                    GraphCanvas.this.mGraphPanel = (GraphPanel)GraphCanvas.this.getParent();
                }
                int n = (int)Math.floor((double)mouseEvent.getX() / GraphCanvas.this.mHscale);
                double d = 0.0;
                if (n >= 0 && n < GraphCanvas.this.mNumOfPoints) {
                    d = GraphCanvas.this.mGraphData[n];
                }
                GraphCanvas.this.mGraphPanel.reportPosition(n + 1, d);
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                int n = (int)Math.floor((double)mouseEvent.getX() / GraphCanvas.this.mHscale);
                if (n < GraphCanvas.this.mHitPosition) {
                    GraphCanvas.this.setNewSelection(n, GraphCanvas.this.mHitPosition);
                } else {
                    GraphCanvas.this.setNewSelection(GraphCanvas.this.mHitPosition, n);
                }
                GraphCanvas.this.pcs.firePropertyChange("graphSelectionChanged", null, GraphCanvas.this.selectionRange);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                GraphCanvas.this.mHitPosition = (int)Math.floor((double)mouseEvent.getX() / GraphCanvas.this.mHscale);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = (int)Math.floor((double)mouseEvent.getX() / GraphCanvas.this.mHscale);
                n = n < 1 ? 1 : n;
                n = n > GraphCanvas.this.mNumOfPoints ? GraphCanvas.this.mNumOfPoints : n;
                GraphCanvas.this.pcs.firePropertyChange("graphSequenceClicked", null, new Integer(n));
            }
        });
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("addPropertyChangeListener")) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)propertyChangeEvent.getNewValue();
            if (propertyChangeListener != null) {
                this.pcs.addPropertyChangeListener(propertyChangeListener);
            }
        } else if (string.equals("removePropertyChangeListener")) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)propertyChangeEvent.getNewValue();
            if (propertyChangeListener != null) {
                this.pcs.removePropertyChangeListener(propertyChangeListener);
            }
        } else if (!string.equals("selectionChanged") && string.equals("caretPosition")) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            this.setNewSelection(n, n + 1);
        }
    }

    private void fireGraphSelectionChanged(int n, int n2) {
        this.selectionRange[0] = n;
        this.selectionRange[1] = n2;
    }

    public void setNewSelection(int n, int n2) {
        this.mSelectFrom = n;
        this.mSelectTo = n2;
        this.repaint();
        this.fireGraphSelectionChanged(this.mSelectFrom, this.mSelectTo);
    }

    public void setCutoff(double d) {
        this.mCutoff = d;
    }

    public void setGraphMax(double d) {
        this.mGraphMax = d;
    }

    public void setGraphMin(double d) {
        this.mGraphMin = d;
    }

    public void setGraphData(double[] dArray) {
        this.mGraphData = dArray;
        if (this.mGraphData == null) {
            this.mNumOfPoints = 0;
            this.repaint();
            return;
        }
        this.mNumOfPoints = this.mGraphData.length;
        this.mVmax = Double.NEGATIVE_INFINITY;
        this.mVmin = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.mNumOfPoints; ++i) {
            this.mVmax = this.mGraphData[i] > this.mVmax ? this.mGraphData[i] : this.mVmax;
            this.mVmin = this.mGraphData[i] < this.mVmin ? this.mGraphData[i] : this.mVmin;
        }
        double d = this.mVmax - this.mVmin;
        this.mVmax += d * 0.05;
        this.mVmin -= d * 0.05;
        this.repaint();
    }

    public void setVscale() {
        Rectangle rectangle = this.getBounds();
        this.mMax = this.mGraphMax == Double.POSITIVE_INFINITY ? this.mVmax : this.mGraphMax;
        this.mMin = this.mGraphMin == Double.NEGATIVE_INFINITY ? this.mVmin : this.mGraphMin;
        this.mVscale = (double)rectangle.height / (this.mMax - this.mMin);
    }

    public void setHscale() {
        Rectangle rectangle = this.getBounds();
        this.mHscale = (double)(rectangle.width - 2) / (double)(this.mNumOfPoints + 1);
    }

    public void setPenColor(Color color) {
        this.mColor = color;
    }

    public int getNumOfPoints() {
        return this.mNumOfPoints;
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offGraphics == null || dimension.width != this.offDimension.width || dimension.height != this.offDimension.height) {
            this.offDimension = dimension;
            this.offImage = this.createImage(dimension.width, dimension.height);
            this.offGraphics = this.offImage.getGraphics();
        }
        this.offGraphics.setColor(this.getBackground());
        this.offGraphics.fillRect(0, 0, dimension.width, dimension.height);
        if (this.mNumOfPoints > 0) {
            this.drawSelection(this.offGraphics);
            this.drawTrace(this.offGraphics);
        } else {
            this.drawNoDataMsg(this.offGraphics);
        }
        graphics.drawImage(this.offImage, 0, 0, this);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    private void drawSelection(Graphics graphics) {
        Rectangle rectangle;
        if (this.mSelectFrom == this.mSelectTo) {
            return;
        }
        Rectangle rectangle2 = rectangle = this.getBounds();
        this.setVscale();
        this.setHscale();
        boolean bl = false;
        boolean bl2 = false;
        int n = rectangle.width;
        int n2 = rectangle.height;
        graphics.setColor(this.mColor);
        double d = this.mHscale;
        int n3 = (int)((double)this.mSelectFrom * d);
        int n4 = (int)((double)this.mSelectTo * d);
        int n5 = n4 - n3;
        graphics.setColor(SystemColor.textHighlight);
        Rectangle rectangle3 = new Rectangle(100, 0, 200, this.getBounds().height);
        graphics.fillRect(n3, 0, n5, this.getBounds().height);
    }

    private void drawTrace(Graphics graphics) {
        Rectangle rectangle;
        Rectangle rectangle2 = rectangle = this.getBounds();
        this.setVscale();
        this.setHscale();
        boolean bl = false;
        int n = 0;
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        graphics.setColor(this.mColor);
        double d = this.mHscale;
        Point point = new Point(0, 0);
        Point point2 = new Point(0, 0);
        Point point3 = new Point(0, 0);
        point2.y = point.y = (int)((double)n3 - (this.mCutoff - this.mMin) * this.mVscale);
        point2.x = point.x = n;
        Rectangle rectangle3 = new Rectangle();
        for (int i = 0; i < this.mNumOfPoints; ++i) {
            double d2 = i >= 0 ? this.mGraphData[i] : 0.0;
            point3.x = (int)((double)(i + 1) * d);
            point3.y = (int)((double)n3 - (d2 - this.mMin) * this.mVscale);
            rectangle3.x = point2.x;
            rectangle3.width = point3.x - point2.x;
            if (d2 > this.mCutoff) {
                rectangle3.y = point3.y;
                rectangle3.height = point.y - point3.y;
            } else {
                rectangle3.y = point.y;
                rectangle3.height = point3.y - point.y;
            }
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            point2.x = point3.x;
            point2.y = point3.y;
        }
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n, point.y, n2, point.y);
    }

    private void drawNoDataMsg(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        Font font = graphics.getFont();
        Font font2 = new Font("Helvetica", 1, 14);
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = "<Not enough sequence to compute graph.>";
        int n = (rectangle.width - fontMetrics.stringWidth(string)) / 2;
        int n2 = (rectangle.height + fontMetrics.getAscent()) / 2;
        graphics.drawString(string, n, n2);
        graphics.setFont(font);
    }
}

