/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.orf;

import com.informagen.giv.GIVPanel;
import com.informagen.giv.MapView;
import com.informagen.sa.orf.ORFGlyphListener;
import com.informagen.sa.orf.ORFXMLParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class ORFViewerPanel
extends JPanel {
    private static final double kEdgeBorder = 0.05;
    GIVPanel givPanel = new GIVPanel(true, true, true);
    JPanel emptyPanel = new JPanel();
    PropertyChangeListener listener;
    private final JLabel reporterLabel = new JLabel();
    private JPanel toolsPanel;
    private final JToolBar buttonBar = new JToolBar();
    private final JToolBar tilingBar = new JToolBar();
    private Vector tiles;
    private Vector glyphs;

    ORFViewerPanel(PropertyChangeListener propertyChangeListener) {
        this.listener = propertyChangeListener;
        this.buildUI();
        this.wireUI();
    }

    void clear() {
        this.remove(this.givPanel);
        this.givPanel = new GIVPanel(true, true, true);
        this.add((Component)this.givPanel, "Center");
    }

    public void initialZoom() {
        this.givPanel.initialZoom();
    }

    void buildUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        this.add((Component)this.givPanel, "Center");
        this.add((Component)this.reporterLabel, "South");
    }

    void wireUI() {
    }

    boolean buildORFmap(String string) {
        this.remove(this.givPanel);
        this.givPanel = new GIVPanel(true, true, true);
        this.add((Component)this.givPanel, "Center");
        StringReader stringReader = new StringReader(string);
        MapView mapView = null;
        ORFXMLParser oRFXMLParser = new ORFXMLParser(stringReader);
        try {
            mapView = oRFXMLParser.parseXML();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, iOException.getMessage());
        }
        if (mapView == null) {
            return false;
        }
        this.installMapView(mapView);
        return true;
    }

    void installMapView(MapView mapView) {
        if (mapView == null) {
            return;
        }
        this.givPanel.installMapView(mapView);
        this.glyphs = this.givPanel.getGlyphs();
        this.tiles = this.givPanel.getTiles();
        ORFGlyphListener oRFGlyphListener = new ORFGlyphListener(this.listener, this.reporterLabel);
        mapView.addGlyphListener(oRFGlyphListener);
    }
}

