/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa;

import ch.randelshofer.quaqua.JSheet;
import ch.randelshofer.quaqua.SheetEvent;
import ch.randelshofer.quaqua.SheetListener;
import com.informagen.Util;
import com.informagen.giv.SAXErrorHandler;
import com.informagen.sa.MainMenuBar;
import com.informagen.sa.PanelPrinter;
import com.informagen.sa.SAFrame;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.roydesign.app.Application;
import net.roydesign.event.ApplicationEvent;
import net.roydesign.io.SpecialFolder;
import net.roydesign.mac.MRJAdapter;
import net.roydesign.ui.StandardMacAboutFrame;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SequenceAnalysis
extends Application {
    private static String appName = "Sequence Analysis";
    private static String appVersion = "1.7.2";
    private static String appCopyright = "Informagen, Inc.";
    private MainMenuBar mainMenuBar;
    private static Vector windows = new Vector();
    static SequenceAnalysis application = null;

    public static void main(String[] stringArray) {
        if (System.getProperty("os.name").contains("Mac")) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        application = new SequenceAnalysis();
    }

    public SequenceAnalysis() {
        JMenuItem jMenuItem;
        this.setName(appName);
        this.addOpenApplicationListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SequenceAnalysis.openDocument((ApplicationEvent)actionEvent);
            }
        });
        this.addReopenApplicationListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.addOpenDocumentListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SequenceAnalysis.openDocument((ApplicationEvent)actionEvent);
            }
        });
        this.addPrintDocumentListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        if (MRJAdapter.isAboutAutomaticallyPresent()) {
            jMenuItem = this.getAboutJMenuItem();
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SequenceAnalysis.this.doAboutBox();
                }
            });
        }
        if (MRJAdapter.isPreferencesAutomaticallyPresent()) {
            jMenuItem = this.getPreferencesJMenuItem();
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SequenceAnalysis.showMessage("Preferences not yet implemented.");
                }
            });
            jMenuItem.setEnabled(false);
        }
        if (MRJAdapter.isQuitAutomaticallyPresent()) {
            jMenuItem = this.getQuitJMenuItem();
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SequenceAnalysis.this.doQuit();
                }
            });
        }
        if (MRJAdapter.isSwingUsingScreenMenuBar()) {
            this.mainMenuBar = new MainMenuBar();
            this.setFramelessJMenuBar(this.mainMenuBar);
            jMenuItem = this.mainMenuBar.newWindowMenuItem;
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 5));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SequenceAnalysis.this.createNewWindow();
                }
            });
        }
        this.createNewWindow();
    }

    MainMenuBar getMainMenuBar() {
        return this.mainMenuBar;
    }

    private static void openDocument(ApplicationEvent applicationEvent) {
        SAFrame sAFrame = null;
        if (windows.size() == 0) {
            sAFrame = new SAFrame(application);
            Util.windowDecorator(sAFrame, 860, 0);
            sAFrame.setVisible(true);
            windows.add(sAFrame);
        } else {
            Enumeration enumeration = windows.elements();
            while (enumeration.hasMoreElements()) {
                SAFrame sAFrame2 = (SAFrame)enumeration.nextElement();
                if (!sAFrame2.isActive()) continue;
                sAFrame = sAFrame2;
                break;
            }
        }
        if (sAFrame != null) {
            sAFrame.openDocument(applicationEvent.getFile());
        }
    }

    public SAFrame createNewWindow() {
        int n = 860;
        int n2 = 0;
        SAFrame sAFrame = new SAFrame(this);
        Util.windowDecorator(sAFrame, n, n2);
        sAFrame.setVisible(true);
        windows.add(sAFrame);
        return sAFrame;
    }

    public void closeWindow(SAFrame sAFrame) {
        sAFrame.dispose();
        windows.remove(sAFrame);
        if (windows.size() == 0 && !MRJAdapter.isQuitAutomaticallyPresent()) {
            this.quit();
        }
    }

    public void quit() {
        this.doQuit();
    }

    public void doAboutBox() {
        StandardMacAboutFrame standardMacAboutFrame = new StandardMacAboutFrame(appName, appVersion);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/com/informagen/sa/SA-icon.png"));
        standardMacAboutFrame.setApplicationIcon(imageIcon);
        standardMacAboutFrame.setBuildVersion(null);
        standardMacAboutFrame.setCopyright(appCopyright + " (Java JVM " + System.getProperty("java.version") + ")");
        InputStream inputStream = this.getClass().getResourceAsStream("/com/informagen/sa/docs/AboutBox.html");
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringWriter stringWriter = new StringWriter();
        try {
            int n;
            while ((n = inputStreamReader.read()) != -1) {
                stringWriter.write(n);
            }
            inputStreamReader.close();
            standardMacAboutFrame.setCredits(stringWriter.toString(), "text/html");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        standardMacAboutFrame.setHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        MRJAdapter.openURL(hyperlinkEvent.getURL().toString());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        standardMacAboutFrame.pack();
        standardMacAboutFrame.setSize(500, standardMacAboutFrame.getSize().height);
        Dimension dimension = standardMacAboutFrame.getToolkit().getScreenSize();
        Dimension dimension2 = standardMacAboutFrame.getSize();
        standardMacAboutFrame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 4);
        standardMacAboutFrame.setVisible(true);
    }

    public void doQuit() {
        System.exit(0);
    }

    private static void readInfoPlist() {
        try {
            File file = new File(SequenceAnalysis.getApplicationPath());
            file = new File(file, "Contents");
            file = new File(file, "Info.plist");
            appName = MRJAdapter.parseInfoPlist(file, "CFBundleName");
            appVersion = MRJAdapter.parseInfoPlist(file, "CFBundleShortVersionString");
            appCopyright = MRJAdapter.parseInfoPlist(file, "CFBundleGetInfoString");
            byte[] byArray = appCopyright.getBytes();
            StringBuffer stringBuffer = new StringBuffer(byArray.length);
            for (int i = 0; i < byArray.length; ++i) {
                if ((byArray[i] & 0xFF) >= 192) continue;
                stringBuffer.append((char)(byArray[i] & 0xFF));
            }
            appCopyright = stringBuffer.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getApplicationName() {
        return appName;
    }

    public static String getWebProxy() {
        return "";
    }

    public static void showMessage(String string) {
        JOptionPane.showMessageDialog(null, string);
    }

    public static XMLReader getXMLReader() throws Exception {
        XMLReader xMLReader = null;
        try {
            xMLReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            throw new NoClassDefFoundError("No SAX parser is available");
        }
        return xMLReader;
    }

    public static ErrorHandler getSAXErrorHandler() {
        return new SAXErrorHandler(System.err);
    }

    public static Properties getModuleProperties() {
        return null;
    }

    public static void launchURL(String string, String string2) {
    }

    public static void launchURL(String string) {
    }

    static boolean loadORF() {
        return true;
    }

    static boolean loadFeatures() {
        return true;
    }

    static boolean loadPSEM() {
        return true;
    }

    static boolean loadPattern() {
        return true;
    }

    static boolean loadFormat() {
        return true;
    }

    static boolean loadPublish() {
        return true;
    }

    static boolean loadPairwise() {
        return true;
    }

    static boolean loadComposition() {
        return true;
    }

    static boolean loadPI() {
        return true;
    }

    static boolean loadMORGAN() {
        return false;
    }

    static boolean loadPrimer3() {
        return true;
    }

    static boolean loadDigest() {
        return true;
    }

    static boolean allowSignalP() {
        return false;
    }

    static boolean showTabIcons() {
        return true;
    }

    static boolean showQuitBtn() {
        return false;
    }

    static void printTextPane(JTextPane jTextPane) {
        new PanelPrinter(jTextPane.getText()).print();
    }

    public static void saveText(Frame frame, final String string, String string2) {
        JFileChooser jFileChooser = new JFileChooser();
        final Preferences preferences = Preferences.userNodeForPackage(frame.getClass());
        try {
            String string3 = preferences.get("SA.defaultDirectory", SpecialFolder.getDesktopFolder().getCanonicalPath());
            jFileChooser.setSelectedFile(new File(string3, string2));
        }
        catch (IOException iOException) {
            jFileChooser.setCurrentDirectory(null);
        }
        JSheet.showSaveSheet(jFileChooser, frame, new SheetListener(){

            public void optionSelected(SheetEvent sheetEvent) {
                File file;
                if (sheetEvent.getOption() == 0 && (file = sheetEvent.getFileChooser().getSelectedFile()) != null) {
                    try {
                        FileWriter fileWriter = new FileWriter(file);
                        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                        bufferedWriter.write(string);
                        bufferedWriter.close();
                        preferences.put("SA.defaultDirectory", file.getParentFile().getAbsolutePath());
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
            }
        });
    }

    public static void saveImage(Frame frame, final Image image, String string, String string2) {
        String string3 = string + "-" + string2 + "." + "png";
        final Preferences preferences = Preferences.userNodeForPackage(frame.getClass());
        JFileChooser jFileChooser = new JFileChooser();
        try {
            String string4 = preferences.get("SA.defaultDirectory", SpecialFolder.getDesktopFolder().getCanonicalPath());
            jFileChooser.setSelectedFile(new File(string4, string3));
        }
        catch (IOException iOException) {
            jFileChooser.setCurrentDirectory(null);
        }
        JSheet.showSaveSheet(jFileChooser, frame, new SheetListener(){

            public void optionSelected(SheetEvent sheetEvent) {
                File file;
                if (sheetEvent.getOption() == 0 && (file = sheetEvent.getFileChooser().getSelectedFile()) != null) {
                    try {
                        int n = image.getWidth(null);
                        int n2 = image.getHeight(null);
                        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
                        Graphics graphics = bufferedImage.getGraphics();
                        graphics.drawImage(image, 0, 0, null);
                        graphics.dispose();
                        ImageIO.write((RenderedImage)bufferedImage, "png", file);
                        preferences.put("SA.defaultDirectory", file.getParentFile().getAbsolutePath());
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
            }
        });
    }

    static void printJPanel(JPanel jPanel, String string) {
        SequenceAnalysis.showMessage("Printing not yet supported");
    }

    private static String getApplicationPath() throws IOException {
        String string = null;
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{new URL("file://127.0.0.1/System/Library/Java/")});
            Class<?> clazz = Class.forName("com.apple.cocoa.foundation.NSBundle", true, uRLClassLoader);
            Method method = clazz.getMethod("mainBundle", null);
            Object object = method.invoke(null, null);
            Method method2 = clazz.getMethod("bundlePath", null);
            string = (String)method2.invoke(object, null);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(malformedURLException.getMessage());
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        return string;
    }
}

