/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa;

import com.infocom.print.PFDocument;
import com.infocom.print.PFInchUnit;
import com.infocom.print.PFPage;
import com.infocom.print.PFPageFormat;
import com.infocom.print.PFParagraph;
import com.infocom.print.PFPoint;
import com.infocom.print.PFSize;
import com.infocom.print.PFUnit;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.commons.lang.StringUtils;

public class PanelPrinter {
    private String text = null;
    private int pointSize = 10;

    public PanelPrinter() {
    }

    public PanelPrinter(String string) {
        this.setText(string);
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setPointSize(int n) {
        this.pointSize = n;
    }

    public void print() {
        if (this.text == null) {
            return;
        }
        PFDocument pFDocument = new PFDocument();
        PFPageFormat pFPageFormat = new PFPageFormat();
        pFPageFormat.setPageOrientation(0);
        pFPageFormat.setRightMargin(new PFInchUnit(0.5));
        pFPageFormat.setLeftMargin(new PFInchUnit(0.5));
        pFPageFormat.setTopMargin(new PFInchUnit(0.5));
        pFPageFormat.setBottomMargin(new PFInchUnit(0.5));
        pFDocument.showPageDialog(false);
        pFDocument.showPrintDialog(true);
        PFPage pFPage = new PFPage();
        pFPage.setPageFormat(pFPageFormat);
        PFParagraph pFParagraph = new PFParagraph();
        PFSize pFSize = pFPage.getPrintableAreaSize();
        PFInchUnit pFInchUnit = new PFInchUnit(0.0);
        PFUnit pFUnit = new PFInchUnit(0.0);
        Font font = new Font("monospaced", 0, this.pointSize);
        ArrayIterator arrayIterator = new ArrayIterator(StringUtils.split(this.text, '\n'));
        while (arrayIterator.hasNext()) {
            String string = (String)arrayIterator.next();
            if (string.length() == 0) {
                string = " ";
            }
            pFPage.add(pFParagraph);
            pFParagraph.setSize(new PFSize(pFSize.getWidth(), new PFInchUnit(0.5)));
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, font);
            pFParagraph.setText(attributedString);
            PFUnit pFUnit2 = pFParagraph.getTextHeight();
            pFUnit = pFUnit.add(pFUnit2);
            if (pFUnit.add(pFUnit2).getUnits() > pFSize.getHeight().getUnits()) {
                pFDocument.addPage(pFPage);
                pFPage = new PFPage();
                pFPage.setPageFormat(pFPageFormat);
                pFSize = pFPage.getPrintableAreaSize();
                pFUnit = new PFInchUnit(0.0);
            }
            pFParagraph = new PFParagraph();
            pFParagraph.setPosition(new PFPoint(pFInchUnit, pFUnit));
        }
        pFDocument.addPage(pFPage);
        pFDocument.print();
    }
}

