/*
 * Decompiled with CFR 0.152.
 */
package com.informagen;

import com.informagen.FilterByMacOSType;
import com.informagen.Sequence;
import com.informagen.SequenceFile;
import com.informagen.swing.ExtensionFileFilter;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.filechooser.FileFilter;
import net.roydesign.mac.MRJAdapter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public class DNAStarFile
extends SequenceFile {
    private static FileFilter fileFilter;
    static final String dnaFileType = "SEQU";
    static final String proteinFileType = "SEQA";
    static final String dnaStarCreator = "ESEQ";
    static int[] seqCharSet;

    public DNAStarFile() {
    }

    public DNAStarFile(File file) {
        super(file);
    }

    public FileFilter getFileFilter() {
        if (fileFilter != null) {
            return fileFilter;
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            fileFilter = new FilterByMacOSType();
            ((FilterByMacOSType)fileFilter).addSignature(dnaStarCreator, proteinFileType);
            ((FilterByMacOSType)fileFilter).addSignature(dnaStarCreator, dnaFileType);
            ((FilterByMacOSType)fileFilter).setDescription("DNA Star");
        } else {
            fileFilter = new ExtensionFileFilter();
            ((ExtensionFileFilter)fileFilter).addExtension("seq");
            ((ExtensionFileFilter)fileFilter).addExtension("pro");
            ((ExtensionFileFilter)fileFilter).addExtension("dnastar");
            ((ExtensionFileFilter)fileFilter).setDescription("DNA Star");
        }
        return fileFilter;
    }

    public Sequence read() {
        Sequence sequence = new Sequence();
        sequence.setUID(StringUtils.substringBefore(this.file.getName(), "."));
        sequence.setTitle("DNAStar file: " + this.file.getName());
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            String string;
            this.reader = new BufferedReader(new FileReader(this.file));
            while ((string = this.reader.readLine()) != null && string.indexOf("^^") == -1) {
                if (string.length() <= 0) continue;
                sequence.setTitle(string);
            }
            block7: while ((n = this.reader.read()) != -1) {
                switch (seqCharSet[n & 0x7F]) {
                    case -1: {
                        continue block7;
                    }
                    case -4: {
                        continue block7;
                    }
                }
                stringBuffer.append((char)n);
            }
            String string2 = MRJAdapter.getFileType(this.file);
            if (string2.equals(dnaFileType)) {
                sequence.setDNA();
            } else if (string2.equals(proteinFileType)) {
                sequence.setProtein();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sequence.setSequence(stringBuffer.toString());
        return sequence;
    }

    public void write(Sequence sequence) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            String string = sequence.getSequence();
            dataOutputStream.writeBytes("Created: ");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE, MMMM d, yyyy H:m");
            dataOutputStream.writeBytes(simpleDateFormat.format(new Date()));
            dataOutputStream.writeByte(13);
            dataOutputStream.writeByte(10);
            dataOutputStream.writeByte(94);
            dataOutputStream.writeByte(94);
            dataOutputStream.writeByte(13);
            dataOutputStream.writeByte(10);
            if (string != null) {
                dataOutputStream.writeBytes(string);
            }
            dataOutputStream.flush();
            dataOutputStream.close();
            MRJAdapter.setFileCreator(this.file, dnaStarCreator);
            MRJAdapter.setFileType(this.file, sequence.isProtein() ? proteinFileType : dnaFileType);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    static {
        seqCharSet = new int[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -5, -1, -1, -1, -1, -1, -1, -1, -1, -1, 45, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -5, -1, -5, -1, -1, 65, 66, 67, 68, 69, 70, 71, 72, 73, -1, 75, 76, 77, 78, -1, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, -1, -1, -1, -1, -1, -1, 97, 98, 99, 100, 101, 102, 103, 104, 105, -1, 107, 108, 109, 110, -1, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, -1, -1, -1, -1, -1};
    }
}

