#include <QtGui> 
#include "gp2fasta.h"
#include <QRegExp>
 
// if we include <QtGui> there is no need to include every class used: <QString>, <QFileDialog>,...
 
gp2fastaapp::gp2fastaapp(QWidget *parent)
{
    setupUi(this); // this sets up GUI

//		CENTER THE WINDOW
 QDesktopWidget *desktop = QApplication::desktop();
    
int screenWidth, width; 
int screenHeight, height;
int x, y;
QSize windowSize;
 
screenWidth = desktop->width(); // get width of screen
screenHeight = desktop->height(); // get height of screen
 
windowSize = size(); // size of our application window
width = windowSize.width(); 
height = windowSize.height();
 
// little computations
x = (screenWidth - width) / 2;
y = (screenHeight - height) / 2;
y -= 50;
 
// move window to desired coordinates
move ( x, y ); 
//		CENTER THE WINDOW END

    // signals/slots section
    connect( pushButtonBrowse, SIGNAL( clicked() ), this, SLOT( getPath() ) ); 
    connect( pushButtonAbout, SIGNAL( clicked() ), this, SLOT( about() ) ); 
    connect( pushButtonConvert, SIGNAL( clicked() ), this, SLOT( convert() ) ); 
    connect( pushButtonSave, SIGNAL( clicked() ), this, SLOT( save() ) ); 
}
 
 
void gp2fastaapp::getPath()
{
    QString path;
    path = QFileDialog::getOpenFileName(this, tr("Choose a file to open"),
        QString::null,
        tr("All Files (*.*)"));
 
    lineEdit->setText( path );
textEdit->clear();
QFile file(path);
 if (file.open(QIODevice::ReadOnly)) 
	{
         QString data(file.readAll());
	 textEdit->append(data);
	}
             //currentEditor->setPlainText(data);
}

void gp2fastaapp::convert()
{
QString gp_sequences;
gp_sequences = textEdit->toPlainText();
textEdit->clear();
QList <QString> seqList;
seqList=gp_sequences.split(QRegExp("\\bLOCUS       \\b"), QString::SkipEmptyParts);


QStringList seqList2;
int size = seqList.size();
QString * Sequences = new QString[size];	

		QString comboOrganism;
		comboOrganism = comboBox->currentText();

		QString comboID;
		comboID = comboBox_2->currentText();




QString separator = lineEdit_2->text();




for (int i = 0; i<seqList.size(); i++)
{
	QString temp = seqList.at(i);
//	textEdit->append(temp);
	temp.prepend("LOCUS:");
	seqList2.append(temp);
	QString temp2 = seqList2.at(i);
//	textEdit->append(temp2);
	Sequences[i] = temp2;
//	textEdit->append(Sequences[i]);
}
//textEdit->clear();

for (int i = 0; i < size; i++)
{
	QString temp = Sequences[i];

//==========================================================

	QString id;
	if (comboID =="LOCUS")
	{
	QRegExp rx("\\bLOCUS:[A-Z_0-9]+\\b");
	int pos = rx.indexIn(temp);
	QString locus = rx.cap(0);									//id
	locus.remove(QRegExp("LOCUS:"));
	id = locus + separator;
	}

	if (comboID =="GI")
	{
	QRegExp rx2("\\bGI:[0-9]+\\b");
	int pos2 = rx2.indexIn(temp);
	QString gi = rx2.cap(0);
	gi.remove(QRegExp("GI:"));
	id = gi + separator;
	}

//==========================================================


	QRegExp rx3("\\bORGANISM  [A-Za-z]+\\s[a-z]+\\b");
	int pos3 = rx3.indexIn(temp);
	QString organism = rx3.cap(0);
	
	organism.remove(QRegExp("\\bORGANISM  "));

		QString organismName;

	if (comboOrganism == "Homo sapiens")
		organismName = organism + separator;

	if (comboOrganism == "Homsap")
	{
		QString genus = organism.left(3);	
		QRegExp rx5("[A-Za-z]+\\s");					//ORGANISM
		QString species = organism.section(rx5, -1,-1);
		species = species.left(3);
		organismName = genus + species + separator;
	}

	if (comboOrganism == "H.sapiens")
	{
		QString genus = organism.left(1);	
		QRegExp rx5("[A-Za-z]+\\s");
		QString species = organism.section(rx5, -1,-1);
		organismName = genus + "." + species + separator;
	}


//===================================================================
	QString add;

        if (checkBox_2->checkState() == Qt::Checked)
	{	
		if(temp.contains("DEFINITION  PREDICTED:"))
			add += "P";
		if(temp.contains("DEFINITION  PREDICTED: similar"))
			add += "s";
		if(temp.contains("DEFINITION  hypothetical protein"))
			add += "h";
		if(temp.contains("DEFINITION  PREDICTED: hypothetical protein"))			//additional
			add += "h";
		if(temp.contains("DEFINITION  unnamed protein product"))
			add += "u";
		if(temp.contains("DEFINITION  novel"))
			add += "n";
		if(temp.contains("DEFINITION  putative") || temp.contains("DEFINITION  probable"))
			add += "p";
		if(temp.contains("DEFINITION  open reading frame"))
			add += "o";
		add += separator;
	}
//=====================================================================
	QString def;

        if (checkBox->checkState() == Qt::Checked)
	{									//detailed definition
	QRegExp rx7("\\bDEFINITION  \\b.+ACCESSION\\b");
	int pos7 = rx7.indexIn(temp);
	QString genename = rx7.cap(0);
	genename.remove("DEFINITION  ");
	genename.remove("ACCESSION");
	genename.remove(-1,3);
	genename = genename.simplified();
	def = genename;
	}

//=====================================================================

	QRegExp rx4("\\bORIGIN\\b");
	QString sequence = temp.section(rx4, -1,-1);
										//sequence
	sequence.remove(QRegExp("ORIGIN"));
	sequence.remove(QRegExp("\\W+"));
	sequence.remove(QRegExp("\\d+"));
	sequence = sequence.toUpper();

//=====================================================================

	QString formated = ">" + organismName + id + add + def;
	if (formated.right(1) == separator)
		formated.remove(-1,1);

	textEdit->append(formated);
	textEdit->append(sequence);
}

delete [] Sequences;	
}
 
void gp2fastaapp::about() 
{
    QMessageBox::about(this,"About gp2fasta",
                "\n\ngp2fasta convertor version 0.2\n\n"
		"\nfor more info see README"
		"\n\nLukasz Kozlowski, 2007"
		"\n\nAny sugestions and comments"
                "\nplease send to: lukaskoz@o2.pl");
}

void gp2fastaapp::save() 
{
	
     QString fileName = QFileDialog::getSaveFileName(this,
                         tr("Choose a file name"), ".",
                         tr("Fasta Files (*.fas *.fasta)"));
     if (fileName.isEmpty())
         return;
     QFile file(fileName);
     if (!file.open(QFile::WriteOnly | QFile::Text)) {
         QMessageBox::warning(this, tr("Dock Widgets"),
                              tr("Cannot write file %1:\n%2.")
                              .arg(fileName)
                              .arg(file.errorString()));
         return;
     }

     QTextStream out(&file);
     QApplication::setOverrideCursor(Qt::WaitCursor);
     out << textEdit->toPlainText();
     QApplication::restoreOverrideCursor();
}
