/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.instructions.branches;

import edsim51sh.Memory;
import edsim51sh.Text;
import edsim51sh.instructions.branches.Branch;

public class Acall
extends Branch {
    private int threeMSBs;

    public Acall(int threeMSBs) {
        this.mneumonic = "ACALL";
        this.size = 2;
        this.cycles = 2;
        this.threeMSBs = threeMSBs;
    }

    public Acall() {
        this(0);
    }

    @Override
    public int execute(Memory ram, int pc) throws Exception {
        pc += 2;
        int sp = ram.readByte(129);
        if (++sp == 256) {
            sp = 0;
        }
        ram.writeByte(129, sp);
        ram.writeByte(sp, pc & 0xFF);
        if (++sp == 256) {
            sp = 0;
        }
        ram.writeByte(129, sp);
        ram.writeByte(sp, pc >> 8);
        int pageAddress = (this.threeMSBs << 8) + this.operand0;
        pc &= 0xF800;
        return pc += pageAddress;
    }

    @Override
    public String toString() {
        int address = (this.threeMSBs << 8) + this.operand0;
        return "ACALL " + Text.inHex(address, false, 3) + "H";
    }

    @Override
    public int getOpcode() {
        return (this.threeMSBs << 5) + 17;
    }
}

