/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.PeripheralMainPanel;
import edsim51di.SevenSegmentDisplay;
import java.awt.Color;

class MultiplexedDisplayGraphics
extends PeripheralMainPanel {
    private SevenSegmentDisplay[] displays = new SevenSegmentDisplay[4];

    MultiplexedDisplayGraphics() {
        this.setBackground(Color.BLACK);
        for (int i = 0; i < this.displays.length; ++i) {
            this.displays[i] = new SevenSegmentDisplay(i);
        }
        this.addDisplays();
    }

    @Override
    void setSize(boolean small) {
        this.removeAll();
        for (int i = 0; i < this.displays.length; ++i) {
            this.displays[i].setSize(small);
        }
        this.addDisplays();
    }

    void write(int data) {
        for (int i = 0; i < this.displays.length; ++i) {
            this.displays[i].write(data);
        }
    }

    void turnOn(int displayNumber) {
        this.displays[displayNumber].turnOn();
    }

    void turnOff(int displayNumber) {
        this.displays[displayNumber].turnOff();
    }

    void turnAllOff() {
        for (int i = 0; i < this.displays.length; ++i) {
            this.displays[i].turnOff();
        }
    }

    void updateGraphics() {
        for (int i = 0; i < this.displays.length; ++i) {
            this.displays[i].updateGraphics();
        }
    }

    private void addDisplays() {
        for (int i = this.displays.length - 1; i >= 0; --i) {
            this.add(this.displays[i]);
        }
    }
}

