/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Board;
import edsim51di.Gui;
import edsim51di.Key;
import edsim51di.Keypad;
import edsim51di.Mapping;
import edsim51di.PeripheralMainPanel;
import edsim51sh.EdSim51Button;
import edsim51sh.InfoButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;

class KeypadGraphics
extends PeripheralMainPanel
implements MouseListener,
ActionListener {
    private double[] rows = new double[]{0.0, 0.1, 0.2, 0.3};
    private double[] columns = new double[]{0.4, 0.5, 0.6};
    private double ANDGateOutput = 3.3;
    static final int STANDARD = 0;
    static final int PULSE = 1;
    static final int RADIO = 2;
    Key[] keys = new Key[this.rows.length * this.columns.length];
    private InfoButton infoButton = new InfoButton(this, "Right-click on a key to change its label (this also works for the switch bank).\n\nTo use interrupts with the keypad, the AND gate must be enabled.\n\nWhen bounce is enabled, keys bounce for approximately 30 ms.\nKeys only bounce while a program is running (as only then is 'time passing').\nKey bounce can only be enabled when the keypad is in standard mode.\n\n", "EdSim51DI - Keypad Information", "information");
    private Mapping[] mappings;
    private Board board;
    private String[] labels = new String[]{"#", "0", "*", "9", "8", "7", "6", "5", "4", "3", "2", "1"};
    private boolean gateEnabled = false;
    private int gatePortNumber;
    private int gatePinNumber;
    private boolean gateOutput = true;
    private String gateEnabledText = "AND Gate Enabled";
    private String gateDisabledText = "AND Gate Disabled";
    private EdSim51Button gateButton = new EdSim51Button();
    private boolean keyBounceEnabled = false;
    private String keyBounceEnabledText = "Key Bounce Enabled";
    private String keyBounceDisabledText = "Key Bounce Disabled";
    private EdSim51Button keyBounceButton = new EdSim51Button();
    private int keypadType = 0;
    private String[] listOfKeypadTypes = new String[]{"Standard", "Pulse", "Radio"};
    private JComboBox keypadTypeMenu = new JComboBox<String>(this.listOfKeypadTypes);
    private String rowDescription = "Keypad Row ";
    private String columnDescription = "Keypad Column ";
    private String gateDescription = "AND Gate Output";
    private JPanel controlPanel1;
    private JPanel controlPanel2;
    private Keypad keypadForLogicDiagram;

    KeypadGraphics(Board board) {
        this.board = board;
        double[] d = board.getPortMapSetting("keypad_rows");
        if (d != null) {
            this.rows = d;
        }
        if ((d = board.getPortMapSetting("keypad_columns")) != null) {
            this.columns = d;
        }
        if ((d = board.getPortMapSetting("ANDGateOutput")) != null) {
            this.ANDGateOutput = d[0];
        }
        this.gatePortNumber = this.getGatePortNumber();
        this.gatePinNumber = this.getGatePinNumber();
        this.initPortMappings();
        String s = board.getHardwareSetting("keypad_type");
        if (s != null) {
            if (s.equals(this.listOfKeypadTypes[1])) {
                this.keypadType = 1;
            } else if (s.equals(this.listOfKeypadTypes[2])) {
                this.keypadType = 2;
            }
        }
        if ((s = board.getHardwareSetting("keypad_bounce")) != null) {
            this.keyBounceEnabled = s.equals("ON");
        }
        if ((s = board.getHardwareSetting("Keypad_ANDGate")) != null) {
            this.gateEnabled = s.equals("ON");
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = new Key(i, this.labels[i], this.getRowNumber(true, i), this.getRowNumber(false, i), this.getColumnNumber(true, i), this.getColumnNumber(false, i), board, this);
            String label = board.getHardwareSetting("key" + i + ":label");
            if (label != null) {
                this.keys[i].setText(label);
            }
            this.keys[i].addMouseListener(this);
        }
        int count = this.keys.length - 1;
        for (int row = 0; row < 4; ++row) {
            int column = 0;
            while (column < 3) {
                gbc.gridx = column++;
                gbc.gridy = row;
                this.add((Component)this.keys[count], gbc);
                --count;
            }
        }
        this.controlPanel1 = new JPanel();
        this.controlPanel1.setLayout(new GridBagLayout());
        Insets insets = new Insets(1, 1, 1, 1);
        if (this.gateEnabled) {
            this.gateButton.setText(this.gateEnabledText);
        } else {
            this.gateButton.setText(this.gateDisabledText);
        }
        gbc = new GridBagConstraints();
        this.gateButton.addActionListener(this);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        this.controlPanel1.add((Component)this.gateButton, gbc);
        if (this.keyBounceEnabled) {
            this.keyBounceButton.setText(this.keyBounceEnabledText);
        } else {
            this.keyBounceButton.setText(this.keyBounceDisabledText);
        }
        this.keyBounceButton.addActionListener(this);
        gbc.gridy = 1;
        this.controlPanel1.add((Component)this.keyBounceButton, gbc);
        this.controlPanel2 = new JPanel();
        this.keypadTypeMenu.setSelectedIndex(this.keypadType);
        this.keypadTypeMenu.addActionListener(this);
        this.controlPanel2.add(this.keypadTypeMenu);
        this.controlPanel2.add(this.infoButton);
        gbc.gridy = 2;
        this.controlPanel1.add((Component)this.controlPanel2, gbc);
        gbc.gridx = this.columns.length;
        gbc.gridy = 0;
        gbc.gridheight = this.rows.length;
        this.add((Component)this.controlPanel1, gbc);
        this.keypadForLogicDiagram = new Keypad(this.mappings, this.rows.length, this.getGateMapping());
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.controlPanel1 != null && this.controlPanel2 != null) {
            this.controlPanel1.setBackground(c);
            this.controlPanel2.setBackground(c);
        }
    }

    Keypad getKeypadForLogicDiagram() {
        return this.keypadForLogicDiagram;
    }

    String[] getRowDescriptions() {
        String[] ss = new String[this.rows.length];
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = this.rowDescription + i;
        }
        return ss;
    }

    String[] getColumnDescriptions() {
        String[] ss = new String[this.columns.length];
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = this.columnDescription + i;
        }
        return ss;
    }

    String getANDGateDescription() {
        return this.gateDescription;
    }

    void reset() {
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i].stopKeyBounce();
            this.keys[i].openKey(true);
        }
        this.updatePortPins();
    }

    @Override
    void setSize(boolean small) {
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i].setSmall(small);
        }
        this.setKeyDimensions();
        int fontSize = small ? 12 : 18;
        this.gateButton.setSize(this.gateEnabledText, this.gateDisabledText, 1, fontSize);
        this.keyBounceButton.setSize(this.keyBounceEnabledText, this.keyBounceDisabledText, 1, fontSize);
        this.infoButton.setSize(small);
        Gui.setFont(this.keypadTypeMenu, 1, fontSize);
    }

    void setKeyDimensions() {
        int i;
        int longestText = 0;
        for (i = 0; i < this.keys.length; ++i) {
            int temp = this.keys[i].getText().length();
            if (temp <= longestText) continue;
            longestText = temp;
        }
        for (i = 0; i < this.keys.length; ++i) {
            this.keys[i].setDimension(longestText);
        }
    }

    Mapping[] getPortMappings() {
        return this.mappings;
    }

    Mapping getGateMapping() {
        return new Mapping(this.gatePortNumber, this.gatePinNumber, this.gateDescription);
    }

    void update() {
        this.bounceKeys();
        this.updatePortPins();
    }

    void refreshGraphics() {
        if (this.keyBounceEnabled) {
            for (int i = 0; i < this.keys.length; ++i) {
                this.keys[i].synchroniseKeyGraphics();
            }
        }
    }

    int getKeypadType() {
        return this.keypadType;
    }

    boolean isKeyBounceEnabled() {
        return this.keyBounceEnabled;
    }

    void updateBitByExternalHardware(boolean state, int portNumber, int pinNumber) {
        for (int keyNumber = 0; keyNumber < this.keys.length; ++keyNumber) {
            int rowPort = this.keys[keyNumber].getRowPort();
            int rowPin = this.keys[keyNumber].getRowPin();
            int columnPort = this.keys[keyNumber].getColumnPort();
            int columnPin = this.keys[keyNumber].getColumnPin();
            if (this.keys[keyNumber].isKeyClosed()) {
                if (rowPort == portNumber && rowPin == pinNumber) {
                    if (state) {
                        this.board.setPortPin(columnPort, columnPin, 100 + keyNumber);
                    } else {
                        this.board.clearPortPin(columnPort, columnPin, 100 + keyNumber);
                        this.gateOutput = false;
                        this.updateGatePortPin();
                    }
                }
                if (columnPort != portNumber || columnPin != pinNumber) continue;
                if (state) {
                    this.board.setPortPin(rowPort, rowPin, 100 + keyNumber);
                    continue;
                }
                this.board.clearPortPin(rowPort, rowPin, 100 + keyNumber);
                this.gateOutput = false;
                this.updateGatePortPin();
                continue;
            }
            if (rowPort == portNumber && rowPin == pinNumber) {
                this.board.setPortPin(columnPort, columnPin, 100 + keyNumber);
            }
            if (columnPort != portNumber || columnPin != pinNumber) continue;
            this.board.setPortPin(rowPort, rowPin, 100 + keyNumber);
            this.gateOutput = state;
            this.updateGatePortPin();
        }
    }

    void updatePortPins() {
        this.gateOutput = true;
        for (int keyNumber = 0; keyNumber < this.keys.length; ++keyNumber) {
            int rowPort = this.keys[keyNumber].getRowPort();
            int rowPin = this.keys[keyNumber].getRowPin();
            int columnPort = this.keys[keyNumber].getColumnPort();
            int columnPin = this.keys[keyNumber].getColumnPin();
            if (this.keys[keyNumber].isKeyClosed()) {
                if (this.board.readPortLatch(rowPort, rowPin) == 0) {
                    this.board.clearPortPin(columnPort, columnPin, 100 + keyNumber);
                    this.gateOutput = false;
                } else if (this.board.readPortLatch(columnPort, columnPin) == 0) {
                    this.board.clearPortPin(rowPort, rowPin, 100 + keyNumber);
                    this.gateOutput = false;
                } else {
                    this.board.setPortPin(rowPort, rowPin, 100 + keyNumber);
                    this.board.setPortPin(columnPort, columnPin, 100 + keyNumber);
                }
            } else {
                this.board.setPortPin(rowPort, rowPin, 100 + keyNumber);
                this.board.setPortPin(columnPort, columnPin, 100 + keyNumber);
            }
            if (this.keys[keyNumber].isKeyClosed()) {
                if (this.board.readPortPin(rowPort, rowPin) == 0) {
                    this.board.clearPortPin(columnPort, columnPin, 100 + keyNumber);
                    this.gateOutput = false;
                    continue;
                }
                if (this.board.readPortPin(columnPort, columnPin) == 0) {
                    this.board.clearPortPin(rowPort, rowPin, 100 + keyNumber);
                    this.gateOutput = false;
                    continue;
                }
                this.board.setPortPin(rowPort, rowPin, 100 + keyNumber);
                this.board.setPortPin(columnPort, columnPin, 100 + keyNumber);
                continue;
            }
            this.board.setPortPin(rowPort, rowPin, 100 + keyNumber);
            this.board.setPortPin(columnPort, columnPin, 100 + keyNumber);
        }
        this.updateGatePortPin();
    }

    private void bounceKeys() {
        if (this.keyBounceEnabled) {
            for (int i = 0; i < this.keys.length; ++i) {
                this.keys[i].bounceKey(this.board.getInstructionElapsedTimeInNanos());
            }
        }
    }

    private void updateGatePortPin() {
        if (this.gateEnabled && !this.gateOutput) {
            this.board.clearPortPin(this.gatePortNumber, this.gatePinNumber, 130);
        } else {
            this.board.setPortPin(this.gatePortNumber, this.gatePinNumber, 130);
        }
    }

    private void initPortMappings() {
        int i;
        this.mappings = new Mapping[this.rows.length + this.columns.length];
        for (i = 0; i < this.rows.length; ++i) {
            this.mappings[i] = new Mapping(this.getPortNumber(true, i), this.getPinNumber(true, i), this.rowDescription + i);
        }
        for (i = 0; i < this.columns.length; ++i) {
            this.mappings[this.rows.length + i] = new Mapping(this.getPortNumber(false, i), this.getPinNumber(false, i), this.columnDescription + i);
        }
    }

    private int getRowNumber(boolean port, int keyNumber) {
        int row = keyNumber / this.columns.length;
        if (port) {
            return this.getPortNumber(true, row);
        }
        return this.getPinNumber(true, row);
    }

    private int getColumnNumber(boolean port, int keyNumber) {
        int column = keyNumber % this.columns.length;
        if (port) {
            return this.getPortNumber(false, column);
        }
        return this.getPinNumber(false, column);
    }

    private int getPortNumber(boolean row, int number) {
        double[] temp = row ? this.rows : this.columns;
        return (int)temp[number];
    }

    private int getPinNumber(boolean row, int number) {
        double[] temp = row ? this.rows : this.columns;
        return (int)(temp[number] * 10.0 - (double)(this.getPortNumber(row, number) * 10));
    }

    private int getGatePortNumber() {
        return (int)this.ANDGateOutput;
    }

    private int getGatePinNumber() {
        return (int)(this.ANDGateOutput * 10.0 - (double)(this.getGatePortNumber() * 10));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.keypadTypeMenu) {
            this.keypadType = this.keypadTypeMenu.getSelectedIndex();
            this.board.setHardwareSetting("keypad_type", this.listOfKeypadTypes[this.keypadType]);
        } else if (event.getSource() == this.gateButton) {
            this.gateEnabled = !this.gateEnabled;
            this.updateGatePortPin();
            if (this.gateEnabled) {
                this.gateButton.setText(this.gateEnabledText);
                this.board.setHardwareSetting("Keypad_ANDGate", "ON");
            } else {
                this.gateButton.setText(this.gateDisabledText);
                this.board.setHardwareSetting("Keypad_ANDGate", "OFF");
            }
        } else if (event.getSource() == this.keyBounceButton) {
            boolean bl = this.keyBounceEnabled = !this.keyBounceEnabled;
            if (this.keyBounceEnabled) {
                this.keyBounceButton.setText(this.keyBounceEnabledText);
                this.board.setHardwareSetting("Keypad_bounce", "ON");
            } else {
                this.keyBounceButton.setText(this.keyBounceDisabledText);
                this.board.setHardwareSetting("Keypad_bounce", "OFF");
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        try {
            Key key = (Key)event.getSource();
            key.mousePressed(event);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        try {
            Key key = (Key)event.getSource();
            key.mouseReleased();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }
}

