/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import org.forester.surfacing.PairwiseDomainSimilarity;

public class CombinationsBasedPairwiseDomainSimilarity
implements PairwiseDomainSimilarity {
    private final int _difference_in_counts;
    private final int _different_domains;
    private final int _same_domains;
    private final double _score;

    public CombinationsBasedPairwiseDomainSimilarity(int n, int n2, int n3) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("attempt to use domain counts less than 0");
        }
        this._difference_in_counts = n3;
        this._same_domains = n;
        this._different_domains = n2;
        this._score = this._different_domains == 0 ? 1.0 : (double)this._same_domains / (double)(this._different_domains + this._same_domains);
    }

    @Override
    public int getDifferenceInCounts() {
        return this._difference_in_counts;
    }

    public int getNumberOfDifferentDomains() {
        return this._different_domains;
    }

    public int getNumberOfSameDomains() {
        return this._same_domains;
    }

    @Override
    public double getSimilarityScore() {
        return this._score;
    }
}

