/*
 * Decompiled with CFR 0.152.
 */
package org.forester.rio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.forester.datastructures.IntMatrix;
import org.forester.io.parsers.IteratingPhylogenyParser;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.rio.RIOException;
import org.forester.sdi.GSDI;
import org.forester.sdi.GSDIR;
import org.forester.sdi.SDIException;
import org.forester.sdi.SDIR;
import org.forester.sdi.SDIutil;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.ForesterUtil;

public final class RIO {
    public static final int DEFAULT_RANGE = -1;
    private static final int END_OF_GT = Integer.MAX_VALUE;
    private static IntMatrix _m;
    private Phylogeny[] _analyzed_gene_trees;
    private List<PhylogenyNode> _removed_gene_tree_nodes;
    private int _ext_nodes;
    private int _int_nodes;
    private SDIutil.TaxonomyComparisonBase _gsdir_tax_comp_base;
    private final StringBuilder _log;
    private final BasicDescriptiveStatistics _duplications_stats;
    private final boolean _produce_log;
    private final boolean _verbose;
    private final REROOTING _rerooting;
    private final Phylogeny _species_tree;
    private Phylogeny _min_dub_gene_tree;
    private Map<Integer, Phylogeny> _dup_to_tree_map;

    private RIO(IteratingPhylogenyParser iteratingPhylogenyParser, Phylogeny phylogeny, SDIutil.ALGORITHM aLGORITHM, REROOTING rEROOTING, String string, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws IOException, SDIException, RIOException {
        if (n2 == -1 && n >= 0) {
            n2 = Integer.MAX_VALUE;
        } else if (n == -1 && n2 >= 0) {
            n = 0;
        }
        RIO.removeSingleDescendentsNodes(phylogeny, bl2);
        iteratingPhylogenyParser.reset();
        RIO.checkPreconditions(iteratingPhylogenyParser, phylogeny, rEROOTING, string, n, n2);
        this._produce_log = bl;
        this._verbose = bl2;
        this._rerooting = rEROOTING;
        this._ext_nodes = -1;
        this._int_nodes = -1;
        this._log = new StringBuilder();
        this._gsdir_tax_comp_base = null;
        this._analyzed_gene_trees = null;
        this._removed_gene_tree_nodes = null;
        this._duplications_stats = new BasicDescriptiveStatistics();
        iteratingPhylogenyParser.reset();
        this.inferOrthologs(iteratingPhylogenyParser, phylogeny, aLGORITHM, string, n, n2, bl3);
        this._species_tree = phylogeny;
    }

    private RIO(Phylogeny[] phylogenyArray, Phylogeny phylogeny, SDIutil.ALGORITHM aLGORITHM, REROOTING rEROOTING, String string, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws IOException, SDIException, RIOException {
        if (n2 == -1 && n >= 0) {
            n2 = phylogenyArray.length - 1;
        } else if (n == -1 && n2 >= 0) {
            n = 0;
        }
        RIO.removeSingleDescendentsNodes(phylogeny, bl2);
        RIO.checkPreconditions(phylogenyArray, phylogeny, rEROOTING, string, n, n2);
        this._produce_log = bl;
        this._verbose = bl2;
        this._rerooting = rEROOTING;
        this._ext_nodes = -1;
        this._int_nodes = -1;
        this._log = new StringBuilder();
        this._gsdir_tax_comp_base = null;
        this._analyzed_gene_trees = null;
        this._removed_gene_tree_nodes = null;
        this._duplications_stats = new BasicDescriptiveStatistics();
        this.inferOrthologs(phylogenyArray, phylogeny, aLGORITHM, string, n, n2, bl3);
        this._species_tree = phylogeny;
    }

    public final Phylogeny[] getAnalyzedGeneTrees() {
        return this._analyzed_gene_trees;
    }

    public final BasicDescriptiveStatistics getDuplicationsStatistics() {
        return this._duplications_stats;
    }

    public final int getExtNodesOfAnalyzedGeneTrees() {
        return this._ext_nodes;
    }

    public final SDIutil.TaxonomyComparisonBase getGSDIRtaxCompBase() {
        return this._gsdir_tax_comp_base;
    }

    public final int getIntNodesOfAnalyzedGeneTrees() {
        return this._int_nodes;
    }

    public final StringBuilder getLog() {
        return this._log;
    }

    public final Phylogeny getMinDuplicationsGeneTree() {
        return this._min_dub_gene_tree;
    }

    public final IntMatrix getOrthologTable() {
        return _m;
    }

    public final List<PhylogenyNode> getRemovedGeneTreeNodes() {
        return this._removed_gene_tree_nodes;
    }

    public final Phylogeny getSpeciesTree() {
        return this._species_tree;
    }

    private final void inferOrthologs(IteratingPhylogenyParser iteratingPhylogenyParser, Phylogeny phylogeny, SDIutil.ALGORITHM aLGORITHM, String string, int n, int n2, boolean bl) throws SDIException, RIOException, FileNotFoundException, IOException {
        boolean bl2;
        if (!iteratingPhylogenyParser.hasNext()) {
            throw new RIOException("no gene trees to analyze");
        }
        if (this.log()) {
            this.preLog(-1, phylogeny, aLGORITHM, string);
        }
        if (this._verbose) {
            System.out.println();
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl3 = bl2 = n < 0 || n2 < n;
        while (iteratingPhylogenyParser.hasNext()) {
            Phylogeny phylogeny2 = iteratingPhylogenyParser.next();
            if (bl2 || n4 >= n && n4 <= n2) {
                if (phylogeny2.isEmpty()) {
                    throw new RIOException("gene tree #" + n4 + " is empty");
                }
                if (phylogeny2.getNumberOfExternalNodes() == 1) {
                    throw new RIOException("gene tree #" + n4 + " has only one external node");
                }
                if (this._verbose) {
                    System.out.print("\r" + n4);
                }
                if (n5 == 0) {
                    if (aLGORITHM == SDIutil.ALGORITHM.SDIR) {
                        PhylogenyMethods.taxonomyBasedDeletionOfExternalNodes(phylogeny2, phylogeny);
                        if (phylogeny.isEmpty()) {
                            throw new RIOException("failed to establish species based mapping between gene and species trees");
                        }
                    }
                    n3 = phylogeny2.getNumberOfExternalNodes();
                } else if (n3 != phylogeny2.getNumberOfExternalNodes()) {
                    throw new RIOException("gene tree #" + n4 + " has a different number of external nodes (" + phylogeny2.getNumberOfExternalNodes() + ") than the preceding gene tree(s) (" + n3 + ")");
                }
                if (aLGORITHM == SDIutil.ALGORITHM.SDIR) {
                    PhylogenyMethods.taxonomyBasedDeletionOfExternalNodes(phylogeny, phylogeny2);
                    if (phylogeny2.isEmpty()) {
                        throw new RIOException("failed to establish species based mapping between gene and species trees");
                    }
                }
                Phylogeny phylogeny3 = this.performOrthologInference(phylogeny2, phylogeny, aLGORITHM, string, n5, bl);
                RIO.calculateOrthologTable(phylogeny3, true, n5);
                ++n5;
            }
            ++n4;
        }
        if (this._verbose) {
            System.out.print("\rGene trees analyzed                 :\t" + n5);
        }
        if (n >= 0 && n5 == 0 && n4 > 0) {
            throw new RIOException("attempt to analyze first gene tree #" + n + " in a set of " + n4);
        }
        if (bl2) {
            n = 0;
        }
        if (this.log()) {
            this.postLog(phylogeny, n, n + n5 - 1);
        }
        if (this._verbose) {
            System.out.println();
            System.out.println();
        }
    }

    private final void inferOrthologs(Phylogeny[] phylogenyArray, Phylogeny phylogeny, SDIutil.ALGORITHM aLGORITHM, String string, int n, int n2, boolean bl) throws SDIException, RIOException, FileNotFoundException, IOException {
        int n3;
        int n4;
        Phylogeny[] phylogenyArray2;
        if (aLGORITHM == SDIutil.ALGORITHM.SDIR) {
            PhylogenyMethods.taxonomyBasedDeletionOfExternalNodes(phylogenyArray[0], phylogeny);
            if (phylogeny.isEmpty()) {
                throw new RIOException("failed to establish species based mapping between gene and species trees");
            }
        }
        if (n >= 0 && n2 >= n && n2 < phylogenyArray.length) {
            phylogenyArray2 = new Phylogeny[1 + n2 - n];
            n4 = 0;
            for (n3 = n; n3 <= n2; ++n3) {
                phylogenyArray2[n4++] = phylogenyArray[n3];
            }
        } else {
            phylogenyArray2 = phylogenyArray;
        }
        if (this.log()) {
            this.preLog(phylogenyArray.length, phylogeny, aLGORITHM, string);
        }
        if (this._verbose && phylogenyArray2.length >= 4) {
            System.out.println();
        }
        this._analyzed_gene_trees = new Phylogeny[phylogenyArray2.length];
        n4 = 0;
        for (n3 = 0; n3 < phylogenyArray2.length; ++n3) {
            Phylogeny phylogeny2 = phylogenyArray2[n3];
            if (phylogeny2.isEmpty()) {
                throw new RIOException("gene tree #" + n3 + " is empty");
            }
            if (phylogeny2.getNumberOfExternalNodes() == 1) {
                throw new RIOException("gene tree #" + n3 + " has only one external node");
            }
            if (this._verbose && phylogenyArray2.length > 4) {
                ForesterUtil.updateProgress((double)n3 / (double)phylogenyArray2.length);
            }
            if (n3 == 0) {
                n4 = phylogeny2.getNumberOfExternalNodes();
            } else if (n4 != phylogeny2.getNumberOfExternalNodes()) {
                throw new RIOException("gene tree #" + n3 + " has a different number of external nodes (" + phylogeny2.getNumberOfExternalNodes() + ") than the preceding gene tree(s) (" + n4 + ")");
            }
            if (aLGORITHM == SDIutil.ALGORITHM.SDIR) {
                PhylogenyMethods.taxonomyBasedDeletionOfExternalNodes(phylogeny, phylogeny2);
                if (phylogeny2.isEmpty()) {
                    throw new RIOException("failed to establish species based mapping between gene and species trees");
                }
            }
            this._analyzed_gene_trees[n3] = this.performOrthologInference(phylogeny2, phylogeny, aLGORITHM, string, n3, bl);
        }
        if (this.log()) {
            this.postLog(phylogeny, n, n2);
        }
        if (this._verbose && phylogenyArray2.length > 4) {
            System.out.println();
            System.out.println();
        }
    }

    private final boolean log() {
        return this._produce_log;
    }

    private final void log(String string) {
        this._log.append(string);
        this._log.append(ForesterUtil.LINE_SEPARATOR);
    }

    private final void logRemovedGeneTreeNodes() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (PhylogenyNode object : this.getRemovedGeneTreeNodes()) {
            Taxonomy taxonomy = object.getNodeData().getTaxonomy();
            switch (this.getGSDIRtaxCompBase()) {
                case CODE: {
                    treeSet.add(taxonomy.getTaxonomyCode());
                    break;
                }
                case ID: {
                    treeSet.add(taxonomy.getIdentifier().toString());
                    break;
                }
                case SCIENTIFIC_NAME: {
                    treeSet.add(taxonomy.getScientificName());
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : treeSet) {
            stringBuilder.append('\t');
            stringBuilder.append(string);
        }
        this.log("Species stripped from gene trees    :" + stringBuilder);
    }

    private final Phylogeny performOrthologInference(Phylogeny phylogeny, Phylogeny phylogeny2, SDIutil.ALGORITHM aLGORITHM, String string, int n, boolean bl) throws SDIException, RIOException {
        Phylogeny phylogeny3;
        switch (aLGORITHM) {
            case SDIR: {
                phylogeny3 = this.performOrthologInferenceBySDI(phylogeny, phylogeny2);
                break;
            }
            case GSDIR: {
                phylogeny3 = this.performOrthologInferenceByGSDI(phylogeny, phylogeny2, string, n, bl);
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal algorithm: " + (Object)((Object)aLGORITHM));
            }
        }
        if (n == 0) {
            this._ext_nodes = phylogeny3.getNumberOfExternalNodes();
            this._int_nodes = phylogeny3.getNumberOfInternalNodes();
        } else if (this._ext_nodes != phylogeny3.getNumberOfExternalNodes()) {
            throw new RIOException("after stripping gene tree #" + n + " has a different number of external nodes (" + phylogeny3.getNumberOfExternalNodes() + ") than the preceding gene tree(s) (" + this._ext_nodes + ")");
        }
        return phylogeny3;
    }

    private final Phylogeny performOrthologInferenceByGSDI(Phylogeny phylogeny, Phylogeny phylogeny2, String string, int n, boolean bl) throws SDIException, RIOException {
        int n2;
        Phylogeny phylogeny3;
        Object object;
        if (this._rerooting == REROOTING.BY_ALGORITHM) {
            object = new GSDIR(phylogeny, phylogeny2, true, n == 0, bl);
            phylogeny3 = ((GSDIR)object).getMinDuplicationsSumGeneTree();
            if (n == 0) {
                this._removed_gene_tree_nodes = ((GSDIR)object).getStrippedExternalGeneTreeNodes();
                for (PhylogenyNode phylogenyNode : this._removed_gene_tree_nodes) {
                    if (phylogenyNode.getNodeData().isHasTaxonomy()) continue;
                    throw new RIOException("node with no (appropriate) taxonomic information found in gene tree #" + n + ": " + phylogenyNode.toString());
                }
            }
            if (n == 0) {
                this._gsdir_tax_comp_base = ((GSDIR)object).getTaxCompBase();
            }
            n2 = ((GSDIR)object).getMinDuplicationsSum();
        } else {
            if (this._rerooting == REROOTING.MIDPOINT) {
                PhylogenyMethods.midpointRoot(phylogeny);
            } else if (this._rerooting == REROOTING.OUTGROUP) {
                object = phylogeny.getNode(string);
                phylogeny.reRoot((PhylogenyNode)object);
            }
            object = new GSDI(phylogeny, phylogeny2, true, true, true, bl);
            this._removed_gene_tree_nodes = ((GSDI)object).getStrippedExternalGeneTreeNodes();
            for (PhylogenyNode phylogenyNode : this._removed_gene_tree_nodes) {
                if (phylogenyNode.getNodeData().isHasTaxonomy()) continue;
                throw new RIOException("node with no (appropriate) taxonomic information found in gene tree #" + n + ": " + phylogenyNode.toString());
            }
            phylogeny3 = phylogeny;
            if (n == 0) {
                this._gsdir_tax_comp_base = ((GSDI)object).getTaxCompBase();
            }
            n2 = ((GSDI)object).getDuplicationsSum();
        }
        phylogeny3.setRerootable(false);
        double d = -1.0;
        if (n == 0 || (double)n2 < this._duplications_stats.getMin()) {
            this._min_dub_gene_tree = phylogeny3;
        } else if ((double)n2 == this._duplications_stats.getMin() && (d = PhylogenyMethods.calculateMaxDistanceToRoot(phylogeny3)) < PhylogenyMethods.calculateMaxDistanceToRoot(this._min_dub_gene_tree)) {
            this._min_dub_gene_tree = phylogeny3;
        }
        if (this._dup_to_tree_map == null) {
            this._dup_to_tree_map = new HashMap<Integer, Phylogeny>();
        }
        if (!this._dup_to_tree_map.containsKey(n2)) {
            this._dup_to_tree_map.put(n2, phylogeny3);
        } else {
            if (d == -1.0) {
                d = PhylogenyMethods.calculateMaxDistanceToRoot(phylogeny3);
            }
            if (d < PhylogenyMethods.calculateMaxDistanceToRoot(this._dup_to_tree_map.get(n2))) {
                this._dup_to_tree_map.put(n2, phylogeny3);
            }
        }
        this._duplications_stats.addValue(n2);
        return phylogeny3;
    }

    public final Map<Integer, Phylogeny> getDuplicationsToTreeMap() {
        return this._dup_to_tree_map;
    }

    private final Phylogeny performOrthologInferenceBySDI(Phylogeny phylogeny, Phylogeny phylogeny2) throws SDIException {
        SDIR sDIR = new SDIR();
        Phylogeny phylogeny3 = sDIR.infer(phylogeny, phylogeny2, false, true, true, true, 1)[0];
        phylogeny3.setRerootable(false);
        int n = sDIR.getMinimalDuplications();
        this._duplications_stats.addValue(n);
        return phylogeny3;
    }

    private final void postLog(Phylogeny phylogeny, int n, int n2) {
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        int n3 = (int)this.getDuplicationsStatistics().getMin();
        int n4 = (int)this.getDuplicationsStatistics().getMax();
        int n5 = (int)this.getDuplicationsStatistics().median();
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (double d : this.getDuplicationsStatistics().getData()) {
            if ((int)d == n3) {
                ++n6;
            }
            if ((int)d == n4) {
                ++n7;
            }
            if ((int)d != n5) continue;
            ++n8;
        }
        double d = 100.0 * (double)n6 / (double)this.getDuplicationsStatistics().getN();
        double d2 = 100.0 * (double)n7 / (double)this.getDuplicationsStatistics().getN();
        double d3 = 100.0 * (double)n8 / (double)this.getDuplicationsStatistics().getN();
        if (this.getRemovedGeneTreeNodes() != null && this.getRemovedGeneTreeNodes().size() > 0) {
            this.logRemovedGeneTreeNodes();
        }
        this.log("Gene trees analyzed                 :\t" + this.getDuplicationsStatistics().getN());
        if (n >= 0 && n2 >= 0) {
            this.log("Gene trees analyzed range           :\t" + n + "-" + n2);
        }
        this.log("Gene tree internal nodes            :\t" + this.getIntNodesOfAnalyzedGeneTrees());
        this.log("Gene tree external nodes            :\t" + this.getExtNodesOfAnalyzedGeneTrees());
        this.log("Removed ext gene tree nodes         :\t" + this.getRemovedGeneTreeNodes().size());
        this.log("Spec tree ext nodes (after strip)   :\t" + phylogeny.getNumberOfExternalNodes());
        this.log("Spec tree polytomies (after strip)  :\t" + PhylogenyMethods.countNumberOfPolytomies(phylogeny));
        this.log("Taxonomy linking based on           :\t" + (Object)((Object)this.getGSDIRtaxCompBase()));
        this.log("Mean number of duplications         :\t" + decimalFormat.format(this.getDuplicationsStatistics().arithmeticMean()) + "\t" + decimalFormat.format(100.0 * this.getDuplicationsStatistics().arithmeticMean() / (double)this.getIntNodesOfAnalyzedGeneTrees()) + "%\t(sd: " + decimalFormat.format(this.getDuplicationsStatistics().sampleStandardDeviation()) + ")");
        if (this.getDuplicationsStatistics().getN() > 3) {
            this.log("Median number of duplications       :\t" + decimalFormat.format(n5) + "\t" + decimalFormat.format(100.0 * (double)n5 / (double)this.getIntNodesOfAnalyzedGeneTrees()) + "%");
        }
        this.log("Minimum duplications                :\t" + n3 + "\t" + decimalFormat.format(100.0 * (double)n3 / (double)this.getIntNodesOfAnalyzedGeneTrees()) + "%");
        this.log("Maximum duplications                :\t" + n4 + "\t" + decimalFormat.format(100.0 * (double)n4 / (double)this.getIntNodesOfAnalyzedGeneTrees()) + "%");
        this.log("Gene trees with median duplications :\t" + n8 + "\t" + decimalFormat.format(d3) + "%");
        this.log("Gene trees with minimum duplications:\t" + n6 + "\t" + decimalFormat.format(d) + "%");
        this.log("Gene trees with maximum duplications:\t" + n7 + "\t" + decimalFormat.format(d2) + "%");
    }

    private final void preLog(int n, Phylogeny phylogeny, SDIutil.ALGORITHM aLGORITHM, String string) {
        if (n > 0) {
            this.log("Number of gene trees (total)        :\t" + n);
        }
        this.log("Algorithm                           :\t" + (Object)((Object)aLGORITHM));
        this.log("Spec tree ext nodes (prior strip)   :\t" + phylogeny.getNumberOfExternalNodes());
        this.log("Spec tree polytomies (prior strip)  :\t" + PhylogenyMethods.countNumberOfPolytomies(phylogeny));
        String string2 = "";
        switch (this._rerooting) {
            case BY_ALGORITHM: {
                string2 = "minimizing duplications";
                break;
            }
            case MIDPOINT: {
                string2 = "midpoint";
                break;
            }
            case OUTGROUP: {
                string2 = "outgroup: " + string;
                break;
            }
            case NONE: {
                string2 = "none";
            }
        }
        this.log("Re-rooting                          :\t" + string2);
    }

    public static final IntMatrix calculateOrthologTable(Phylogeny[] phylogenyArray, boolean bl) throws RIOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (PhylogenyNode phylogenyNode : phylogenyArray[0].getExternalNodes()) {
            Phylogeny[] phylogenyArray2 = RIO.obtainLabel(hashSet, phylogenyNode);
            hashSet.add((String)phylogenyArray2);
            arrayList.add((String)phylogenyArray2);
        }
        if (bl) {
            Collections.sort(arrayList);
        }
        IntMatrix intMatrix = new IntMatrix(arrayList);
        int n = 0;
        for (Phylogeny phylogeny : phylogenyArray) {
            RIO.updateCounts(intMatrix, ++n, phylogeny);
        }
        return intMatrix;
    }

    public static final RIO executeAnalysis(File file, File file2, SDIutil.ALGORITHM aLGORITHM, REROOTING rEROOTING, String string, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws IOException, SDIException, RIOException {
        Phylogeny[] phylogenyArray = RIO.parseGeneTrees(file);
        if (phylogenyArray.length < 1) {
            throw new RIOException("\"" + file + "\" is devoid of appropriate gene trees");
        }
        Phylogeny phylogeny = SDIutil.parseSpeciesTree(phylogenyArray[0], file2, false, true, NHXParser.TAXONOMY_EXTRACTION.NO);
        return new RIO(phylogenyArray, phylogeny, aLGORITHM, rEROOTING, string, n, n2, bl, bl2, bl3);
    }

    public static final RIO executeAnalysis(File file, Phylogeny phylogeny, SDIutil.ALGORITHM aLGORITHM, REROOTING rEROOTING, String string, boolean bl, boolean bl2, boolean bl3) throws IOException, SDIException, RIOException {
        return new RIO(RIO.parseGeneTrees(file), phylogeny, aLGORITHM, rEROOTING, string, -1, -1, bl, bl2, bl3);
    }

    public static final RIO executeAnalysis(File file, Phylogeny phylogeny, SDIutil.ALGORITHM aLGORITHM, REROOTING rEROOTING, String string, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws IOException, SDIException, RIOException {
        return new RIO(RIO.parseGeneTrees(file), phylogeny, aLGORITHM, rEROOTING, string, n, n2, bl, bl2, bl3);
    }

    public static final RIO executeAnalysis(IteratingPhylogenyParser iteratingPhylogenyParser, File file, SDIutil.ALGORITHM aLGORITHM, REROOTING rEROOTING, String string, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws IOException, SDIException, RIOException {
        Phylogeny phylogeny = iteratingPhylogenyParser.next();
        if (phylogeny == null || phylogeny.isEmpty() || phylogeny.getNumberOfExternalNodes() < 2) {
            throw new RIOException("input file does not seem to contain any gene trees");
        }
        Phylogeny phylogeny2 = SDIutil.parseSpeciesTree(phylogeny, file, false, true, NHXParser.TAXONOMY_EXTRACTION.NO);
        iteratingPhylogenyParser.reset();
        return new RIO(iteratingPhylogenyParser, phylogeny2, aLGORITHM, rEROOTING, string, n, n2, bl, bl2, bl3);
    }

    public static final RIO executeAnalysis(IteratingPhylogenyParser iteratingPhylogenyParser, Phylogeny phylogeny, SDIutil.ALGORITHM aLGORITHM, REROOTING rEROOTING, String string, boolean bl, boolean bl2, boolean bl3) throws IOException, SDIException, RIOException {
        return new RIO(iteratingPhylogenyParser, phylogeny, aLGORITHM, rEROOTING, string, -1, -1, bl, bl2, bl3);
    }

    public static final RIO executeAnalysis(IteratingPhylogenyParser iteratingPhylogenyParser, Phylogeny phylogeny, SDIutil.ALGORITHM aLGORITHM, REROOTING rEROOTING, String string, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws IOException, SDIException, RIOException {
        return new RIO(iteratingPhylogenyParser, phylogeny, aLGORITHM, rEROOTING, string, n, n2, bl, bl2, bl3);
    }

    public static final RIO executeAnalysis(Phylogeny[] phylogenyArray, Phylogeny phylogeny) throws IOException, SDIException, RIOException {
        return new RIO(phylogenyArray, phylogeny, SDIutil.ALGORITHM.GSDIR, REROOTING.BY_ALGORITHM, null, -1, -1, false, false, false);
    }

    public static final RIO executeAnalysis(Phylogeny[] phylogenyArray, Phylogeny phylogeny, SDIutil.ALGORITHM aLGORITHM, REROOTING rEROOTING, String string, boolean bl, boolean bl2, boolean bl3) throws IOException, SDIException, RIOException {
        return new RIO(phylogenyArray, phylogeny, aLGORITHM, rEROOTING, string, -1, -1, bl, bl2, bl3);
    }

    public static final RIO executeAnalysis(Phylogeny[] phylogenyArray, Phylogeny phylogeny, SDIutil.ALGORITHM aLGORITHM, REROOTING rEROOTING, String string, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws IOException, SDIException, RIOException {
        return new RIO(phylogenyArray, phylogeny, aLGORITHM, rEROOTING, string, n, n2, bl, bl2, bl3);
    }

    private static final void calculateOrthologTable(Phylogeny phylogeny, boolean bl, int n) throws RIOException {
        if (n == 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            HashSet<String> hashSet = new HashSet<String>();
            for (PhylogenyNode phylogenyNode : phylogeny.getExternalNodes()) {
                String string = RIO.obtainLabel(hashSet, phylogenyNode);
                hashSet.add(string);
                arrayList.add(string);
            }
            if (bl) {
                Collections.sort(arrayList);
            }
            _m = new IntMatrix(arrayList);
        }
        RIO.updateCounts(_m, n, phylogeny);
    }

    private static final void checkPreconditions(IteratingPhylogenyParser iteratingPhylogenyParser, Phylogeny phylogeny, REROOTING rEROOTING, String string, int n, int n2) throws RIOException, IOException {
        Phylogeny phylogeny2 = iteratingPhylogenyParser.next();
        if (phylogeny2 == null || phylogeny2.isEmpty()) {
            throw new RIOException("input file does not seem to contain any gene trees");
        }
        if (phylogeny2.getNumberOfExternalNodes() < 2) {
            throw new RIOException("input file does not seem to contain any useable gene trees");
        }
        if (!phylogeny.isRooted()) {
            throw new RIOException("species tree is not rooted");
        }
        if (!(n2 == -1 && n == -1 || n2 >= n && n2 >= 0 && n >= 0)) {
            throw new RIOException("attempt to set range (0-based) of gene to analyze to: from " + n + " to " + n2);
        }
        if (rEROOTING == REROOTING.OUTGROUP && ForesterUtil.isEmpty(string)) {
            throw new RIOException("outgroup not set for midpoint rooting");
        }
        if (rEROOTING != REROOTING.OUTGROUP && !ForesterUtil.isEmpty(string)) {
            throw new RIOException("outgroup only used for midpoint rooting");
        }
        if (rEROOTING == REROOTING.MIDPOINT && PhylogenyMethods.calculateMaxDistanceToRoot(phylogeny2) <= 0.0) {
            throw new RIOException("attempt to use midpoint rooting on gene trees which seem to have no (positive) branch lengths (cladograms)");
        }
        if (rEROOTING == REROOTING.OUTGROUP) {
            try {
                phylogeny2.getNode(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RIOException("cannot perform re-rooting by outgroup: " + illegalArgumentException.getLocalizedMessage());
            }
        }
    }

    private static final void checkPreconditions(Phylogeny[] phylogenyArray, Phylogeny phylogeny, REROOTING rEROOTING, String string, int n, int n2) throws RIOException {
        if (!phylogeny.isRooted()) {
            throw new RIOException("species tree is not rooted");
        }
        if (!(n2 == -1 && n == -1 || n2 >= n && n2 < phylogenyArray.length && n2 >= 0 && n >= 0)) {
            throw new RIOException("attempt to set range (0-based) of gene to analyze to: from " + n + " to " + n2 + " (out of " + phylogenyArray.length + ")");
        }
        if (rEROOTING == REROOTING.OUTGROUP && ForesterUtil.isEmpty(string)) {
            throw new RIOException("outgroup not set for midpoint rooting");
        }
        if (rEROOTING != REROOTING.OUTGROUP && !ForesterUtil.isEmpty(string)) {
            throw new RIOException("outgroup only used for midpoint rooting");
        }
        if (rEROOTING == REROOTING.MIDPOINT && PhylogenyMethods.calculateMaxDistanceToRoot(phylogenyArray[0]) <= 0.0) {
            throw new RIOException("attempt to use midpoint rooting on gene trees which seem to have no (positive) branch lengths (cladograms)");
        }
        if (rEROOTING == REROOTING.OUTGROUP) {
            try {
                phylogenyArray[0].getNode(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RIOException("cannot perform re-rooting by outgroup: " + illegalArgumentException.getLocalizedMessage());
            }
        }
    }

    private static final String obtainLabel(Set<String> set, PhylogenyNode phylogenyNode) throws RIOException {
        String string;
        if (phylogenyNode.getNodeData().isHasSequence() && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getName())) {
            string = phylogenyNode.getNodeData().getSequence().getName();
        } else if (phylogenyNode.getNodeData().isHasSequence() && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getSymbol())) {
            string = phylogenyNode.getNodeData().getSequence().getSymbol();
        } else if (phylogenyNode.getNodeData().isHasSequence() && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getGeneName())) {
            string = phylogenyNode.getNodeData().getSequence().getGeneName();
        } else if (!ForesterUtil.isEmpty(phylogenyNode.getName())) {
            string = phylogenyNode.getName();
        } else {
            throw new RIOException("node " + phylogenyNode + " has no appropriate label");
        }
        if (set.contains(string)) {
            throw new RIOException("label " + string + " is not unique");
        }
        return string;
    }

    private static final Phylogeny[] parseGeneTrees(File file) throws FileNotFoundException, IOException {
        PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
        PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
        if (phylogenyParser instanceof NHXParser) {
            NHXParser nHXParser = (NHXParser)phylogenyParser;
            nHXParser.setReplaceUnderscores(false);
            nHXParser.setIgnoreQuotes(true);
            nHXParser.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
        } else if (phylogenyParser instanceof NexusPhylogeniesParser) {
            NexusPhylogeniesParser nexusPhylogeniesParser = (NexusPhylogeniesParser)phylogenyParser;
            nexusPhylogeniesParser.setReplaceUnderscores(false);
            nexusPhylogeniesParser.setIgnoreQuotes(true);
            nexusPhylogeniesParser.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
        }
        return phylogenyFactory.create(file, phylogenyParser);
    }

    private static final void removeSingleDescendentsNodes(Phylogeny phylogeny, boolean bl) {
        int n = PhylogenyMethods.countNumberOfOneDescendantNodes(phylogeny);
        if (n > 0) {
            if (bl) {
                System.out.println("warning: species tree has " + n + " internal nodes with only one descendent which are therefore going to be removed");
            }
            PhylogenyMethods.deleteInternalNodesWithOnlyOneDescendent(phylogeny);
        }
    }

    private static final void updateCounts(IntMatrix intMatrix, int n, Phylogeny phylogeny) throws RIOException {
        PhylogenyMethods.preOrderReId(phylogeny);
        HashMap<String, PhylogenyNode> hashMap = PhylogenyMethods.createNameToExtNodeMap(phylogeny);
        for (int i = 0; i < intMatrix.size(); ++i) {
            String string = intMatrix.getLabel(i);
            PhylogenyNode phylogenyNode = hashMap.get(string);
            if (phylogenyNode == null) {
                throw new RIOException("node \"" + string + "\" not present in gene tree #" + n);
            }
            for (int j = 0; j < intMatrix.size(); ++j) {
                String string2 = intMatrix.getLabel(j);
                PhylogenyNode phylogenyNode2 = hashMap.get(string2);
                if (phylogenyNode2 == null) {
                    throw new RIOException("node \"" + string2 + "\" not present in gene tree #" + n);
                }
                if (PhylogenyMethods.calculateLCAonTreeWithIdsInPreOrder(phylogenyNode, phylogenyNode2).isDuplication()) continue;
                intMatrix.inreaseByOne(i, j);
            }
        }
    }

    public static enum REROOTING {
        NONE,
        BY_ALGORITHM,
        MIDPOINT,
        OUTGROUP;

    }
}

