/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Property;
import org.forester.util.ForesterUtil;

public class PropertiesList
implements PhylogenyData {
    private final List<Property> _properties;
    private final Comparator<Property> comp = new Comparator<Property>(){

        @Override
        public int compare(Property property, Property property2) {
            return property2.getRef().compareTo(property.getRef());
        }
    };

    public PropertiesList() {
        this._properties = new ArrayList<Property>();
    }

    public int size() {
        return this._properties.size();
    }

    public void addProperty(Property property) throws IllegalArgumentException {
        this._properties.add(property);
        Collections.sort(this._properties, this.comp);
    }

    @Override
    public StringBuffer asSimpleText() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (Property property : this.getProperties()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("\n");
            }
            stringBuffer.append(property.asText());
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    @Override
    public PhylogenyData copy() {
        PropertiesList propertiesList = new PropertiesList();
        for (Property property : this.getProperties()) {
            propertiesList.addProperty(property);
        }
        return propertiesList;
    }

    public List<Property> getProperties() {
        return this._properties;
    }

    public List<Property> getPropertiesWithGivenReferencePrefix(String string) throws IllegalArgumentException {
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("reference prefix is null or empty");
        }
        String string2 = new String(string.trim());
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (Property property : this.getProperties()) {
            if (!property.getRef().startsWith(string2)) continue;
            arrayList.add(property);
        }
        return arrayList;
    }

    public List<Property> getProperties(String string) throws IllegalArgumentException {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (Property property : this.getProperties()) {
            if (!property.getRef().equals(string)) continue;
            arrayList.add(property);
        }
        return arrayList;
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        if (this.getProperties() != null) {
            for (Property property : this.getProperties()) {
                property.toPhyloXML(writer, n, string);
            }
        }
    }

    public String toString() {
        return this.asSimpleText().toString();
    }
}

