/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml;

import java.util.ArrayList;
import java.util.HashMap;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.util.ForesterUtil;
import org.xml.sax.Attributes;

public class XmlElement {
    public static final boolean DEBUG = false;
    private final String _namespaceUri;
    private final String _localName;
    private final String _qualifiedName;
    private String _value;
    private final HashMap<String, String> _attributes;
    private final ArrayList<XmlElement> _childElements;
    private XmlElement _parent;

    public XmlElement(String string, String string2, String string3, Attributes attributes) {
        this._namespaceUri = string;
        this._localName = string2;
        this._qualifiedName = string3;
        if (attributes != null) {
            this._attributes = new HashMap(attributes.getLength());
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.getAttributes().put(new String(attributes.getQName(i)), new String(attributes.getValue(i)));
            }
        } else {
            this._attributes = new HashMap();
        }
        this._childElements = new ArrayList();
        this._parent = null;
    }

    public void addChildElement(XmlElement xmlElement) {
        xmlElement.setParent(this);
        this.getChildElements().add(xmlElement);
    }

    public void appendValue(String string) {
        this._value = this._value + string;
    }

    public String getAttribute(String string) {
        if (!this.isHasAttribute(string)) {
            throw new IllegalArgumentException("no attribute named [" + string + "] present in element [" + this.getQualifiedName() + "]");
        }
        return this.getAttributes().get(string);
    }

    public HashMap<String, String> getAttributes() {
        return this._attributes;
    }

    public XmlElement getChildElement(int n) {
        if (n < 0 || n >= this.getNumberOfChildElements()) {
            throw new IllegalArgumentException("attempt to get child element with index " + n + " for element with " + this.getNumberOfChildElements() + " child elements");
        }
        return this.getChildElements().get(n);
    }

    ArrayList<XmlElement> getChildElements() {
        return this._childElements;
    }

    String getLocalName() {
        return this._localName;
    }

    String getNamespaceUri() {
        return this._namespaceUri;
    }

    public int getNumberOfChildElements() {
        return this.getChildElements().size();
    }

    public XmlElement getParent() {
        return this._parent;
    }

    public String getQualifiedName() {
        return this._qualifiedName;
    }

    XmlElement getRoot() {
        XmlElement xmlElement = this;
        while (xmlElement.getParent() != null) {
            xmlElement = xmlElement.getParent();
        }
        return xmlElement;
    }

    public boolean getValueAsBoolean() throws PhylogenyParserException {
        boolean bl = false;
        try {
            bl = Boolean.valueOf(this.getValueAsString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new PhylogenyParserException("attempt to parse [" + this.getValueAsString() + "] into boolean, in " + this.toString());
        }
        return bl;
    }

    public double getValueAsDouble() throws PhyloXmlDataFormatException {
        double d = 0.0;
        try {
            d = Double.parseDouble(this.getValueAsString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new PhyloXmlDataFormatException("attempt to parse [" + this.getValueAsString() + "] into double, in " + this.toString());
        }
        return d;
    }

    public int getValueAsInt() throws PhyloXmlDataFormatException {
        int n = 0;
        try {
            n = Integer.parseInt(this.getValueAsString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new PhyloXmlDataFormatException("attempt to parse [" + this.getValueAsString() + "] into integer, in " + this.toString());
        }
        return n;
    }

    public String getValueAsString() {
        if (this._value == null) {
            return "";
        }
        return this._value.replaceAll("\\s+", " ").trim();
    }

    public boolean isHasAttribute(String string) {
        return this.getAttributes().containsKey(string);
    }

    public boolean isHasValue() {
        return !ForesterUtil.isEmpty(this._value);
    }

    void setParent(XmlElement xmlElement) {
        this._parent = xmlElement;
    }

    public void setValue(String string) {
        this._value = string;
    }

    public String toString() {
        if (this.getParent() != null) {
            return "\"" + this.getQualifiedName() + "\" [value: " + this.getValueAsString() + ", parent element: \"" + this.getParent().getQualifiedName() + "\"]";
        }
        return "\"" + this.getQualifiedName() + "\" [value: " + this.getValueAsString() + "]";
    }
}

