/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.SortedSet;
import javax.swing.JOptionPane;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.tools.RunnableProcess;
import org.forester.phylogeny.Phylogeny;
import org.forester.ws.seqdb.SequenceDbWsTools;

public final class SequenceDataRetriver
extends RunnableProcess {
    private final Phylogeny _phy;
    private final MainFrameApplication _mf;
    private final TreePanel _treepanel;
    public static final boolean DEBUG = false;

    public SequenceDataRetriver(MainFrameApplication mainFrameApplication, TreePanel treePanel, Phylogeny phylogeny) {
        this._phy = phylogeny;
        this._mf = mainFrameApplication;
        this._treepanel = treePanel;
    }

    @Override
    public void run() {
        this.execute();
    }

    private void execute() {
        this.start(this._mf, "sequence data");
        SortedSet<String> sortedSet = null;
        try {
            sortedSet = SequenceDbWsTools.obtainSeqInformation(this._phy, false, true, 4000);
        }
        catch (UnknownHostException unknownHostException) {
            JOptionPane.showMessageDialog(this._mf, unknownHostException.getLocalizedMessage(), "Network error during sequence data gathering", 0);
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(this._mf, iOException.toString(), "Failed to obtain sequence data", 0);
            return;
        }
        finally {
            this.end(this._mf);
        }
        this._treepanel.setTree(this._phy);
        this._mf.showWhole();
        this._treepanel.setEdited(true);
        if (sortedSet != null && sortedSet.size() > 0) {
            int n = sortedSet.size();
            boolean bl = false;
            if (n > 20) {
                bl = true;
                n = 20;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (sortedSet.size() == 1) {
                stringBuffer.append("For the following node no data was found:\n");
            } else {
                stringBuffer.append("For the following nodes no data was found (total: " + sortedSet.size() + "):\n");
            }
            int n2 = 0;
            for (String string : sortedSet) {
                if (n2 > 19) break;
                stringBuffer.append(string);
                stringBuffer.append("\n");
                ++n2;
            }
            if (bl) {
                stringBuffer.append("...");
            }
            try {
                JOptionPane.showMessageDialog(this._mf, stringBuffer.toString(), "Sequence Tool Completed", 2);
            }
            catch (Exception exception) {}
        } else {
            try {
                JOptionPane.showMessageDialog(this._mf, "Sequence tool successfully completed", "Sequence Tool Completed", 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

