/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.forester.archaeopteryx.AptxConstants;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreeColorSet;
import org.forester.archaeopteryx.TreeFontSet;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.phylogeny.data.NodeDataField;
import org.forester.phylogeny.data.NodeVisualData;
import org.forester.util.ForesterUtil;

public final class Configuration {
    static final String[][] clickto_options = new String[][]{{"Display Node Data", "display"}, {"Collapse/Uncollapse", "display"}, {"Root/Reroot", "display"}, {"Go to Sub/Supertree", "display"}, {"Swap Descendants", "display"}, {"Colorize Node(s)", "display"}, {"Change Node Font(s)", "display"}, {"Colorize Subtree(s)", "display"}, {"Open Sequence DB", "display"}, {"Open PDB", "display"}, {"Open Taxonomy DB", "display"}, {"Launch BLAST", "display"}, {"Cut Subtree", "display"}, {"Copy Subtree", "display"}, {"Paste Subtree", "display"}, {"Delete Subtree/Node", "display"}, {"Add New Node", "display"}, {"Edit Node Data", "display"}, {"Sort Descendants", "display"}, {"List Node Data", "display"}, {"Select Node(s)", "display"}, {"Uncollapse All", "display"}, {"Order Subtree", "display"}};
    private static final String[][] DEFAULT_SPECIES_COLORS = new String[][]{{"BRAFL", "0x00FFFF"}, {"SPHGR", "0x9620F0"}, {"STRPU", "0x9620F0"}, {"CIOIN", "0xFF1CAE"}, {"CIOSA", "0xFF2CAE"}, {"BOVIN", "0x5C3317"}, {"CANFA", "0x8B2323"}, {"HUMAN", "0xFF2400"}, {"PANTR", "0xCC2400"}, {"MOUSE", "0xFF7F00"}, {"RAT", "0xFFEF00"}, {"MONDO", "0xEE9A49"}, {"ORNAN", "0xCD853F"}, {"XENLA", "0x6BAA23"}, {"XENTR", "0x6BAA23"}, {"CHICK", "0xFFC125"}, {"FUGRU", "0x0000FF"}, {"BRARE", "0x0000DD"}, {"DANRE", "0x0000BB"}, {"TETNG", "0x0000AA"}, {"ORYLA", "0x000088"}, {"GASAC", "0x000066"}, {"CAEEL", "0x666699"}, {"CAEBR", "0xB0B0B0"}, {"DROME", "0x663366"}, {"DROPS", "0x996699"}, {"APIME", "0x7A7700"}, {"AEDAE", "0x8C5900"}, {"TRICA", "0x918E00"}, {"NEMVE", "0x0066CC"}, {"HYDVU", "0x3399FF"}, {"LUBBA", "0xF7B5CB"}, {"GEOCY", "0xF5A0BD"}, {"AMPQE", "0x009966"}, {"SUBDO", "0xC790B9"}, {"MONBE", "0xFC0FC0"}, {"DICPU", "0xFFCC33"}, {"DICDI", "0xFFCC00"}, {"ENTHI", "0x5959AB"}, {"ARATH", "0x00FF00"}, {"POPTR", "0x006400"}, {"VITVI", "0x00CD00"}, {"GLYMA", "0x00FF7F"}, {"ORYSA", "0x008B00"}, {"ORYSJ", "0x008C00"}, {"SORBI", "0x00EE76"}, {"SELMO", "0x238E23"}, {"PHYPA", "0x09F911"}, {"OSTLU", "0x7FFF00"}, {"OSTTA", "0x7FFF00"}, {"OSTRC", "0x7FFF00"}, {"MICPU", "0x66CD00"}, {"MIC99", "0x66CD00"}, {"CHLRE", "0xB3EE3A"}, {"VOLCA", "0xC0FF3E"}, {"CHLSP", "0x6B8E23"}, {"CYAME", "0xD02090"}, {"YEAST", "0xAAAAAA"}, {"BACFR", "0xFF0000"}, {"BACTN", "0xFFFF00"}, {"MYXXD", "0x0000FF"}, {"STIAU", "0x00FFFF"}, {"BACOV", "0x8C5900"}, {"BACUN", "0x66CD00"}, {"PORGI", "0x918E00"}};
    static final int display_node_data = 0;
    static final int collapse_uncollapse = 1;
    static final int reroot = 2;
    static final int subtree = 3;
    static final int swap = 4;
    static final int color_node_font = 5;
    static final int change_node_font = 6;
    static final int color_subtree = 7;
    static final int open_seq_web = 8;
    static final int open_pdb_web = 9;
    static final int open_tax_web = 10;
    static final int blast = 11;
    static final int cut_subtree = 12;
    static final int copy_subtree = 13;
    static final int paste_subtree = 14;
    static final int delete_subtree_or_node = 15;
    static final int add_new_node = 16;
    static final int edit_node_data = 17;
    static final int sort_descendents = 18;
    static final int get_ext_desc_data = 19;
    static final int select_nodes = 20;
    static final int uncollapse_all = 21;
    static final int order_subtree = 22;
    static final String[][] display_options = new String[][]{{"Phylogram", "display", "?"}, {"Node Name", "display", "yes"}, {"Taxonomy Code", "display", "yes"}, {"Seq Annotations", "display", "no"}, {"Confidence Values", "display", "?"}, {"Node Events", "display", "?"}, {"Colorize by Taxonomy", "display", "no"}, {"Colorize by Sequence", "display", "no"}, {"Visual Styles/Branch Colors", "display", "no"}, {"Branch Widths", "display", "no"}, {"Domain Architectures", "display", "no"}, {"Binary Characters", "nodisplay", "no"}, {"Binary Char Counts", "nodisplay", "no"}, {"Seq Name", "display", "yes"}, {"Seq Accession", "display", "no"}, {"Show Internal Data", "display", "yes"}, {"Dyna Hide", "display", "yes"}, {"Taxonomy Scientific", "display", "yes"}, {"Taxonomy Common", "display", "no"}, {"Colorize by Annotation", "display", "no"}, {"Seq Symbol", "display", "yes"}, {"Rollover", "display", "yes"}, {"Relation Confidence", "nodisplay", "no"}, {"Vector Data", "nodisplay", "no"}, {"Taxonomy Images", "display", "no"}, {"Properties", "display", "no"}, {"Gene Name", "display", "yes"}, {"Multiple Seq Alignment", "display", "no"}, {"Branch Length Values", "display", "no"}, {"Taxonomy Rank", "display", "no"}, {"Show External Data", "display", "yes"}};
    static final int display_as_phylogram = 0;
    static final int show_node_names = 1;
    static final int show_tax_code = 2;
    static final int show_annotation = 3;
    static final int write_confidence_values = 4;
    static final int write_events = 5;
    static final int color_according_to_species = 6;
    static final int color_according_to_sequence = 7;
    static final int use_style = 8;
    static final int width_branches = 9;
    static final int show_domain_architectures = 10;
    static final int show_binary_characters = 11;
    static final int show_binary_character_counts = 12;
    static final int show_seq_names = 13;
    static final int show_sequence_acc = 14;
    static final int display_internal_data = 15;
    static final int dynamically_hide_data = 16;
    static final int show_taxonomy_scientific_names = 17;
    static final int show_taxonomy_common_names = 18;
    static final int color_according_to_annotation = 19;
    static final int show_seq_symbols = 20;
    static final int node_data_popup = 21;
    static final int show_relation_confidence = 22;
    static final int show_vector_data = 23;
    static final int show_taxonomy_images = 24;
    static final int show_properties = 25;
    static final int show_gene_names = 26;
    static final int show_mol_seqs = 27;
    static final int write_branch_length_values = 28;
    static final int show_tax_rank = 29;
    static final int display_external_data = 30;
    static final String VALIDATE_AGAINST_PHYLOXML_XSD_SCHEMA = "validate_against_phyloxml_xsd_schema";
    private static Hashtable<String, Color> _sequence_colors;
    private static Hashtable<String, Color> _annotation_colors;
    private static Hashtable<String, Color> _domain_colors;
    private static Hashtable<String, Color> _species_colors;
    private static String DEFAULT_FONT_FAMILY;
    private static final int DEPRECATED = -2;
    private static final String DISPLAY_COLOR_KEY = "display_color";
    String config_filename;
    int default_clickto = 0;
    String default_config_filename = "_aptx_configuration_file";
    TreeColorSet tree_color_set;
    TreeFontSet tree_font_set;
    boolean verbose = false;
    private boolean _abbreviate_scientific_names = false;
    private boolean _antialias_screen = true;
    private boolean _background_color_gradient = false;
    private String _base_font_family_name = "";
    private int _base_font_size = -1;
    private Options.CLADOGRAM_TYPE _cladogram_type = AptxConstants.CLADOGRAM_TYPE_DEFAULT;
    private boolean _color_labels_same_as_parent_branch = false;
    private int _default_bootstrap_samples = -1;
    private NodeVisualData.NodeFill _default_node_fill = NodeVisualData.NodeFill.SOLID;
    private NodeVisualData.NodeShape _default_node_shape = NodeVisualData.NodeShape.RECTANGLE;
    private short _default_node_shape_size = (short)7;
    private SortedMap<String, Color> _display_colors = null;
    private boolean _display_sequence_relations = false;
    private boolean _editable = true;
    private NodeDataField _ext_desc_data_to_return = NodeDataField.UNKNOWN;
    private EXT_NODE_DATA_RETURN_ON _ext_node_data_return_on = EXT_NODE_DATA_RETURN_ON.WINODW;
    private int _frame_x_size;
    private int _frame_y_size;
    private Color _gui_background_color = AptxConstants.GUI_BACKGROUND_DEFAULT;
    private Color _gui_button_background_color = AptxConstants.BUTTON_BACKGROUND_COLOR_DEFAULT;
    private Color _gui_button_border_color = AptxConstants.BUTTON_BORDER_COLOR_DEFAULT;
    private Color _gui_button_text_color = AptxConstants.BUTTON_TEXT_COLOR_DEFAULT;
    private Color _gui_checkbox_and_button_active_color = AptxConstants.CHECKBOX_AND_BUTTON_ACTIVE_COLOR_DEFAULT;
    private Color _gui_checkbox_text_color = AptxConstants.CHECKBOX_TEXT_COLOR_DEFAULT;
    private Color _gui_menu_background_color = AptxConstants.MENU_BACKGROUND_COLOR_DEFAULT;
    private Color _gui_menu_text_color = AptxConstants.MENU_TEXT_COLOR_DEFAULT;
    private boolean _hide_controls_and_menus = false;
    private boolean _internal_number_are_confidence_for_nh_parsing = false;
    private String _label_for_get_ext_descendents_data = "";
    private int _max_base_font_size = 20;
    private boolean _midpoint_root = false;
    private int _min_base_font_size = 2;
    private double _min_confidence_value = 0.0;
    private boolean _nh_parsing_replace_underscores = false;
    private Options.NODE_LABEL_DIRECTION _node_label_direction = Options.NODE_LABEL_DIRECTION.HORIZONTAL;
    private short _number_of_digits_after_comma_for_branch_length_values = (short)3;
    private short _number_of_digits_after_comma_for_confidence_values = (short)2;
    private short _ov_max_height = (short)80;
    private short _ov_max_width = (short)80;
    private Options.OVERVIEW_PLACEMENT_TYPE _ov_placement = Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT;
    private File _path_to_local_fastme = null;
    private File _path_to_local_mafft = null;
    private File _path_to_local_raxml = null;
    private Options.PHYLOGENY_GRAPHICS_TYPE _phylogeny_graphics_type = Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR;
    private float _print_line_width = 0.5f;
    private boolean _show_annotation_ref_source = true;
    private boolean _show_default_node_shapes_external = false;
    private boolean _show_default_node_shapes_for_marked_nodes = false;
    private boolean _show_default_node_shapes_internal = false;
    private boolean _show_domain_labels = true;
    private boolean _show_overview = true;
    private boolean _show_scale = false;
    private NHXParser.TAXONOMY_EXTRACTION _taxonomy_extraction = NHXParser.TAXONOMY_EXTRACTION.NO;
    private UI _ui = UI.UNKNOWN;
    private boolean _use_tabbed_display = false;
    private boolean _validate_against_phyloxml_xsd_schema = true;
    private Color _vector_data_min_color = Color.BLUE;
    private Color _vector_data_max_color = Color.YELLOW;
    private Color _vector_data_mean_color = Color.WHITE;
    private double _vector_data_height = 12.0;
    private int _vector_data_width = 120;
    private boolean _line_up_renderable_node_data = true;
    private boolean _right_align_domains = false;
    private boolean _allow_thick_strokes = false;
    private boolean _could_read_config_file = false;

    public Configuration() {
        this(null, false, false, false);
    }

    public Configuration(String string, boolean bl, boolean bl2, boolean bl3) {
        this.config_filename = ForesterUtil.isEmpty(string) ? this.default_config_filename : string;
        this._could_read_config_file = false;
        this.setDisplayColors(new TreeMap<String, Color>());
        this.config_filename = this.config_filename.trim();
        URL uRL = null;
        if (bl) {
            try {
                uRL = new URL(this.config_filename);
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    this.readConfig(bufferedReader);
                    bufferedReader.close();
                    ForesterUtil.programMessage("Archaeopteryx", "successfully read from configuration url [" + this.config_filename + "]");
                    this._could_read_config_file = true;
                }
                catch (Exception exception) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "failed to read configuration from [" + this.config_filename + "]: " + exception.getLocalizedMessage());
                }
            }
            catch (Exception exception) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "cannot find or open configuration url [" + this.config_filename + "]");
            }
        } else {
            File file = new File(this.config_filename);
            if (!file.exists()) {
                file = new File(this.config_filename + ".txt");
            }
            if (file.exists() && file.canRead()) {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    this.readConfig(bufferedReader);
                    bufferedReader.close();
                    this._could_read_config_file = true;
                }
                catch (Exception exception) {
                    if (bl3) {
                        ForesterUtil.printWarningMessage("Archaeopteryx", "failed to read configuration from [" + this.config_filename + "]: " + exception);
                    }
                }
            } else if (bl3) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "cannot find or open configuration file [" + this.config_filename + "]");
            }
        }
    }

    public String getBaseFontFamilyName() {
        return this._base_font_family_name;
    }

    public int getDefaultBootstrapSamples() {
        return this._default_bootstrap_samples;
    }

    public NodeVisualData.NodeFill getDefaultNodeFill() {
        return this._default_node_fill;
    }

    public NodeVisualData.NodeShape getDefaultNodeShape() {
        return this._default_node_shape;
    }

    public short getDefaultNodeShapeSize() {
        return this._default_node_shape_size;
    }

    public NodeDataField getExtDescNodeDataToReturn() {
        return this._ext_desc_data_to_return;
    }

    public EXT_NODE_DATA_RETURN_ON getExtNodeDataReturnOn() {
        return this._ext_node_data_return_on;
    }

    public int getFrameXSize() {
        return this._frame_x_size;
    }

    public int getFrameYSize() {
        return this._frame_y_size;
    }

    public String getLabelForGetExtDescendentsData() {
        return this._label_for_get_ext_descendents_data;
    }

    public File getPathToLocalFastme() {
        return this._path_to_local_fastme;
    }

    public File getPathToLocalMafft() {
        return this._path_to_local_mafft;
    }

    public File getPathToLocalRaxml() {
        return this._path_to_local_raxml;
    }

    public double getVectorDataHeight() {
        return this._vector_data_height;
    }

    public Color getVectorDataMaxColor() {
        return this._vector_data_max_color;
    }

    public Color getVectorDataMeanColor() {
        return this._vector_data_mean_color;
    }

    public Color getVectorDataMinColor() {
        return this._vector_data_min_color;
    }

    public int getVectorDataWidth() {
        return this._vector_data_width;
    }

    public boolean isAbbreviateScientificTaxonNames() {
        return this._abbreviate_scientific_names;
    }

    public boolean isAllowThickStrokes() {
        return this._allow_thick_strokes;
    }

    public boolean isBackgroundColorGradient() {
        return this._background_color_gradient;
    }

    public boolean isColorByTaxonomicGroup() {
        return false;
    }

    public boolean isColorLabelsSameAsParentBranch() {
        return this._color_labels_same_as_parent_branch;
    }

    public final boolean isLineUpRendarableNodeData() {
        return this._line_up_renderable_node_data;
    }

    public boolean isMidpointReroot() {
        return this._midpoint_root;
    }

    public final boolean isRightLineUpDomains() {
        return this._right_align_domains;
    }

    public boolean isShowAnnotationRefSource() {
        return this._show_annotation_ref_source;
    }

    public boolean isShowDefaultNodeShapesExternal() {
        return this._show_default_node_shapes_external;
    }

    public boolean isShowDefaultNodeShapesForMarkedNodes() {
        return this._show_default_node_shapes_for_marked_nodes;
    }

    public boolean isShowDefaultNodeShapesInternal() {
        return this._show_default_node_shapes_internal;
    }

    public boolean isShowDomainLabels() {
        return this._show_domain_labels;
    }

    public void putDisplayColors(String string, Color color) {
        this.getDisplayColors().put(string, color);
    }

    public void setAbbreviateScientificTaxonNames(boolean bl) {
        this._abbreviate_scientific_names = bl;
    }

    public void setAddTaxonomyImagesCB(boolean bl) {
        Configuration.display_options[24][1] = bl ? "yes" : "no";
    }

    public void setBackgroundColorGradient(boolean bl) {
        this._background_color_gradient = bl;
    }

    public void setBaseFontFamilyName(String string) {
        this._base_font_family_name = string;
    }

    public void setBaseFontSize(int n) {
        this._base_font_size = n;
    }

    public void setColorizeBranches(boolean bl) {
        Configuration.display_options[8][2] = bl ? "yes" : "no";
    }

    public void setColorLabelsSameAsParentBranch(boolean bl) {
        this._color_labels_same_as_parent_branch = bl;
    }

    public void setDefaultNodeFill(NodeVisualData.NodeFill nodeFill) {
        this._default_node_fill = nodeFill;
    }

    public void setDefaultNodeShape(NodeVisualData.NodeShape nodeShape) {
        this._default_node_shape = nodeShape;
    }

    public void setDefaultNodeShapeSize(short s) {
        this._default_node_shape_size = s;
    }

    public void setDisplayAsPhylogram(boolean bl) {
        Configuration.display_options[0][2] = bl ? "yes" : "no";
    }

    public void setDisplayColors(SortedMap<String, Color> sortedMap) {
        this._display_colors = sortedMap;
    }

    public void setDisplayConfidenceValues(boolean bl) {
        Configuration.display_options[4][2] = bl ? "yes" : "no";
    }

    public void setDisplayGeneNames(boolean bl) {
        Configuration.display_options[26][2] = bl ? "yes" : "no";
    }

    public void setDisplayInternalData(boolean bl) {
        Configuration.display_options[15][2] = bl ? "yes" : "no";
    }

    public void setDisplayExternalData(boolean bl) {
        Configuration.display_options[30][2] = bl ? "yes" : "no";
    }

    public void setDisplayMultipleSequenceAlignment(boolean bl) {
        Configuration.display_options[27][2] = bl ? "yes" : "no";
    }

    public void setDisplayNodeNames(boolean bl) {
        Configuration.display_options[1][2] = bl ? "yes" : "no";
    }

    public void setDisplaySequenceAcc(boolean bl) {
        Configuration.display_options[14][2] = bl ? "yes" : "no";
    }

    public void setDisplaySequenceNames(boolean bl) {
        Configuration.display_options[13][2] = bl ? "yes" : "no";
    }

    public void setDisplaySequenceRelations(boolean bl) {
        this._display_sequence_relations = bl;
    }

    public void setDisplaySequenceSymbols(boolean bl) {
        Configuration.display_options[20][2] = bl ? "yes" : "no";
    }

    public void setDisplayTaxonomyCode(boolean bl) {
        Configuration.display_options[2][2] = bl ? "yes" : "no";
    }

    public void setDisplayTaxonomyRank(boolean bl) {
        Configuration.display_options[29][2] = bl ? "yes" : "no";
    }

    public void setDisplayTaxonomyCommonNames(boolean bl) {
        Configuration.display_options[18][2] = bl ? "yes" : "no";
    }

    public void setDisplayTaxonomyImages(boolean bl) {
        Configuration.display_options[24][2] = bl ? "yes" : "no";
    }

    public void setDisplayTaxonomyScientificNames(boolean bl) {
        Configuration.display_options[17][2] = bl ? "yes" : "no";
    }

    public void setDynamicallyHideData(boolean bl) {
        Configuration.display_options[16][2] = bl ? "yes" : "no";
    }

    public void setExtDescNodeDataToReturn(NodeDataField nodeDataField) {
        this._ext_desc_data_to_return = nodeDataField;
    }

    public void setFrameXSize(int n) {
        this._frame_x_size = n;
    }

    public void setFrameYSize(int n) {
        this._frame_y_size = n;
    }

    public final void setLineUpRendarableNodeData(boolean bl) {
        this._line_up_renderable_node_data = bl;
    }

    public void setMidpointReroot(boolean bl) {
        this._midpoint_root = bl;
    }

    public void setMinConfidenceValue(double d) {
        this._min_confidence_value = d;
    }

    public void setNodeLabelDirection(Options.NODE_LABEL_DIRECTION nODE_LABEL_DIRECTION) {
        this._node_label_direction = nODE_LABEL_DIRECTION;
    }

    public void setNumberOfDigitsAfterCommaForBranchLengthValue(short s) {
        this._number_of_digits_after_comma_for_branch_length_values = s;
    }

    public void setNumberOfDigitsAfterCommaForConfidenceValues(short s) {
        this._number_of_digits_after_comma_for_confidence_values = s;
    }

    public void setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE pHYLOGENY_GRAPHICS_TYPE) {
        this._phylogeny_graphics_type = pHYLOGENY_GRAPHICS_TYPE;
    }

    public void setPrintLineWidth(float f) {
        this._print_line_width = f;
    }

    public void setReplaceUnderscoresInNhParsing(boolean bl) {
        this._nh_parsing_replace_underscores = bl;
    }

    public final void setRightLineUpDomains(boolean bl) {
        this._right_align_domains = bl;
    }

    public void setShowDefaultNodeShapesExternal(boolean bl) {
        this._show_default_node_shapes_external = bl;
    }

    public void setShowDefaultNodeShapesForMarkedNodes(boolean bl) {
        this._show_default_node_shapes_for_marked_nodes = bl;
    }

    public void setShowDefaultNodeShapesInternal(boolean bl) {
        this._show_default_node_shapes_internal = bl;
    }

    public void setShowDomainLabels(boolean bl) {
        this._show_domain_labels = bl;
    }

    public void setShowScale(boolean bl) {
        this._show_scale = bl;
    }

    public void setUseStyle(boolean bl) {
        Configuration.display_options[8][2] = bl ? "yes" : "no";
    }

    private int getClickToIndex(String string) {
        int n = -1;
        if (string.equals("edit_info")) {
            n = 0;
            ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [edit_info] is deprecated, use [display node data] instead");
        } else if (string.equals("display_node_data")) {
            n = 0;
        } else if (string.equals("collapse_uncollapse")) {
            n = 1;
        } else if (string.equals("uncollapse_all")) {
            n = 21;
        } else if (string.equals("reroot")) {
            n = 2;
        } else if (string.equals("subtree")) {
            n = 3;
        } else if (string.equals("swap")) {
            n = 4;
        } else if (string.equals("order_subtree")) {
            n = 22;
        } else if (string.equals("sort_descendants")) {
            n = 18;
        } else if (string.equals("get_ext_descendents_data")) {
            n = 19;
        } else {
            if (string.equals("display_sequences")) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [display_sequences] is deprecated");
                return -2;
            }
            if (string.equals("open_seq_web")) {
                n = 8;
            } else if (string.equals("open_pdb_web")) {
                n = 9;
            } else if (string.equals("open_tax_web")) {
                n = 10;
            } else if (string.equals("blast")) {
                n = 11;
            } else if (string.equals("cut_subtree")) {
                n = 12;
            } else if (string.equals("copy_subtree")) {
                n = 13;
            } else if (string.equals("paste_subtree")) {
                n = 14;
            } else if (string.equals("delete")) {
                n = 15;
            } else if (string.equals("add_new_node")) {
                n = 16;
            } else if (string.equals("edit_node_data")) {
                n = 17;
            } else if (string.equals("select_nodes")) {
                n = 20;
            } else {
                if (string.equals("display_node_popup")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [display_node_popup] is deprecated");
                    return -2;
                }
                if (string.equals("custom_option")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [custom_option] is deprecated");
                    return -2;
                }
                if (string.equals("color_subtree")) {
                    n = 7;
                } else if (string.equals("change_node_font")) {
                    n = 6;
                } else if (string.equals("color_node_font")) {
                    n = 5;
                } else if (string.equals("color_subtree")) {
                    n = 7;
                }
            }
        }
        return n;
    }

    private final void initSpeciesColors() {
        _species_colors = new Hashtable();
        for (String[] stringArray : DEFAULT_SPECIES_COLORS) {
            _species_colors.put(stringArray[0], Color.decode(stringArray[1]));
        }
    }

    private boolean parseBoolean(String string) {
        String string2 = string.trim().toLowerCase();
        if (string2.equals("yes") || string2.equals("true")) {
            return true;
        }
        if (string2.equals("no") || string2.equals("false")) {
            return false;
        }
        ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse boolean value from [" + string + "]");
        return false;
    }

    private double parseDouble(String string) {
        double d = 0.0;
        try {
            d = Double.parseDouble(string.trim());
        }
        catch (Exception exception) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse double from [" + string + "]");
            d = 0.0;
        }
        return d;
    }

    private float parseFloat(String string) {
        float f = 0.0f;
        try {
            f = Float.parseFloat(string.trim());
        }
        catch (Exception exception) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse float from [" + string + "]");
            f = 0.0f;
        }
        return f;
    }

    private int parseInt(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string.trim());
        }
        catch (Exception exception) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse integer from [" + string + "]");
            n = -1;
        }
        return n;
    }

    private short parseShort(String string) {
        int n = -1;
        try {
            n = Short.parseShort(string.trim());
        }
        catch (Exception exception) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse short from [" + string + "]");
            n = -1;
        }
        return (short)n;
    }

    private void processFontFamily(StringTokenizer stringTokenizer) {
        String[] stringArray;
        this.setBaseFontFamilyName("");
        String string = ((String)stringTokenizer.nextElement()).trim();
        for (String string2 : stringArray = string.split(",+")) {
            string2 = string2.replace('_', ' ').trim();
            if (Arrays.binarySearch(AptxUtil.getAvailableFontFamiliesSorted(), string2) < 0) continue;
            this.setBaseFontFamilyName(string2);
            break;
        }
    }

    private void readConfig(BufferedReader bufferedReader) throws IOException {
        String string;
        do {
            if ((string = bufferedReader.readLine()) == null || (string = string.trim()).startsWith("#") || ForesterUtil.isEmpty(string)) continue;
            string = string.replaceAll("\\s+", "\t");
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            this.setKeyValue(stringTokenizer);
        } while (string != null);
    }

    private void setAntialiasScreen(boolean bl) {
        this._antialias_screen = bl;
    }

    private void setCladogramType(Options.CLADOGRAM_TYPE cLADOGRAM_TYPE) {
        this._cladogram_type = cLADOGRAM_TYPE;
    }

    private void setDefaultBootstrapSamples(int n) {
        this._default_bootstrap_samples = n;
    }

    private void setEditable(boolean bl) {
        this._editable = bl;
    }

    private void setExtNodeDataReturnOn(EXT_NODE_DATA_RETURN_ON eXT_NODE_DATA_RETURN_ON) {
        this._ext_node_data_return_on = eXT_NODE_DATA_RETURN_ON;
    }

    private void setInternalNumberAreConfidenceForNhParsing(boolean bl) {
        this._internal_number_are_confidence_for_nh_parsing = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setKeyValue(StringTokenizer stringTokenizer) {
        String string = ((String)stringTokenizer.nextElement()).replace(':', ' ').trim().toLowerCase();
        if (!stringTokenizer.hasMoreElements()) {
            return;
        }
        if (string.equals("default_click_to")) {
            String string2 = (String)stringTokenizer.nextElement();
            this.default_clickto = this.getClickToIndex(string2);
            if (this.default_clickto == -1) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "invalid value [" + string2 + "] for [default_click_to]");
                this.default_clickto = 0;
                return;
            }
            if (this.default_clickto != -2) return;
            return;
        } else {
            if (string.equals("native_ui")) {
                String string3 = ((String)stringTokenizer.nextElement()).trim().toLowerCase();
                if (string3.equals("yes") || string3.equals("true")) {
                    this._ui = UI.NATIVE;
                    return;
                }
                if (string3.equals("no") || string3.equals("false")) {
                    this._ui = UI.CROSSPLATFORM;
                    return;
                }
                if (string3.equals("?")) {
                    this._ui = UI.UNKNOWN;
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse yes/no/? value from [" + string3 + "]");
                this._ui = UI.UNKNOWN;
                return;
            }
            if (string.equals(VALIDATE_AGAINST_PHYLOXML_XSD_SCHEMA)) {
                this.setValidatePhyloXmlAgainstSchema(this.parseBoolean((String)stringTokenizer.nextElement()));
                return;
            }
            if (string.equals("antialias_screen")) {
                this.setAntialiasScreen(this.parseBoolean((String)stringTokenizer.nextElement()));
                return;
            }
            if (string.equals("phylogeny_graphics_type")) {
                String string4 = ((String)stringTokenizer.nextElement()).trim();
                if (string4.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX.toString())) {
                    this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX);
                    return;
                }
                if (string4.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED.toString())) {
                    this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED);
                    return;
                }
                if (string4.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE.toString())) {
                    this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE);
                    return;
                }
                if (string4.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED.toString())) {
                    this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED);
                    return;
                }
                if (string4.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR.toString())) {
                    this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
                    return;
                }
                if (string4.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR.toString())) {
                    this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR);
                    return;
                }
                if (string4.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED.toString())) {
                    this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED);
                    return;
                }
                if (string4.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR.toString())) {
                    this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR);
                    return;
                }
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + string4 + "] for [phylogeny_graphics_type]");
                return;
            }
            if (string.equals("min_confidence_value")) {
                String string5 = ((String)stringTokenizer.nextElement()).trim();
                double d = this.parseDouble(string5);
                this.setMinConfidenceValue(d);
                return;
            }
            if (string.equals("font_family")) {
                this.processFontFamily(stringTokenizer);
                return;
            }
            if (string.equals("font_size")) {
                String string6 = ((String)stringTokenizer.nextElement()).trim();
                int n = this.parseInt(string6);
                if (n <= 0) return;
                this.setBaseFontSize(n);
                return;
            }
            if (string.equals("font_size_min")) {
                String string7 = ((String)stringTokenizer.nextElement()).trim();
                int n = this.parseInt(string7);
                if (n <= 0) return;
                this.setMinBaseFontSize(n);
                return;
            }
            if (string.equals("font_size_max")) {
                String string8 = ((String)stringTokenizer.nextElement()).trim();
                int n = this.parseInt(string8);
                if (n <= 1) return;
                this.setMaxBaseFontSize(n);
                return;
            }
            if (string.equals("pdf_export_line_width")) {
                String string9 = ((String)stringTokenizer.nextElement()).trim();
                float f = this.parseFloat(string9);
                if (f > 0.0f) {
                    this.setPrintLineWidth(f);
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "value for [pdf_export_line_width] cannot be zero or negative");
                return;
            }
            if (string.equals("window_initial_size_x")) {
                String string10 = ((String)stringTokenizer.nextElement()).trim();
                int n = this.parseInt(string10);
                if (n <= 0) return;
                this.setFrameXSize(n);
                return;
            }
            if (string.equals("window_initial_size_y")) {
                String string11 = ((String)stringTokenizer.nextElement()).trim();
                int n = this.parseInt(string11);
                if (n <= 0) return;
                this.setFrameYSize(n);
                return;
            }
            if (string.equals("default_number_of_bootstrap_resamples")) {
                String string12 = ((String)stringTokenizer.nextElement()).trim();
                int n = this.parseInt(string12);
                if (n >= 0) {
                    this.setDefaultBootstrapSamples(n);
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "value for [default_number_of_bootstrap_resamples] cannot be negative");
                return;
            }
            if (string.equals("mafft_local")) {
                String string13 = ((String)stringTokenizer.nextElement()).trim();
                if (ForesterUtil.isEmpty(string13)) return;
                this.setPathToLocalMafft(new File(string13));
                return;
            }
            if (string.equals("fastme_local")) {
                String string14 = ((String)stringTokenizer.nextElement()).trim();
                if (ForesterUtil.isEmpty(string14)) return;
                this.setPathToLocalFastme(new File(string14));
                return;
            }
            if (string.equals("raxml_local")) {
                String string15 = ((String)stringTokenizer.nextElement()).trim();
                if (ForesterUtil.isEmpty(string15)) return;
                this.setPathToLocalRaxml(new File(string15));
                return;
            }
            if (string.equals("show_scale")) {
                this.setShowScale(this.parseBoolean((String)stringTokenizer.nextElement()));
                return;
            }
            if (string.equals("show_overview")) {
                this.setShowOverview(this.parseBoolean((String)stringTokenizer.nextElement()));
                return;
            }
            if (string.equals("background_gradient")) {
                this.setBackgroundColorGradient(this.parseBoolean((String)stringTokenizer.nextElement()));
                return;
            }
            if (string.equals("color_labels_same_as_branch_length_values")) {
                this.setColorLabelsSameAsParentBranch(this.parseBoolean((String)stringTokenizer.nextElement()));
                return;
            }
            if (string.equals("show_domain_labels")) {
                this.setShowDomainLabels(this.parseBoolean((String)stringTokenizer.nextElement()));
                return;
            }
            if (string.equals("show_seq_annotation_ref_sources")) {
                this.setShowAnnotationRefSource(this.parseBoolean((String)stringTokenizer.nextElement()));
                return;
            }
            if (string.equals("abbreviate_scientific_names")) {
                this.setAbbreviateScientificTaxonNames(this.parseBoolean((String)stringTokenizer.nextElement()));
                return;
            }
            if (string.equals("cladogram_type")) {
                String string16 = ((String)stringTokenizer.nextElement()).trim();
                if (string16.equalsIgnoreCase(Options.CLADOGRAM_TYPE.NON_LINED_UP.toString())) {
                    this.setCladogramType(Options.CLADOGRAM_TYPE.NON_LINED_UP);
                    return;
                }
                if (string16.equalsIgnoreCase(Options.CLADOGRAM_TYPE.LINED_UP.toString())) {
                    this.setCladogramType(Options.CLADOGRAM_TYPE.LINED_UP);
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + string16 + "] for [cladogram_type]");
                return;
            }
            if (string.equals("hide_controls_and_menus")) {
                this._hide_controls_and_menus = this.parseBoolean((String)stringTokenizer.nextElement());
                return;
            }
            if (string.equals("use_tabbed_display")) {
                this._use_tabbed_display = this.parseBoolean((String)stringTokenizer.nextElement());
                return;
            }
            if (string.equals("overview_width")) {
                short s = this.parseShort((String)stringTokenizer.nextElement());
                this.setOvMaxWidth(s);
                return;
            }
            if (string.equals("overview_height")) {
                short s = this.parseShort((String)stringTokenizer.nextElement());
                this.setOvMaxHeight(s);
                return;
            }
            if (string.equals("overview_placement_type")) {
                String string17 = ((String)stringTokenizer.nextElement()).trim();
                if (string17.equalsIgnoreCase(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT.toTag())) {
                    this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT);
                    return;
                }
                if (string17.equalsIgnoreCase(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_RIGHT.toTag())) {
                    this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_RIGHT);
                    return;
                }
                if (string17.equalsIgnoreCase(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_LEFT.toTag())) {
                    this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_LEFT);
                    return;
                }
                if (string17.equalsIgnoreCase(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_RIGHT.toTag())) {
                    this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_RIGHT);
                    return;
                }
                this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT);
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + string17 + "] for [overview_placement_type]");
                return;
            }
            if (string.equals("node_label_direction")) {
                String string18 = ((String)stringTokenizer.nextElement()).trim();
                if (string18.equalsIgnoreCase(Options.NODE_LABEL_DIRECTION.HORIZONTAL.toString())) {
                    this.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.HORIZONTAL);
                    return;
                }
                if (string18.equalsIgnoreCase(Options.NODE_LABEL_DIRECTION.RADIAL.toString())) {
                    this.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.RADIAL);
                    return;
                }
                this.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.HORIZONTAL);
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + string18 + "] for [node_label_direction]");
                return;
            }
            if (string.equals("branch_length_value_digits")) {
                short s = this.parseShort(((String)stringTokenizer.nextElement()).trim());
                if (s >= 0) {
                    this.setNumberOfDigitsAfterCommaForBranchLengthValue(s);
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "illegal value [" + s + "] for [branch_length_value_digits]");
                return;
            }
            if (string.equals("confidence_value_digits")) {
                short s = this.parseShort(((String)stringTokenizer.nextElement()).trim());
                if (s >= 0) {
                    this.setNumberOfDigitsAfterCommaForConfidenceValues(s);
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "illegal value [" + s + "] for [confidence_value_digits]");
                return;
            }
            if (string.equals("allow_editing")) {
                this.setEditable(this.parseBoolean((String)stringTokenizer.nextElement()));
                return;
            }
            if (string.equals("display_sequence_relations")) {
                this.setDisplaySequenceRelations(this.parseBoolean((String)stringTokenizer.nextElement()));
                return;
            }
            if (string.equals("replace_underscores_in_nh_parsing")) {
                boolean bl = this.parseBoolean((String)stringTokenizer.nextElement());
                if (bl && this.getTaxonomyExtraction() != NHXParser.TAXONOMY_EXTRACTION.NO) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "attempt to extract taxonomies and replace underscores at the same time");
                    return;
                }
                this.setReplaceUnderscoresInNhParsing(bl);
                return;
            }
            if (string.equals("taxonomy_extraction_in_nh_parsing")) {
                String string19 = (String)stringTokenizer.nextElement();
                if (string19.equalsIgnoreCase("no")) {
                    this.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.NO);
                } else if (string19.equalsIgnoreCase("pfam_relaxed")) {
                    this.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_RELAXED);
                } else if (string19.equalsIgnoreCase("pfam_strict")) {
                    this.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_STRICT);
                } else if (string19.equalsIgnoreCase("aggressive")) {
                    this.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
                } else {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value for \"taxonomy_extraction_in_nh_parsing\": " + string19 + " (must be either: no, pfam_relaxed, pfam_strict, or aggressive)");
                }
                if (this.getTaxonomyExtraction() == NHXParser.TAXONOMY_EXTRACTION.NO) return;
                if (!this.isReplaceUnderscoresInNhParsing()) return;
                ForesterUtil.printWarningMessage("Archaeopteryx", "attempt to extract taxonomies and replace underscores at the same time");
                return;
            }
            if (string.equals("internal_labels_are_confidence_values")) {
                this.setInternalNumberAreConfidenceForNhParsing(this.parseBoolean((String)stringTokenizer.nextElement()));
                return;
            }
            if (string.equals("gui_background_color")) {
                this._gui_background_color = Color.decode((String)stringTokenizer.nextElement());
                return;
            }
            if (string.equals("gui_checkbox_text_color")) {
                this._gui_checkbox_text_color = Color.decode((String)stringTokenizer.nextElement());
                return;
            }
            if (string.equals("gui_checkbox_and_button_active_color")) {
                this._gui_checkbox_and_button_active_color = Color.decode((String)stringTokenizer.nextElement());
                return;
            }
            if (string.equals("gui_button_text_color")) {
                this._gui_button_text_color = Color.decode((String)stringTokenizer.nextElement());
                return;
            }
            if (string.equals("gui_button_background_color")) {
                this._gui_button_background_color = Color.decode((String)stringTokenizer.nextElement());
                return;
            }
            if (string.equals("gui_menu_background_color")) {
                this._gui_menu_background_color = Color.decode((String)stringTokenizer.nextElement());
                return;
            }
            if (string.equals("gui_menu_text_color")) {
                this._gui_menu_text_color = Color.decode((String)stringTokenizer.nextElement());
                return;
            }
            if (string.equals("gui_button_border_color")) {
                this._gui_button_border_color = Color.decode((String)stringTokenizer.nextElement());
                return;
            }
            if (string.equals("show_default_node_shapes_internal")) {
                this.setShowDefaultNodeShapesInternal(this.parseBoolean(((String)stringTokenizer.nextElement()).trim()));
                return;
            }
            if (string.equals("show_default_node_shapes_external")) {
                this.setShowDefaultNodeShapesExternal(this.parseBoolean(((String)stringTokenizer.nextElement()).trim()));
                return;
            }
            if (string.equals("show_node_shapes_for_nodes_with_vis_data")) {
                this.setShowDefaultNodeShapesForMarkedNodes(this.parseBoolean(((String)stringTokenizer.nextElement()).trim()));
                return;
            }
            if (string.equals("default_node_size")) {
                short s = this.parseShort(((String)stringTokenizer.nextElement()).trim());
                this.setDefaultNodeShapeSize(s);
                return;
            }
            if (string.equals("default_node_fill")) {
                String string20 = ((String)stringTokenizer.nextElement()).trim();
                if (string20.equalsIgnoreCase(NodeVisualData.NodeFill.NONE.toString())) {
                    this.setDefaultNodeFill(NodeVisualData.NodeFill.NONE);
                    return;
                }
                if (string20.equalsIgnoreCase(NodeVisualData.NodeFill.GRADIENT.toString())) {
                    this.setDefaultNodeFill(NodeVisualData.NodeFill.GRADIENT);
                    return;
                }
                if (string20.equalsIgnoreCase(NodeVisualData.NodeFill.SOLID.toString())) {
                    this.setDefaultNodeFill(NodeVisualData.NodeFill.SOLID);
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + string20 + "] for [default_node_fill]");
                return;
            }
            if (string.equals("default_node_shape")) {
                String string21 = ((String)stringTokenizer.nextElement()).trim();
                if (string21.equalsIgnoreCase(NodeVisualData.NodeShape.CIRCLE.toString())) {
                    this.setDefaultNodeShape(NodeVisualData.NodeShape.CIRCLE);
                    return;
                }
                if (string21.equalsIgnoreCase(NodeVisualData.NodeShape.RECTANGLE.toString())) {
                    this.setDefaultNodeShape(NodeVisualData.NodeShape.RECTANGLE);
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + string21 + "] for [default_node_shape]");
                return;
            }
            if (string.equals("midpoint_reroot")) {
                this.setMidpointReroot(this.parseBoolean((String)stringTokenizer.nextElement()));
                return;
            }
            if (string.equals("list_node_data_field") || string.equals("ext_descendents_data_to_return")) {
                String string22 = ((String)stringTokenizer.nextElement()).trim();
                if (string22.equalsIgnoreCase("node_name")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.NODE_NAME);
                    return;
                }
                if (string22.equalsIgnoreCase("sequence_acc")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.SEQUENCE_ACC);
                    return;
                }
                if (string22.equalsIgnoreCase("sequence_mol_seq_fasta")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.SEQUENCE_MOL_SEQ_FASTA);
                    return;
                }
                if (string22.equalsIgnoreCase("sequence_name")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.SEQUENCE_NAME);
                    return;
                }
                if (string22.equalsIgnoreCase("gene_name")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.GENE_NAME);
                    return;
                }
                if (string22.equalsIgnoreCase("sequence_symbol")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.SEQUENCE_SYMBOL);
                    return;
                }
                if (string22.equalsIgnoreCase("taxonomy_scientific_name")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.TAXONOMY_SCIENTIFIC_NAME);
                    return;
                }
                if (string22.equalsIgnoreCase("taxonomy_code")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.TAXONOMY_CODE);
                    return;
                }
                if (string22.equalsIgnoreCase("user_selected")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.UNKNOWN);
                    return;
                }
                if (string22.equalsIgnoreCase("domains")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.DOMAINS_ALL);
                    return;
                }
                if (string22.equalsIgnoreCase("domains_collapsed")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.DOMAINS_COLLAPSED_PER_PROTEIN);
                    return;
                }
                if (string22.equalsIgnoreCase("seq_annotations")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.SEQ_ANNOTATIONS);
                    return;
                }
                if (string22.equalsIgnoreCase("go_term_ids")) {
                    this.setExtDescNodeDataToReturn(NodeDataField.GO_TERM_IDS);
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + string22 + "] for [ext_descendents_data_to_return]");
                return;
            }
            if (string.equals("list_node_data_custom_label") || string.equals("label_for_get_ext_descendents_data")) {
                String string23 = ((String)stringTokenizer.nextElement()).trim();
                if (ForesterUtil.isEmpty(string23)) return;
                if (string23.length() <= 1) return;
                this.setLabelForGetExtDescendentsData(string23.replaceAll("_", " "));
                return;
            }
            if (string.equals("list_node_data_in") || string.equals("ext_descendents_data_to_return_on")) {
                String string24 = ((String)stringTokenizer.nextElement()).trim().toLowerCase();
                if (string24.equals("console")) {
                    this.setExtNodeDataReturnOn(EXT_NODE_DATA_RETURN_ON.CONSOLE);
                    return;
                }
                if (string24.equals("window")) {
                    this.setExtNodeDataReturnOn(EXT_NODE_DATA_RETURN_ON.WINODW);
                    return;
                }
                if (string24.equals("buffer_only")) {
                    this.setExtNodeDataReturnOn(EXT_NODE_DATA_RETURN_ON.BUFFER_ONLY);
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + string24 + "] for [ext_descendents_data_to_return_on]");
                return;
            }
            if (string.equals("vector_data_min_color")) {
                this._vector_data_min_color = Color.decode((String)stringTokenizer.nextElement());
                return;
            }
            if (string.equals("vector_data_max_color")) {
                this._vector_data_max_color = Color.decode((String)stringTokenizer.nextElement());
                return;
            }
            if (string.equals("vector_data_mean_color")) {
                this._vector_data_mean_color = Color.decode((String)stringTokenizer.nextElement());
                return;
            }
            if (string.equals("vector_data_width")) {
                this._vector_data_width = this.parseShort((String)stringTokenizer.nextElement());
                if (this._vector_data_width >= 1) return;
                this._vector_data_width = 120;
                return;
            }
            if (string.equals("vector_data_height")) {
                this._vector_data_height = this.parseShort((String)stringTokenizer.nextElement());
                if (!(this._vector_data_height < 1.0)) return;
                this._vector_data_height = 12.0;
                return;
            }
            if (string.equals("line_up_renderable_data")) {
                this.setLineUpRendarableNodeData(this.parseBoolean((String)stringTokenizer.nextElement()));
                return;
            }
            if (string.equals("right_align_domain_architectures")) {
                this.setRightLineUpDomains(this.parseBoolean((String)stringTokenizer.nextElement()));
                return;
            }
            if (string.equals("allow_thick_strokes")) {
                this._allow_thick_strokes = this.parseBoolean((String)stringTokenizer.nextElement());
                return;
            }
            if (stringTokenizer.countTokens() >= 2) {
                int n = -1;
                if (string.equals("phylogram")) {
                    n = 0;
                } else if (string.equals("rollover")) {
                    n = 21;
                } else if (string.equals("color_according_to_species")) {
                    n = 6;
                } else if (string.equals("color_according_to_sequence")) {
                    n = 7;
                } else if (string.equals("show_node_names")) {
                    n = 1;
                } else if (string.equals("show_taxonomy_code")) {
                    n = 2;
                } else if (string.equals("show_taxonomy_rank")) {
                    n = 29;
                } else if (string.equals("write_confidence_values")) {
                    n = 4;
                } else if (string.equals("write_branch_length_values")) {
                    n = 28;
                } else if (string.equals("write_events")) {
                    n = 5;
                } else if (string.equals("use_visual_styles")) {
                    n = 8;
                } else if (string.equals("color_branches")) {
                    n = 8;
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [color_branches] is deprecated, use [use_visual_styles] instead");
                } else if (string.equals("width_branches")) {
                    n = 9;
                } else if (string.equals("show_domain_architectures")) {
                    n = 10;
                } else if (string.equals("show_msa")) {
                    n = 27;
                } else if (string.equals("show_annotations")) {
                    n = 3;
                } else if (string.equals("show_binary_characters")) {
                    n = 11;
                } else if (string.equals("show_binary_character_counts")) {
                    n = 12;
                } else if (string.equals("show_seq_names")) {
                    n = 13;
                } else if (string.equals("show_gene_names")) {
                    n = 26;
                } else if (string.equals("show_seq_symbols")) {
                    n = 20;
                } else if (string.equals("show_seq_acc")) {
                    n = 14;
                } else if (string.equals("display_internal_data")) {
                    n = 15;
                } else if (string.equals("display_external_data")) {
                    n = 30;
                } else if (string.equals("dynamically_hide_data")) {
                    n = 16;
                } else if (string.equals("show_taxonomy_scientific_names")) {
                    n = 17;
                } else if (string.equals("show_taxonomy_common_names")) {
                    n = 18;
                } else if (string.equals("show_taxonomy_images")) {
                    n = 24;
                } else if (string.equals("color_according_to_annotation")) {
                    n = 19;
                } else if (string.equals("show_vector_data")) {
                    n = 23;
                } else if (string.equals("show_properties")) {
                    n = 25;
                } else if (string.equals("show_relation_confidence")) {
                    n = 22;
                }
                if (n >= 0) {
                    Configuration.display_options[n][1] = (String)stringTokenizer.nextElement();
                    Configuration.display_options[n][2] = (String)stringTokenizer.nextElement();
                    return;
                }
                if (n == -2) {
                    return;
                }
                if (string.equals("click_to")) {
                    String string25 = (String)stringTokenizer.nextElement();
                    n = this.getClickToIndex(string25);
                    if (n >= 0) {
                        Configuration.clickto_options[n][1] = (String)stringTokenizer.nextElement();
                        return;
                    }
                    if (n == -2) {
                        return;
                    }
                    ForesterUtil.printWarningMessage("Archaeopteryx", "unknown click-to option: " + string25);
                    return;
                }
                if (string.equals("species_color")) {
                    this.getSpeciesColors().put(((String)stringTokenizer.nextElement()).replace('_', ' '), Color.decode((String)stringTokenizer.nextElement()));
                    return;
                }
                if (string.equals("sequence_color")) {
                    this.getSequenceColors().put(((String)stringTokenizer.nextElement()).replace('_', ' '), Color.decode((String)stringTokenizer.nextElement()));
                    return;
                }
                if (string.equals("domain_color")) {
                    this.getDomainColors().put((String)stringTokenizer.nextElement(), Color.decode((String)stringTokenizer.nextElement()));
                    return;
                }
                if (string.equals("annotation_color")) {
                    this.getAnnotationColors().put((String)stringTokenizer.nextElement(), Color.decode((String)stringTokenizer.nextElement()));
                    return;
                }
                if (string.equals("function_color")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [function_color] is deprecated");
                    return;
                }
                if (string.equals(DISPLAY_COLOR_KEY)) {
                    this.putDisplayColors((String)stringTokenizer.nextElement(), Color.decode((String)stringTokenizer.nextElement()));
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown configuration key [" + string + "] in: " + this.config_filename);
                return;
            }
            ForesterUtil.printWarningMessage("Archaeopteryx", "unknown configuration key [" + string + "] in: " + this.config_filename);
        }
    }

    private void setLabelForGetExtDescendentsData(String string) {
        this._label_for_get_ext_descendents_data = string;
    }

    private void setMaxBaseFontSize(int n) {
        this._max_base_font_size = n;
    }

    private void setMinBaseFontSize(int n) {
        this._min_base_font_size = n;
    }

    private void setOvMaxHeight(short s) {
        this._ov_max_height = s;
    }

    private void setOvMaxWidth(short s) {
        this._ov_max_width = s;
    }

    private void setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE oVERVIEW_PLACEMENT_TYPE) {
        this._ov_placement = oVERVIEW_PLACEMENT_TYPE;
    }

    private void setPathToLocalFastme(File file) {
        this._path_to_local_fastme = file;
    }

    private void setPathToLocalMafft(File file) {
        this._path_to_local_mafft = file;
    }

    private void setPathToLocalRaxml(File file) {
        this._path_to_local_raxml = file;
    }

    private void setShowAnnotationRefSource(boolean bl) {
        this._show_annotation_ref_source = bl;
    }

    private void setShowOverview(boolean bl) {
        this._show_overview = bl;
    }

    private void setValidatePhyloXmlAgainstSchema(boolean bl) {
        this._validate_against_phyloxml_xsd_schema = bl;
    }

    boolean displaySequenceRelations() {
        return this._display_sequence_relations;
    }

    boolean doCheckOption(int n) {
        return display_options[n][2].equalsIgnoreCase("yes") || display_options[n][2].equalsIgnoreCase("true");
    }

    boolean doDisplayClickToOption(int n) {
        return clickto_options[n][1].equalsIgnoreCase("display");
    }

    boolean doDisplayOption(int n) {
        return display_options[n][1].equalsIgnoreCase("display");
    }

    boolean doGuessCheckOption(int n) {
        return display_options[n][2].equals("?");
    }

    Map<String, Color> getAnnotationColors() {
        if (_annotation_colors == null) {
            _annotation_colors = new Hashtable();
        }
        return _annotation_colors;
    }

    int getBaseFontSize() {
        return this._base_font_size;
    }

    Options.CLADOGRAM_TYPE getCladogramType() {
        return this._cladogram_type;
    }

    int getClickToOptionsCount() {
        return clickto_options.length;
    }

    String getClickToTitle(int n) {
        return clickto_options[n][0];
    }

    int getDefaultDisplayClicktoOption() {
        return this.default_clickto;
    }

    SortedMap<String, Color> getDisplayColors() {
        return this._display_colors;
    }

    String getDisplayTitle(int n) {
        return display_options[n][0];
    }

    Map<String, Color> getDomainColors() {
        if (_domain_colors == null) {
            _domain_colors = new Hashtable();
        }
        return _domain_colors;
    }

    Color getGuiBackgroundColor() {
        return this._gui_background_color;
    }

    Color getGuiButtonBackgroundColor() {
        return this._gui_button_background_color;
    }

    Color getGuiButtonBorderColor() {
        return this._gui_button_border_color;
    }

    Color getGuiButtonTextColor() {
        return this._gui_button_text_color;
    }

    Color getGuiCheckboxAndButtonActiveColor() {
        return this._gui_checkbox_and_button_active_color;
    }

    Color getGuiCheckboxTextColor() {
        return this._gui_checkbox_text_color;
    }

    Color getGuiMenuBackgroundColor() {
        return this._gui_menu_background_color;
    }

    Color getGuiMenuTextColor() {
        return this._gui_menu_text_color;
    }

    static int getGuiFontSize() {
        return 11;
    }

    int getMaxBaseFontSize() {
        return this._max_base_font_size;
    }

    int getMinBaseFontSize() {
        return this._min_base_font_size;
    }

    double getMinConfidenceValue() {
        return this._min_confidence_value;
    }

    Options.NODE_LABEL_DIRECTION getNodeLabelDirection() {
        return this._node_label_direction;
    }

    short getNumberOfDigitsAfterCommaForBranchLengthValues() {
        return this._number_of_digits_after_comma_for_branch_length_values;
    }

    short getNumberOfDigitsAfterCommaForConfidenceValues() {
        return this._number_of_digits_after_comma_for_confidence_values;
    }

    short getOvMaxHeight() {
        return this._ov_max_height;
    }

    short getOvMaxWidth() {
        return this._ov_max_width;
    }

    Options.OVERVIEW_PLACEMENT_TYPE getOvPlacement() {
        return this._ov_placement;
    }

    Options.PHYLOGENY_GRAPHICS_TYPE getPhylogenyGraphicsType() {
        return this._phylogeny_graphics_type;
    }

    float getPrintLineWidth() {
        return this._print_line_width;
    }

    Hashtable<String, Color> getSequenceColors() {
        if (_sequence_colors == null) {
            _sequence_colors = new Hashtable();
        }
        return _sequence_colors;
    }

    Hashtable<String, Color> getSpeciesColors() {
        if (_species_colors == null) {
            this.initSpeciesColors();
        }
        return _species_colors;
    }

    final NHXParser.TAXONOMY_EXTRACTION getTaxonomyExtraction() {
        return this._taxonomy_extraction;
    }

    boolean isAntialiasScreen() {
        return this._antialias_screen;
    }

    boolean isDrawAsPhylogram() {
        return this.doCheckOption(0);
    }

    boolean isEditable() {
        return this._editable;
    }

    boolean isHideControlPanelAndMenubar() {
        return this._hide_controls_and_menus;
    }

    boolean isInternalNumberAreConfidenceForNhParsing() {
        return this._internal_number_are_confidence_for_nh_parsing;
    }

    boolean isReplaceUnderscoresInNhParsing() {
        return this._nh_parsing_replace_underscores;
    }

    boolean isShowOverview() {
        return this._show_overview;
    }

    boolean isShowScale() {
        return this._show_scale;
    }

    final boolean isUseNativeUI() {
        if (this._ui == UI.UNKNOWN && ForesterUtil.isMac()) {
            this._ui = UI.NATIVE;
        }
        return this._ui == UI.NATIVE;
    }

    boolean isUseTabbedDisplay() {
        return this._use_tabbed_display;
    }

    boolean isValidatePhyloXmlAgainstSchema() {
        return this._validate_against_phyloxml_xsd_schema;
    }

    final void setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION) {
        this._taxonomy_extraction = tAXONOMY_EXTRACTION;
    }

    static String getDefaultFontFamilyName() {
        return DEFAULT_FONT_FAMILY;
    }

    public boolean isCouldReadConfigFile() {
        return this._could_read_config_file;
    }

    static {
        DEFAULT_FONT_FAMILY = "";
        for (String string : AptxConstants.DEFAULT_FONT_CHOICES) {
            if (Arrays.binarySearch(AptxUtil.getAvailableFontFamiliesSorted(), string) < 0) continue;
            DEFAULT_FONT_FAMILY = string;
            break;
        }
        if (ForesterUtil.isEmpty(DEFAULT_FONT_FAMILY)) {
            DEFAULT_FONT_FAMILY = AptxConstants.DEFAULT_FONT_CHOICES[AptxConstants.DEFAULT_FONT_CHOICES.length - 1];
        }
    }

    static enum TRIPLET {
        FALSE,
        TRUE,
        UNKNOWN;

    }

    public static enum UI {
        CROSSPLATFORM,
        NATIVE,
        NIMBUS,
        UNKNOWN;

    }

    public static enum EXT_NODE_DATA_RETURN_ON {
        BUFFER_ONLY,
        CONSOLE,
        WINODW;

    }
}

