/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.swing.JOptionPane;
import javax.swing.text.MaskFormatter;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.ControlPanel;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreePanel;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.tol.TolParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.AsciiHistogram;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;
import org.forester.util.TaxonomyUtil;

public final class AptxUtil {
    private static final String[] AVAILABLE_FONT_FAMILIES_SORTED = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();

    public static final Color calculateColorFromString(String string, boolean bl) {
        String string2 = string.toUpperCase();
        char c = string2.charAt(0);
        int n = 32;
        int n2 = 32;
        if (string2.length() > 1) {
            n = bl ? string2.charAt(1) : string2.charAt(string2.length() - 1);
            if (bl) {
                if (string2.length() > 2) {
                    n2 = string2.indexOf(" ") > 0 ? string2.charAt(string2.indexOf(" ") + 1) : string2.charAt(2);
                }
            } else if (string2.length() > 2) {
                n2 = string2.charAt((string2.length() - 1) / 2);
            }
        }
        c = AptxUtil.normalizeCharForRGB(c);
        n = AptxUtil.normalizeCharForRGB((char)n);
        n2 = AptxUtil.normalizeCharForRGB((char)n2);
        if (c > '\u00c8' && n > 200 && n2 > 200) {
            c = '\u0000';
        } else if (c < '<' && n < 60 && n2 < 60) {
            n = 255;
        } else if (Math.abs(c - n) < 40 && Math.abs(n - n2) < 40) {
            n2 = 255;
        }
        return new Color(c, n, n2);
    }

    public static MaskFormatter createMaskFormatter(String string) {
        MaskFormatter maskFormatter = null;
        try {
            maskFormatter = new MaskFormatter(string);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException);
        }
        return maskFormatter;
    }

    public static final boolean isHasAtLeastNodeWithEvent(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            if (!phylogenyNodeIterator.next().getNodeData().isHasEvent()) continue;
            return true;
        }
        return false;
    }

    public static final boolean isHasAtLeastOneBranchLengthLargerThanZero(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            if (!(phylogenyNodeIterator.next().getDistanceToParent() > 0.0)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isHasAtLeast50PercentBranchLengthLargerThanZero(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        int n = 0;
        int n2 = 0;
        while (phylogenyNodeIterator.hasNext()) {
            if (phylogenyNodeIterator.next().getDistanceToParent() > 0.0) {
                ++n;
            }
            ++n2;
        }
        if (n2 == 0) {
            return false;
        }
        return (double)n / (double)n2 >= 0.5;
    }

    public static final boolean isHasNoBranchLengthSmallerThanZero(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!(phylogenyNode.getDistanceToParent() < 0.0) || phylogenyNode.isRoot()) continue;
            return false;
        }
        return true;
    }

    public static final boolean isHasAtLeastOneBranchWithSupportSD(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getBranchData().isHasConfidences()) continue;
            List<Confidence> list = phylogenyNode.getBranchData().getConfidences();
            for (Confidence confidence : list) {
                if (!(confidence.getStandardDeviation() > 0.0)) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean isHasAtLeastOneBranchWithSupportValues(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            if (!phylogenyNodeIterator.next().getBranchData().isHasConfidences()) continue;
            return true;
        }
        return false;
    }

    public static final boolean isHasAtLeastOneNodeWithScientificName(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName())) continue;
            return true;
        }
        return false;
    }

    public static final boolean isHasAtLeastOneNodeWithSequenceAnnotation(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasSequence() || ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAnnotations())) continue;
            return true;
        }
        return false;
    }

    public static final void launchWebBrowser(URI uRI, String string) throws IOException {
        try {
            AptxUtil.openUrlInWebBrowser(uRI.toString());
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public static Set<Taxonomy> obtainAllDistinctTaxonomies(PhylogenyNode phylogenyNode) {
        List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
        HashSet<Taxonomy> hashSet = new HashSet<Taxonomy>();
        for (PhylogenyNode phylogenyNode2 : list) {
            if (!phylogenyNode2.getNodeData().isHasTaxonomy() || phylogenyNode2.getNodeData().getTaxonomy().isEmpty()) continue;
            hashSet.add(phylogenyNode2.getNodeData().getTaxonomy());
        }
        return hashSet;
    }

    public static final void printWarningMessage(String string, String string2) {
        System.out.println("[" + string + "] > " + string2);
    }

    public static final Phylogeny[] readPhylogeniesFromUrl(URL uRL, boolean bl, boolean bl2, boolean bl3, NHXParser.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION, boolean bl4) throws FileNotFoundException, IOException {
        PhylogenyParser phylogenyParser;
        PhylogenyParser phylogenyParser2;
        boolean bl5 = false;
        if (uRL.getHost().toLowerCase().indexOf("tolweb") >= 0) {
            phylogenyParser2 = new TolParser();
        } else {
            phylogenyParser2 = ParserUtils.createParserDependingOnUrlContents(uRL, bl);
            if (phylogenyParser2 instanceof NHXParser) {
                bl5 = true;
                phylogenyParser = (NHXParser)phylogenyParser2;
                ((NHXParser)phylogenyParser).setReplaceUnderscores(bl2);
                ((NHXParser)phylogenyParser).setIgnoreQuotes(false);
                ((NHXParser)phylogenyParser).setTaxonomyExtraction(tAXONOMY_EXTRACTION);
            } else if (phylogenyParser2 instanceof NexusPhylogeniesParser) {
                bl5 = true;
                phylogenyParser = (NexusPhylogeniesParser)phylogenyParser2;
                ((NexusPhylogeniesParser)phylogenyParser).setReplaceUnderscores(bl2);
                ((NexusPhylogeniesParser)phylogenyParser).setIgnoreQuotes(false);
            }
        }
        AptxUtil.printAppletMessage("Archaeopteryx", "parser is " + phylogenyParser2.getName());
        phylogenyParser = null;
        try {
            phylogenyParser = ForesterUtil.readPhylogeniesFromUrl(uRL, phylogenyParser2);
        }
        catch (KeyManagementException keyManagementException) {
            throw new IOException(keyManagementException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException(noSuchAlgorithmException.getMessage());
        }
        if (phylogenyParser != null) {
            if (bl5 && bl3) {
                for (PhylogenyParser phylogenyParser3 : phylogenyParser) {
                    PhylogenyMethods.transferInternalNodeNamesToConfidence((Phylogeny)((Object)phylogenyParser3), "");
                }
            }
            if (bl4) {
                for (PhylogenyParser phylogenyParser3 : phylogenyParser) {
                    PhylogenyMethods.midpointRoot((Phylogeny)((Object)phylogenyParser3));
                    PhylogenyMethods.orderAppearance(((Phylogeny)((Object)phylogenyParser3)).getRoot(), true, true, PhylogenyMethods.DESCENDANT_SORT_PRIORITY.NODE_NAME);
                }
            }
        }
        return phylogenyParser;
    }

    public static final void showErrorMessage(Component component, String string) {
        AptxUtil.printAppletMessage("Archaeopteryx", string);
        JOptionPane.showMessageDialog(component, string, "[Archaeopteryx 0.9928 beta] Error", 0);
    }

    public static void writePhylogenyToGraphicsFile(File file, File file2, int n, int n2, GraphicsExportType graphicsExportType, Configuration configuration) throws IOException {
        PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
        Phylogeny[] phylogenyArray = null;
        phylogenyArray = PhylogenyMethods.readPhylogenies(phylogenyParser, file);
        AptxUtil.writePhylogenyToGraphicsFile(phylogenyArray[0], file2, n, n2, graphicsExportType, configuration);
    }

    public static void writePhylogenyToGraphicsFile(Phylogeny phylogeny, File file, int n, int n2, GraphicsExportType graphicsExportType, Configuration configuration) throws IOException {
        Phylogeny[] phylogenyArray = new Phylogeny[]{phylogeny};
        MainFrameApplication mainFrameApplication = MainFrameApplication.createInstance(phylogenyArray, configuration);
        AptxUtil.writePhylogenyToGraphicsFileNonInteractive(file, n, n2, mainFrameApplication.getMainPanel().getCurrentTreePanel(), mainFrameApplication.getMainPanel().getControlPanel(), graphicsExportType, mainFrameApplication.getOptions());
        mainFrameApplication.end();
    }

    public static final void writePhylogenyToGraphicsFileNonInteractive(File file, int n, int n2, TreePanel treePanel, ControlPanel controlPanel, GraphicsExportType graphicsExportType, Options options) throws IOException {
        treePanel.calcParametersForPainting(n, n2);
        treePanel.resetPreferredSize();
        treePanel.repaint();
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        if (options.isAntialiasPrint()) {
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Phylogeny phylogeny = treePanel.getPhylogeny();
        if (phylogeny == null || phylogeny.isEmpty()) {
            return;
        }
        if (file.isDirectory()) {
            throw new IOException("\"" + file + "\" is a directory");
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHints(renderingHints);
        treePanel.paintPhylogeny(graphics2D, false, true, n, n2, 0, 0);
        if (graphicsExportType == GraphicsExportType.TIFF) {
            AptxUtil.writeToTiff(file, bufferedImage);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, graphicsExportType.toString(), file);
        }
        graphics2D.dispose();
    }

    private static final char normalizeCharForRGB(char c) {
        c = (char)(c - 65);
        c = (char)((c = (char)((double)c * 10.2)) > '\u00ff' ? 255 : (int)c);
        c = c < '\u0000' ? (char)'\u0000' : c;
        return c;
    }

    private static final void openUrlInWebBrowser(String string) throws IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, InterruptedException {
        String string2 = System.getProperty("os.name");
        Runtime runtime = Runtime.getRuntime();
        if (string2.toLowerCase().startsWith("win")) {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + string);
        } else if (ForesterUtil.isMac()) {
            Class<?> clazz = Class.forName("com.apple.eio.FileManager");
            Method method = clazz.getDeclaredMethod("openURL", String.class);
            method.invoke(null, string);
        } else {
            String[] stringArray = new String[]{"firefox", "opera", "konqueror", "mozilla", "netscape", "epiphany"};
            String string3 = null;
            for (int i = 0; i < stringArray.length && string3 == null; ++i) {
                if (runtime.exec(new String[]{"which", stringArray[i]}).waitFor() != 0) continue;
                string3 = stringArray[i];
            }
            if (string3 == null) {
                throw new IOException("could not find a web browser to open [" + string + "] in");
            }
            runtime.exec(new String[]{string3, string});
        }
    }

    static final void addPhylogeniesToTabs(Phylogeny[] phylogenyArray, String string, String string2, Configuration configuration, MainPanel mainPanel) {
        if (phylogenyArray.length > 100) {
            JOptionPane.showMessageDialog(mainPanel, "Attempt to load " + phylogenyArray.length + " phylogenies,\ngoing to load only the first " + 100, "Archaeopteryx more than 100 phylogenies", 2);
        }
        int n = 1;
        for (Phylogeny phylogeny : phylogenyArray) {
            CharSequence charSequence;
            if (phylogeny.isEmpty() || n > 100) continue;
            String string3 = "";
            String string4 = "";
            if (phylogenyArray.length > 1) {
                if (!ForesterUtil.isEmpty(string)) {
                    string3 = new String(string);
                }
                if (!ForesterUtil.isEmpty(string2)) {
                    string4 = new String(string2);
                } else if (!ForesterUtil.isEmpty(string)) {
                    string4 = new String(string);
                }
                charSequence = "";
                if (string4.indexOf(46) > 0) {
                    charSequence = string4.substring(string4.lastIndexOf(46), string4.length());
                    string4 = string4.substring(0, string4.lastIndexOf(46));
                }
                if (!ForesterUtil.isEmpty(string4)) {
                    string4 = string4 + "_";
                }
                if (!ForesterUtil.isEmpty(phylogeny.getName())) {
                    string4 = string4 + phylogeny.getName().replaceAll(" ", "_");
                } else if (phylogeny.getIdentifier() != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    if (!ForesterUtil.isEmpty(phylogeny.getIdentifier().getProvider())) {
                        stringBuffer.append(phylogeny.getIdentifier().getProvider());
                        stringBuffer.append("_");
                    }
                    stringBuffer.append(phylogeny.getIdentifier().getValue());
                    string4 = string4 + stringBuffer;
                } else {
                    string4 = string4 + n;
                }
                if (!ForesterUtil.isEmpty(string3) && ForesterUtil.isEmpty(phylogeny.getName()) && phylogeny.getIdentifier() == null) {
                    string3 = string3 + " [" + n + "]";
                }
                if (!ForesterUtil.isEmpty((String)charSequence)) {
                    string4 = string4 + (String)charSequence;
                }
            } else {
                if (!ForesterUtil.isEmpty(string)) {
                    string3 = new String(string);
                }
                string4 = "";
                if (!ForesterUtil.isEmpty(string2)) {
                    string4 = new String(string2);
                } else if (!ForesterUtil.isEmpty(string)) {
                    string4 = new String(string);
                }
                if (ForesterUtil.isEmpty(string4)) {
                    if (!ForesterUtil.isEmpty(phylogeny.getName())) {
                        string4 = new String(phylogeny.getName()).replaceAll(" ", "_");
                    } else if (phylogeny.getIdentifier() != null) {
                        charSequence = new StringBuffer();
                        if (!ForesterUtil.isEmpty(phylogeny.getIdentifier().getProvider())) {
                            ((StringBuffer)charSequence).append(phylogeny.getIdentifier().getProvider());
                            ((StringBuffer)charSequence).append("_");
                        }
                        ((StringBuffer)charSequence).append(phylogeny.getIdentifier().getValue());
                        string4 = new String(((StringBuffer)charSequence).toString().replaceAll(" ", "_"));
                    }
                }
            }
            mainPanel.addPhylogenyInNewTab(phylogeny, configuration, string3, string2);
            mainPanel.getCurrentTreePanel().setTreeFile(new File(string4));
            AptxUtil.lookAtSomeTreePropertiesForAptxControlSettings(phylogeny, mainPanel.getControlPanel(), configuration);
            ++n;
        }
    }

    static final void addPhylogenyToPanel(Phylogeny[] phylogenyArray, Configuration configuration, MainPanel mainPanel) {
        Phylogeny phylogeny = phylogenyArray[0];
        mainPanel.addPhylogenyInPanel(phylogeny, configuration);
        AptxUtil.lookAtSomeTreePropertiesForAptxControlSettings(phylogeny, mainPanel.getControlPanel(), configuration);
    }

    static final boolean canWriteFormat(String string) {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        return iterator.hasNext();
    }

    static final String createBasicInformation(Phylogeny phylogeny, File file) {
        StringBuilder stringBuilder = new StringBuilder();
        if (phylogeny != null && !phylogeny.isEmpty()) {
            DescriptiveStatistics descriptiveStatistics;
            String string = null;
            if (file != null) {
                try {
                    string = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!ForesterUtil.isEmpty(string)) {
                    stringBuilder.append("Path: ");
                    stringBuilder.append(string);
                    stringBuilder.append("\n");
                }
            }
            if (!ForesterUtil.isEmpty(phylogeny.getName())) {
                stringBuilder.append("Name: ");
                stringBuilder.append(phylogeny.getName());
                stringBuilder.append("\n");
            }
            if (phylogeny.getIdentifier() != null) {
                stringBuilder.append("Id: ");
                stringBuilder.append(phylogeny.getIdentifier().toString());
                stringBuilder.append("\n");
            }
            if (!ForesterUtil.isEmpty(phylogeny.getDescription())) {
                stringBuilder.append("Description: ");
                stringBuilder.append(phylogeny.getDescription());
                stringBuilder.append("\n");
            }
            if (!ForesterUtil.isEmpty(phylogeny.getDistanceUnit())) {
                stringBuilder.append("Distance Unit: ");
                stringBuilder.append(phylogeny.getDistanceUnit());
                stringBuilder.append("\n");
            }
            if (!ForesterUtil.isEmpty(phylogeny.getType())) {
                stringBuilder.append("Type: ");
                stringBuilder.append(phylogeny.getType());
                stringBuilder.append("\n");
            }
            stringBuilder.append("Rooted: ");
            stringBuilder.append(phylogeny.isRooted());
            stringBuilder.append("\n");
            stringBuilder.append("Rerootable: ");
            stringBuilder.append(phylogeny.isRerootable());
            stringBuilder.append("\n");
            stringBuilder.append("Nodes: ");
            stringBuilder.append(phylogeny.getNodeCount());
            stringBuilder.append("\n");
            stringBuilder.append("External nodes: ");
            stringBuilder.append(phylogeny.getNumberOfExternalNodes());
            stringBuilder.append("\n");
            stringBuilder.append("Internal nodes: ");
            stringBuilder.append(phylogeny.getNodeCount() - phylogeny.getNumberOfExternalNodes());
            stringBuilder.append("\n");
            stringBuilder.append("Internal nodes with polytomies: ");
            stringBuilder.append(PhylogenyMethods.countNumberOfPolytomies(phylogeny));
            stringBuilder.append("\n");
            stringBuilder.append("Branches: ");
            stringBuilder.append(phylogeny.getNumberOfBranches());
            stringBuilder.append("\n");
            stringBuilder.append("Depth: ");
            stringBuilder.append(PhylogenyMethods.calculateMaxDepth(phylogeny));
            stringBuilder.append("\n");
            stringBuilder.append("Maximum distance to root: ");
            stringBuilder.append(ForesterUtil.round(PhylogenyMethods.calculateMaxDistanceToRoot(phylogeny), 6));
            stringBuilder.append("\n");
            Set<Taxonomy> set = AptxUtil.obtainAllDistinctTaxonomies(phylogeny.getRoot());
            if (set != null) {
                stringBuilder.append("Distinct external taxonomies: ");
                stringBuilder.append(set.size());
            }
            for (Taxonomy object2 : set) {
                System.out.println(object2.toString());
            }
            stringBuilder.append("\n");
            DescriptiveStatistics descriptiveStatistics2 = PhylogenyMethods.calculateBranchLengthStatistics(phylogeny);
            if (descriptiveStatistics2.getN() > 3) {
                stringBuilder.append("\n");
                stringBuilder.append("Branch-length statistics: ");
                stringBuilder.append("\n");
                stringBuilder.append("    Number of branches with non-negative branch-lengths: " + descriptiveStatistics2.getN());
                stringBuilder.append("\n");
                stringBuilder.append("    Median: " + ForesterUtil.round(descriptiveStatistics2.median(), 6));
                stringBuilder.append("\n");
                stringBuilder.append("    Mean: " + ForesterUtil.round(descriptiveStatistics2.arithmeticMean(), 6) + " (stdev: " + ForesterUtil.round(descriptiveStatistics2.sampleStandardDeviation(), 6) + ")");
                stringBuilder.append("\n");
                stringBuilder.append("    Minimum: " + ForesterUtil.round(descriptiveStatistics2.getMin(), 6));
                stringBuilder.append("\n");
                stringBuilder.append("    Maximum: " + ForesterUtil.round(descriptiveStatistics2.getMax(), 6));
                stringBuilder.append("\n");
                if (Math.abs(descriptiveStatistics2.getMax() - descriptiveStatistics2.getMin()) > 1.0E-4) {
                    stringBuilder.append("\n");
                    AsciiHistogram asciiHistogram = new AsciiHistogram(descriptiveStatistics2);
                    stringBuilder.append(asciiHistogram.toStringBuffer(12, '#', 40, 7, "    "));
                }
            }
            if ((descriptiveStatistics = PhylogenyMethods.calculateNumberOfDescendantsPerNodeStatistics(phylogeny)).getN() > 2) {
                stringBuilder.append("\n");
                stringBuilder.append("Descendants per node statistics: ");
                stringBuilder.append("\n");
                stringBuilder.append("    Median: " + ForesterUtil.round(descriptiveStatistics.median(), 6));
                stringBuilder.append("\n");
                stringBuilder.append("    Mean: " + ForesterUtil.round(descriptiveStatistics.arithmeticMean(), 6) + " (stdev: " + ForesterUtil.round(descriptiveStatistics.sampleStandardDeviation(), 6) + ")");
                stringBuilder.append("\n");
                stringBuilder.append("    Minimum: " + ForesterUtil.roundToInt(descriptiveStatistics.getMin()));
                stringBuilder.append("\n");
                stringBuilder.append("    Maximum: " + ForesterUtil.roundToInt(descriptiveStatistics.getMax()));
                stringBuilder.append("\n");
            }
            List<DescriptiveStatistics> list = null;
            try {
                list = PhylogenyMethods.calculateConfidenceStatistics(phylogeny);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ForesterUtil.printWarningMessage("Archaeopteryx", illegalArgumentException.getMessage());
            }
            if (list != null && list.size() > 0) {
                stringBuilder.append("\n");
                for (int i = 0; i < list.size(); ++i) {
                    DescriptiveStatistics descriptiveStatistics3 = list.get(i);
                    if (descriptiveStatistics3 == null || descriptiveStatistics3.getN() <= 1) continue;
                    if (list.size() > 1) {
                        stringBuilder.append("Support statistics " + (i + 1) + ": ");
                    } else {
                        stringBuilder.append("Support statistics: ");
                    }
                    if (!ForesterUtil.isEmpty(descriptiveStatistics3.getDescription())) {
                        stringBuilder.append("\n");
                        stringBuilder.append("    Type: " + descriptiveStatistics3.getDescription());
                    }
                    stringBuilder.append("\n");
                    stringBuilder.append("    Branches with support: " + descriptiveStatistics3.getN());
                    stringBuilder.append("\n");
                    stringBuilder.append("    Median: " + ForesterUtil.round(descriptiveStatistics3.median(), 6));
                    stringBuilder.append("\n");
                    stringBuilder.append("    Mean: " + ForesterUtil.round(descriptiveStatistics3.arithmeticMean(), 6));
                    if (descriptiveStatistics3.getN() > 2) {
                        stringBuilder.append(" (stdev: " + ForesterUtil.round(descriptiveStatistics3.sampleStandardDeviation(), 6) + ")");
                    }
                    stringBuilder.append("\n");
                    stringBuilder.append("    Minimum: " + ForesterUtil.round(descriptiveStatistics3.getMin(), 6));
                    stringBuilder.append("\n");
                    stringBuilder.append("    Maximum: " + ForesterUtil.round(descriptiveStatistics3.getMax(), 6));
                    stringBuilder.append("\n");
                }
            }
        }
        return stringBuilder.toString();
    }

    static final void dieWithSystemError(String string) {
        System.out.println();
        System.out.println("Archaeopteryx encountered the following system error: " + string);
        System.out.println("Please contact the authors.");
        System.out.println("Archaeopteryx needs to close.");
        System.out.println();
        System.exit(-1);
    }

    static final String[] getAllPossibleRanks() {
        String[] stringArray = new String[TaxonomyUtil.TAXONOMY_RANKS_LIST.size() - 2];
        int n = 0;
        for (String string : TaxonomyUtil.TAXONOMY_RANKS_LIST) {
            if (string.equals("unknown") || string.equals("other")) continue;
            stringArray[n++] = string;
        }
        return stringArray;
    }

    static final String[] getAllPossibleRanks(Map<String, Integer> map) {
        String[] stringArray = new String[TaxonomyUtil.TAXONOMY_RANKS_LIST.size() - 2];
        int n = 0;
        for (String string : TaxonomyUtil.TAXONOMY_RANKS_LIST) {
            if (string.equals("unknown") || string.equals("other")) continue;
            if (map != null && map.containsKey(string)) {
                stringArray[n++] = string + " (" + map.get(string) + ")";
                continue;
            }
            stringArray[n++] = string;
        }
        return stringArray;
    }

    static final String[] getAllRanks(Phylogeny phylogeny) {
        TreeSet<String> treeSet = new TreeSet<String>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getRank())) continue;
            treeSet.add(phylogenyNode.getNodeData().getTaxonomy().getRank());
        }
        return ForesterUtil.stringSetToArray(treeSet);
    }

    static final String[] getAvailableFontFamiliesSorted() {
        return AVAILABLE_FONT_FAMILIES_SORTED;
    }

    static final boolean isUsOrCanada() {
        try {
            if (Locale.getDefault().equals(Locale.CANADA) || Locale.getDefault().equals(Locale.US)) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    static final void lookAtRealBranchLengthsForAptxControlSettings(Phylogeny phylogeny, ControlPanel controlPanel) {
        if (phylogeny != null && !phylogeny.isEmpty()) {
            boolean bl = AptxUtil.isHasAtLeastOneBranchLengthLargerThanZero(phylogeny);
            if (!bl) {
                controlPanel.setTreeDisplayType(Options.PHYLOGENY_DISPLAY_TYPE.CLADOGRAM);
                controlPanel.setDrawPhylogramEnabled(false);
            } else {
                boolean bl2 = AptxUtil.isHasNoBranchLengthSmallerThanZero(phylogeny);
                if (bl2) {
                    controlPanel.setTreeDisplayType(Options.PHYLOGENY_DISPLAY_TYPE.UNALIGNED_PHYLOGRAM);
                }
                if (controlPanel.getDisplayAsUnalignedPhylogramRb() != null) {
                    controlPanel.setDrawPhylogramEnabled(true);
                }
            }
        }
    }

    static final void lookAtSomeTreePropertiesForAptxControlSettings(Phylogeny phylogeny, ControlPanel controlPanel, Configuration configuration) {
        if (phylogeny != null && !phylogeny.isEmpty()) {
            boolean bl = AptxUtil.isHasAtLeastOneBranchLengthLargerThanZero(phylogeny);
            if (!bl) {
                controlPanel.setTreeDisplayType(Options.PHYLOGENY_DISPLAY_TYPE.CLADOGRAM);
                controlPanel.setDrawPhylogramEnabled(false);
            }
            if (phylogeny.getFirstExternalNode().getBranchData().getBranchColor() != null && controlPanel.getUseVisualStylesCb() != null) {
                controlPanel.getUseVisualStylesCb().setSelected(true);
            }
            if (phylogeny.getFirstExternalNode().getBranchData().getBranchWidth() != null && phylogeny.getFirstExternalNode().getBranchData().getBranchWidth().getValue() != 1.0 && controlPanel.getUseBranchWidthsCb() != null) {
                controlPanel.getUseBranchWidthsCb().setSelected(true);
            }
            if (configuration.doGuessCheckOption(0) && controlPanel.getDisplayAsAlignedPhylogramRb() != null) {
                if (bl) {
                    boolean bl2 = AptxUtil.isHasAtLeast50PercentBranchLengthLargerThanZero(phylogeny);
                    if (bl2) {
                        controlPanel.setTreeDisplayType(Options.PHYLOGENY_DISPLAY_TYPE.UNALIGNED_PHYLOGRAM);
                    }
                    controlPanel.setDrawPhylogramEnabled(true);
                } else {
                    controlPanel.setTreeDisplayType(Options.PHYLOGENY_DISPLAY_TYPE.CLADOGRAM);
                }
            }
            if (configuration.doGuessCheckOption(4) && controlPanel.getWriteConfidenceCb() != null) {
                if (AptxUtil.isHasAtLeastOneBranchWithSupportValues(phylogeny)) {
                    controlPanel.setCheckbox(4, true);
                } else {
                    controlPanel.setCheckbox(4, false);
                }
            }
            if (configuration.doGuessCheckOption(5) && controlPanel.getShowEventsCb() != null) {
                if (AptxUtil.isHasAtLeastNodeWithEvent(phylogeny)) {
                    controlPanel.setCheckbox(5, true);
                } else {
                    controlPanel.setCheckbox(5, false);
                }
            }
        }
    }

    static final void openWebsite(String string) throws IOException {
        try {
            AptxUtil.launchWebBrowser(new URI(string), "Archaeopteryx");
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    static final void outOfMemoryError(OutOfMemoryError outOfMemoryError) {
        System.err.println();
        System.err.println("Java memory allocation might be too small, try \"-Xmx2048m\" java command line option");
        System.err.println();
        outOfMemoryError.printStackTrace();
        System.err.println();
        JOptionPane.showMessageDialog(null, "Java memory allocation might be too small, try \"-Xmx2048m\" java command line option\n\nError: " + outOfMemoryError.getLocalizedMessage(), "Out of Memory Error [Archaeopteryx 0.9928 beta]", 0);
        System.exit(-1);
    }

    static final void printAppletMessage(String string, String string2) {
        System.out.println("[" + string + "] > " + string2);
    }

    static final void removeBranchColors(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNodeIterator.next().getBranchData().setBranchColor(null);
        }
    }

    static final void removeVisualStyles(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNodeIterator.next().getNodeData().setNodeVisualData(null);
        }
    }

    static final void unexpectedError(Error error) {
        System.err.println();
        error.printStackTrace(System.err);
        System.err.println();
        StringBuffer stringBuffer = new StringBuffer();
        for (StackTraceElement stackTraceElement : error.getStackTrace()) {
            stringBuffer.append(stackTraceElement + "\n");
        }
        JOptionPane.showMessageDialog(null, "An unexpected (possibly severe) error has occured - terminating. \nPlease contact: phyloxml@gmail.com \nError: " + error.getLocalizedMessage() + "\n" + stringBuffer, "Unexpected Severe Error [Archaeopteryx 0.9928 beta]", 0);
        System.exit(-1);
    }

    static final void unexpectedException(Exception exception) {
        System.err.println();
        exception.printStackTrace(System.err);
        System.err.println();
        StringBuffer stringBuffer = new StringBuffer();
        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
            stringBuffer.append(stackTraceElement + "\n");
        }
        JOptionPane.showMessageDialog(null, "An unexpected exception has occured. \nPlease contact: phyloxml@gmail.com \nException: " + exception.getLocalizedMessage() + "\n" + stringBuffer, "Unexpected Exception [Archaeopteryx0.9928 beta]", 0);
    }

    static final String writePhylogenyToGraphicsByteArrayOutputStream(ByteArrayOutputStream byteArrayOutputStream, int n, int n2, TreePanel treePanel, ControlPanel controlPanel, GraphicsExportType graphicsExportType, Options options) throws IOException {
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        if (options.isAntialiasPrint()) {
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Phylogeny phylogeny = treePanel.getPhylogeny();
        if (phylogeny == null || phylogeny.isEmpty()) {
            return "";
        }
        Rectangle rectangle = null;
        if (options.isGraphicsExportVisibleOnly()) {
            rectangle = treePanel.getVisibleRect();
            n = rectangle.width;
            n2 = rectangle.height;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHints(renderingHints);
        int n3 = 0;
        int n4 = 0;
        if (options.isGraphicsExportVisibleOnly()) {
            graphics2D = (Graphics2D)graphics2D.create(-rectangle.x, -rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setClip(null);
            n3 = rectangle.x;
            n4 = rectangle.y;
        }
        treePanel.paintPhylogeny(graphics2D, false, true, n, n2, n3, n4);
        ImageIO.write((RenderedImage)bufferedImage, graphicsExportType.toString(), byteArrayOutputStream);
        graphics2D.dispose();
        System.gc();
        if (!options.isGraphicsExportUsingActualSize()) {
            treePanel.getMainPanel().getControlPanel().showWhole();
        }
        String string = byteArrayOutputStream.toString();
        if (n > 0 && n2 > 0) {
            string = string + " [size: " + n + ", " + n2 + "]";
        }
        return string;
    }

    static final String writePhylogenyToGraphicsFile(String string, int n, int n2, TreePanel treePanel, ControlPanel controlPanel, GraphicsExportType graphicsExportType, Options options) throws IOException {
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        if (options.isAntialiasPrint()) {
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Phylogeny phylogeny = treePanel.getPhylogeny();
        if (phylogeny == null || phylogeny.isEmpty()) {
            return "";
        }
        File file = new File(string);
        if (file.isDirectory()) {
            throw new IOException("\"" + string + "\" is a directory");
        }
        Rectangle rectangle = null;
        if (options.isGraphicsExportVisibleOnly()) {
            rectangle = treePanel.getVisibleRect();
            n = rectangle.width;
            n2 = rectangle.height;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHints(renderingHints);
        int n3 = 0;
        int n4 = 0;
        if (options.isGraphicsExportVisibleOnly()) {
            graphics2D = (Graphics2D)graphics2D.create(-rectangle.x, -rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setClip(null);
            n3 = rectangle.x;
            n4 = rectangle.y;
        }
        treePanel.paintPhylogeny(graphics2D, false, true, n, n2, n3, n4);
        if (graphicsExportType == GraphicsExportType.TIFF) {
            AptxUtil.writeToTiff(file, bufferedImage);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, graphicsExportType.toString(), file);
        }
        graphics2D.dispose();
        System.gc();
        if (!options.isGraphicsExportUsingActualSize()) {
            treePanel.getMainPanel().getControlPanel().showWhole();
        }
        String string2 = file.toString();
        if (n > 0 && n2 > 0) {
            string2 = string2 + " [size: " + n + ", " + n2 + "]";
        }
        return string2;
    }

    static final void writeToTiff(File file, BufferedImage bufferedImage) throws IOException {
        ImageIO.write((RenderedImage)bufferedImage, "TIFF", file);
    }

    static final Map<String, Integer> getRankCounts(Phylogeny phylogeny) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (phylogeny != null && !phylogeny.isEmpty()) {
            PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
            while (phylogenyNodeIterator.hasNext()) {
                PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
                if (phylogenyNode.isExternal() || !phylogenyNode.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getRank()) || phylogenyNode.isRoot()) continue;
                String string = phylogenyNode.getNodeData().getTaxonomy().getRank().toLowerCase();
                if (hashMap.containsKey(string)) {
                    hashMap.put(string, (Integer)hashMap.get(string) + 1);
                    continue;
                }
                hashMap.put(string, 1);
            }
        }
        return hashMap;
    }

    static {
        Arrays.sort(AVAILABLE_FONT_FAMILIES_SORTED);
    }

    public static enum GraphicsExportType {
        BMP("bmp"),
        GIF("gif"),
        JPG("jpg"),
        PDF("pdf"),
        PNG("png"),
        TIFF("tif");

        private final String _suffix;

        private GraphicsExportType(String string2) {
            this._suffix = string2;
        }

        public String toString() {
            return this._suffix;
        }
    }
}

