/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;

public class PieChartRenderer
extends AbstractChartRenderer {
    public PieChartRenderer(ChartDataModel model) {
        super(model);
    }

    public PieChartRenderer(CoordSystem cs, ChartDataModel model) {
        super(cs, model);
    }

    @Override
    public boolean renderChart(Graphics2D g) {
        Object rh = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ChartDataModel m = this.getChartDataModel();
        RowColorModel rcm = this.getRowColorModel();
        double height = this.getBounds().getHeight();
        double width = this.getBounds().getWidth();
        int datenreihen = m.getDataSetNumber();
        int min_length = Integer.MAX_VALUE;
        int i = 0;
        while (i < datenreihen) {
            min_length = Math.min(min_length, m.getDataSetLength(i));
            ++i;
        }
        double center_y = this.getBounds().getCenterY();
        double center_x = this.getBounds().getCenterX();
        double rad = Math.min(width * 0.9, height * 0.9);
        double modelVal = 0.0;
        int reihe = min_length;
        while (reihe >= 1 && !this.getStopFlag()) {
            double kreis = rad / (double)min_length * (double)reihe;
            Ellipse2D.Double circle = new Ellipse2D.Double(center_x - kreis / 2.0, center_y - kreis / 2.0, kreis, kreis);
            double sum = 0.0;
            double start = 0.0;
            int i2 = 0;
            while (i2 < datenreihen && !this.getStopFlag()) {
                modelVal = m.getValueAt(i2, reihe - 1).doubleValue();
                if (!Double.isNaN(modelVal)) {
                    sum += modelVal;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < datenreihen && !this.getStopFlag()) {
                double value = m.getValueAt(i2, reihe - 1).doubleValue();
                if (Double.isNaN(value)) {
                    value = 0.0;
                }
                Arc2D.Double arc = new Arc2D.Double(circle.getBounds2D(), start, 360.0 * value / sum, 2);
                start += 360.0 * value / sum;
                g.setColor(rcm.getColor(i2));
                g.fill(arc);
                ++i2;
            }
            g.setColor(Color.black);
            g.draw(circle);
            --reihe;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rh);
        boolean completed = !this.getStopFlag();
        this.resetStopFlag();
        return completed;
    }
}

