/*
 * Decompiled with CFR 0.152.
 */
package staticStuff;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;

public class ImageExporter {
    public static final int BMP = 0;
    public static final int PNG = 1;
    private static final byte[] IHDR = new byte[]{73, 72, 68, 82};
    private static final byte[] IDAT = new byte[]{73, 68, 65, 84};
    private static final byte[] IEND = new byte[]{73, 69, 78, 68};
    private static final int PNG_truecolor = 2;
    private int fillerBytes;
    private int type;
    private File theFile;
    private BufferedOutputStream out;
    private DeflaterOutputStream theDeflater;
    private ByteArrayOutputStream byteOut;
    private CRC32 theCRC = new CRC32();

    public ImageExporter(File outFile, int width, int height, int type) throws FileNotFoundException, IOException {
        this.theFile = outFile;
        this.type = type;
        this.out = new BufferedOutputStream(new FileOutputStream(this.theFile));
        if (this.out != null) {
            if (type == 0) {
                this.writeHeaderBMP(width, height);
            }
            if (type == 1) {
                this.writeHeaderPNG(width, height);
            }
        }
    }

    private void writeHeaderBMP(int width, int height) throws IOException {
        this.out.write(66);
        this.out.write(77);
        int lineBytes = width * 3;
        this.fillerBytes = lineBytes % 4;
        int size = (lineBytes += this.fillerBytes) * height + 54;
        int four = size >>> 24 & 0xFF;
        int three = size >>> 16 & 0xFF;
        int two = size >>> 8 & 0xFF;
        int one = size >>> 0 & 0xFF;
        this.out.write(one);
        this.out.write(two);
        this.out.write(three);
        this.out.write(four);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(54);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(40);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        four = width >>> 24 & 0xFF;
        three = width >>> 16 & 0xFF;
        two = width >>> 8 & 0xFF;
        one = width >>> 0 & 0xFF;
        this.out.write(one);
        this.out.write(two);
        this.out.write(three);
        this.out.write(four);
        height = -height;
        four = height >>> 24 & 0xFF;
        three = height >>> 16 & 0xFF;
        two = height >>> 8 & 0xFF;
        one = height >>> 0 & 0xFF;
        this.out.write(one);
        this.out.write(two);
        this.out.write(three);
        this.out.write(four);
        this.out.write(1);
        this.out.write(0);
        this.out.write(24);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        int pixel_meter = 11811;
        four = pixel_meter >>> 24 & 0xFF;
        three = pixel_meter >>> 16 & 0xFF;
        two = pixel_meter >>> 8 & 0xFF;
        one = pixel_meter >>> 0 & 0xFF;
        this.out.write(one);
        this.out.write(two);
        this.out.write(three);
        this.out.write(four);
        this.out.write(one);
        this.out.write(two);
        this.out.write(three);
        this.out.write(four);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
    }

    private void writeHeaderPNG(int width, int height) throws IOException {
        this.out.write(137);
        this.out.write(80);
        this.out.write(78);
        this.out.write(71);
        this.out.write(13);
        this.out.write(10);
        this.out.write(26);
        this.out.write(10);
        byte[] data = new byte[]{(byte)(width >>> 24 & 0xFF), (byte)(width >>> 16 & 0xFF), (byte)(width >>> 8 & 0xFF), (byte)(width >>> 0 & 0xFF), (byte)(height >>> 24 & 0xFF), (byte)(height >>> 16 & 0xFF), (byte)(height >>> 8 & 0xFF), (byte)(height >>> 0 & 0xFF), 8, 2, 0, 0, 0};
        this.writePNGchunk(IHDR, data);
        this.byteOut = new ByteArrayOutputStream();
        this.byteOut.reset();
        this.theDeflater = new DeflaterOutputStream(this.byteOut);
    }

    public void write(BufferedImage bI) throws IOException {
        if (this.type == 0) {
            this.writeBMP(bI);
        } else if (this.type == 1) {
            this.writePNG(bI);
        }
    }

    private void writeBMP(BufferedImage bI) throws IOException {
        int height = bI.getHeight();
        int width = bI.getWidth();
        WritableRaster raster = bI.getRaster();
        for (int line = 0; line < height; ++line) {
            int i;
            int[] pixels = null;
            pixels = raster.getPixels(0, line, width, 1, pixels);
            byte[] bytes = new byte[pixels.length];
            for (i = 0; i < pixels.length; ++i) {
                bytes[i] = (byte)pixels[i];
            }
            this.out.write(bytes);
            for (i = 0; i < this.fillerBytes; ++i) {
                this.out.write(0);
            }
        }
    }

    private void writePNG(BufferedImage bI) throws IOException {
        WritableRaster raster = bI.getRaster();
        int width = bI.getWidth();
        int height = bI.getHeight();
        byte[] data = new byte[width * height * 3 + height];
        int pos = 0;
        for (int line = 0; line < height; ++line) {
            data[pos] = 0;
            ++pos;
            int[] pixels = null;
            pixels = raster.getPixels(0, line, width, 1, pixels);
            int i = 0;
            while (i < pixels.length) {
                data[pos] = (byte)pixels[i];
                ++i;
                ++pos;
            }
        }
        this.theDeflater.write(data);
        this.writePNGchunk(IDAT, this.byteOut.toByteArray());
        this.byteOut.reset();
    }

    public void writePNGchunk(byte[] header, byte[] data) throws IOException {
        this.out.write(data.length >>> 24 & 0xFF);
        this.out.write(data.length >>> 16 & 0xFF);
        this.out.write(data.length >>> 8 & 0xFF);
        this.out.write(data.length >>> 0 & 0xFF);
        this.theCRC.reset();
        this.theCRC.update(header);
        this.out.write(header);
        this.theCRC.update(data);
        this.out.write(data);
        long crc = (int)this.theCRC.getValue();
        this.out.write((int)(crc >>> 24) & 0xFF);
        this.out.write((int)(crc >>> 16) & 0xFF);
        this.out.write((int)(crc >>> 8) & 0xFF);
        this.out.write((int)(crc >>> 0) & 0xFF);
    }

    public void close() {
        try {
            if (this.type == 1) {
                this.theDeflater.flush();
                this.theDeflater.close();
                this.writePNGchunk(IDAT, this.byteOut.toByteArray());
                this.writePNGchunk(IEND, new byte[0]);
            }
            this.out.close();
            this.out = null;
            this.theFile = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

