/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.GUI;

import FCSalyzer.FCS.FCS_data;
import FCSalyzer.GUI.mainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class viewRawDataDialog
implements ActionListener,
WindowListener,
ListSelectionListener {
    private final JSplitPane tableHolder;
    private final JSplitPane paramHolder;
    private final JList fileList;
    private final JTable rawEventsTable;
    private final JTable compEventsTable;
    private final JTable displayEventsTable;
    private final JTable headerTable;
    private final eventsTableManager rawEventsTableModel;
    private final eventsTableManager compEventsTableModel;
    private final eventsTableManager displayEventsTableModel;
    private List<FCS_data> theFiles;
    private static final String CLOSE = "CLOSE";
    private final JButton CLOSE_Button = new JButton("Close Dialog");
    private final JDialog theDialog = new JDialog();
    private final String[] headerColumns = new String[]{"Description", "Label", "Value"};
    private final Class[] headerClasses = new Class[]{String.class, String.class, String.class};
    private final String[] columnNames = new String[]{"Description", "Key", "Content"};
    private ArrayList<TableModelListener> listeners = new ArrayList();
    private mainFrame theFrame;

    public viewRawDataDialog(mainFrame paramFrame) {
        this.theFrame = paramFrame;
        this.theDialog.setModal(true);
        this.theDialog.setTitle("View data");
        this.theDialog.setLayout(new BorderLayout());
        this.theDialog.addWindowListener(this);
        this.theDialog.setLocationByPlatform(true);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.CLOSE_Button);
        this.CLOSE_Button.setActionCommand(CLOSE);
        this.CLOSE_Button.addActionListener(this);
        this.theDialog.add((Component)buttonPanel, "South");
        this.theDialog.setDefaultCloseOperation(2);
        this.fileList = new JList();
        this.fileList.setSelectionMode(0);
        this.fileList.addListSelectionListener(this);
        JScrollPane fileScroller = new JScrollPane(this.fileList);
        this.rawEventsTableModel = new eventsTableManager(0);
        this.rawEventsTable = new JTable(this.rawEventsTableModel);
        this.rawEventsTable.setAutoResizeMode(0);
        JScrollPane rawEventsScroller = new JScrollPane(this.rawEventsTable);
        this.compEventsTableModel = new eventsTableManager(1);
        this.compEventsTable = new JTable(this.compEventsTableModel);
        this.compEventsTable.setAutoResizeMode(0);
        JScrollPane compEventsScroller = new JScrollPane(this.compEventsTable);
        this.displayEventsTableModel = new eventsTableManager(2);
        this.displayEventsTable = new JTable(this.displayEventsTableModel);
        this.displayEventsTable.setAutoResizeMode(0);
        JScrollPane displayEventsScroller = new JScrollPane(this.displayEventsTable);
        this.headerTable = new JTable();
        this.headerTable.setDefaultEditor(Object.class, null);
        JScrollPane headerScroller = new JScrollPane(this.headerTable);
        JTabbedPane eventsHolder = new JTabbedPane();
        eventsHolder.add("Events as in file", rawEventsScroller);
        eventsHolder.add("Events for calculation", compEventsScroller);
        eventsHolder.add("Events as displayed", displayEventsScroller);
        this.paramHolder = new JSplitPane(1, headerScroller, eventsHolder);
        this.paramHolder.setDividerSize(2);
        this.paramHolder.setContinuousLayout(true);
        JPanel propertiesHolder = new JPanel(new BorderLayout());
        propertiesHolder.add((Component)this.paramHolder, "Center");
        this.tableHolder = new JSplitPane(1, fileScroller, propertiesHolder);
        this.tableHolder.setDividerSize(2);
        this.tableHolder.setContinuousLayout(true);
        this.theDialog.add((Component)this.tableHolder, "Center");
        this.theDialog.setLocationByPlatform(true);
        this.tableHolder.setDividerLocation(120);
        this.paramHolder.setDividerLocation(250);
        this.theDialog.setSize(800, 300);
    }

    public boolean showDialog(List<FCS_data> documentDatafiles, String docName) {
        this.theFiles = documentDatafiles;
        String[] names = new String[this.theFiles.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.theFiles.get(i).getDataFileName();
        }
        this.fileList.setListData(names);
        if (names.length > 0) {
            this.fileList.setSelectedIndex(0);
        }
        this.theDialog.setTitle("Datafiles in: " + docName);
        this.theDialog.setVisible(true);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(CLOSE)) {
            this.theDialog.setVisible(false);
            this.theFiles = null;
            this.theFrame = null;
            this.theDialog.dispose();
            return;
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.theDialog.setVisible(false);
        this.theFiles = null;
        this.theFrame = null;
        this.theDialog.dispose();
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int selected = this.fileList.getSelectedIndex();
        if (selected < 0) {
            selected = 0;
        }
        FCS_data currentFile = this.theFiles.get(selected);
        ArrayList<String> keyDescriptions = currentFile.getKeywordsDescription();
        ArrayList<String> keyItems = currentFile.getKeywordsTEXT();
        ArrayList<String> valueItems = currentFile.getValuesTEXT();
        Object[][] data = new String[keyItems.size()][3];
        for (int i = 0; i < data.length; ++i) {
            data[i][0] = keyDescriptions.get(i);
            data[i][1] = keyItems.get(i);
            data[i][2] = valueItems.get(i);
        }
        DefaultTableModel dT = new DefaultTableModel(data, this.columnNames);
        this.headerTable.setModel(dT);
        this.rawEventsTableModel.setDataFile(currentFile);
        this.compEventsTableModel.setDataFile(currentFile);
        this.displayEventsTableModel.setDataFile(currentFile);
    }

    private class eventsTableManager
    implements TableModel {
        private final ArrayList<TableModelListener> listeners = new ArrayList();
        private FCS_data currentFile;
        private static final int RAW = 0;
        private static final int CALC = 1;
        private static final int DISPLAY = 2;
        private int type = 0;

        public eventsTableManager(int setType) {
            this.type = setType;
        }

        public void setDataFile(FCS_data newFile) {
            this.currentFile = newFile;
            for (TableModelListener listener : this.listeners) {
                listener.tableChanged(null);
            }
        }

        @Override
        public int getRowCount() {
            if (this.currentFile != null) {
                return this.currentFile.getEventCount();
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            if (this.currentFile != null) {
                if (this.type == 0) {
                    return this.currentFile.getRawParameterCount() + 1;
                }
                return this.currentFile.getTotalParameterCount() + 1;
            }
            return 0;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (this.currentFile == null) {
                return null;
            }
            if (columnIndex == 0) {
                return "#";
            }
            return this.currentFile.getParameterLabel(columnIndex - 1);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Integer.class;
            }
            return Double.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.currentFile == null) {
                return null;
            }
            if (columnIndex == 0) {
                return rowIndex;
            }
            if (this.type == 0) {
                return this.currentFile.getRawEvent(rowIndex)[columnIndex - 1];
            }
            if (this.type == 1) {
                return this.currentFile.getEvents(rowIndex, 1)[1][0][columnIndex - 1];
            }
            return this.currentFile.getEvents(rowIndex, 1)[0][0][columnIndex - 1];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }
    }
}

