/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.GUI;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class tableCellColorEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private JColorChooser theChooser = new JColorChooser();
    private JButton theButton = new JButton();
    private JDialog theDialog = JColorChooser.createDialog(this.theButton, "Choose a Color", true, this.theChooser, this, null);
    private static final String EDIT = "edit";
    private int color;
    private boolean canceled = true;

    public tableCellColorEditor() {
        this.theButton.addActionListener(this);
        this.theButton.setActionCommand(EDIT);
    }

    @Override
    public Object getCellEditorValue() {
        if (!this.canceled) {
            return this.color;
        }
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof ImageIcon) {
            this.theButton.setIcon((ImageIcon)value);
            Image img = ((ImageIcon)value).getImage();
            if (img instanceof BufferedImage) {
                this.color = ((BufferedImage)img).getRGB(1, 1);
            }
        }
        return this.theButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(EDIT)) {
            this.canceled = true;
            this.theChooser.setColor(this.color);
            this.theDialog.setVisible(true);
            this.fireEditingStopped();
        } else {
            this.canceled = false;
            this.color = this.theChooser.getColor().getRGB();
        }
    }
}

