/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.GUI;

import FCSalyzer.FCS.FCS_data;
import FCSalyzer.FCS.attachData.ImportPanel;
import FCSalyzer.FCS.attachData.definedTick;
import FCSalyzer.GUI.FACS_document;
import FCSalyzer.GUI.mainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class attachParameterDialog
implements ActionListener,
WindowListener,
ChangeListener {
    private final JList fileList;
    private final JEditorPane infoText;
    private final JTable existingParamTable;
    private final ImportPanel theImporter;
    private List<FCS_data> theFiles;
    private static final String CLOSE = "CLOSE";
    private static final String DELETE = "DELETE";
    private final JButton CLOSE_Button = new JButton("Close Dialog");
    private final JDialog theDialog = new JDialog();
    private final JTabbedPane actionsHolder;
    private ArrayList<TableModelListener> listeners = new ArrayList();
    private FACS_document theDocument;
    private mainFrame theFrame;
    private static final String existingParameters = "<html><body><p>The currently attached parameters of the FCS datafile selected in the left list are shown here.</p><p>Existing parameters can be deleted. Regions (and gates) are not updated when deleting a parameter! Please check all regions and gates!</p>";
    private static final String importParameters = "<html><p>Here, new parameters can be imported and attached to an existing FCS data file. Text files (CSV) can be imported. Please <u>open</u> an import file to get started.</p><p>For importing files, make sure to select the correct FCS datafile in the list on the left, then click 'Import'</p><p>Options for importing:</p><p><b>[Name]</b>: Enter the name that shall be used for the new imported parameter. The name can't be empty.</p><p><b>[Import]</b>: Check this box if the parameter shall be imported.</p><p><b>[Event#]</b>: Check this box if this parameter is actually the number of the event for which the values shall be imported. This is usefull if your imported data covers only some specific events in the FCS datafile, not all events. For example, you might have exported only the events showing in a particular (gated) plot, used that data for generating additional data (like a cluster number), and are now adding that data to the events used in the export. All other events will get the value specified under <b>[for #missing]</b><br><u>Please note:</u> the Event# must be sorted in ascending order!</p><p><b>[Log Display]</b>: Shall this parameter be shown on a log-scale by default?</p><p><b>[Categorical]</b>: Is this a category instead of a measurement? Categories can be defined in the original TXT/CSV file either as a number or as a text.When importing, FCSalyzer changes the category information into equally spaced values. For example, if the text 'male' and 'female' are used to define categories, they will be changed to 100 and 200, respectively. Similarly, the values 0,2,5 will be changed to 100, 200, 300. If there are missing values, an additional category will be made that holds all those events. When displaying that parameter in a plot, the plot axis will not show the regular ticks based on values, but instead custom ticks that show the category, for example '[male]' or '[0]'; the category that holds events with missing values will be in the category '[]'.</p><p><b>[Jitter]</b>: During importing, a small random change will be applied to the values ('jitter'). This jitter is useful when importing categories, as then the values will not be precisely '100' but somewhat around that value, turning them into a nice visible population instead of just one single point in the plots.</p><p><b>[Range]</b>: This value defines the maximum range of the parameter, and will thus define the display range of this parameter in the plots. The value can be adjusted by you, but not be set lower than the highest value.</p><p><b>[Highest Value]</b>: For your information, this is the highest value that was found for this parameter.</p><p><b>[Status]</b>: For your information: are there non/numerical values found for this parameter? Are there values for all events of the selected FCS datafile (file list to the left), or are there values missing?</p><p><b>[for #missing#]</b>: If values are missing for events, this value will be used instead. It is better to prepare values for all events instead of relying on this replacement value.</p></body></html>";

    public attachParameterDialog(FACS_document paramDoc, mainFrame paramFrame) {
        this.theDocument = paramDoc;
        this.theFrame = paramFrame;
        this.theDialog.setModal(true);
        this.theDialog.setTitle("Attach parameters");
        this.theDialog.setLayout(new BorderLayout());
        this.theDialog.addWindowListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.CLOSE_Button);
        this.CLOSE_Button.setActionCommand(CLOSE);
        this.CLOSE_Button.addActionListener(this);
        this.theDialog.add((Component)buttonPanel, "South");
        this.theDialog.setDefaultCloseOperation(2);
        this.fileList = new JList();
        this.fileList.setSelectionMode(0);
        this.fileList.addListSelectionListener(new fileListListener());
        JScrollPane fileScroller = new JScrollPane(this.fileList);
        this.infoText = new JEditorPane();
        this.infoText.setContentType("text/html");
        this.infoText.setEditable(false);
        this.infoText.setText(existingParameters);
        JScrollPane infoScroller = new JScrollPane(this.infoText);
        this.actionsHolder = new JTabbedPane();
        this.actionsHolder.addChangeListener(this);
        JSplitPane rightSide = new JSplitPane(1, infoScroller, this.actionsHolder);
        rightSide.setDividerSize(2);
        rightSide.setContinuousLayout(true);
        JPanel rightHolder = new JPanel(new BorderLayout());
        rightHolder.add((Component)rightSide, "Center");
        JSplitPane leftSide = new JSplitPane(1, fileScroller, rightHolder);
        leftSide.setDividerSize(2);
        leftSide.setContinuousLayout(true);
        leftSide.setDividerLocation(120);
        rightSide.setDividerLocation(250);
        this.theDialog.add((Component)leftSide, "Center");
        this.theDialog.setLocationByPlatform(true);
        this.theDialog.setSize(800, 500);
        JPanel showPanel = new JPanel(new BorderLayout());
        JPanel showButtons = new JPanel();
        JButton delButton = new JButton();
        delButton.setActionCommand(DELETE);
        delButton.addActionListener(this);
        delButton.setText("Delete");
        showButtons.add(delButton);
        this.existingParamTable = new JTable();
        this.existingParamTable.setSelectionMode(0);
        JScrollPane exScroller = new JScrollPane(this.existingParamTable);
        showPanel.add((Component)exScroller, "Center");
        showPanel.add((Component)showButtons, "South");
        this.actionsHolder.add("Show Parameters", showPanel);
        this.theImporter = new ImportPanel(this);
        this.actionsHolder.add("Import Parameters", this.theImporter.getGUI());
    }

    public void attachFiles(File[] attachedFiles, definedTick[][] defTicks) {
        int selected = this.fileList.getSelectedIndex();
        if (selected < 0) {
            selected = 0;
        }
        if (selected >= this.theFiles.size()) {
            selected = this.theFiles.size() - 1;
        }
        FCS_data currentF = this.theFiles.get(selected);
        currentF.attachParameters(attachedFiles, defTicks);
        this.theDocument.refreshView(currentF);
        tableParametersModel tableModel = new tableParametersModel(currentF);
        this.existingParamTable.setModel(tableModel);
        tableModel.setRegulars(this.existingParamTable.getDefaultEditor(String.class), this.existingParamTable.getDefaultRenderer(String.class), this.existingParamTable.getDefaultEditor(Boolean.class), this.existingParamTable.getDefaultRenderer(Boolean.class));
        this.existingParamTable.setDefaultEditor(String.class, tableModel);
        this.existingParamTable.setDefaultRenderer(String.class, tableModel);
        this.existingParamTable.setAutoResizeMode(0);
    }

    public boolean showDialog() {
        this.theFiles = this.theDocument.getDatafiles();
        String[] names = new String[this.theFiles.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.theFiles.get(i).getDataFileName();
        }
        this.fileList.setListData(names);
        if (names.length > 0) {
            this.fileList.setSelectedIndex(0);
        }
        this.theDialog.setTitle("Attach parameters to FACS datafiles in: " + this.theDocument.getName());
        this.theDialog.setVisible(true);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(CLOSE)) {
            this.theDialog.setVisible(false);
            this.theFiles = null;
            this.theDocument = null;
            this.theDialog.dispose();
            return;
        }
        if (e.getActionCommand().equals(DELETE)) {
            FCS_data current = this.theFiles.get(this.fileList.getSelectedIndex());
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            for (int i = 1; i < this.existingParamTable.getColumnCount(); ++i) {
                if (!this.existingParamTable.getValueAt(1, i).equals(true)) continue;
                toRemove.add(i - 1);
            }
            current.removeAttachedParameters(toRemove.toArray(new Integer[0]));
            this.theDocument.refreshView(current);
            tableParametersModel tableModel = new tableParametersModel(current);
            this.existingParamTable.setModel(tableModel);
            tableModel.setRegulars(this.existingParamTable.getDefaultEditor(String.class), this.existingParamTable.getDefaultRenderer(String.class), this.existingParamTable.getDefaultEditor(Boolean.class), this.existingParamTable.getDefaultRenderer(Boolean.class));
            this.existingParamTable.setDefaultEditor(String.class, tableModel);
            this.existingParamTable.setDefaultRenderer(String.class, tableModel);
            this.existingParamTable.setAutoResizeMode(0);
            this.theImporter.setRowsToImport(current.getEventCount());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.actionsHolder.getSelectedIndex() > 0) {
            this.infoText.setText(importParameters);
        } else {
            this.infoText.setText(existingParameters);
        }
        this.infoText.setCaretPosition(0);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.theDialog.setVisible(false);
        this.theFiles = null;
        this.theDocument = null;
        this.theDialog.dispose();
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    private class tableParametersModel
    extends AbstractCellEditor
    implements TableModel,
    TableCellEditor,
    TableCellRenderer,
    FocusListener,
    ActionListener {
        private ArrayList<TableModelListener> listeners = new ArrayList();
        private FCS_data theData;
        private int existingParameterCount;
        private JCheckBox editorCheckBox = new JCheckBox();
        private TableCellEditor booleanEditor;
        private TableCellRenderer booleanRenderer;
        private TableCellEditor regularEditor;
        private TableCellRenderer regularRenderer;
        private TableCellEditor currentEditor;
        private Component editorComponent;
        private int editorRow;
        private int editorColumn;
        private boolean addedListeners;
        private Boolean[] toDelete;

        public tableParametersModel(FCS_data paramData) {
            this.theData = paramData;
            this.existingParameterCount = this.theData.getAttachedParameterCount();
            this.toDelete = new Boolean[this.existingParameterCount + 1];
            for (int i = 0; i < this.existingParameterCount; ++i) {
                this.toDelete[i] = Boolean.FALSE;
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentEditor.getCellEditorValue();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.existingParameterCount + 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "";
            }
            return "Attached #" + columnIndex;
        }

        @Override
        public int getRowCount() {
            return this.theData.getEventCount() + 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                if (rowIndex == 0) {
                    return "Description";
                }
                if (rowIndex == 1) {
                    return "Delete?";
                }
                return "Event# " + (rowIndex - 2);
            }
            if (rowIndex == 0) {
                return this.theData.getAttachedParameterDescription(columnIndex - 1);
            }
            if (rowIndex == 1) {
                return this.toDelete[columnIndex - 1];
            }
            return this.theData.getAttachedParameterValue(columnIndex - 1, rowIndex - 2);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (rowIndex != 1) {
                return false;
            }
            return columnIndex != 0;
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex > this.toDelete.length) {
                return;
            }
            if (columnIndex == 0) {
                return;
            }
            if (rowIndex != 1) {
                return;
            }
            if (aValue instanceof Boolean) {
                this.toDelete[columnIndex - 1] = (Boolean)aValue;
            }
        }

        public void setRegulars(TableCellEditor oldEditor, TableCellRenderer oldRenderer, TableCellEditor oldBooleanEditor, TableCellRenderer oldBooleanRenderer) {
            this.regularEditor = oldEditor;
            this.regularRenderer = oldRenderer;
            this.booleanEditor = oldBooleanEditor;
            this.booleanRenderer = oldBooleanRenderer;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (!this.addedListeners) {
                JComponent ch;
                Component c = this.booleanEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
                if (c instanceof JCheckBox) {
                    ch = (JCheckBox)c;
                    ((AbstractButton)ch).addActionListener(this);
                }
                if ((c = this.regularEditor.getTableCellEditorComponent(table, value, isSelected, row, column)) instanceof JTextField) {
                    ch = (JTextField)c;
                    ch.addFocusListener(this);
                }
                this.addedListeners = true;
            }
            if (row == 1) {
                this.currentEditor = this.booleanEditor;
                this.editorComponent = this.booleanEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
                this.editorRow = row;
                this.editorColumn = column;
                return this.editorComponent;
            }
            this.currentEditor = this.regularEditor;
            this.editorComponent = this.regularEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
            this.editorRow = row;
            this.editorColumn = column;
            return this.editorComponent;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (row == 1 && column != 0) {
                return this.booleanRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            return this.regularRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.getSource() instanceof JTextField) {
                this.setValueAt(((JTextField)e.getSource()).getText(), this.editorRow, this.editorColumn);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JCheckBox) {
                this.setValueAt(((JCheckBox)e.getSource()).isSelected(), this.editorRow, this.editorColumn);
            }
        }
    }

    private class fileListListener
    implements ListSelectionListener {
        private fileListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selected = attachParameterDialog.this.fileList.getSelectedIndex();
            if (selected < 0) {
                selected = 0;
            }
            if (selected >= attachParameterDialog.this.theFiles.size()) {
                selected = attachParameterDialog.this.theFiles.size() - 1;
            }
            FCS_data newF = (FCS_data)attachParameterDialog.this.theFiles.get(selected);
            tableParametersModel tableModel = new tableParametersModel(newF);
            attachParameterDialog.this.existingParamTable.setModel(tableModel);
            tableModel.setRegulars(attachParameterDialog.this.existingParamTable.getDefaultEditor(String.class), attachParameterDialog.this.existingParamTable.getDefaultRenderer(String.class), attachParameterDialog.this.existingParamTable.getDefaultEditor(Boolean.class), attachParameterDialog.this.existingParamTable.getDefaultRenderer(Boolean.class));
            attachParameterDialog.this.existingParamTable.setDefaultEditor(String.class, tableModel);
            attachParameterDialog.this.existingParamTable.setDefaultRenderer(String.class, tableModel);
            attachParameterDialog.this.existingParamTable.setAutoResizeMode(0);
            attachParameterDialog.this.theImporter.setRowsToImport(newF.getEventCount());
        }
    }
}

