/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.FCS;

import FCSalyzer.FCS.FCS_RegionGatesHolder;
import FCSalyzer.FCS.FCS_boolean_and;
import FCSalyzer.FCS.FCS_boolean_not;
import FCSalyzer.FCS.FCS_boolean_or;
import FCSalyzer.FCS.FCS_containing;
import FCSalyzer.FCS.FCS_region;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import staticStuff.staticMethods;

public class FCS_gate
implements FCS_containing {
    private int color = Color.RED.getRGB();
    private String name = "";
    private String lowerCaseName = "";
    private String strategy = "";
    private FCS_RegionGatesHolder theRaG;
    private FCS_containing decodedStrategy = null;
    private String decodedStrategyString = "";
    private int imageSize = 12;
    private BufferedImage colorImage = new BufferedImage(this.imageSize, this.imageSize, 1);
    private ImageIcon colorImageIcon = new ImageIcon(this.colorImage);
    private boolean allRegionsExist = false;
    public static final String XML_name = "Gate";
    private static final String XML_gateName = "Name";
    private static final String XML_strategy = "Strategy";
    private static final String XML_color = "Color";

    private FCS_gate() {
    }

    public FCS_gate(String paramName, FCS_RegionGatesHolder paramRaG) {
        if (paramName == null || paramRaG == null) {
            throw new IllegalArgumentException();
        }
        if ((paramName = paramName.trim()).isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (paramRaG.nameExists(paramName)) {
            while (paramRaG.nameExists(paramName = paramName + "-")) {
            }
        }
        this.name = paramName;
        this.lowerCaseName = this.name.toLowerCase();
        this.theRaG = paramRaG;
        this.colorImage();
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int paramColor) {
        this.color = paramColor;
    }

    @Override
    public boolean contains(double[] event) {
        if (this.isValid()) {
            return this.decodedStrategy.contains(event);
        }
        return false;
    }

    public void toXML(Node parent) {
        Node g = staticMethods.addNode(parent, XML_name, null);
        staticMethods.addNode(g, XML_gateName, this.name);
        staticMethods.addNode(g, XML_strategy, this.strategy);
        staticMethods.addNode(g, XML_color, this.color);
    }

    public static FCS_gate fromXML(Node sourceNode, FCS_RegionGatesHolder theRaG) {
        FCS_gate returnGate = new FCS_gate();
        returnGate.theRaG = theRaG;
        NodeList nL = sourceNode.getChildNodes();
        for (int i = 0; i < nL.getLength(); ++i) {
            Node current = nL.item(i);
            if (current.getNodeName().equals(XML_gateName)) {
                returnGate.name = staticMethods.getNodeText(current);
                returnGate.lowerCaseName = returnGate.name.toLowerCase();
                continue;
            }
            if (current.getNodeName().equals(XML_strategy)) {
                returnGate.setStrategy(staticMethods.getNodeText(current));
                continue;
            }
            if (!current.getNodeName().equals(XML_color)) continue;
            returnGate.setColor(staticMethods.getNodeInteger(current, Color.BLACK.getRGB()));
        }
        if (returnGate.name.isEmpty()) {
            return null;
        }
        return returnGate;
    }

    protected void addPrefix(String prefix, int count, StringBuilder target) {
        for (int i = 0; i < count; ++i) {
            target.append(prefix);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLowerCaseName() {
        return this.lowerCaseName;
    }

    public boolean setName(String paramName) {
        if (paramName == null) {
            return false;
        }
        if ((paramName = paramName.trim()).isEmpty() || paramName.contains("\"") || paramName.contains("(") || paramName.contains(")") || paramName.toLowerCase().equals("and") || paramName.toLowerCase().equals("or") || paramName.toLowerCase().equals("not") || this.theRaG.nameExists(paramName.toLowerCase())) {
            return false;
        }
        if (this.uses(paramName)) {
            return false;
        }
        String oldName = this.name;
        this.name = paramName;
        this.lowerCaseName = this.name.toLowerCase();
        this.theRaG.nameChanged(oldName, paramName);
        return true;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String paramStrategy) {
        this.strategy = paramStrategy.trim();
        this.decodedStrategy = this.decode(this.strategy);
        if (this.decodedStrategy != null) {
            this.decodedStrategyString = ((Object)this.decodedStrategy).toString();
            this.allRegionsExist = this.testForAvailableRG();
            if (this.uses(this.lowerCaseName)) {
                this.decodedStrategy = null;
                this.decodedStrategyString = "";
            }
        } else {
            this.decodedStrategyString = "";
            this.allRegionsExist = false;
        }
        this.theRaG.updateGates(this);
    }

    private boolean uses(String paramName) {
        paramName = paramName.toLowerCase();
        if (this.decodedStrategy == null) {
            return false;
        }
        for (String currentPart : this.getNames()) {
            if (currentPart.equals(paramName)) {
                return true;
            }
            FCS_gate currentGate = this.theRaG.getGate(currentPart);
            if (currentGate == null || !currentGate.uses(paramName)) continue;
            return true;
        }
        return false;
    }

    private FCS_containing decode(String strategy) {
        if ((strategy = strategy.trim().toLowerCase()).isEmpty()) {
            return null;
        }
        char[] strategyChars = strategy.toCharArray();
        StringBuilder tempPart = new StringBuilder();
        FCS_containing firstPart = null;
        boolean operator = false;
        boolean notOperator = false;
        for (int i = 0; i < strategyChars.length; ++i) {
            FCS_containing toAdd;
            FCS_containing newPart;
            String tempName;
            if (strategyChars[i] == '(') {
                --i;
                do {
                    tempPart.append(strategyChars[++i]);
                } while (strategyChars[i] != ')' && i < strategyChars.length - 1);
                if (strategyChars[i] != ')') {
                    return null;
                }
                tempName = tempPart.toString();
                tempPart.setLength(0);
            } else if (strategyChars[i] == '\"') {
                do {
                    if (strategyChars[++i] == '(' || strategyChars[i] == ')') {
                        return null;
                    }
                    if (strategyChars[i] == '\"') continue;
                    tempPart.append(strategyChars[i]);
                } while (i < strategyChars.length - 1 && strategyChars[i] != '\"');
                if (strategyChars[i] != '\"') {
                    return null;
                }
                tempName = tempPart.toString().trim();
                if (tempName.isEmpty()) {
                    return null;
                }
                tempPart.setLength(0);
            } else {
                do {
                    if (strategyChars[i] == ' ' || strategyChars[i] == '\"' || strategyChars[i] == '(') continue;
                    if (strategyChars[i] == ')') {
                        return null;
                    }
                    tempPart.append(strategyChars[i]);
                    ++i;
                } while (i < strategyChars.length && strategyChars[i] != ' ' && strategyChars[i] != '\"' && strategyChars[i] != '(');
                tempName = tempPart.toString().trim();
                tempPart.setLength(0);
            }
            if (tempName == null || tempName.isEmpty()) continue;
            if (tempName.equals("and")) {
                if (firstPart == null) {
                    return null;
                }
                if (operator) {
                    return null;
                }
                operator = true;
                notOperator = false;
                if (firstPart instanceof FCS_boolean_and) continue;
                newPart = new FCS_boolean_and();
                ((FCS_boolean_and)newPart).addPart(firstPart);
                firstPart = newPart;
                continue;
            }
            if (tempName.equals("or")) {
                if (firstPart == null) {
                    return null;
                }
                if (operator) {
                    return null;
                }
                operator = true;
                notOperator = false;
                if (firstPart instanceof FCS_boolean_or) continue;
                newPart = new FCS_boolean_or();
                ((FCS_boolean_or)newPart).addPart(firstPart);
                firstPart = newPart;
                continue;
            }
            if (tempName.equals("not")) {
                operator = true;
                notOperator = true;
                continue;
            }
            FCS_containing subGate = null;
            if (tempName.startsWith("(") && (subGate = this.decode(tempName.substring(1, tempName.length() - 1))) == null) {
                return null;
            }
            if (subGate == null) {
                toAdd = this.theRaG.getRegion(tempName);
                if (toAdd == null) {
                    toAdd = this.theRaG.getGate(tempName);
                }
            } else {
                toAdd = subGate;
            }
            if (toAdd == null) {
                return null;
            }
            if (notOperator) {
                toAdd = new FCS_boolean_not(toAdd);
            }
            if (firstPart == null) {
                firstPart = toAdd;
            } else {
                if (!operator) {
                    return null;
                }
                if (firstPart instanceof FCS_boolean_and) {
                    ((FCS_boolean_and)firstPart).addPart(toAdd);
                } else if (firstPart instanceof FCS_boolean_or) {
                    ((FCS_boolean_or)firstPart).addPart(toAdd);
                }
            }
            operator = false;
            notOperator = false;
        }
        return firstPart;
    }

    public String getDecodedStrategy() {
        return this.decodedStrategyString;
    }

    public void setColor(Object aValue) {
        if (aValue instanceof Color) {
            aValue = ((Color)aValue).getRGB();
        }
        if (aValue instanceof Integer) {
            this.color = (Integer)aValue;
        }
        this.colorImage();
    }

    private void colorImage() {
        for (int i = 0; i < this.imageSize; ++i) {
            for (int j = 0; j < this.imageSize; ++j) {
                this.colorImage.setRGB(i, j, this.color);
            }
        }
        this.colorImageIcon.setImage(this.colorImage);
    }

    public ImageIcon getColorImageIcon() {
        return this.colorImageIcon;
    }

    public void updateValidity() {
        this.decodedStrategy = this.decode(this.strategy);
        if (this.decodedStrategy != null) {
            this.decodedStrategyString = ((Object)this.decodedStrategy).toString();
        }
        this.allRegionsExist = this.testForAvailableRG();
    }

    private boolean testForAvailableRG() {
        if (this.decodedStrategy == null) {
            return false;
        }
        for (String currentPart : this.getNames()) {
            FCS_gate currentGate = this.theRaG.getGate(currentPart);
            if (currentGate != null && !currentGate.isValid()) {
                return false;
            }
            FCS_region currentRegion = this.theRaG.getRegion(currentPart);
            if (currentRegion != null || currentGate != null) continue;
            return false;
        }
        return true;
    }

    private ArrayList<String> getNames() {
        char[] stratChars = this.decodedStrategyString.toLowerCase().toCharArray();
        StringBuilder temp = new StringBuilder();
        ArrayList<String> names = new ArrayList<String>();
        boolean quote = false;
        for (int i = 0; i < stratChars.length; ++i) {
            if (stratChars[i] == '\"') {
                if (quote) {
                    names.add(temp.toString());
                    quote = false;
                    temp.setLength(0);
                    continue;
                }
                quote = true;
                continue;
            }
            if (!quote) continue;
            temp.append(stratChars[i]);
        }
        return names;
    }

    public boolean isValid() {
        return this.allRegionsExist && this.decodedStrategy != null;
    }

    public void changeNameInStrategy(String oldName, String newName) {
        int i;
        oldName = oldName.toLowerCase();
        boolean newNameHasSpaces = newName.contains(" ");
        boolean oldNameHasSpaces = oldName.contains(" ");
        if (newNameHasSpaces && !oldNameHasSpaces) {
            newName = '\"' + newName + '\"';
        }
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder temp = new StringBuilder();
        char[] theChars = this.strategy.toCharArray();
        boolean insideName = false;
        for (i = 0; i < theChars.length; ++i) {
            char c = theChars[i];
            if (c == '\"') {
                boolean bl = insideName = !insideName;
            }
            if (!insideName) {
                if (c == ' ' || c == '(' || c == ')' || c == '\"') {
                    parts.add(temp.toString());
                    temp.setLength(0);
                    temp.append(c);
                    parts.add(temp.toString());
                    temp.setLength(0);
                    continue;
                }
                temp.append(c);
                continue;
            }
            if (c == '\"') {
                parts.add(temp.toString());
                temp.setLength(0);
                temp.append(c);
                parts.add(temp.toString());
                temp.setLength(0);
                continue;
            }
            temp.append(c);
        }
        parts.add(temp.toString());
        for (i = 0; i < parts.size(); ++i) {
            if (!((String)parts.get(i)).toLowerCase().equals(oldName)) continue;
            parts.set(i, newName);
            if (newNameHasSpaces || !oldNameHasSpaces) continue;
            if (i > 0) {
                parts.set(i - 1, "");
            }
            if (i > parts.size()) continue;
            parts.set(i + 1, "");
        }
        temp.setLength(0);
        for (String currPart : parts) {
            temp.append(currPart);
        }
        this.setStrategy(temp.toString());
    }

    @Override
    public String toString() {
        return "\"" + this.getName() + "\"";
    }
}

