/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.FACS_objects;

import FCSalyzer.FACS_objects.FACS_panel;
import FCSalyzer.FACS_objects.FACS_plot;
import FCSalyzer.FCS.FCS_RegionGatesHolder;
import FCSalyzer.FCS.FCS_gate;
import FCSalyzer.FCS.FCS_marker;
import FCSalyzer.FCS.FCS_quadrant;
import FCSalyzer.FCS.FCS_statistics;
import FCSalyzer.GUI.FACS_document;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JLabel;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import staticStuff.staticMethods;

public class FACS_statistics
extends FACS_panel {
    private int statistics = 0;
    public static final int SHOW_QUADRANT_STATS = 1;
    public static final int SHOW_MARKER_STATS = 131072;
    public static final int SHOW_REGION_STATS = 2;
    public static final int SHOW_GATE_STATS = 4;
    public static final int SHOW_EVENTS = 8;
    public static final int SHOW_PERCENT_GATED = 16;
    public static final int SHOW_PERCENT_TOTAL = 32;
    public static final int SHOW_X_MEAN = 64;
    public static final int SHOW_X_MEDIAN = 128;
    public static final int SHOW_Y_MEAN = 512;
    public static final int SHOW_Y_MEDIAN = 1024;
    public static final int SHOW_FILENAME = 4096;
    public static final int SHOW_GATE = 8192;
    public static final int SHOW_PARAMETERS = 16384;
    public static final int SHOW_SAMPLE_DESC = 32768;
    public static final int SHOW_TOTAL_EVENTS = 65536;
    public static final int SHOW_X_CV = 262144;
    public static final int SHOW_Y_CV = 524288;
    public static final int STATS_NOT_SET = Integer.MIN_VALUE;
    private FCS_quadrant quadrant;
    private ArrayList<FCS_marker> markers;
    private FCS_RegionGatesHolder theRaG;
    private FACS_plot parentPlot;
    private final JLabel textArea = new JLabel();
    private final int border = 5;
    private FCS_statistics[] theStats;
    private int appliedGate = -1;
    private int overlay = 0;
    public static final String XML_NAME = "FACS_statistics";
    private static final String XML_VISIBLE_STAT = "visible_Statistics";
    private static final String XML_STAT_FILE_NAME = "Filename";
    private static final String XML_STAT_SAMPLE_DESCRIPTION = "Sample_Description";
    private static final String XML_STAT_PARAMETERS = "Parameters";
    private static final String XML_STAT_TOTAL_EVENTS = "Total_Events";
    private static final String XML_STAT_GATE = "Gate";
    private static final String XML_STAT_QUADRANTS = "Quadrants";
    private static final String XML_STAT_MARKERS = "Markers";
    private static final String XML_STAT_REGIONS = "Regions";
    private static final String XML_STAT_GATES = "Gates";
    private static final String XML_STAT_EVENTS = "Events";
    private static final String XML_STAT_PERCENT_GATED = "Percent_gated";
    private static final String XML_STAT_PERCENT_TOTAL = "Percent_total";
    private static final String XML_STAT_X_MEAN = "X_Mean";
    private static final String XML_STAT_X_CV = "X_CV";
    private static final String XML_STAT_X_MEDIAN = "X_Median";
    private static final String XML_STAT_Y_MEAN = "Y_Mean";
    private static final String XML_STAT_Y_CV = "Y_CV";
    private static final String XML_STAT_Y_MEDIAN = "Y_Median";

    private FACS_statistics() {
        this.generateGUI();
    }

    public FACS_statistics(FACS_document paramDoc, FACS_plot paramPlot, int paramStatistics, FCS_quadrant paramQuadrant, ArrayList<FCS_marker> paramMarkers, FCS_RegionGatesHolder paramRaG, boolean refresh) throws IOException {
        this.generateGUI();
        this.setFCS_Document(paramDoc);
        this.statistics = paramStatistics;
        this.parentPlot = paramPlot;
        this.quadrant = paramQuadrant;
        this.theRaG = paramRaG;
        this.markers = paramMarkers;
        this.theStats = new FCS_statistics[this.parentPlot.getOverlayCount()];
        if (refresh) {
            this.refresh(true);
        }
    }

    private void generateGUI() {
        this.addMouseListener(this);
        this.textArea.addMouseListener(this);
        this.textArea.setActionMap(null);
        this.textArea.setForeground(Color.black);
        this.addMouseMotionListener(this);
        this.textArea.addMouseMotionListener(this);
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.textArea.setOpaque(true);
        this.textArea.setBackground(Color.white);
        this.textArea.setVerticalAlignment(1);
        this.setLayout(new BorderLayout());
        this.add(Box.createHorizontalStrut(5), "East");
        this.add(Box.createHorizontalStrut(5), "West");
        this.add(Box.createVerticalStrut(5), "North");
        this.add(Box.createVerticalStrut(5), "South");
        this.add(this.textArea);
        this.setFontSize(Float.valueOf(10.0f));
    }

    public void setQuadrant(FCS_quadrant paramQuadrant) {
        this.quadrant = paramQuadrant;
    }

    public void setMarkers(ArrayList<FCS_marker> paramMarkers) {
        this.markers = paramMarkers;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mouseClicked(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mousePressed(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mouseExited(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mouseMoved(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.textArea) {
            e.translatePoint(5, 5);
        }
        super.mouseReleased(e);
    }

    @Override
    public FACS_statistics duplicate() {
        FACS_statistics toReturn = new FACS_statistics();
        toReturn.setFontSize(this.getFontSize());
        toReturn.parentPlot = this.parentPlot;
        toReturn.quadrant = this.quadrant;
        toReturn.statistics = this.statistics;
        toReturn.theDocument = this.theDocument;
        toReturn.theStats = this.theStats;
        toReturn.textArea.setText(this.textArea.getText());
        toReturn.appliedGate = this.appliedGate;
        toReturn.overlay = this.overlay;
        toReturn.theRaG = this.theRaG;
        toReturn.setBounds(this.getBounds());
        return toReturn;
    }

    public void setParentPlot(FACS_plot newParent, boolean refresh) throws IOException {
        this.parentPlot = newParent;
        this.markers = this.parentPlot.getMarkers();
        if (refresh) {
            this.refresh(true);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.textArea.setBounds(5, 5, width - 10, height - 10);
    }

    @Override
    public void setFontSize(Float newSize) {
        super.setFontSize(newSize);
        this.textArea.setFont(this.getFont());
    }

    public void refresh(boolean calculateStatistics) throws IOException {
        if (this.theStats.length != this.parentPlot.getOverlayCount()) {
            this.theStats = new FCS_statistics[this.parentPlot.getOverlayCount()];
            calculateStatistics = true;
        }
        StringBuilder newText = new StringBuilder(500);
        newText.append("<html>");
        for (int i = 0; i < this.theStats.length; ++i) {
            if (calculateStatistics) {
                boolean calcMedian = (this.statistics & 0x80) != 0 || (this.statistics & 0x400) != 0;
                boolean calcCV = (this.statistics & 0x40000) != 0 || (this.statistics & 0x80000) != 0;
                this.theStats[i] = new FCS_statistics(this.parentPlot.getData(i), this.quadrant, this.markers, this.theRaG, this.parentPlot.getGateIndex(i), this.parentPlot.getParamX(i), this.parentPlot.getParamY(i), calcMedian, calcCV);
            }
            FCS_statistics currentStat = this.theStats[i];
            if (!currentStat.calculationSuccess) {
                newText.append("Warning: out-of-memory during median calculation for one or more parameters.<br>Try increasing the memory heap size by using the paramter '-Xmx'.<br>");
                newText.append("<br>");
            }
            if ((this.statistics & 0x1000) != 0) {
                newText.append("Filename: ");
                newText.append(currentStat.getFileName());
                newText.append("<br>");
            }
            if ((this.statistics & 0x8000) != 0) {
                newText.append("Sample Desc: ");
                newText.append(currentStat.getSampleDescription());
                newText.append("<br>");
            }
            if ((this.statistics & 0x10000) != 0) {
                newText.append("Total events: ");
                newText.append(currentStat.getTotalEvents());
                newText.append("<br>");
            }
            if ((this.statistics & 0x2000) != 0) {
                newText.append("Gate: ");
                FCS_gate theGate = this.parentPlot.getGate(i);
                if (theGate != null) {
                    newText.append(theGate.getName());
                } else {
                    newText.append("-");
                }
                newText.append("<br>");
            }
            if ((this.statistics & 0x4000) != 0) {
                newText.append("x-Parameter: ");
                newText.append(this.parentPlot.getParamXLabel(i));
                newText.append("<br>");
                if (!this.parentPlot.isHistogram()) {
                    newText.append("y-Parameter: ");
                    newText.append(this.parentPlot.getParamYLabel(i));
                    newText.append("<br>");
                }
            }
            newText.append("<table bgcolor=\"black\" cellspacing=\"1\"  style=\"padding:1px\">");
            newText.append("<tr>");
            newText.append("<th bgcolor=\"white\">Label</th>");
            if ((this.statistics & 8) != 0) {
                newText.append("<th bgcolor=\"white\">Events</th>");
            }
            if ((this.statistics & 0x10) != 0) {
                newText.append("<th bgcolor=\"white\">Percent gated</th>");
            }
            if ((this.statistics & 0x20) != 0) {
                newText.append("<th bgcolor=\"white\">Percent total</th>");
            }
            if ((this.statistics & 0x40) != 0) {
                newText.append("<th bgcolor=\"white\">x-Mean</th>");
            }
            if ((this.statistics & 0x40000) != 0) {
                newText.append("<th bgcolor=\"white\">x-CV (%)</th>");
            }
            if ((this.statistics & 0x80) != 0) {
                newText.append("<th bgcolor=\"white\">x-Median</th>");
            }
            if ((this.statistics & 0x200) != 0 && !this.parentPlot.isHistogram()) {
                newText.append("<th bgcolor=\"white\">y-Mean</th>");
            }
            if ((this.statistics & 0x80000) != 0 && !this.parentPlot.isHistogram()) {
                newText.append("<th bgcolor=\"white\">y-CV (%)</th>");
            }
            if ((this.statistics & 0x400) != 0 && !this.parentPlot.isHistogram()) {
                newText.append("<th bgcolor=\"white\">y-Median</th>");
            }
            newText.append("</tr>");
            String prefix = "<td bgcolor=\"white\">";
            String appendix = "</td>";
            String endLine = "</tr>";
            newText.append("<tr align=\"right\"><td bgcolor=\"white\">");
            newText.append("all");
            newText.append(appendix);
            this.appendStatistics(0, 0, newText, currentStat, prefix, appendix);
            newText.append(endLine);
            if (this.quadrant != null && (this.statistics & 1) != 0) {
                String param_x = this.parentPlot.getParamXLabel(i);
                String param_y = this.parentPlot.getParamYLabel(i);
                newText.append("<tr align=\"right\"><td bgcolor=\"white\">");
                newText.append(param_x).append(FCS_quadrant.paramSigns[0][1]).append(" ").append(param_y).append(FCS_quadrant.paramSigns[0][0]);
                newText.append(appendix);
                this.appendStatistics(1, 0, newText, currentStat, prefix, appendix);
                newText.append(endLine);
                newText.append("<tr align=\"right\"><td bgcolor=\"white\">");
                newText.append(param_x).append(FCS_quadrant.paramSigns[1][1]).append(" ").append(param_y).append(FCS_quadrant.paramSigns[1][0]);
                newText.append(appendix);
                this.appendStatistics(1, 1, newText, currentStat, prefix, appendix);
                newText.append(endLine);
                newText.append("<tr align=\"right\"><td bgcolor=\"white\">");
                newText.append(param_x).append(FCS_quadrant.paramSigns[2][1]).append(" ").append(param_y).append(FCS_quadrant.paramSigns[2][0]);
                newText.append(appendix);
                this.appendStatistics(1, 2, newText, currentStat, prefix, appendix);
                newText.append(endLine);
                newText.append("<tr align=\"right\"><td bgcolor=\"white\">");
                newText.append(param_x).append(FCS_quadrant.paramSigns[3][1]).append(" ").append(param_y).append(FCS_quadrant.paramSigns[3][0]);
                newText.append(appendix);
                this.appendStatistics(1, 3, newText, currentStat, prefix, appendix);
                newText.append(endLine);
            }
            if ((this.statistics & 0x20000) != 0) {
                for (int k = 0; k < this.markers.size(); ++k) {
                    newText.append("<tr align=\"right\"><td bgcolor=\"white\">");
                    newText.append(this.markers.get(k).getName());
                    newText.append(appendix);
                    this.appendStatistics(4, k, newText, currentStat, prefix, appendix);
                    newText.append(endLine);
                }
            }
            if ((this.statistics & 2) != 0) {
                for (int k = 0; k < this.theRaG.getRegionsCount(); ++k) {
                    newText.append("<tr align=\"right\"><td bgcolor=\"white\">");
                    newText.append(this.theRaG.getRegion(k).getName());
                    newText.append(appendix);
                    this.appendStatistics(2, k, newText, currentStat, prefix, appendix);
                    newText.append(endLine);
                }
            }
            if ((this.statistics & 4) != 0) {
                for (int k = 0; k < this.theRaG.getGatesCount(); ++k) {
                    FCS_gate theGate = this.theRaG.getGate(k);
                    if (!theGate.isValid()) continue;
                    newText.append("<tr align=\"right\"><td bgcolor=\"white\">");
                    newText.append(theGate.getName());
                    newText.append(appendix);
                    this.appendStatistics(3, k, newText, currentStat, prefix, appendix);
                    newText.append(endLine);
                }
            }
            newText.append("</table><br>");
        }
        newText.append("</html>");
        this.textArea.setText(newText.toString());
        this.textArea.setBounds(this.textArea.getX(), this.textArea.getY(), this.textArea.getPreferredSize().width, this.textArea.getPreferredSize().height);
    }

    private void appendStatistics(int type, int index, StringBuilder target, FCS_statistics stats, String prefix, String appendix) {
        if ((this.statistics & 8) != 0) {
            target.append(prefix);
            target.append(stats.getStatistics(0, 0, type, index));
            target.append(appendix);
        }
        if ((this.statistics & 0x10) != 0) {
            target.append(prefix);
            target.append(stats.getStatistics(1, 0, type, index));
            target.append(appendix);
        }
        if ((this.statistics & 0x20) != 0) {
            target.append(prefix);
            target.append(stats.getStatistics(2, 0, type, index));
            target.append(appendix);
        }
        if ((this.statistics & 0x40) != 0) {
            target.append(prefix);
            target.append(stats.getStatistics(3, 0, type, index));
            target.append(appendix);
        }
        if ((this.statistics & 0x40000) != 0) {
            target.append(prefix);
            target.append(stats.getStatistics(5, 0, type, index));
            target.append(appendix);
        }
        if ((this.statistics & 0x80) != 0) {
            target.append(prefix);
            target.append(stats.getStatistics(4, 0, type, index));
            target.append(appendix);
        }
        if ((this.statistics & 0x200) != 0 && !this.parentPlot.isHistogram()) {
            target.append(prefix);
            target.append(stats.getStatistics(3, 1, type, index));
            target.append(appendix);
        }
        if ((this.statistics & 0x80000) != 0 && !this.parentPlot.isHistogram()) {
            target.append(prefix);
            target.append(stats.getStatistics(5, 1, type, index));
            target.append(appendix);
        }
        if ((this.statistics & 0x400) != 0 && !this.parentPlot.isHistogram()) {
            target.append(prefix);
            target.append(stats.getStatistics(4, 1, type, index));
            target.append(appendix);
        }
    }

    public void toXML(Node parent) {
        Node stat = staticMethods.addNode(parent, XML_NAME, null);
        Node bounds = staticMethods.addNode(stat, "Bounds", null);
        Rectangle r = this.getBounds();
        staticMethods.addNode(bounds, "X", r.getX());
        staticMethods.addNode(bounds, "Y", r.getY());
        staticMethods.addNode(bounds, "Width", r.getWidth());
        staticMethods.addNode(bounds, "Height", r.getHeight());
        staticMethods.addNode(stat, "ZOrder", this.theDocument.getComponentZOrder(this));
        Node font = staticMethods.addNode(stat, "Font", null);
        staticMethods.addNode(font, "Size", this.getFont().getSize());
        Node s = staticMethods.addNode(stat, XML_VISIBLE_STAT, null);
        staticMethods.addNode(s, XML_STAT_FILE_NAME, (this.statistics & 0x1000) != 0);
        staticMethods.addNode(s, XML_STAT_SAMPLE_DESCRIPTION, (this.statistics & 0x8000) != 0);
        staticMethods.addNode(s, XML_STAT_PARAMETERS, (this.statistics & 0x4000) != 0);
        staticMethods.addNode(s, XML_STAT_TOTAL_EVENTS, (this.statistics & 0x10000) != 0);
        staticMethods.addNode(s, XML_STAT_GATE, (this.statistics & 0x2000) != 0);
        staticMethods.addNode(s, XML_STAT_QUADRANTS, (this.statistics & 1) != 0);
        staticMethods.addNode(s, XML_STAT_MARKERS, (this.statistics & 0x20000) != 0);
        staticMethods.addNode(s, XML_STAT_REGIONS, (this.statistics & 2) != 0);
        staticMethods.addNode(s, XML_STAT_GATES, (this.statistics & 4) != 0);
        staticMethods.addNode(s, XML_STAT_EVENTS, (this.statistics & 8) != 0);
        staticMethods.addNode(s, XML_STAT_PERCENT_GATED, (this.statistics & 0x10) != 0);
        staticMethods.addNode(s, XML_STAT_PERCENT_TOTAL, (this.statistics & 0x20) != 0);
        staticMethods.addNode(s, XML_STAT_X_MEAN, (this.statistics & 0x40) != 0);
        staticMethods.addNode(s, XML_STAT_X_CV, (this.statistics & 0x40000) != 0);
        staticMethods.addNode(s, XML_STAT_X_MEDIAN, (this.statistics & 0x80) != 0);
        staticMethods.addNode(s, XML_STAT_Y_MEAN, (this.statistics & 0x200) != 0);
        staticMethods.addNode(s, XML_STAT_Y_CV, (this.statistics & 0x80000) != 0);
        staticMethods.addNode(s, XML_STAT_Y_MEDIAN, (this.statistics & 0x400) != 0);
    }

    public static FACS_statistics loadStatistics(FACS_document paramDoc, FACS_plot paramPlot, Node storedData) throws NumberFormatException, IOException {
        Rectangle bounds = null;
        Float fonts = null;
        int paramStats = 0;
        Integer zo = null;
        NodeList nL = storedData.getChildNodes();
        for (int i = 0; i < nL.getLength(); ++i) {
            Node curr2;
            NodeList nL_temp;
            Node current = nL.item(i);
            String nameCurrent = current.getNodeName();
            if (nameCurrent.equals("Bounds")) {
                nL_temp = current.getChildNodes();
                double x = 0.0;
                double y = 0.0;
                double width = 0.0;
                double height = 0.0;
                for (int j = 0; j < nL_temp.getLength(); ++j) {
                    Node curr22 = nL_temp.item(j);
                    String curr2Name = curr22.getNodeName();
                    if (curr2Name.equals("X")) {
                        x = staticMethods.getNodeDouble(curr22, x);
                        continue;
                    }
                    if (curr2Name.equals("Y")) {
                        y = staticMethods.getNodeDouble(curr22, y);
                        continue;
                    }
                    if (curr2Name.equals("Width")) {
                        width = staticMethods.getNodeDouble(curr22, width);
                        continue;
                    }
                    if (!curr2Name.equals("Height")) continue;
                    height = staticMethods.getNodeDouble(curr22, height);
                }
                bounds = new Rectangle((int)x, (int)y, (int)width, (int)height);
                continue;
            }
            if (nameCurrent.equals("Font")) {
                nL_temp = current.getChildNodes();
                for (int j = 0; j < nL_temp.getLength(); ++j) {
                    curr2 = nL_temp.item(j);
                    String curr2Name = curr2.getNodeName();
                    if (!curr2Name.equals("Size")) continue;
                    fonts = staticMethods.getNodeFloat(curr2, fonts);
                }
                continue;
            }
            if (nameCurrent.equals(XML_VISIBLE_STAT)) {
                nL_temp = current.getChildNodes();
                for (int j = 0; j < nL_temp.getLength(); ++j) {
                    curr2 = nL_temp.item(j);
                    String curr2Name = curr2.getNodeName();
                    if (!staticMethods.getNodeBoolean(curr2)) continue;
                    if (curr2Name.equals(XML_STAT_FILE_NAME)) {
                        paramStats |= 0x1000;
                        continue;
                    }
                    if (curr2Name.equals(XML_STAT_PARAMETERS)) {
                        paramStats |= 0x4000;
                        continue;
                    }
                    if (curr2Name.equals(XML_STAT_GATE)) {
                        paramStats |= 0x2000;
                        continue;
                    }
                    if (curr2Name.equals(XML_STAT_SAMPLE_DESCRIPTION)) {
                        paramStats |= 0x8000;
                        continue;
                    }
                    if (curr2Name.equals(XML_STAT_TOTAL_EVENTS)) {
                        paramStats |= 0x10000;
                        continue;
                    }
                    if (curr2Name.equals(XML_STAT_QUADRANTS)) {
                        paramStats |= 1;
                        continue;
                    }
                    if (curr2Name.equals(XML_STAT_MARKERS)) {
                        paramStats |= 0x20000;
                        continue;
                    }
                    if (curr2Name.equals(XML_STAT_REGIONS)) {
                        paramStats |= 2;
                        continue;
                    }
                    if (curr2Name.equals(XML_STAT_GATES)) {
                        paramStats |= 4;
                        continue;
                    }
                    if (curr2Name.equals(XML_STAT_EVENTS)) {
                        paramStats |= 8;
                        continue;
                    }
                    if (curr2Name.equals(XML_STAT_PERCENT_GATED)) {
                        paramStats |= 0x10;
                        continue;
                    }
                    if (curr2Name.equals(XML_STAT_PERCENT_TOTAL)) {
                        paramStats |= 0x20;
                        continue;
                    }
                    if (curr2Name.equals(XML_STAT_X_MEAN)) {
                        paramStats |= 0x40;
                        continue;
                    }
                    if (curr2Name.equals(XML_STAT_X_CV)) {
                        paramStats |= 0x40000;
                        continue;
                    }
                    if (curr2Name.equals(XML_STAT_X_MEDIAN)) {
                        paramStats |= 0x80;
                        continue;
                    }
                    if (curr2Name.equals(XML_STAT_Y_MEAN)) {
                        paramStats |= 0x200;
                        continue;
                    }
                    if (curr2Name.equals(XML_STAT_Y_CV)) {
                        paramStats |= 0x80000;
                        continue;
                    }
                    if (!curr2Name.equals(XML_STAT_Y_MEDIAN)) continue;
                    paramStats |= 0x400;
                }
                continue;
            }
            if (!nameCurrent.equals("ZOrder")) continue;
            zo = staticMethods.getNodeInteger(current, null);
        }
        FACS_statistics newStat = new FACS_statistics(paramDoc, paramPlot, paramStats, paramPlot.getQuadrant(), paramPlot.getMarkers(), paramPlot.getRaG(), false);
        newStat.setBounds(bounds);
        if (fonts != null) {
            newStat.setFontSize(fonts);
        }
        if (zo != null) {
            newStat.rememberZOrder(zo);
        }
        return newStat;
    }

    public int getStatisticsDescriptor() {
        return this.statistics;
    }

    @Override
    public synchronized void delete() {
        this.quadrant = null;
        this.theRaG = null;
        if (this.parentPlot != null) {
            this.parentPlot.removeChild(this);
        }
        this.parentPlot = null;
        this.theDocument = null;
    }

    public void setStatisticsDescriptor(int newStats) throws IOException {
        this.statistics = newStats;
        if ((this.statistics & 0x80) != 0 || (this.statistics & 0x400) != 0) {
            this.refresh(true);
        }
        if ((this.statistics & 0x40000) != 0 || (this.statistics & 0x80000) != 0) {
            this.refresh(true);
        } else {
            this.refresh(false);
        }
    }

    public void setGate(int paramgate) {
        this.appliedGate = paramgate;
    }

    @Override
    public void removeListeners() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.textArea.removeMouseMotionListener(this);
    }

    @Override
    public String toString() {
        StringBuilder toReturn = new StringBuilder();
        String delimiter = "\t";
        toReturn.append("Label\t");
        if ((this.statistics & 8) != 0) {
            toReturn.append("Events\t");
        }
        if ((this.statistics & 0x10) != 0) {
            toReturn.append("Percent gated\t");
        }
        if ((this.statistics & 0x20) != 0) {
            toReturn.append("Percent total\t");
        }
        if ((this.statistics & 0x40) != 0) {
            toReturn.append("x-Mean\t");
        }
        if ((this.statistics & 0x40000) != 0) {
            toReturn.append("x-CV (%)\t");
        }
        if ((this.statistics & 0x80) != 0) {
            toReturn.append("x-Median\t");
        }
        if ((this.statistics & 0x200) != 0 && !this.parentPlot.isHistogram()) {
            toReturn.append("y-Mean\t");
        }
        if ((this.statistics & 0x80000) != 0 && !this.parentPlot.isHistogram()) {
            toReturn.append("y-CV (%)\t");
        }
        if ((this.statistics & 0x400) != 0 && !this.parentPlot.isHistogram()) {
            toReturn.append("y-Median\t");
        }
        toReturn.append("\n");
        for (int i = 0; i < this.theStats.length; ++i) {
            StringBuilder prefixBuild = new StringBuilder();
            FCS_statistics currentStat = this.theStats[i];
            prefixBuild.append(currentStat.getFileName());
            prefixBuild.append(delimiter);
            if ((this.statistics & 0x8000) != 0) {
                prefixBuild.append(currentStat.getSampleDescription());
                prefixBuild.append(delimiter);
            }
            if ((this.statistics & 0x10000) != 0) {
                prefixBuild.append(currentStat.getTotalEvents());
                prefixBuild.append(delimiter);
            }
            if ((this.statistics & 0x2000) != 0) {
                FCS_gate theGate = this.parentPlot.getGate(i);
                if (theGate != null) {
                    prefixBuild.append(theGate.getName());
                } else {
                    prefixBuild.append("-");
                }
                prefixBuild.append(delimiter);
            }
            if ((this.statistics & 0x4000) != 0) {
                prefixBuild.append(this.parentPlot.getParamXLabel(i));
                prefixBuild.append(delimiter);
                if (!this.parentPlot.isHistogram()) {
                    prefixBuild.append(this.parentPlot.getParamYLabel(i));
                    prefixBuild.append(delimiter);
                }
            }
            String prefix = prefixBuild.toString();
            String valuePrefix = "";
            String endLine = "\n";
            toReturn.append(prefix);
            toReturn.append("all");
            toReturn.append(delimiter);
            this.appendStatistics(0, 0, toReturn, currentStat, valuePrefix, delimiter);
            toReturn.append(endLine);
            if (this.quadrant != null && (this.statistics & 1) != 0) {
                String param_x = this.parentPlot.getParamXLabel(i);
                String param_y = this.parentPlot.getParamYLabel(i);
                toReturn.append(prefix);
                toReturn.append(param_x).append(FCS_quadrant.paramSigns[0][1]).append(" ").append(param_y).append(FCS_quadrant.paramSigns[0][0]);
                toReturn.append(delimiter);
                this.appendStatistics(1, 0, toReturn, currentStat, valuePrefix, delimiter);
                toReturn.append(endLine);
                toReturn.append(prefix);
                toReturn.append(param_x).append(FCS_quadrant.paramSigns[1][1]).append(" ").append(param_y).append(FCS_quadrant.paramSigns[1][0]);
                toReturn.append(delimiter);
                this.appendStatistics(1, 1, toReturn, currentStat, valuePrefix, delimiter);
                toReturn.append(endLine);
                toReturn.append(prefix);
                toReturn.append(param_x).append(FCS_quadrant.paramSigns[2][1]).append(" ").append(param_y).append(FCS_quadrant.paramSigns[2][0]);
                toReturn.append(delimiter);
                this.appendStatistics(1, 2, toReturn, currentStat, valuePrefix, delimiter);
                toReturn.append(endLine);
                toReturn.append(prefix);
                toReturn.append(param_x).append(FCS_quadrant.paramSigns[3][1]).append(" ").append(param_y).append(FCS_quadrant.paramSigns[3][0]);
                toReturn.append(delimiter);
                this.appendStatistics(1, 3, toReturn, currentStat, valuePrefix, delimiter);
                toReturn.append(endLine);
            }
            if ((this.statistics & 0x20000) != 0) {
                for (int k = 0; k < this.markers.size(); ++k) {
                    toReturn.append(prefix);
                    toReturn.append(this.markers.get(k).getName());
                    toReturn.append(delimiter);
                    this.appendStatistics(4, k, toReturn, currentStat, valuePrefix, delimiter);
                    toReturn.append(endLine);
                }
            }
            if ((this.statistics & 2) != 0) {
                for (int k = 0; k < this.theRaG.getRegionsCount(); ++k) {
                    toReturn.append(prefix);
                    toReturn.append(this.theRaG.getRegion(k).getName());
                    toReturn.append(delimiter);
                    this.appendStatistics(2, k, toReturn, currentStat, valuePrefix, delimiter);
                    toReturn.append(endLine);
                }
            }
            if ((this.statistics & 4) == 0) continue;
            for (int k = 0; k < this.theRaG.getGatesCount(); ++k) {
                FCS_gate theGate = this.theRaG.getGate(k);
                if (!theGate.isValid()) continue;
                toReturn.append(prefix);
                toReturn.append(theGate.getName());
                toReturn.append(delimiter);
                this.appendStatistics(3, k, toReturn, currentStat, valuePrefix, delimiter);
                toReturn.append(endLine);
            }
        }
        return toReturn.toString();
    }

    public String getHTML() {
        return this.textArea.getText();
    }
}

