/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.FACS_objects;

import FCSalyzer.GUI.FACS_document;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;

public abstract class FACS_panel
extends JPanel
implements MouseInputListener {
    private boolean isSelected = false;
    private boolean rememberedSelection = false;
    protected FACS_document theDocument = null;
    private float fontSize = 12.0f;
    protected final int cornerSize = 10;
    private int start_x;
    private int start_y;
    public static final int NO_DRAG = -1;
    private int dragType = -1;
    public static final int TOP_LEFT_CORNER_DRAG = 0;
    public static final int TOP_RIGHT_CORNER_DRAG = 1;
    public static final int BOTTOM_LEFT_CORNER_DRAG = 2;
    public static final int BOTTOM_RIGHT_CORNER_DRAG = 3;
    public static final int MOVE_DRAG = 4;
    private static final int TOP_DRAG_OPTION = 4;
    private Rectangle dragRectangle;
    private Integer ZOrder = null;
    private static final float[] DASH = new float[]{1.0f, 5.0f};
    private static final Stroke DOTTED = new BasicStroke(0.0f, 2, 0, 1.0f, DASH, 0.0f);
    public static final String XML_BOUNDS = "Bounds";
    public static final String XML_BOUNDS_X = "X";
    public static final String XML_BOUNDS_Y = "Y";
    public static final String XML_BOUNDS_WIDTH = "Width";
    public static final String XML_BOUNDS_HEIGHT = "Height";
    public static final String XML_ZORDER = "ZOrder";
    public static final String XML_FONT = "Font";
    public static final String XML_FONT_SIZE = "Size";

    protected void setFCS_Document(FACS_document paramDoc) {
        this.theDocument = paramDoc;
    }

    public void removeFCS_Document() {
        this.theDocument = null;
    }

    protected FACS_document getFCS_Document() {
        return this.theDocument;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean newValue) {
        if (newValue != this.isSelected) {
            this.isSelected = newValue;
            this.theDocument.setDisplayedFontGatePercentage();
        } else {
            this.isSelected = newValue;
        }
        this.repaint();
    }

    public void rememberSelection() {
        this.rememberedSelection = this.isSelected;
    }

    public boolean getRememberedSelection() {
        return this.rememberedSelection;
    }

    public void setFontSize(Float newSize) {
        this.fontSize = newSize.floatValue();
        this.setFont(this.getFont().deriveFont(this.fontSize));
    }

    public Float getFontSize() {
        return Float.valueOf(this.fontSize);
    }

    public int getDragType() {
        return this.dragType;
    }

    public void setDragType(int newType) {
        if (newType <= -2 || newType >= 5) {
            throw new IllegalArgumentException("Argument out of range");
        }
        this.dragType = newType;
    }

    protected void drawBorder(Graphics g, boolean colorSelection) {
        if (!this.isPaintingForPrint()) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.isSelected() && colorSelection) {
                g2.setColor(Color.RED);
            } else {
                g2.setColor(Color.GRAY);
                g2.setStroke(DOTTED);
            }
            int max_x = this.getBounds().width - 1;
            int max_y = this.getBounds().height - 1;
            g2.drawLine(0, 0, max_x, 0);
            g2.drawLine(0, max_y, max_x, max_y);
            g2.drawLine(0, 0, 0, max_y);
            g2.drawLine(max_x, 0, max_x, max_y);
            if (this.isSelected() && colorSelection) {
                g2.fillRect(0, 0, 5, 5);
                g2.fillRect(0, max_y - 4, 5, 5);
                g2.fillRect(max_x - 4, 0, 5, 5);
                g2.fillRect(max_x - 4, max_y - 4, 5, 5);
            }
        }
    }

    public abstract FACS_panel duplicate();

    public abstract void delete();

    protected void addPrefix(String prefix, int count, StringBuilder addTo) {
        for (int i = 0; i < count; ++i) {
            addTo.append(prefix);
        }
    }

    public void moveObject(int difference_x, int difference_y) {
        int x = difference_x + this.getX();
        int y = difference_y + this.getY();
        this.setBounds(x, y, this.getWidth(), this.getHeight());
    }

    @Override
    public void setSize(int w, int h) {
        this.setBounds(this.getX(), this.getY(), w, h);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if ((e.getModifiersEx() & 0x40) == 0) {
            this.theDocument.clearSelections(this);
        } else {
            this.setSelected(!this.isSelected());
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.theDocument.putInFront(this);
        this.start_x = e.getX();
        this.start_y = e.getY();
        this.dragRectangle = this.getBounds();
        if (this.start_x > 0 && this.start_x < 10 && this.start_y > 0 && this.start_y < 10) {
            this.dragType = 0;
            this.theDocument.setSelectedObjectDragType(this.dragType);
            return;
        }
        if ((double)this.start_x > this.dragRectangle.getWidth() - 10.0 && (double)this.start_x < this.dragRectangle.getWidth() && this.start_y > 0 && this.start_y < 10) {
            this.dragType = 1;
            this.theDocument.setSelectedObjectDragType(this.dragType);
            return;
        }
        if (this.start_x > 0 && this.start_x < 10 && (double)this.start_y > this.dragRectangle.getHeight() - 10.0 && (double)this.start_y < this.dragRectangle.getHeight()) {
            this.dragType = 2;
            this.theDocument.setSelectedObjectDragType(this.dragType);
            return;
        }
        if ((double)this.start_x > this.dragRectangle.getWidth() - 10.0 && (double)this.start_x < this.dragRectangle.getWidth() && (double)this.start_y > this.dragRectangle.getHeight() - 10.0 && (double)this.start_y < this.dragRectangle.getHeight()) {
            this.dragType = 3;
            this.theDocument.setSelectedObjectDragType(this.dragType);
            return;
        }
        this.dragType = 4;
        this.theDocument.setSelectedObjectDragType(this.dragType);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setCursor(Cursor.getDefaultCursor());
        this.dragType = -1;
        this.theDocument.setSelectedObjectDragType(this.dragType);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isSelected()) {
            this.theDocument.clearSelections(this);
        }
        switch (this.dragType) {
            case 4: {
                int difference_x = e.getX() - this.start_x;
                int difference_y = e.getY() - this.start_y;
                this.theDocument.moveSelectedObjects(difference_x, difference_y);
                break;
            }
            case 0: {
                int x = e.getX() - this.start_x + this.getX();
                int y = e.getY() - this.start_y + this.getY();
                int w = (int)this.dragRectangle.getMaxX() - x;
                int h = (int)this.dragRectangle.getMaxY() - y;
                this.setBounds(x, y, w, h);
                this.theDocument.setSelectedObjectSize(w, h);
                break;
            }
            case 1: {
                int x = this.getX();
                int y = e.getY() - this.start_y + this.getY();
                int w = (int)this.dragRectangle.getWidth() + e.getX() - this.start_x;
                int h = (int)this.dragRectangle.getMaxY() - y;
                this.setBounds(x, y, w, h);
                this.theDocument.setSelectedObjectSize(w, h);
                break;
            }
            case 2: {
                int x = e.getX() - this.start_x + this.getX();
                int y = this.getY();
                int w = (int)this.dragRectangle.getMaxX() - x;
                int h = (int)this.dragRectangle.getHeight() + e.getY() - this.start_y;
                this.setBounds(x, y, w, h);
                this.theDocument.setSelectedObjectSize(w, h);
                break;
            }
            case 3: {
                int x = this.getX();
                int y = this.getY();
                int w = (int)this.dragRectangle.getWidth() + e.getX() - this.start_x;
                int h = (int)this.dragRectangle.getHeight() + e.getY() - this.start_y;
                this.setBounds(x, y, w, h);
                this.theDocument.setSelectedObjectSize(w, h);
                break;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int w = this.getBounds().width;
        int h = this.getBounds().height;
        if (x > 0 && x < 10 && y > 0 && y < 10) {
            this.setCursor(Cursor.getPredefinedCursor(6));
            return;
        }
        if (x > w - 10 && x < w && y > 0 && y < 10) {
            this.setCursor(Cursor.getPredefinedCursor(7));
            return;
        }
        if (x > 0 && x < 10 && y > h - 10 && y < h) {
            this.setCursor(Cursor.getPredefinedCursor(4));
            return;
        }
        if (x > w - 10 && x < w && y > h - 10 && y < h) {
            this.setCursor(Cursor.getPredefinedCursor(5));
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(13));
    }

    public void rememberZOrder(int newZ) {
        this.ZOrder = newZ;
    }

    public Integer recallZOrder() {
        return this.ZOrder;
    }

    public abstract void removeListeners();

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.drawBorder(g, true);
    }
}

