/****************************************************************************
 *      renderwidget.cc: a widget for displaying the rendering output
 *      This is part of the yafray package
 *      Copyright (C) 2008 Gustavo Pichorim Boiko
 *
 *      This library is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU Lesser General Public
 *      License as published by the Free Software Foundation; either
 *      version 2.1 of the License, or (at your option) any later version.
 *
 *      This library is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *      Lesser General Public License for more details.
 *
 *      You should have received a copy of the GNU Lesser General Public
 *      License along with this library; if not, write to the Free Software
 *      Foundation,Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <QtCore/QDebug>
#include <QtGui/QApplication>
#include <QtGui/QPushButton>
#include <QtGui/QPainter>
#include <QtGui/QPaintEvent>
#include "renderwidget.h"
#include "events.h"
#include <iostream>

/*=====================================
/	RenderWidget implementation
/=====================================*/

RenderWidget::RenderWidget(QWidget *parent): QLabel(parent) {
	borderStart = QPoint(0, 0);
	rendering = true;
}

bool RenderWidget::event(QEvent *e)
{
	if (e->type() == GuiUpdate)
	{
		GuiUpdateEvent *ge = static_cast<GuiUpdateEvent*>(e);
		if (ge->fullUpdate())
		{
			img = ge->img();
			pix = QPixmap::fromImage(ge->img());
			update();
		}
		else
		{
			QPainter p;
			p.begin(&pix);
			p.drawImage(ge->rect(), ge->img(), ge->rect());
			update(ge->rect());
			p.end();

			p.begin(&img);
			p.drawImage(ge->rect(), ge->img(), ge->rect());
			p.end();
		}
		return true;
	}
	return QLabel::event(e);
}

void RenderWidget::paintEvent(QPaintEvent *e)
{
	if (rendering) {
		QRect r = e->rect();
		QPainter painter(this);
		painter.setClipRegion(e->region());

		//if (pixmap.isNull()) {
		if (pix.isNull()) {
			painter.fillRect(r, Qt::black);
			painter.setPen(Qt::white);
			painter.drawText(rect(), Qt::AlignCenter, tr("<no image data>"));
			return;
		}
		painter.drawPixmap(r, pix, r);
	}
	else {
		QLabel::paintEvent(e);
	}
}

bool RenderWidget::saveImage(const QString &path, bool alpha)
{
	QImage image(img);
	if (alpha) {
		/*
		QPainter p(&image);
		p.setCompositionMode(QPainter::CompositionMode_DestinationIn);
		p.drawImage(0, 0, alphaChannel);
		TODO: the 8-bit greyscale colors need to be copied to the alpha channel somehow
		      for now, use the obsolete setAlphaChannel() method
		*/
		image.setAlphaChannel(alphaChannel);
	}
	return image.save(path, 0);
}

void RenderWidget::finishedRender() {
	rendering = false;
	setPixmap(pix);
}
