/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import javafx.animation.PauseTransition;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.util.Duration;

public class OpenPosition {
    private final SimpleObjectProperty symbolObj;
    private final SimpleStringProperty name;
    private final SimpleStringProperty instrumentID;
    private final SimpleDoubleProperty openQty;
    private final SimpleDoubleProperty tradingQty;
    private final SimpleDoubleProperty averagePrice;
    private final SimpleDoubleProperty costBasis;
    private final SimpleDoubleProperty marketPrice;
    private final SimpleDoubleProperty marketValue;
    private final SimpleDoubleProperty pl;
    private final SimpleDoubleProperty plPct;
    private final SimpleDoubleProperty dayPl;
    private final SimpleDoubleProperty dayPlPct;
    private final SimpleDoubleProperty priorClose;
    public final Diff diff = new Diff();
    private PauseTransition openQtyAgingTime = null;
    private PauseTransition tradingQtyAgingTime = null;
    private PauseTransition averagePriceAgingTime = null;
    private PauseTransition costBasisAgingTime = null;
    private PauseTransition marketPriceAgingTime = null;
    private PauseTransition marketValueAgingTime = null;
    private PauseTransition plAgingTime = null;
    private PauseTransition plPctAgingTime = null;
    private PauseTransition dayPLAgingTime = null;
    private PauseTransition dayPLPctAgingTime = null;

    public OpenPosition(Map<String, Object> pos) {
        this.name = new SimpleStringProperty(pos.get("name").toString());
        this.instrumentID = new SimpleStringProperty(pos.get("instrumentID").toString());
        this.costBasis = new SimpleDoubleProperty(((Double)pos.get("costBasis")).doubleValue());
        this.openQty = new SimpleDoubleProperty(((Double)pos.get("openQty")).doubleValue());
        this.tradingQty = new SimpleDoubleProperty(((Double)pos.get("tradingQty")).doubleValue());
        this.averagePrice = new SimpleDoubleProperty(((Double)pos.get("averagePrice")).doubleValue());
        this.marketPrice = new SimpleDoubleProperty(((Double)pos.get("marketPrice")).doubleValue());
        this.marketValue = new SimpleDoubleProperty(((Double)pos.get("marketValue")).doubleValue());
        this.priorClose = new SimpleDoubleProperty(((Double)pos.get("priorClose")).doubleValue());
        this.pl = new SimpleDoubleProperty(((Double)pos.get("unrealizedPL")).doubleValue());
        this.dayPl = new SimpleDoubleProperty(((Double)pos.get("unrealizedDayPL")).doubleValue());
        this.dayPlPct = new SimpleDoubleProperty(((Double)pos.get("unrealizedDayPLPercent")).doubleValue());
        this.plPct = new SimpleDoubleProperty(OpenPosition.roundTwoDp(new BigDecimal(this.getPl() / this.getCostBasis() * 100.0)).doubleValue());
        String symbolStr = pos.get("symbol").toString();
        String urlStr = pos.get("urlImage").toString();
        this.symbolObj = new SimpleObjectProperty();
        this.symbolObj.set((Object)new SymbolUrl(symbolStr, urlStr));
    }

    public void setSymbolObj(SymbolUrl sym) {
        this.symbolObj.set((Object)sym);
    }

    public Object getSymbolObj() {
        return this.symbolObj.get();
    }

    public SimpleObjectProperty symbolObjProperty() {
        return this.symbolObj;
    }

    public final String getSymbol() {
        SymbolUrl symbolUrl = (SymbolUrl)this.getSymbolObj();
        return symbolUrl.getSymbol();
    }

    public final void setUrlImage(String v) {
        SymbolUrl symbolUrl = new SymbolUrl(this.getSymbol(), v);
        this.setSymbolObj(symbolUrl);
    }

    public final String getUrlImage() {
        SymbolUrl symbolUrl = (SymbolUrl)this.symbolObj.get();
        return symbolUrl.getUrl();
    }

    public final String getName() {
        return this.name.get();
    }

    public final void setName(String v) {
        this.name.set(v);
    }

    public SimpleStringProperty nameProperty() {
        return this.name;
    }

    public final String getInstrumentID() {
        return this.instrumentID.get();
    }

    public final void setInstrumentID(String v) {
        this.instrumentID.set(v);
    }

    public SimpleStringProperty instrumentIDProperty() {
        return this.instrumentID;
    }

    public final Double getOpenQty() {
        return this.openQty.get();
    }

    public final void setOpenQty(Double v) {
        this.openQty.set(v.doubleValue());
    }

    public SimpleDoubleProperty openQtyProperty() {
        return this.openQty;
    }

    public final Double getTradingQty() {
        return this.tradingQty.get();
    }

    public final void setTradingQty(Double v) {
        this.tradingQty.set(v.doubleValue());
    }

    public SimpleDoubleProperty tradingQtyProperty() {
        return this.tradingQty;
    }

    public final Double getAveragePrice() {
        return this.averagePrice.get();
    }

    public final void setAveragePrice(Double v) {
        this.averagePrice.set(v.doubleValue());
    }

    public SimpleDoubleProperty averagePriceProperty() {
        return this.averagePrice;
    }

    public final Double getCostBasis() {
        return this.costBasis.get();
    }

    public final void setCostBasis(Double v) {
        this.costBasis.set(v.doubleValue());
    }

    public SimpleDoubleProperty costBasisProperty() {
        return this.costBasis;
    }

    public final Double getMarketPrice() {
        return this.marketPrice.get();
    }

    public final void setMarketPrice(Double v) {
        this.marketPrice.set(v.doubleValue());
    }

    public SimpleDoubleProperty marketPriceProperty() {
        return this.marketPrice;
    }

    public final Double getMarketValue() {
        return this.marketValue.get();
    }

    public final void setMarketValue(Double v) {
        this.marketValue.set(v.doubleValue());
    }

    public SimpleDoubleProperty marketValueProperty() {
        return this.marketValue;
    }

    public final Double getPl() {
        return this.pl.get();
    }

    public final void setPl(Double v) {
        this.pl.set(v.doubleValue());
    }

    public SimpleDoubleProperty plProperty() {
        return this.pl;
    }

    public final Double getPlPct() {
        return this.plPct.get();
    }

    public final void setPlPct(Double v) {
        this.plPct.set(v.doubleValue());
    }

    public SimpleDoubleProperty plPctProperty() {
        return this.plPct;
    }

    public final Double getDayPl() {
        return this.dayPl.get();
    }

    public final void setDayPl(Double v) {
        this.dayPl.set(v.doubleValue());
    }

    public SimpleDoubleProperty dayPlProperty() {
        return this.dayPl;
    }

    public final Double getDayPlPct() {
        return this.dayPlPct.get();
    }

    public final void setDayPlPct(Double v) {
        this.dayPlPct.set(v.doubleValue());
    }

    public SimpleDoubleProperty dayPlPctProperty() {
        return this.dayPlPct;
    }

    public final Double getPriorClose() {
        return this.priorClose.get();
    }

    public final void setPriorClose(Double v) {
        this.priorClose.set(v.doubleValue());
    }

    public SimpleDoubleProperty priorCloseProperty() {
        return this.priorClose;
    }

    private void setDiff(Double oldVal, Double newVal, IntegerProperty diffPty, PauseTransition agingTime) {
        int diffVal = Double.compare(newVal, oldVal);
        diffPty.set(diffVal);
        if (agingTime != null) {
            agingTime.playFromStart();
            return;
        }
        agingTime = new PauseTransition(Duration.seconds((double)5.0));
        agingTime.setOnFinished(event -> diffPty.set(0));
        agingTime.play();
    }

    public void compareAndUpdate(OpenPosition newPos) {
        if (!this.getInstrumentID().equals(newPos.getInstrumentID())) {
            return;
        }
        Double newOpenQty = newPos.getOpenQty();
        this.setDiff(this.getOpenQty(), newOpenQty, this.diff.openQtyPty, this.openQtyAgingTime);
        this.setOpenQty(newOpenQty);
        Double newTradingQty = newPos.getTradingQty();
        this.setDiff(this.getTradingQty(), newTradingQty, this.diff.tradingQtyPty, this.tradingQtyAgingTime);
        this.setTradingQty(newTradingQty);
        Double newAveragePrice = newPos.getAveragePrice();
        this.setDiff(this.getAveragePrice(), newAveragePrice, this.diff.averagePricePty, this.averagePriceAgingTime);
        this.setAveragePrice(newAveragePrice);
        Double newCostBasis = newPos.getCostBasis();
        this.setDiff(this.getCostBasis(), newCostBasis, this.diff.costBasisPty, this.costBasisAgingTime);
        this.setCostBasis(newCostBasis);
        Double newMarketPrice = newPos.getMarketPrice();
        this.setDiff(this.getMarketPrice(), newMarketPrice, this.diff.marketPricePty, this.marketPriceAgingTime);
        this.setMarketPrice(newMarketPrice);
        Double newMarketValue = newPos.getMarketValue();
        this.setDiff(this.getMarketValue(), newMarketValue, this.diff.marketValuePty, this.marketValueAgingTime);
        this.setMarketValue(newMarketValue);
        Double newPl = newPos.getPl();
        this.setDiff(this.getPl(), newPl, this.diff.plPty, this.plAgingTime);
        this.setPl(newPl);
        Double newPlPct = newPos.getPlPct();
        this.setDiff(this.getPlPct(), newPlPct, this.diff.plPctPty, this.plPctAgingTime);
        this.setPlPct(newPlPct);
        Double newDayPl = newPos.getDayPl();
        this.setDiff(this.getDayPl(), newDayPl, this.diff.dayPlPty, this.dayPLAgingTime);
        this.setDayPl(newDayPl);
        Double newDayPlPct = newPos.getDayPlPct();
        this.setDiff(this.getDayPlPct(), newDayPlPct, this.diff.dayPlPctPty, this.dayPLPctAgingTime);
        this.setDayPlPct(newDayPlPct);
        this.setPriorClose(newPos.getPriorClose());
    }

    private static Double roundTwoDp(BigDecimal num) {
        return num.setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public void updatePrice(Double price) {
        this.setDiff(this.getMarketPrice(), price, this.diff.marketPricePty, this.marketPriceAgingTime);
        this.setMarketPrice(price);
        Double newMarketValue = OpenPosition.roundTwoDp(new BigDecimal(this.getOpenQty() * price));
        this.setDiff(this.getMarketValue(), newMarketValue, this.diff.marketValuePty, this.marketValueAgingTime);
        this.setMarketValue(newMarketValue);
        Double newPL = OpenPosition.roundTwoDp(new BigDecimal(newMarketValue - this.getCostBasis()));
        this.setDiff(this.getPl(), newPL, this.diff.plPty, this.plAgingTime);
        this.setPl(newPL);
        Double newPlPct = OpenPosition.roundTwoDp(new BigDecimal(newPL / this.getCostBasis() * 100.0));
        this.setDiff(this.getPlPct(), newPlPct, this.diff.plPctPty, this.plPctAgingTime);
        this.setPlPct(newPlPct);
        Double newDayPl = OpenPosition.roundTwoDp(new BigDecimal((price - this.getPriorClose()) * this.getTradingQty()));
        this.setDiff(this.getDayPl(), newDayPl, this.diff.dayPlPty, this.dayPLAgingTime);
        this.setDayPl(newDayPl);
        Double newDayPlPct = OpenPosition.roundTwoDp(new BigDecimal((price - this.getPriorClose()) / this.getPriorClose() * 100.0));
        this.setDiff(this.getDayPlPct(), newDayPlPct, this.diff.dayPlPctPty, this.dayPLPctAgingTime);
        this.setDayPlPct(newDayPlPct);
    }

    public static class Diff {
        public IntegerProperty openQtyPty = new SimpleIntegerProperty(0);
        public IntegerProperty tradingQtyPty = new SimpleIntegerProperty(0);
        public IntegerProperty averagePricePty = new SimpleIntegerProperty(0);
        public IntegerProperty costBasisPty = new SimpleIntegerProperty(0);
        public IntegerProperty marketPricePty = new SimpleIntegerProperty(0);
        public IntegerProperty marketValuePty = new SimpleIntegerProperty(0);
        public IntegerProperty plPty = new SimpleIntegerProperty(0);
        public IntegerProperty plPctPty = new SimpleIntegerProperty(0);
        public IntegerProperty dayPlPty = new SimpleIntegerProperty(0);
        public IntegerProperty dayPlPctPty = new SimpleIntegerProperty(0);
    }

    public static class SymbolUrl {
        private String symbol;
        private String url;

        public SymbolUrl(String symbol, String url) {
            this.symbol = symbol;
            this.url = url;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public void setSymbol(String symbol) {
            this.symbol = symbol;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}

